/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.table.AbstractTableModel;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import org.micromanager.api.ScriptInterface;
import org.micromanager.dialogs.CalibrationEditor;
import org.micromanager.utils.Calibration;
import org.micromanager.utils.CalibrationList;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.ReportingUtils;

public class CalibrationListDlg
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "Calibration Editor";
    public static final String PIXEL_SIZE_GROUP = "ConfigPixelSize";
    private JTable calTable_;
    private SpringLayout springLayout;
    private CMMCore core_;
    private Preferences prefs_;
    private CalibrationList calibrationList_;
    private ScriptInterface parentGUI_;

    public CalibrationListDlg(CMMCore core) {
        this.core_ = core;
        this.setTitle("Pixel Size Calibration");
        this.springLayout = new SpringLayout();
        this.getContentPane().setLayout(this.springLayout);
        Preferences root = Preferences.userNodeForPackage(this.getClass());
        this.prefs_ = root.node(root.absolutePath() + "/CalibrationListDlg");
        this.setPrefsNode(this.prefs_);
        this.setMinimumSize(new Dimension(263, 239));
        this.loadAndRestorePosition(100, 100, 365, 495);
        Rectangle r = this.getBounds();
        ++r.x;
        JScrollPane scrollPane = new JScrollPane();
        this.getContentPane().add(scrollPane);
        this.springLayout.putConstraint("South", (Component)scrollPane, -16, "South", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)scrollPane, 15, "North", (Component)this.getContentPane());
        this.calibrationList_ = new CalibrationList(this.core_);
        this.calibrationList_.getCalibrationsFromCore();
        this.calTable_ = new JTable(){
            private static final long serialVersionUID = -5870707914970187465L;

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = "";
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                if (rowIndex < 0) {
                    return "";
                }
                CalTableModel ptm = (CalTableModel)CalibrationListDlg.this.calTable_.getModel();
                String label = (String)ptm.getValueAt(rowIndex, 0);
                try {
                    if (CalibrationListDlg.this.core_.isPixelSizeConfigDefined(label)) {
                        Configuration cfg = CalibrationListDlg.this.core_.getPixelSizeConfigData(label);
                        tip = cfg.getVerbose();
                    }
                }
                catch (Exception ex) {
                    CalibrationListDlg.this.handleException(ex);
                }
                return tip;
            }
        };
        this.calTable_.setFont(new Font("", 0, 10));
        CalTableModel model = new CalTableModel();
        model.setData(this.calibrationList_);
        this.calTable_.setModel(model);
        this.calTable_.setSelectionMode(0);
        scrollPane.setViewportView(this.calTable_);
        JButton newButton = new JButton();
        newButton.setFont(new Font("", 0, 10));
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalibrationListDlg.this.addNewCalibration();
            }
        });
        newButton.setText("New");
        this.getContentPane().add(newButton);
        this.springLayout.putConstraint("South", (Component)newButton, 40, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)newButton, 17, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)newButton, -9, "East", (Component)this.getContentPane());
        JButton editButton = new JButton();
        editButton.setFont(new Font("", 0, 10));
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalibrationListDlg.this.editCalibration();
            }
        });
        editButton.setText("Edit");
        this.getContentPane().add(editButton);
        this.springLayout.putConstraint("South", (Component)editButton, 65, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)editButton, 42, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)editButton, -9, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)editButton, -109, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)newButton, 0, "West", (Component)editButton);
        JButton removeButton = new JButton();
        removeButton.setFont(new Font("", 0, 10));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalibrationListDlg.this.removeCalibration();
            }
        });
        removeButton.setText("Remove");
        this.getContentPane().add(removeButton);
        this.springLayout.putConstraint("South", (Component)removeButton, 88, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)removeButton, 65, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)removeButton, -9, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)removeButton, -109, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)newButton, 0, "West", (Component)removeButton);
        JButton removeAllButton = new JButton();
        removeAllButton.setFont(new Font("", 0, 10));
        removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalibrationListDlg.this.removeAllCalibrations();
            }
        });
        removeAllButton.setText("Remove All");
        this.getContentPane().add(removeAllButton);
        this.springLayout.putConstraint("South", (Component)removeAllButton, 111, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)removeAllButton, 88, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)removeAllButton, 100, "West", (Component)removeButton);
        this.springLayout.putConstraint("West", (Component)removeAllButton, 0, "West", (Component)removeButton);
        JButton closeButton = new JButton();
        closeButton.setFont(new Font("", 0, 10));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalibrationListDlg.this.dispose();
            }
        });
        closeButton.setText("Close");
        this.getContentPane().add(closeButton);
        this.springLayout.putConstraint("South", (Component)closeButton, 0, "South", (Component)scrollPane);
        this.springLayout.putConstraint("North", (Component)closeButton, -23, "South", (Component)scrollPane);
        this.springLayout.putConstraint("East", (Component)scrollPane, -5, "West", (Component)closeButton);
        this.springLayout.putConstraint("West", (Component)scrollPane, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)closeButton, -5, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)closeButton, 0, "West", (Component)removeButton);
    }

    public void addNewCalibration() {
        String name = "Res" + this.calibrationList_.size();
        if (this.editPreset(name, "0.00")) {
            this.calibrationList_.getCalibrationsFromCore();
            CalTableModel ptm = (CalTableModel)this.calTable_.getModel();
            ptm.fireTableDataChanged();
            this.parentGUI_.setConfigChanged(true);
            this.parentGUI_.refreshGUI();
        }
    }

    public void editCalibration() {
        CalTableModel ptm = (CalTableModel)this.calTable_.getModel();
        int idx = this.calTable_.getSelectedRow();
        if (idx < 0) {
            this.handleError("A Pixel Size Calibration must be selected first.");
            return;
        }
        String size = (String)ptm.getValueAt(idx, 1);
        String label = (String)ptm.getValueAt(idx, 0);
        if (this.editPreset(label, size)) {
            this.calibrationList_.getCalibrationsFromCore();
            ptm.fireTableDataChanged();
            this.parentGUI_.setConfigChanged(true);
            this.parentGUI_.refreshGUI();
        }
    }

    public void updateCalibrations() {
        this.refreshCalibrations();
        this.parentGUI_.setConfigChanged(true);
        this.parentGUI_.refreshGUI();
    }

    public void refreshCalibrations() {
        CalTableModel ptm = (CalTableModel)this.calTable_.getModel();
        this.calibrationList_.getCalibrationsFromCore();
        ptm.fireTableDataChanged();
        int row = ptm.getCurrentPixelConfigRow();
        if (row >= 0) {
            this.calTable_.setRowSelectionInterval(row, row);
        }
    }

    public void setParentGUI(ScriptInterface parent) {
        this.parentGUI_ = parent;
    }

    public void removeCalibration() {
        CalTableModel ptm = (CalTableModel)this.calTable_.getModel();
        int idx = this.calTable_.getSelectedRow();
        String label = (String)ptm.getValueAt(idx, 0);
        int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove calibration group " + label + "?", TITLE, 0, 1);
        if (result == 0) {
            try {
                this.core_.deletePixelSizeConfig(label);
            }
            catch (Exception e) {
                this.handleException(e);
            }
            this.calibrationList_.getCalibrationsFromCore();
            ptm.fireTableDataChanged();
            this.parentGUI_.refreshGUI();
            this.parentGUI_.setConfigChanged(true);
        }
    }

    public void removeAllCalibrations() {
        int result = JOptionPane.showConfirmDialog(this, "Are you absolutely sure you want to remove all calibrations? (No Undo possible!)", TITLE, 0, 1);
        if (result == 0) {
            try {
                for (int i = 0; i < this.calibrationList_.size(); ++i) {
                    this.core_.deletePixelSizeConfig(this.calibrationList_.get(i).getLabel());
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            this.calibrationList_.getCalibrationsFromCore();
            CalTableModel ptm = (CalTableModel)this.calTable_.getModel();
            ptm.fireTableDataChanged();
            this.parentGUI_.refreshGUI();
            this.parentGUI_.setConfigChanged(true);
        }
    }

    public boolean editPreset(String calibrationName, String pixelSize) {
        int result = JOptionPane.showConfirmDialog(this, "Devices will move to the settings being edited. Please make sure there is no danger of collision.", TITLE, 2, 2);
        if (result == 0) {
            CalibrationEditor dlg = new CalibrationEditor(calibrationName, pixelSize);
            dlg.setCore(this.core_);
            dlg.setVisible(true);
            if (dlg.isChanged()) {
                this.parentGUI_.setConfigChanged(true);
            }
            return dlg.isChanged();
        }
        return false;
    }

    private void handleException(Exception e) {
        ReportingUtils.showError(e);
    }

    private void handleError(String errText) {
        ReportingUtils.showError(errText);
    }

    private class CalTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"Label", "Pixel Size [um]"};
        private CalibrationList calibrationList;

        private CalTableModel() {
        }

        public void setData(CalibrationList cl) {
            this.calibrationList = cl;
        }

        @Override
        public int getRowCount() {
            return this.calibrationList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.COLUMN_NAMES[columnIndex];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Calibration cal = this.calibrationList.get(rowIndex);
            if (columnIndex == 0) {
                return cal.getLabel();
            }
            if (columnIndex == 1) {
                return cal.getPixelSizeUm().toString();
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            Calibration cal = this.calibrationList.get(rowIndex);
            if (columnIndex == 1) {
                try {
                    double val = Double.parseDouble(value.toString());
                    CalibrationListDlg.this.core_.setPixelSizeUm(cal.getLabel(), val);
                    cal.setPixelSizeUm(val);
                    CalibrationListDlg.this.parentGUI_.setConfigChanged(true);
                    CalibrationListDlg.this.parentGUI_.refreshGUI();
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }

        public int getCurrentPixelConfigRow() {
            try {
                String curConfig = CalibrationListDlg.this.core_.getCurrentPixelSizeConfig();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    if (!this.getValueAt(i, 0).equals(curConfig)) continue;
                    return i;
                }
            }
            catch (Exception ex) {
                ReportingUtils.logError(ex);
            }
            return -1;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        private void handleException(Exception e) {
            String errText = "Exception occurred: " + e.getMessage();
            JOptionPane.showMessageDialog(null, errText);
        }
    }
}

