/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.BevelBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.DeviceType;
import mmcorej.PropertySetting;
import mmcorej.PropertyType;
import mmcorej.StrVector;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.ShowFlags;
import org.micromanager.utils.SliderPanel;
import org.micromanager.utils.SortFunctionObjects;

public class CalibrationEditor
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private final JTextArea textArea_;
    private final JTextField presetSizeField_;
    private final JTextField presetLabelField_;
    private final String label_;
    private final String pixelSize_;
    private final SpringLayout springLayout;
    Boolean changed_;
    private JTable table_;
    private PropertyTableData data_;
    private ScriptInterface parentGUI_;
    private ShowFlags flags_;
    private JCheckBox showCamerasCheckBox_;
    private JCheckBox showShuttersCheckBox_;
    private JCheckBox showStagesCheckBox_;
    private JCheckBox showStateDevicesCheckBox_;
    private JCheckBox showOtherCheckBox_;
    private JCheckBox showReadonlyCheckBox_;
    private Configuration initialCfg_;
    private final JScrollPane scrollPane_;
    private boolean tableEditable_ = true;

    public CalibrationEditor(String label, String pixelSize) {
        this.setModal(true);
        this.label_ = label;
        this.pixelSize_ = pixelSize;
        this.changed_ = false;
        Preferences root = Preferences.userNodeForPackage(this.getClass());
        this.setPrefsNode(root.node(root.absolutePath() + "/CalibrationEditor"));
        this.initialCfg_ = new Configuration();
        this.flags_ = new ShowFlags();
        this.flags_.load(this.getPrefsNode());
        this.springLayout = new SpringLayout();
        this.getContentPane().setLayout(this.springLayout);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CalibrationEditor.this.savePosition();
                CalibrationEditor.this.flags_.save(CalibrationEditor.this.getPrefsNode());
            }

            @Override
            public void windowOpened(WindowEvent e) {
                CalibrationEditor.this.data_.updateFlags();
                CalibrationEditor.this.data_.updateStatus();
                CalibrationEditor.this.data_.showOriginalSelection();
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                CalibrationEditor.this.savePosition();
                CalibrationEditor.this.flags_.save(CalibrationEditor.this.getPrefsNode());
            }
        });
        this.setTitle("Calibration Group Editor");
        this.setMinimumSize(new Dimension(490, 280));
        this.loadPosition(100, 100, 551, 562);
        this.setDefaultCloseOperation(2);
        this.scrollPane_ = new JScrollPane();
        this.scrollPane_.setFont(new Font("Arial", 0, 10));
        this.scrollPane_.setBorder(new BevelBorder(1));
        this.getContentPane().add(this.scrollPane_);
        this.springLayout.putConstraint("South", (Component)this.scrollPane_, -5, "South", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.scrollPane_, 160, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.scrollPane_, -5, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.scrollPane_, 5, "West", (Component)this.getContentPane());
        this.table_ = new JTable();
        this.table_.setSelectionMode(2);
        this.table_.setAutoCreateColumnsFromModel(false);
        this.scrollPane_.setViewportView(this.table_);
        this.showCamerasCheckBox_ = new JCheckBox();
        this.showCamerasCheckBox_.setFont(new Font("", 0, 10));
        this.showCamerasCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((CalibrationEditor)CalibrationEditor.this).flags_.cameras_ = CalibrationEditor.this.showCamerasCheckBox_.isSelected();
                CalibrationEditor.this.data_.updateStatus();
            }
        });
        this.showCamerasCheckBox_.setText("Show cameras");
        this.getContentPane().add(this.showCamerasCheckBox_);
        this.springLayout.putConstraint("South", (Component)this.showCamerasCheckBox_, 28, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showCamerasCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.showCamerasCheckBox_, 111, "West", (Component)this.getContentPane());
        this.showShuttersCheckBox_ = new JCheckBox();
        this.showShuttersCheckBox_.setFont(new Font("", 0, 10));
        this.showShuttersCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((CalibrationEditor)CalibrationEditor.this).flags_.shutters_ = CalibrationEditor.this.showShuttersCheckBox_.isSelected();
                CalibrationEditor.this.data_.updateStatus();
            }
        });
        this.showShuttersCheckBox_.setText("Show shutters");
        this.getContentPane().add(this.showShuttersCheckBox_);
        this.springLayout.putConstraint("East", (Component)this.showShuttersCheckBox_, 111, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showShuttersCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.showShuttersCheckBox_, 50, "North", (Component)this.getContentPane());
        this.showStagesCheckBox_ = new JCheckBox();
        this.showStagesCheckBox_.setFont(new Font("", 0, 10));
        this.showStagesCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((CalibrationEditor)CalibrationEditor.this).flags_.stages_ = CalibrationEditor.this.showStagesCheckBox_.isSelected();
                CalibrationEditor.this.data_.updateStatus();
            }
        });
        this.showStagesCheckBox_.setText("Show stages");
        this.getContentPane().add(this.showStagesCheckBox_);
        this.springLayout.putConstraint("East", (Component)this.showStagesCheckBox_, 111, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showStagesCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.showStagesCheckBox_, 73, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.showStagesCheckBox_, 50, "North", (Component)this.getContentPane());
        this.showStateDevicesCheckBox_ = new JCheckBox();
        this.showStateDevicesCheckBox_.setFont(new Font("", 0, 10));
        this.showStateDevicesCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((CalibrationEditor)CalibrationEditor.this).flags_.state_ = CalibrationEditor.this.showStateDevicesCheckBox_.isSelected();
                CalibrationEditor.this.data_.updateStatus();
            }
        });
        this.showStateDevicesCheckBox_.setText("Show wheels, turrets,etc.");
        this.getContentPane().add(this.showStateDevicesCheckBox_);
        this.springLayout.putConstraint("East", (Component)this.showStateDevicesCheckBox_, 165, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showStateDevicesCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.showStateDevicesCheckBox_, 95, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.showStateDevicesCheckBox_, 72, "North", (Component)this.getContentPane());
        this.showOtherCheckBox_ = new JCheckBox();
        this.showOtherCheckBox_.setFont(new Font("", 0, 10));
        this.showOtherCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((CalibrationEditor)CalibrationEditor.this).flags_.other_ = CalibrationEditor.this.showOtherCheckBox_.isSelected();
                CalibrationEditor.this.data_.updateStatus();
            }
        });
        this.showOtherCheckBox_.setText("Show other devices");
        this.getContentPane().add(this.showOtherCheckBox_);
        this.springLayout.putConstraint("East", (Component)this.showOtherCheckBox_, 155, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.showOtherCheckBox_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.showOtherCheckBox_, 95, "North", (Component)this.getContentPane());
        boolean showShowReadonlyCheckBox_ = true;
        if (showShowReadonlyCheckBox_) {
            this.showReadonlyCheckBox_ = new JCheckBox();
            this.showReadonlyCheckBox_.setFont(new Font("Arial", 0, 10));
            this.showReadonlyCheckBox_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CalibrationEditor.this.data_.setShowReadonly(CalibrationEditor.this.showReadonlyCheckBox_.isSelected());
                    CalibrationEditor.this.data_.updateStatus();
                }
            });
            this.showReadonlyCheckBox_.setText("Show read-only properties");
            this.getContentPane().add(this.showReadonlyCheckBox_);
            this.springLayout.putConstraint("West", (Component)this.showReadonlyCheckBox_, 190, "West", (Component)this.getContentPane());
            this.springLayout.putConstraint("North", (Component)this.showReadonlyCheckBox_, 0, "North", (Component)this.showOtherCheckBox_);
        }
        JLabel presetLabel = new JLabel();
        presetLabel.setText("Label: ");
        presetLabel.setFont(new Font("", 0, 10));
        this.getContentPane().add(presetLabel);
        this.springLayout.putConstraint("East", (Component)presetLabel, 340, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)presetLabel, 190, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)presetLabel, 26, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)presetLabel, 15, "North", (Component)this.getContentPane());
        this.presetLabelField_ = new JTextField(this.label_);
        this.getContentPane().add(this.presetLabelField_);
        this.springLayout.putConstraint("East", (Component)this.presetLabelField_, 340, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.presetLabelField_, 190, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.presetLabelField_, 46, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.presetLabelField_, 27, "North", (Component)this.getContentPane());
        JLabel presetSizeLabel = new JLabel();
        presetSizeLabel.setFont(new Font("", 0, 10));
        presetSizeLabel.setText("Pixel Size (um/pixel):");
        this.getContentPane().add(presetSizeLabel);
        this.springLayout.putConstraint("South", (Component)presetSizeLabel, 70, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)presetSizeLabel, 56, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)presetSizeLabel, 340, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)presetSizeLabel, 190, "West", (Component)this.getContentPane());
        this.presetSizeField_ = new JTextField(this.pixelSize_);
        this.getContentPane().add(this.presetSizeField_);
        this.springLayout.putConstraint("East", (Component)this.presetSizeField_, 340, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.presetSizeField_, 190, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.presetSizeField_, 90, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.presetSizeField_, 71, "North", (Component)this.getContentPane());
        JButton okButton = new JButton();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (CalibrationEditor.this.applySettings()) {
                    CalibrationEditor.this.changed_ = Boolean.TRUE;
                    CalibrationEditor.this.dispose();
                }
            }
        });
        okButton.setText("OK");
        this.getContentPane().add(okButton);
        this.springLayout.putConstraint("South", (Component)okButton, 49, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)okButton, 26, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)okButton, 475, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)okButton, 385, "West", (Component)this.getContentPane());
        JButton cancelButton = new JButton();
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CalibrationEditor.this.dispose();
            }
        });
        cancelButton.setText("Cancel");
        this.getContentPane().add(cancelButton);
        this.springLayout.putConstraint("East", (Component)cancelButton, 475, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)cancelButton, 385, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)cancelButton, 75, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)cancelButton, 52, "North", (Component)this.getContentPane());
        this.textArea_ = new JTextArea();
        this.textArea_.setFont(new Font("Arial", 0, 10));
        this.textArea_.setWrapStyleWord(true);
        this.textArea_.setText("Select all settings you want use in this calibration and press OK to save changes.\nYou can also change settings by clicking in the right hand column.");
        this.textArea_.setEditable(false);
        this.textArea_.setOpaque(false);
        this.getContentPane().add(this.textArea_);
        this.springLayout.putConstraint("East", (Component)this.textArea_, -5, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.textArea_, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)this.textArea_, 155, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.textArea_, 122, "North", (Component)this.getContentPane());
    }

    protected boolean applySettings() {
        String duplicate;
        int column = this.table_.getEditingColumn();
        if (column > -1) {
            TableCellEditor cellEditor = this.table_.getColumnModel().getColumn(column).getCellEditor();
            if (cellEditor == null) {
                cellEditor = this.table_.getDefaultEditor(this.table_.getColumnClass(column));
            }
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
        }
        if (!this.data_.isEditingGroup()) {
            this.data_.updateStatus();
        }
        if ((duplicate = this.data_.findMatchingPreset()) != null && duplicate.compareTo(this.label_) != 0) {
            JOptionPane.showMessageDialog(this, "This calibration is the same as: " + duplicate + "\nYou must choose a unique set of values.");
            return false;
        }
        return this.data_.applySettings(this.label_, this.presetLabelField_.getText(), this.presetSizeField_.getText());
    }

    public void editNameOnly() {
        this.presetSizeField_.setEditable(false);
        this.tableEditable_ = false;
        if (this.data_.isEditingGroup()) {
            this.textArea_.setText("Please choose the properties to use when defining a pixel size configuration,\nand choose a name for the current pixel size settings.");
        } else {
            this.textArea_.setText("Please choose a name for this pixel size configuration.");
        }
    }

    public void setCore(CMMCore core) {
        this.data_ = new PropertyTableData(core, this.flags_);
        this.table_ = new JTable();
        this.table_.setSelectionMode(2);
        this.table_.setAutoCreateColumnsFromModel(false);
        this.scrollPane_.setViewportView(this.table_);
        this.table_.setModel(this.data_);
        try {
            if (core.isPixelSizeConfigDefined(this.label_)) {
                core.setPixelSizeConfig(this.label_);
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
        PropertyCellEditor cellEditor = new PropertyCellEditor();
        PropertyCellRenderer renderer = new PropertyCellRenderer();
        for (int k = 0; k < this.data_.getColumnCount(); ++k) {
            TableColumn column = new TableColumn(k, 200, renderer, cellEditor);
            this.table_.addColumn(column);
        }
        this.showCamerasCheckBox_.setSelected(this.flags_.cameras_);
        this.showStagesCheckBox_.setSelected(this.flags_.stages_);
        this.showShuttersCheckBox_.setSelected(this.flags_.shutters_);
        this.showStateDevicesCheckBox_.setSelected(this.flags_.state_);
        this.showOtherCheckBox_.setSelected(this.flags_.other_);
        if (!this.data_.isEditingGroup()) {
            this.getContentPane().remove(this.showCamerasCheckBox_);
            this.getContentPane().remove(this.showStagesCheckBox_);
            this.getContentPane().remove(this.showShuttersCheckBox_);
            this.getContentPane().remove(this.showStateDevicesCheckBox_);
            this.getContentPane().remove(this.showOtherCheckBox_);
            this.getContentPane().remove(this.showReadonlyCheckBox_);
            this.data_.setShowReadonly(true);
            this.textArea_.setText("Choose values for the properties contained in this calibration.\nAvailable properties are determined by the first preset defined for this group");
        }
        this.data_.updateFlags();
        this.data_.updateStatus();
    }

    public void setParentGUI(ScriptInterface parent) {
        this.parentGUI_ = parent;
    }

    public boolean isChanged() {
        return this.changed_;
    }

    public class PropertyCellRenderer
    implements TableCellRenderer {
        PropertyItem item_;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
            JComponent comp;
            PropertyTableData data = (PropertyTableData)table.getModel();
            this.item_ = data.getPropertyItem(rowIndex);
            JLabel lab = new JLabel();
            lab.setHorizontalAlignment(2);
            lab.setOpaque(true);
            if (this.item_.readOnly) {
                lab.setBackground(Color.LIGHT_GRAY);
            } else {
                lab.setBackground(Color.WHITE);
            }
            if (hasFocus) {
                // empty if block
            }
            if (colIndex == 0) {
                lab.setText((String)value);
                comp = lab;
            } else if (colIndex == 1) {
                if (this.item_.hasRange) {
                    SliderPanel slider = new SliderPanel();
                    if (this.item_.isInteger()) {
                        slider.setLimits((int)this.item_.lowerLimit, (int)this.item_.upperLimit);
                    } else {
                        slider.setLimits(this.item_.lowerLimit, this.item_.upperLimit);
                    }
                    try {
                        if (this.item_.isFloat()) {
                            value = NumberUtils.doubleToDisplayString(Double.parseDouble((String)value));
                        } else if (this.item_.isInteger()) {
                            value = NumberUtils.intToDisplayString(Integer.parseInt((String)value));
                        }
                    }
                    catch (Exception e) {
                        ReportingUtils.logError(e);
                    }
                    try {
                        slider.setText((String)value);
                    }
                    catch (ParseException ex) {
                        ReportingUtils.logError(ex);
                    }
                    slider.setToolTipText((String)value);
                    comp = slider;
                } else {
                    lab.setText(this.item_.value.toString());
                    comp = lab;
                }
            } else if (colIndex == 2) {
                JCheckBox cb = new JCheckBox();
                cb.setSelected(this.item_.confInclude);
                if (this.item_.readOnly) {
                    cb.setEnabled(false);
                }
                comp = cb;
            } else {
                lab.setText("Undefined");
                comp = lab;
            }
            return comp;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public class PropertyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        JTextField text_ = new JTextField();
        JComboBox combo_ = new JComboBox();
        JCheckBox check_ = new JCheckBox();
        int editingCol_;
        PropertyItem item_;
        SliderPanel slider_ = new SliderPanel();

        public PropertyCellEditor() {
            this.check_.setSelected(false);
            this.check_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
            this.combo_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
            this.slider_.addEditActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
            this.slider_.addSliderMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    PropertyCellEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int colIndex) {
            if (isSelected) {
                // empty if block
            }
            this.editingCol_ = colIndex;
            PropertyTableData data = (PropertyTableData)table.getModel();
            this.item_ = data.getPropertyItem(rowIndex);
            if (colIndex == 1) {
                int i;
                if (this.item_.allowed.length == 0) {
                    if (this.item_.hasRange) {
                        if (this.item_.isInteger()) {
                            this.slider_.setLimits((int)this.item_.lowerLimit, (int)this.item_.upperLimit);
                        } else {
                            this.slider_.setLimits(this.item_.lowerLimit, this.item_.upperLimit);
                            try {
                                value = NumberUtils.doubleToDisplayString(Double.parseDouble((String)value));
                            }
                            catch (Exception e) {
                                ReportingUtils.logError(e);
                            }
                        }
                        try {
                            this.slider_.setText((String)value);
                        }
                        catch (ParseException ex) {
                            ReportingUtils.logError(ex);
                        }
                        return this.slider_;
                    }
                    this.text_.setText((String)value);
                    return this.text_;
                }
                ActionListener[] l = this.combo_.getActionListeners();
                for (i = 0; i < l.length; ++i) {
                    this.combo_.removeActionListener(l[i]);
                }
                this.combo_.removeAllItems();
                for (i = 0; i < this.item_.allowed.length; ++i) {
                    this.combo_.addItem(this.item_.allowed[i]);
                }
                this.combo_.setSelectedItem(this.item_.value);
                return this.combo_;
            }
            if (colIndex == 2) {
                this.check_.setSelected(this.item_.confInclude);
                return this.check_;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.editingCol_ == 1) {
                if (this.item_.allowed.length == 0) {
                    if (this.item_.hasRange) {
                        return this.slider_.getText();
                    }
                    return this.text_.getText();
                }
                return this.combo_.getSelectedItem();
            }
            if (this.editingCol_ == 2) {
                return this.check_.isSelected();
            }
            return null;
        }
    }

    class PropertyTableData
    extends AbstractTableModel {
        private static final long serialVersionUID = -5582899855072387637L;
        public final String[] columnNames_ = new String[]{"Property", "Value", "Use"};
        ArrayList<PropertyItem> propList_ = new ArrayList();
        private CMMCore core_ = null;
        Configuration[] groupData_;
        PropertySetting[] groupSignature_;
        private boolean showReadonly_ = false;
        private String[] presetNames_;

        public PropertyTableData(CMMCore core, ShowFlags flags) {
            this.core_ = core;
            CalibrationEditor.this.flags_ = flags;
            this.updateStatus();
        }

        public String findMatchingPreset() {
            int i;
            ArrayList<PropertyItem> selected = new ArrayList<PropertyItem>();
            for (i = 0; i < this.propList_.size(); ++i) {
                PropertyItem item = this.propList_.get(i);
                if (!item.confInclude) continue;
                selected.add(item);
            }
            for (i = 0; i < this.groupData_.length; ++i) {
                int matchCount = 0;
                for (int j = 0; j < selected.size(); ++j) {
                    PropertyItem pi = (PropertyItem)selected.get(j);
                    PropertySetting ps = new PropertySetting(pi.device, pi.name, pi.value);
                    if (!this.groupData_[i].isSettingIncluded(ps)) continue;
                    ++matchCount;
                }
                if (matchCount != selected.size()) continue;
                return this.presetNames_[i];
            }
            return null;
        }

        public void setShowReadonly(boolean showReadonly) {
            this.showReadonly_ = showReadonly;
        }

        public boolean applySettings(String oldLabel, String newLabel, String pixelSize) {
            if (!oldLabel.equals(newLabel)) {
                try {
                    if (this.core_.isPixelSizeConfigDefined(oldLabel)) {
                        this.core_.deletePixelSizeConfig(oldLabel);
                    }
                }
                catch (Exception e) {
                    ReportingUtils.showError(e);
                    return false;
                }
            }
            ArrayList<PropertyItem> selected = new ArrayList<PropertyItem>();
            for (int i = 0; i < this.propList_.size(); ++i) {
                PropertyItem item = this.propList_.get(i);
                if (!item.confInclude) continue;
                selected.add(item);
            }
            if (selected.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Please select \"Use\" column for at least one Property that affects pixel size");
                return false;
            }
            ArrayList<PropertyItem> mismatched = new ArrayList<PropertyItem>();
            ArrayList<PropertySetting> missing = new ArrayList<PropertySetting>();
            if (!this.isEditingGroup()) {
                int i;
                for (i = 0; i < selected.size(); ++i) {
                    int j;
                    PropertyItem item = (PropertyItem)selected.get(i);
                    for (j = 0; j < this.groupSignature_.length && (item.device.compareTo(this.groupSignature_[j].getDeviceLabel()) != 0 || item.name.compareTo(this.groupSignature_[j].getPropertyName()) != 0); ++j) {
                    }
                    if (this.groupSignature_.length != j) continue;
                    mismatched.add(item);
                }
                for (i = 0; i < this.groupSignature_.length; ++i) {
                    int j;
                    for (j = 0; j < selected.size(); ++j) {
                        PropertyItem item = (PropertyItem)selected.get(j);
                        if (item.device.compareTo(this.groupSignature_[i].getDeviceLabel()) == 0 && item.name.compareTo(this.groupSignature_[i].getPropertyName()) == 0) break;
                    }
                    if (selected.size() != j) continue;
                    missing.add(this.groupSignature_[i]);
                }
            }
            if (mismatched.size() > 0 || missing.size() > 0) {
                String mismatchedList = "";
                for (int i = 0; i < mismatched.size(); ++i) {
                    mismatchedList = mismatchedList + ((PropertyItem)mismatched.get((int)i)).device + "-" + ((PropertyItem)mismatched.get((int)i)).name + "\n";
                }
                String missingList = "";
                for (int i = 0; i < missing.size(); ++i) {
                    missingList = missingList + ((PropertySetting)missing.get(i)).getDeviceLabel() + "-" + ((PropertySetting)missing.get(i)).getPropertyName() + "\n";
                }
                String msgText = "All presets within a group should operate on the same set of device properties.\nBased on the previously defined presets in this group, the following inconsistencises were detected:\n\n" + (mismatched.size() > 0 ? "Properties not previously defined:\n" + mismatchedList : "\n") + (missing.size() > 0 ? "Properties prviously defined but missing from this preset:\n" + missingList : "\n") + "\nPlease revise all presets in a single group to use the same set of properties.\n" + "Otherwise some of the presets within the group may appear to be ambiguous";
                JOptionPane.showMessageDialog(null, msgText);
            }
            try {
                if (this.core_.isPixelSizeConfigDefined(newLabel)) {
                    this.core_.deletePixelSizeConfig(newLabel);
                }
                for (int i = 0; i < selected.size(); ++i) {
                    PropertyItem item = (PropertyItem)selected.get(i);
                    this.core_.definePixelSizeConfig(newLabel, item.device, item.name, item.value);
                }
                this.core_.setPixelSizeUm(newLabel, NumberUtils.displayStringToDouble(pixelSize));
            }
            catch (Exception e) {
                ReportingUtils.showError(e);
                return false;
            }
            return true;
        }

        public boolean verifyPresetSignature() {
            return true;
        }

        public void deletePixelSizeConfig(String configName) {
            try {
                this.core_.deletePixelSizeConfig(configName);
            }
            catch (Exception e) {
                ReportingUtils.showError(e);
            }
        }

        @Override
        public int getRowCount() {
            return this.propList_.size();
        }

        @Override
        public int getColumnCount() {
            if (this.isEditingGroup()) {
                return this.columnNames_.length;
            }
            return this.columnNames_.length - 1;
        }

        public boolean isEditingGroup() {
            return this.groupSignature_.length == 0;
        }

        public PropertyItem getPropertyItem(int row) {
            return this.propList_.get(row);
        }

        @Override
        public Object getValueAt(int row, int col) {
            PropertyItem item = this.propList_.get(row);
            if (col == 0) {
                return item.device + "-" + item.name;
            }
            if (col == 1) {
                return item.value;
            }
            if (col == 2) {
                return item.confInclude;
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            PropertyItem item = this.propList_.get(row);
            if (col == 1) {
                try {
                    if (item.isInteger()) {
                        this.core_.setProperty(item.device, item.name, new Integer(NumberUtils.displayStringToInt((String)value)).toString());
                    } else if (item.isFloat()) {
                        this.core_.setProperty(item.device, item.name, new Double(NumberUtils.displayStringToDouble((String)value)).toString());
                    } else {
                        this.core_.setProperty(item.device, item.name, value.toString());
                    }
                    this.core_.waitForDevice(item.device);
                    this.refresh();
                    if (CalibrationEditor.this.parentGUI_ != null) {
                        CalibrationEditor.this.parentGUI_.refreshGUI();
                    }
                    this.fireTableCellUpdated(row, col);
                }
                catch (Exception e) {
                    ReportingUtils.showError(e);
                }
            } else if (col == 2) {
                item.confInclude = (Boolean)value;
            }
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames_[column];
        }

        @Override
        public boolean isCellEditable(int nRow, int nCol) {
            if (nCol == 1) {
                return CalibrationEditor.this.tableEditable_ && !this.propList_.get((int)nRow).readOnly;
            }
            if (nCol == 2) {
                return this.isEditingGroup();
            }
            return false;
        }

        StrVector getAvailablePixelSizeConfigs() {
            return this.core_.getAvailablePixelSizeConfigs();
        }

        public void refresh() {
            try {
                for (int i = 0; i < this.propList_.size(); ++i) {
                    PropertyItem item = this.propList_.get(i);
                    item.value = this.core_.getProperty(item.device, item.name);
                }
                this.fireTableDataChanged();
            }
            catch (Exception e) {
                ReportingUtils.showError(e);
            }
        }

        public final void updateStatus() {
            int i;
            this.groupData_ = new Configuration[0];
            try {
                if (this.core_.isPixelSizeConfigDefined(CalibrationEditor.this.label_)) {
                    CalibrationEditor.this.initialCfg_ = this.core_.getPixelSizeConfigData(CalibrationEditor.this.label_);
                }
                StrVector cfgNames = this.core_.getAvailablePixelSizeConfigs();
                this.groupData_ = new Configuration[(int)cfgNames.size()];
                this.presetNames_ = new String[(int)cfgNames.size()];
                for (i = 0; i < this.groupData_.length; ++i) {
                    this.groupData_[i] = this.core_.getPixelSizeConfigData(cfgNames.get(i));
                    this.presetNames_[i] = cfgNames.get(i);
                }
                if (this.groupData_.length > 0) {
                    this.groupSignature_ = new PropertySetting[(int)this.groupData_[0].size()];
                    i = 0;
                    while ((long)i < this.groupData_[0].size()) {
                        this.groupSignature_[i] = this.groupData_[0].getSetting((long)i);
                        ++i;
                    }
                } else {
                    this.groupSignature_ = new PropertySetting[0];
                }
            }
            catch (Exception e) {
                ReportingUtils.showError(e);
            }
            try {
                StrVector devices = this.core_.getLoadedDevices();
                this.propList_.clear();
                i = 0;
                while ((long)i < devices.size()) {
                    DeviceType dtype = this.core_.getDeviceType(devices.get(i));
                    boolean showDevice = dtype == DeviceType.MagnifierDevice ? false : (dtype == DeviceType.SerialDevice ? false : (dtype == DeviceType.CameraDevice ? ((CalibrationEditor)CalibrationEditor.this).flags_.cameras_ : (dtype == DeviceType.ShutterDevice ? ((CalibrationEditor)CalibrationEditor.this).flags_.shutters_ : (dtype == DeviceType.StageDevice ? ((CalibrationEditor)CalibrationEditor.this).flags_.stages_ : (dtype == DeviceType.XYStageDevice ? ((CalibrationEditor)CalibrationEditor.this).flags_.stages_ : (dtype == DeviceType.StateDevice ? ((CalibrationEditor)CalibrationEditor.this).flags_.state_ : ((CalibrationEditor)CalibrationEditor.this).flags_.other_))))));
                    if (showDevice) {
                        StrVector properties = this.core_.getDevicePropertyNames(devices.get(i));
                        int j = 0;
                        while ((long)j < properties.size()) {
                            PropertyItem item = new PropertyItem();
                            item.device = devices.get(i);
                            item.name = properties.get(j);
                            item.value = this.core_.getProperty(devices.get(i), properties.get(j));
                            item.readOnly = this.core_.isPropertyReadOnly(devices.get(i), properties.get(j));
                            item.preInit = this.core_.isPropertyPreInit(devices.get(i), properties.get(j));
                            item.hasRange = this.core_.hasPropertyLimits(devices.get(i), properties.get(j));
                            item.lowerLimit = this.core_.getPropertyLowerLimit(devices.get(i), properties.get(j));
                            item.upperLimit = this.core_.getPropertyUpperLimit(devices.get(i), properties.get(j));
                            item.type = this.core_.getPropertyType(item.device, item.name);
                            StrVector values = this.core_.getAllowedPropertyValues(devices.get(i), properties.get(j));
                            item.allowed = new String[(int)values.size()];
                            int k = 0;
                            while ((long)k < values.size()) {
                                item.allowed[k] = values.get(k);
                                ++k;
                            }
                            if (PropertyType.Float == item.type) {
                                Arrays.sort(item.allowed, new SortFunctionObjects.DoubleStringComp());
                            } else if (PropertyType.Integer == item.type) {
                                Arrays.sort(item.allowed, new SortFunctionObjects.IntStringComp());
                            } else if (PropertyType.String == item.type) {
                                boolean allNumeric = true;
                                for (int k2 = 0; k2 < item.allowed.length; ++k2) {
                                    if (!item.allowed[k2].equals("") && Character.isDigit(item.allowed[k2].charAt(0))) continue;
                                    allNumeric = false;
                                    break;
                                }
                                if (allNumeric) {
                                    Arrays.sort(item.allowed, new SortFunctionObjects.NumericPrefixStringComp());
                                } else {
                                    Arrays.sort(item.allowed);
                                }
                            }
                            if (!(item.preInit || item.readOnly && !this.showReadonly_)) {
                                item.confInclude = CalibrationEditor.this.initialCfg_.isPropertyIncluded(item.device, item.name);
                                if (this.isMatchingSignature(item) && (dtype != DeviceType.CameraDevice || !item.name.equals("Binning"))) {
                                    this.propList_.add(item);
                                    if (!this.isEditingGroup()) {
                                        item.confInclude = true;
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                ReportingUtils.showError(e);
            }
            this.fireTableStructureChanged();
        }

        private boolean isMatchingSignature(PropertyItem item) {
            int j;
            if (this.isEditingGroup()) {
                return true;
            }
            for (j = 0; j < this.groupSignature_.length && (item.device.compareTo(this.groupSignature_[j].getDeviceLabel()) != 0 || item.name.compareTo(this.groupSignature_[j].getPropertyName()) != 0); ++j) {
            }
            return j != this.groupSignature_.length;
        }

        private void updateFlags() {
            try {
                if (this.core_.isPixelSizeConfigDefined(CalibrationEditor.this.label_)) {
                    CalibrationEditor.this.initialCfg_ = this.core_.getPixelSizeConfigData(CalibrationEditor.this.label_);
                }
                int i = 0;
                while ((long)i < CalibrationEditor.this.initialCfg_.size()) {
                    DeviceType dtype = this.core_.getDeviceType(CalibrationEditor.this.initialCfg_.getSetting((long)i).getDeviceLabel());
                    if (dtype == DeviceType.CameraDevice) {
                        ((CalibrationEditor)CalibrationEditor.this).flags_.cameras_ = true;
                        CalibrationEditor.this.showCamerasCheckBox_.setSelected(true);
                    } else if (dtype == DeviceType.ShutterDevice) {
                        ((CalibrationEditor)CalibrationEditor.this).flags_.shutters_ = true;
                        CalibrationEditor.this.showShuttersCheckBox_.setSelected(true);
                    } else if (dtype == DeviceType.StageDevice) {
                        ((CalibrationEditor)CalibrationEditor.this).flags_.stages_ = true;
                        CalibrationEditor.this.showStagesCheckBox_.setSelected(true);
                    } else if (dtype == DeviceType.StateDevice) {
                        ((CalibrationEditor)CalibrationEditor.this).flags_.state_ = true;
                        CalibrationEditor.this.showStateDevicesCheckBox_.setSelected(true);
                    } else {
                        CalibrationEditor.this.showOtherCheckBox_.setSelected(true);
                        ((CalibrationEditor)CalibrationEditor.this).flags_.other_ = true;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                ReportingUtils.showError(e);
            }
        }

        public void showOriginalSelection() {
            for (int i = 0; i < this.propList_.size(); ++i) {
                PropertyItem item = this.propList_.get(i);
                item.confInclude = CalibrationEditor.this.initialCfg_.size() == 0L ? false : CalibrationEditor.this.initialCfg_.isPropertyIncluded(item.device, item.name);
            }
            this.fireTableDataChanged();
        }
    }
}

