/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.api.ScriptInterface;
import org.micromanager.dialogs.CustomTimeIntervalsPanel;
import org.micromanager.utils.MMDialog;

public class AdvancedOptionsDialog
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private final AcquisitionEngine acqEng_;
    private final JTabbedPane tabbedPane_;
    private final JPanel closeButtonPanel_;
    private final CustomTimeIntervalsPanel customTimeIntervalsPanel_;

    public AdvancedOptionsDialog(AcquisitionEngine acqEng, ScriptInterface gui) {
        this.setModal(true);
        this.acqEng_ = acqEng;
        this.loadPosition(0, 0, 600, 500);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                AdvancedOptionsDialog.this.savePosition();
            }
        });
        this.setTitle("Advanced acquisition options");
        this.setMinimumSize(new Dimension(600, 400));
        this.tabbedPane_ = new JTabbedPane();
        this.customTimeIntervalsPanel_ = new CustomTimeIntervalsPanel(this.acqEng_, this.tabbedPane_, gui);
        this.tabbedPane_.add("Custom time intervals", this.customTimeIntervalsPanel_);
        this.getContentPane().add(this.tabbedPane_);
        this.closeButtonPanel_ = new JPanel();
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedOptionsDialog.this.close();
            }
        });
        this.closeButtonPanel_.add(closeButton);
        this.getContentPane().add((Component)this.closeButtonPanel_, "Last");
    }

    @Override
    public void setVisible(boolean b) {
        this.updatePanels();
        super.setVisible(b);
    }

    private void updatePanels() {
        this.customTimeIntervalsPanel_.syncCheckBoxFromAcqEng();
        this.customTimeIntervalsPanel_.syncIntervalsFromAcqEng();
    }

    private void close() {
        this.setVisible(false);
    }
}

