/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.dialogs;

import com.swtdesigner.SwingResourceManager;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import mmcorej.CMMCore;
import org.micromanager.MMOptions;
import org.micromanager.MMStudio;
import org.micromanager.acquisition.AcquisitionEngine;
import org.micromanager.acquisition.ComponentTitledBorder;
import org.micromanager.acquisition.TaggedImageStorageDiskDefault;
import org.micromanager.acquisition.TaggedImageStorageMultipageTiff;
import org.micromanager.api.ScriptInterface;
import org.micromanager.dialogs.AdvancedOptionsDialog;
import org.micromanager.dialogs.ChannelCellEditor;
import org.micromanager.dialogs.ChannelCellRenderer;
import org.micromanager.dialogs.ChannelTableModel;
import org.micromanager.internalinterfaces.AcqSettingsListener;
import org.micromanager.utils.AcqOrderMode;
import org.micromanager.utils.ChannelSpec;
import org.micromanager.utils.ColorEditor;
import org.micromanager.utils.ColorRenderer;
import org.micromanager.utils.ContrastSettings;
import org.micromanager.utils.DisplayMode;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.GUIColors;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.MMFrame;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.TooltipTextMaker;

public class AcqControlDlg
extends MMFrame
implements PropertyChangeListener,
AcqSettingsListener {
    private static final long serialVersionUID = 1L;
    protected JButton listButton_;
    private final JButton afButton_;
    private JSpinner afSkipInterval_;
    private final JComboBox acqOrderBox_;
    public static final String NEW_ACQFILE_NAME = "MMAcquistion.xml";
    public static final String ACQ_SETTINGS_NODE = "AcquistionSettings";
    public static final String COLOR_SETTINGS_NODE = "ColorSettings";
    private static final String EXPOSURE_SETTINGS_NODE = "AcqExposureSettings";
    private JComboBox channelGroupCombo_;
    private final JTextArea commentTextArea_;
    private final JComboBox zValCombo_;
    private final JTextField nameField_;
    private final JTextField rootField_;
    private final JTextArea summaryTextArea_;
    private final JComboBox timeUnitCombo_;
    private final JFormattedTextField interval_;
    private final JFormattedTextField zStep_;
    private final JFormattedTextField zTop_;
    private final JFormattedTextField zBottom_;
    private AcquisitionEngine acqEng_;
    private final JScrollPane channelTablePane_;
    private JTable channelTable_;
    private final JSpinner numFrames_;
    private ChannelTableModel model_;
    private final MMOptions options_;
    private final Preferences prefs_;
    private final Preferences acqPrefs_;
    private final Preferences colorPrefs_;
    private final Preferences exposurePrefs_;
    private File acqFile_;
    private String acqDir_;
    private int zVals_ = 0;
    private final JButton acquireButton_;
    private final JButton setBottomButton_;
    private final JButton setTopButton_;
    protected JComboBox displayModeCombo_;
    private ScriptInterface studio_;
    private final GUIColors guiColors_;
    private final NumberFormat numberFormat_;
    private final JLabel namePrefixLabel_;
    private final JLabel saveTypeLabel_;
    private final JRadioButton singleButton_;
    private final JRadioButton multiButton_;
    private final JLabel rootLabel_;
    private final JButton browseRootButton_;
    private final JLabel displayMode_;
    private final JCheckBox stackKeepShutterOpenCheckBox_;
    private final JCheckBox chanKeepShutterOpenCheckBox_;
    private final AcqOrderMode[] acqOrderModes_;
    private AdvancedOptionsDialog advancedOptionsWindow_;
    private static final String ACQ_FILE_DIR = "dir";
    private static final String ACQ_INTERVAL = "acqInterval";
    private static final String ACQ_TIME_UNIT = "acqTimeInit";
    private static final String ACQ_ZBOTTOM = "acqZbottom";
    private static final String ACQ_ZTOP = "acqZtop";
    private static final String ACQ_ZSTEP = "acqZstep";
    private static final String ACQ_ENABLE_SLICE_SETTINGS = "enableSliceSettings";
    private static final String ACQ_ENABLE_MULTI_POSITION = "enableMultiPosition";
    private static final String ACQ_ENABLE_MULTI_FRAME = "enableMultiFrame";
    private static final String ACQ_ENABLE_MULTI_CHANNEL = "enableMultiChannels";
    private static final String ACQ_ORDER_MODE = "acqOrderMode";
    private static final String ACQ_NUMFRAMES = "acqNumframes";
    private static final String ACQ_CHANNEL_GROUP = "acqChannelGroup";
    private static final String ACQ_NUM_CHANNELS = "acqNumchannels";
    private static final String ACQ_CHANNELS_KEEP_SHUTTER_OPEN = "acqChannelsKeepShutterOpen";
    private static final String ACQ_STACK_KEEP_SHUTTER_OPEN = "acqStackKeepShutterOpen";
    private static final String CHANNEL_NAME_PREFIX = "acqChannelName";
    private static final String CHANNEL_USE_PREFIX = "acqChannelUse";
    private static final String CHANNEL_EXPOSURE_PREFIX = "acqChannelExp";
    private static final String CHANNEL_ZOFFSET_PREFIX = "acqChannelZOffset";
    private static final String CHANNEL_DOZSTACK_PREFIX = "acqChannelDoZStack";
    private static final String CHANNEL_CONTRAST_MIN_PREFIX = "acqChannelContrastMin";
    private static final String CHANNEL_CONTRAST_MAX_PREFIX = "acqChannelContrastMax";
    private static final String CHANNEL_CONTRAST_GAMMA_PREFIX = "acqChannelContrstGamma";
    private static final String CHANNEL_COLOR_R_PREFIX = "acqChannelColorR";
    private static final String CHANNEL_COLOR_G_PREFIX = "acqChannelColorG";
    private static final String CHANNEL_COLOR_B_PREFIX = "acqChannelColorB";
    private static final String CHANNEL_SKIP_PREFIX = "acqSkip";
    private static final String ACQ_Z_VALUES = "acqZValues";
    private static final String ACQ_DIR_NAME = "acqDirName";
    private static final String ACQ_ROOT_NAME = "acqRootName";
    private static final String ACQ_SAVE_FILES = "acqSaveFiles";
    private static final String ACQ_DISPLAY_MODE = "acqDisplayMode";
    private static final String ACQ_AF_ENABLE = "autofocus_enabled";
    private static final String ACQ_AF_SKIP_INTERVAL = "autofocusSkipInterval";
    private static final String ACQ_COLUMN_WIDTH = "column_width";
    private static final String ACQ_COLUMN_ORDER = "column_order";
    private static final int ACQ_DEFAULT_COLUMN_WIDTH = 77;
    private static final String CUSTOM_INTERVAL_PREFIX = "customInterval";
    private static final String ACQ_ENABLE_CUSTOM_INTERVALS = "enableCustomIntervals";
    private static final FileDialogs.FileType ACQ_SETTINGS_FILE = new FileDialogs.FileType("ACQ_SETTINGS_FILE", "Acquisition settings", System.getProperty("user.home") + "/AcqSettings.xml", true, "xml");
    private int[] columnWidth_;
    private int[] columnOrder_;
    private CheckBoxPanel framesPanel_;
    private final JPanel framesSubPanel_;
    private final CardLayout framesSubPanelLayout_;
    private static final String DEFAULT_FRAMES_PANEL_NAME = "Default frames panel";
    private static final String OVERRIDE_FRAMES_PANEL_NAME = "Override frames panel";
    private CheckBoxPanel channelsPanel_;
    private CheckBoxPanel slicesPanel_;
    protected CheckBoxPanel positionsPanel_;
    private JPanel acquisitionOrderPanel_;
    private CheckBoxPanel afPanel_;
    private JPanel summaryPanel_;
    private CheckBoxPanel savePanel_;
    private ComponentTitledPanel commentsPanel_;
    private Border dayBorder_;
    private Border nightBorder_;
    private ArrayList<JPanel> panelList_;
    private boolean disableGUItoSettings_ = false;

    public final void createChannelTable() {
        this.model_ = new ChannelTableModel(this.studio_, this.acqEng_, this.exposurePrefs_, this.colorPrefs_, this.options_);
        this.model_.addTableModelListener(this.model_);
        this.channelTable_ = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Object tip = null;
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return AcqControlDlg.this.model_.getToolTipText(realIndex);
                    }
                };
            }
        };
        this.channelTable_.setFont(new Font("Dialog", 0, 10));
        this.channelTable_.setAutoCreateColumnsFromModel(false);
        this.channelTable_.setModel(this.model_);
        this.model_.setChannels(this.acqEng_.getChannels());
        ChannelCellEditor cellEditor = new ChannelCellEditor(this.acqEng_, this.exposurePrefs_, this.colorPrefs_);
        ChannelCellRenderer cellRenderer = new ChannelCellRenderer(this.acqEng_);
        this.channelTable_.setAutoResizeMode(0);
        for (int k = 0; k < this.model_.getColumnCount(); ++k) {
            int colIndex = AcqControlDlg.search(this.columnOrder_, k);
            if (colIndex < 0) {
                colIndex = k;
            }
            if (colIndex == this.model_.getColumnCount() - 1) {
                ColorRenderer cr = new ColorRenderer(true);
                ColorEditor ce = new ColorEditor(this.model_, this.model_.getColumnCount() - 1);
                TableColumn column = new TableColumn(this.model_.getColumnCount() - 1, 200, cr, ce);
                column.setPreferredWidth(this.columnWidth_[this.model_.getColumnCount() - 1]);
                this.channelTable_.addColumn(column);
                continue;
            }
            TableColumn column = new TableColumn(colIndex, 200, cellRenderer, cellEditor);
            column.setPreferredWidth(this.columnWidth_[colIndex]);
            this.channelTable_.addColumn(column);
        }
        this.channelTablePane_.setViewportView(this.channelTable_);
    }

    public JPanel createPanel(String text, int left, int top, int right, int bottom) {
        return this.createPanel(text, left, top, right, bottom, false);
    }

    public JPanel createPanel(String text, int left, int top, int right, int bottom, boolean checkBox) {
        ComponentTitledPanel thePanel = checkBox ? new CheckBoxPanel(text) : new LabelPanel(text);
        thePanel.setTitleFont(new Font("Dialog", 1, 12));
        this.panelList_.add(thePanel);
        thePanel.setBounds(left, top, right - left, bottom - top);
        this.dayBorder_ = BorderFactory.createEtchedBorder();
        this.nightBorder_ = BorderFactory.createEtchedBorder(Color.gray, Color.darkGray);
        thePanel.setLayout(null);
        this.getContentPane().add(thePanel);
        return thePanel;
    }

    public void updatePanelBorder(JPanel thePanel) {
        TitledBorder border = (TitledBorder)thePanel.getBorder();
        if (this.studio_.getBackgroundStyle().contentEquals("Day")) {
            border.setBorder(this.dayBorder_);
        } else {
            border.setBorder(this.nightBorder_);
        }
    }

    public final void createEmptyPanels() {
        this.panelList_ = new ArrayList();
        this.framesPanel_ = (CheckBoxPanel)this.createPanel("Time points", 5, 5, 220, 91, true);
        this.positionsPanel_ = (CheckBoxPanel)this.createPanel("Multiple positions (XY)", 5, 93, 220, 154, true);
        this.slicesPanel_ = (CheckBoxPanel)this.createPanel("Z-stacks (slices)", 5, 156, 220, 306, true);
        this.acquisitionOrderPanel_ = this.createPanel("Acquisition order", 226, 5, 427, 63);
        this.summaryPanel_ = this.createPanel("Summary", 226, 156, 427, 306);
        this.afPanel_ = (CheckBoxPanel)this.createPanel("Autofocus", 226, 65, 427, 154, true);
        this.channelsPanel_ = (CheckBoxPanel)this.createPanel("Channels", 5, 308, 510, 451, true);
        this.savePanel_ = (CheckBoxPanel)this.createPanel("Save images", 5, 453, 510, 560, true);
        this.commentsPanel_ = (ComponentTitledPanel)this.createPanel("Acquisition Comments", 5, 564, 530, 650, false);
    }

    private void createToolTips() {
        this.framesPanel_.setToolTipText("Acquire images over a repeating time interval");
        this.positionsPanel_.setToolTipText("Acquire images from a series of positions in the XY plane");
        this.slicesPanel_.setToolTipText("Acquire images from a series of Z positions");
        String imageName = this.getClass().getResource("/org/micromanager/icons/acq_order_figure.png").toString();
        String acqOrderToolTip = "<html>Lets you select the order of image acquisition when some combination of multiple dimensions<br>(i.e. time points, XY positions, Z-slices, or Channels)  is selected.  During image acquisition, the<br>values of each dimension are iterated in the reverse order of their listing here.  \"Time\" and \"Position\" <br>always precede \"Slice\" and \"Channel\" <br><br>For example, suppose there are are two time points, two XY positions, and two Z slices, and Acquisition<br>order is set to \"Time, Position, Slice\".  The microscope will acquire images in the following order: <br> Time point 1, XY position 1, Z-slice 1 <br>Time point 1, XY position 1, Z-slice 2 <br>Time point 1, XY position 2, Z-slice 1 <br>Time point 1, XY position 2, Z-slice 2 <br>Time point 2, XY position 1, Z-slice 1 <br>etc. <br><br><img src=" + imageName + "></html>";
        this.acquisitionOrderPanel_.setToolTipText(acqOrderToolTip);
        this.acqOrderBox_.setToolTipText(acqOrderToolTip);
        this.afPanel_.setToolTipText("Toggle autofocus on/off");
        this.channelsPanel_.setToolTipText("Lets you acquire images in multiple channels (groups of properties with multiple preset values");
        this.savePanel_.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("If the Save images option is selected, images will be saved to disk continuously during the acquisition. If this option is not selected, images are accumulated only in the 5D-Image window, and once the acquisition is finished, image data can be saved to disk. However, saving files automatically during acquisition secures the acquired data against an unexpected computer failure or accidental closing of image window. Even when saving to disk, some of the acquired images are still kept in memory, facilitating fast playback. If such behavior is not desired, check the 'Conserve RAM' option (Tools | Options)"));
    }

    public AcqControlDlg(AcquisitionEngine acqEng, Preferences prefs, ScriptInterface gui, MMOptions options) {
        this.prefs_ = prefs;
        this.studio_ = gui;
        this.guiColors_ = new GUIColors();
        this.options_ = options;
        this.setIconImage(SwingResourceManager.getImage(MMStudio.class, "icons/microscope.gif"));
        Preferences root = Preferences.userNodeForPackage(this.getClass());
        this.acqPrefs_ = root.node(root.absolutePath() + "/" + ACQ_SETTINGS_NODE);
        this.colorPrefs_ = root.node(root.absolutePath() + "/" + COLOR_SETTINGS_NODE);
        this.exposurePrefs_ = root.node(root.absolutePath() + "/" + EXPOSURE_SETTINGS_NODE);
        this.setDefaultCloseOperation(0);
        this.numberFormat_ = NumberFormat.getNumberInstance();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AcqControlDlg.this.close();
            }
        });
        this.acqEng_ = acqEng;
        acqEng.addSettingsListener(this);
        this.getContentPane().setLayout(null);
        this.setResizable(false);
        this.setTitle("Multi-Dimensional Acquisition");
        this.setBackground(this.guiColors_.background.get(this.studio_.getBackgroundStyle()));
        this.createEmptyPanels();
        JPanel defaultPanel = new JPanel();
        JPanel overridePanel = new JPanel();
        defaultPanel.setLayout(null);
        JLabel overrideLabel = new JLabel("Custom time intervals enabled");
        overrideLabel.setFont(new Font("Arial", 1, 12));
        overrideLabel.setForeground(Color.red);
        JButton disableCustomIntervalsButton = new JButton("Disable custom intervals");
        disableCustomIntervalsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.acqEng_.enableCustomTimeIntervals(false);
                AcqControlDlg.this.updateGUIContents();
            }
        });
        disableCustomIntervalsButton.setFont(new Font("Arial", 0, 10));
        overridePanel.add((Component)overrideLabel, "First");
        overridePanel.add((Component)disableCustomIntervalsButton, "Last");
        this.framesPanel_.setLayout(new BorderLayout());
        this.framesSubPanelLayout_ = new CardLayout();
        this.framesSubPanel_ = new JPanel(this.framesSubPanelLayout_);
        this.framesPanel_.add(this.framesSubPanel_);
        this.framesSubPanel_.add((Component)defaultPanel, DEFAULT_FRAMES_PANEL_NAME);
        this.framesSubPanel_.add((Component)overridePanel, OVERRIDE_FRAMES_PANEL_NAME);
        this.framesSubPanelLayout_.show(this.framesSubPanel_, DEFAULT_FRAMES_PANEL_NAME);
        this.framesPanel_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.applySettings();
            }
        });
        JLabel numberLabel = new JLabel();
        numberLabel.setFont(new Font("Arial", 0, 10));
        numberLabel.setText("Number");
        defaultPanel.add(numberLabel);
        numberLabel.setBounds(15, 0, 54, 24);
        SpinnerNumberModel sModel = new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1));
        this.numFrames_ = new JSpinner(sModel);
        ((JSpinner.DefaultEditor)this.numFrames_.getEditor()).getTextField().setFont(new Font("Arial", 0, 10));
        defaultPanel.add(this.numFrames_);
        this.numFrames_.setBounds(60, 0, 70, 24);
        this.numFrames_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AcqControlDlg.this.applySettings();
            }
        });
        JLabel intervalLabel = new JLabel();
        intervalLabel.setFont(new Font("Arial", 0, 10));
        intervalLabel.setText("Interval");
        intervalLabel.setToolTipText("Interval between successive time points.  Setting an intervalof 0 will cause micromanager to acquire 'burts' of images as fast as possible");
        defaultPanel.add(intervalLabel);
        intervalLabel.setBounds(15, 27, 43, 24);
        this.interval_ = new JFormattedTextField(this.numberFormat_);
        this.interval_.setFont(new Font("Arial", 0, 10));
        this.interval_.setValue(1.0);
        this.interval_.addPropertyChangeListener("value", this);
        defaultPanel.add(this.interval_);
        this.interval_.setBounds(60, 27, 55, 24);
        this.timeUnitCombo_ = new JComboBox();
        this.timeUnitCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.timeUnitCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"ms", "s", "min"}));
        this.timeUnitCombo_.setFont(new Font("Arial", 0, 10));
        this.timeUnitCombo_.setBounds(120, 27, 67, 24);
        defaultPanel.add(this.timeUnitCombo_);
        this.listButton_ = new JButton();
        this.listButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.studio_.showXYPositionList();
            }
        });
        this.listButton_.setToolTipText("Open XY list dialog");
        this.listButton_.setIcon(SwingResourceManager.getIcon(AcqControlDlg.class, "icons/application_view_list.png"));
        this.listButton_.setText("Edit position list...");
        this.listButton_.setMargin(new Insets(2, 5, 2, 5));
        this.listButton_.setFont(new Font("Dialog", 0, 10));
        this.listButton_.setBounds(42, 25, 136, 26);
        this.positionsPanel_.add(this.listButton_);
        this.slicesPanel_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.applySettings();
            }
        });
        JLabel zbottomLabel = new JLabel();
        zbottomLabel.setFont(new Font("Arial", 0, 10));
        zbottomLabel.setText("Z-start [um]");
        zbottomLabel.setBounds(30, 30, 69, 15);
        this.slicesPanel_.add(zbottomLabel);
        this.zBottom_ = new JFormattedTextField(this.numberFormat_);
        this.zBottom_.setFont(new Font("Arial", 0, 10));
        this.zBottom_.setBounds(95, 27, 54, 21);
        this.zBottom_.setValue(1.0);
        this.zBottom_.addPropertyChangeListener("value", this);
        this.slicesPanel_.add(this.zBottom_);
        this.setBottomButton_ = new JButton();
        this.setBottomButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.setBottomPosition();
            }
        });
        this.setBottomButton_.setMargin(new Insets(-5, -5, -5, -5));
        this.setBottomButton_.setFont(new Font("", 0, 10));
        this.setBottomButton_.setText("Set");
        this.setBottomButton_.setToolTipText("Set value as microscope's current Z position");
        this.setBottomButton_.setBounds(150, 27, 50, 22);
        this.slicesPanel_.add(this.setBottomButton_);
        JLabel ztopLabel = new JLabel();
        ztopLabel.setFont(new Font("Arial", 0, 10));
        ztopLabel.setText("Z-end [um]");
        ztopLabel.setBounds(30, 53, 69, 15);
        this.slicesPanel_.add(ztopLabel);
        this.zTop_ = new JFormattedTextField(this.numberFormat_);
        this.zTop_.setFont(new Font("Arial", 0, 10));
        this.zTop_.setBounds(95, 50, 54, 21);
        this.zTop_.setValue(1.0);
        this.zTop_.addPropertyChangeListener("value", this);
        this.slicesPanel_.add(this.zTop_);
        this.setTopButton_ = new JButton();
        this.setTopButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.setTopPosition();
            }
        });
        this.setTopButton_.setMargin(new Insets(-5, -5, -5, -5));
        this.setTopButton_.setFont(new Font("Dialog", 0, 10));
        this.setTopButton_.setText("Set");
        this.setTopButton_.setToolTipText("Set value as microscope's current Z position");
        this.setTopButton_.setBounds(150, 50, 50, 22);
        this.slicesPanel_.add(this.setTopButton_);
        JLabel zstepLabel = new JLabel();
        zstepLabel.setFont(new Font("Arial", 0, 10));
        zstepLabel.setText("Z-step [um]");
        zstepLabel.setBounds(30, 76, 69, 15);
        this.slicesPanel_.add(zstepLabel);
        this.zStep_ = new JFormattedTextField(this.numberFormat_);
        this.zStep_.setFont(new Font("Arial", 0, 10));
        this.zStep_.setBounds(95, 73, 54, 21);
        this.zStep_.setValue(1.0);
        this.zStep_.addPropertyChangeListener("value", this);
        this.slicesPanel_.add(this.zStep_);
        this.zValCombo_ = new JComboBox();
        this.zValCombo_.setFont(new Font("Arial", 0, 10));
        this.zValCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.zValCalcChanged();
            }
        });
        this.zValCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"relative Z", "absolute Z"}));
        this.zValCombo_.setBounds(30, 97, 110, 22);
        this.slicesPanel_.add(this.zValCombo_);
        this.stackKeepShutterOpenCheckBox_ = new JCheckBox();
        this.stackKeepShutterOpenCheckBox_.setText("Keep shutter open");
        this.stackKeepShutterOpenCheckBox_.setFont(new Font("Arial", 0, 10));
        this.stackKeepShutterOpenCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.applySettings();
            }
        });
        this.stackKeepShutterOpenCheckBox_.setSelected(false);
        this.stackKeepShutterOpenCheckBox_.setBounds(60, 121, 150, 22);
        this.slicesPanel_.add(this.stackKeepShutterOpenCheckBox_);
        this.acqOrderBox_ = new JComboBox();
        this.acqOrderBox_.setFont(new Font("", 0, 10));
        this.acqOrderBox_.setBounds(2, 26, 195, 22);
        this.acquisitionOrderPanel_.add(this.acqOrderBox_);
        this.acqOrderModes_ = new AcqOrderMode[4];
        this.acqOrderModes_[0] = new AcqOrderMode(0);
        this.acqOrderModes_[1] = new AcqOrderMode(1);
        this.acqOrderModes_[2] = new AcqOrderMode(2);
        this.acqOrderModes_[3] = new AcqOrderMode(3);
        this.acqOrderBox_.addItem(this.acqOrderModes_[0]);
        this.acqOrderBox_.addItem(this.acqOrderModes_[1]);
        this.acqOrderBox_.addItem(this.acqOrderModes_[2]);
        this.acqOrderBox_.addItem(this.acqOrderModes_[3]);
        this.summaryTextArea_ = new JTextArea();
        this.summaryTextArea_.setFont(new Font("Arial", 0, 11));
        this.summaryTextArea_.setEditable(false);
        this.summaryTextArea_.setBounds(4, 19, 350, 120);
        this.summaryTextArea_.setMargin(new Insets(2, 2, 2, 2));
        this.summaryTextArea_.setOpaque(false);
        this.summaryPanel_.add(this.summaryTextArea_);
        this.afPanel_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AcqControlDlg.this.applySettings();
            }
        });
        this.afButton_ = new JButton();
        this.afButton_.setToolTipText("Set autofocus options");
        this.afButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AcqControlDlg.this.afOptions();
            }
        });
        this.afButton_.setText("Options...");
        this.afButton_.setIcon(SwingResourceManager.getIcon(AcqControlDlg.class, "icons/wrench_orange.png"));
        this.afButton_.setMargin(new Insets(2, 5, 2, 5));
        this.afButton_.setFont(new Font("Dialog", 0, 10));
        this.afButton_.setBounds(50, 21, 100, 28);
        this.afPanel_.add(this.afButton_);
        JLabel afSkipFrame1 = new JLabel();
        afSkipFrame1.setFont(new Font("Dialog", 0, 10));
        afSkipFrame1.setText("Skip frame(s): ");
        afSkipFrame1.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("The number of 'frames skipped' correspondsto the number of time intervals of image acquisition that pass before micromanager autofocuses again.  Micromanager will always autofocus when moving to a new position regardless of this value"));
        afSkipFrame1.setBounds(35, 54, 70, 21);
        this.afPanel_.add(afSkipFrame1);
        this.afSkipInterval_ = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        ((JSpinner.DefaultEditor)this.afSkipInterval_.getEditor()).getTextField().setFont(new Font("Arial", 0, 10));
        this.afSkipInterval_.setBounds(105, 54, 55, 22);
        this.afSkipInterval_.setValue(this.acqEng_.getAfSkipInterval());
        this.afSkipInterval_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AcqControlDlg.this.applySettings();
                AcqControlDlg.this.afSkipInterval_.setValue(AcqControlDlg.this.acqEng_.getAfSkipInterval());
            }
        });
        this.afPanel_.add(this.afSkipInterval_);
        this.channelsPanel_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.applySettings();
            }
        });
        JLabel channelsLabel = new JLabel();
        channelsLabel.setFont(new Font("Arial", 0, 10));
        channelsLabel.setBounds(90, 19, 80, 24);
        channelsLabel.setText("Channel group:");
        this.channelsPanel_.add(channelsLabel);
        this.channelGroupCombo_ = new JComboBox();
        this.channelGroupCombo_.setFont(new Font("", 0, 10));
        this.updateGroupsCombo();
        this.channelGroupCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String newGroup = (String)AcqControlDlg.this.channelGroupCombo_.getSelectedItem();
                if (AcqControlDlg.this.acqEng_.setChannelGroup(newGroup)) {
                    AcqControlDlg.this.model_.cleanUpConfigurationList();
                    if (AcqControlDlg.this.studio_.getAutofocusManager() != null) {
                        try {
                            AcqControlDlg.this.studio_.getAutofocusManager().refresh();
                        }
                        catch (MMException e) {
                            ReportingUtils.showError(e);
                        }
                    }
                } else {
                    AcqControlDlg.this.updateGroupsCombo();
                }
            }
        });
        this.channelGroupCombo_.setBounds(165, 20, 150, 22);
        this.channelsPanel_.add(this.channelGroupCombo_);
        this.channelTablePane_ = new JScrollPane();
        this.channelTablePane_.setFont(new Font("Arial", 0, 10));
        this.channelTablePane_.setBounds(10, 45, 414, 90);
        this.channelsPanel_.add(this.channelTablePane_);
        JButton addButton = new JButton();
        addButton.setFont(new Font("Arial", 0, 10));
        addButton.setMargin(new Insets(0, 0, 0, 0));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.applySettings();
                AcqControlDlg.this.model_.addNewChannel();
                AcqControlDlg.this.model_.fireTableStructureChanged();
            }
        });
        addButton.setText("New");
        addButton.setToolTipText("Create new channel for currently selected channel group");
        addButton.setBounds(430, 45, 68, 22);
        this.channelsPanel_.add(addButton);
        JButton removeButton = new JButton();
        removeButton.setFont(new Font("Arial", 0, 10));
        removeButton.setMargin(new Insets(-5, -5, -5, -5));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int sel = AcqControlDlg.this.channelTable_.getSelectedRow();
                if (sel > -1) {
                    AcqControlDlg.this.applySettings();
                    AcqControlDlg.this.model_.removeChannel(sel);
                    AcqControlDlg.this.model_.fireTableStructureChanged();
                    if (AcqControlDlg.this.channelTable_.getRowCount() > sel) {
                        AcqControlDlg.this.channelTable_.setRowSelectionInterval(sel, sel);
                    }
                }
            }
        });
        removeButton.setText("Remove");
        removeButton.setToolTipText("Remove currently selected channel");
        removeButton.setBounds(430, 69, 68, 22);
        this.channelsPanel_.add(removeButton);
        JButton upButton = new JButton();
        upButton.setFont(new Font("Arial", 0, 10));
        upButton.setMargin(new Insets(0, 0, 0, 0));
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int sel = AcqControlDlg.this.channelTable_.getSelectedRow();
                if (sel > -1) {
                    AcqControlDlg.this.applySettings();
                    int newSel = AcqControlDlg.this.model_.rowUp(sel);
                    AcqControlDlg.this.model_.fireTableStructureChanged();
                    AcqControlDlg.this.channelTable_.setRowSelectionInterval(newSel, newSel);
                }
            }
        });
        upButton.setText("Up");
        upButton.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("Move currently selected channel up (Channels higher on list are acquired first)"));
        upButton.setBounds(430, 93, 68, 22);
        this.channelsPanel_.add(upButton);
        JButton downButton = new JButton();
        downButton.setFont(new Font("Arial", 0, 10));
        downButton.setMargin(new Insets(0, 0, 0, 0));
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int sel = AcqControlDlg.this.channelTable_.getSelectedRow();
                if (sel > -1) {
                    AcqControlDlg.this.applySettings();
                    int newSel = AcqControlDlg.this.model_.rowDown(sel);
                    AcqControlDlg.this.model_.fireTableStructureChanged();
                    AcqControlDlg.this.channelTable_.setRowSelectionInterval(newSel, newSel);
                }
            }
        });
        downButton.setText("Down");
        downButton.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("Move currently selected channel down (Channels lower on list are acquired later)"));
        downButton.setBounds(430, 117, 68, 22);
        this.channelsPanel_.add(downButton);
        this.chanKeepShutterOpenCheckBox_ = new JCheckBox();
        this.chanKeepShutterOpenCheckBox_.setText("Keep shutter open");
        this.chanKeepShutterOpenCheckBox_.setFont(new Font("Arial", 0, 10));
        this.chanKeepShutterOpenCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.applySettings();
            }
        });
        this.chanKeepShutterOpenCheckBox_.setSelected(false);
        this.chanKeepShutterOpenCheckBox_.setBounds(330, 20, 150, 22);
        this.channelsPanel_.add(this.chanKeepShutterOpenCheckBox_);
        this.savePanel_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AcqControlDlg.this.savePanel_.isSelected()) {
                    AcqControlDlg.this.displayModeCombo_.setSelectedIndex(0);
                }
                AcqControlDlg.this.applySettings();
            }
        });
        this.displayMode_ = new JLabel();
        this.displayMode_.setFont(new Font("Arial", 0, 10));
        this.displayMode_.setText("Display");
        this.displayMode_.setBounds(150, 15, 49, 21);
        this.displayModeCombo_ = new JComboBox();
        this.displayModeCombo_.setFont(new Font("", 0, 10));
        this.displayModeCombo_.setBounds(188, 14, 150, 24);
        this.displayModeCombo_.addItem(new DisplayMode(0));
        this.displayModeCombo_.addItem(new DisplayMode(1));
        this.displayModeCombo_.addItem(new DisplayMode(2));
        this.displayModeCombo_.setEnabled(false);
        this.rootLabel_ = new JLabel();
        this.rootLabel_.setFont(new Font("Arial", 0, 10));
        this.rootLabel_.setText("Directory root");
        this.rootLabel_.setBounds(10, 30, 72, 22);
        this.savePanel_.add(this.rootLabel_);
        this.rootField_ = new JTextField();
        this.rootField_.setFont(new Font("Arial", 0, 10));
        this.rootField_.setBounds(90, 30, 354, 22);
        this.savePanel_.add(this.rootField_);
        this.browseRootButton_ = new JButton();
        this.browseRootButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.setRootDirectory();
            }
        });
        this.browseRootButton_.setMargin(new Insets(2, 5, 2, 5));
        this.browseRootButton_.setFont(new Font("Dialog", 0, 10));
        this.browseRootButton_.setText("...");
        this.browseRootButton_.setBounds(445, 30, 47, 24);
        this.savePanel_.add(this.browseRootButton_);
        this.browseRootButton_.setToolTipText("Browse");
        this.namePrefixLabel_ = new JLabel();
        this.namePrefixLabel_.setFont(new Font("Arial", 0, 10));
        this.namePrefixLabel_.setText("Name prefix");
        this.namePrefixLabel_.setBounds(10, 55, 76, 22);
        this.savePanel_.add(this.namePrefixLabel_);
        this.nameField_ = new JTextField();
        this.nameField_.setFont(new Font("Arial", 0, 10));
        this.nameField_.setBounds(90, 55, 354, 22);
        this.savePanel_.add(this.nameField_);
        this.saveTypeLabel_ = new JLabel("Saving format: ");
        this.saveTypeLabel_.setFont(new Font("Arial", 0, 10));
        this.saveTypeLabel_.setBounds(10, 80, 100, 22);
        this.savePanel_.add(this.saveTypeLabel_);
        this.singleButton_ = new JRadioButton("Separate image files");
        this.singleButton_.setFont(new Font("Arial", 0, 10));
        this.singleButton_.setBounds(110, 80, 150, 22);
        this.savePanel_.add(this.singleButton_);
        this.singleButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageUtils.setImageStorageClass(TaggedImageStorageDiskDefault.class);
            }
        });
        this.multiButton_ = new JRadioButton("Image stack file");
        this.multiButton_.setFont(new Font("Arial", 0, 10));
        this.multiButton_.setBounds(260, 80, 200, 22);
        this.savePanel_.add(this.multiButton_);
        this.multiButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageUtils.setImageStorageClass(TaggedImageStorageMultipageTiff.class);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.singleButton_);
        buttonGroup.add(this.multiButton_);
        this.updateSavingTypeButtons();
        JScrollPane commentScrollPane = new JScrollPane();
        commentScrollPane.setBounds(10, 28, 485, 50);
        this.commentsPanel_.add(commentScrollPane);
        this.commentTextArea_ = new JTextArea();
        commentScrollPane.setViewportView(this.commentTextArea_);
        this.commentTextArea_.setFont(new Font("", 0, 10));
        this.commentTextArea_.setToolTipText("Comment for the current acquistion");
        this.commentTextArea_.setWrapStyleWord(true);
        this.commentTextArea_.setLineWrap(true);
        this.commentTextArea_.setBorder(new EtchedBorder(1));
        JButton closeButton = new JButton();
        closeButton.setFont(new Font("Arial", 0, 10));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.saveSettings();
                AcqControlDlg.this.saveAcqSettings();
                AcqControlDlg.this.dispose();
                AcqControlDlg.this.studio_.makeActive();
            }
        });
        closeButton.setText("Close");
        closeButton.setBounds(432, 10, 80, 22);
        this.getContentPane().add(closeButton);
        this.acquireButton_ = new JButton();
        this.acquireButton_.setMargin(new Insets(-9, -9, -9, -9));
        this.acquireButton_.setFont(new Font("Arial", 1, 12));
        this.acquireButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractCellEditor ae = (AbstractCellEditor)((Object)AcqControlDlg.this.channelTable_.getCellEditor());
                if (ae != null) {
                    ae.stopCellEditing();
                }
                AcqControlDlg.this.runAcquisition();
            }
        });
        this.acquireButton_.setText("Acquire!");
        this.acquireButton_.setBounds(432, 44, 80, 22);
        this.getContentPane().add(this.acquireButton_);
        JButton stopButton = new JButton();
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.acqEng_.abortRequest();
            }
        });
        stopButton.setText("Stop");
        stopButton.setFont(new Font("Arial", 1, 12));
        stopButton.setBounds(432, 68, 80, 22);
        this.getContentPane().add(stopButton);
        JButton loadButton = new JButton();
        loadButton.setFont(new Font("Arial", 0, 10));
        loadButton.setMargin(new Insets(-5, -5, -5, -5));
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.loadAcqSettingsFromFile();
            }
        });
        loadButton.setText("Load...");
        loadButton.setBounds(432, 102, 80, 22);
        this.getContentPane().add(loadButton);
        loadButton.setToolTipText("Load acquisition settings");
        JButton saveAsButton = new JButton();
        saveAsButton.setFont(new Font("Arial", 0, 10));
        saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.saveAsAcqSettingsToFile();
            }
        });
        saveAsButton.setToolTipText("Save current acquisition settings as");
        saveAsButton.setText("Save as...");
        saveAsButton.setBounds(432, 126, 80, 22);
        saveAsButton.setMargin(new Insets(-5, -5, -5, -5));
        this.getContentPane().add(saveAsButton);
        JButton advancedButton = new JButton();
        advancedButton.setFont(new Font("Arial", 0, 10));
        advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.showAdvancedDialog();
                AcqControlDlg.this.updateGUIContents();
            }
        });
        advancedButton.setText("Advanced");
        advancedButton.setBounds(432, 170, 80, 22);
        this.getContentPane().add(advancedButton);
        this.positionsPanel_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AcqControlDlg.this.applySettings();
            }
        });
        this.displayModeCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.applySettings();
            }
        });
        this.acqOrderBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AcqControlDlg.this.applySettings();
            }
        });
        this.loadAcqSettings();
        this.createChannelTable();
        this.updateGUIContents();
        this.applySettings();
        this.createToolTips();
        this.loadAndRestorePosition(100, 100);
        this.setSize(521, 690);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.applySettings();
        this.summaryTextArea_.setText(this.acqEng_.getVerboseSummary());
    }

    public void setChannelExposureTime(String channelGroup, String channel, double exposure) {
        if (!channelGroup.equals(this.acqEng_.getChannelGroup()) || this.acqEng_.getChannelConfigs().length <= 0) {
            return;
        }
        for (String config : this.acqEng_.getChannelConfigs()) {
            if (!channel.equals(config)) continue;
            this.exposurePrefs_.putDouble("Exposure_" + this.acqEng_.getChannelGroup() + "_" + channel, exposure);
            this.model_.setChannelExposureTime(channelGroup, channel, exposure);
        }
    }

    public double getChannelExposureTime(String channelGroup, String channel, double defaultExp) {
        return this.exposurePrefs_.getDouble("Exposure_" + channelGroup + "_" + channel, defaultExp);
    }

    protected void afOptions() {
        if (this.studio_.getAutofocusManager().getDevice() != null) {
            this.studio_.getAutofocusManager().showOptionsDialog();
        }
    }

    public boolean inArray(String member, String[] group) {
        for (int i = 0; i < group.length; ++i) {
            if (!member.equals(group[i])) continue;
            return true;
        }
        return false;
    }

    public final void updateSavingTypeButtons() {
        if (ImageUtils.getImageStorageClass().equals(TaggedImageStorageDiskDefault.class)) {
            this.singleButton_.setSelected(true);
        } else if (ImageUtils.getImageStorageClass().equals(TaggedImageStorageMultipageTiff.class)) {
            this.multiButton_.setSelected(true);
        }
    }

    public void close() {
        try {
            this.saveSettings();
        }
        catch (Throwable t) {
            ReportingUtils.logError(t, "in saveSettings");
        }
        try {
            this.saveAcqSettings();
        }
        catch (Throwable t) {
            ReportingUtils.logError(t, "in saveAcqSettings");
        }
        try {
            this.dispose();
        }
        catch (Throwable t) {
            ReportingUtils.logError(t, "in dispose");
        }
        if (null != this.studio_) {
            try {
                this.studio_.makeActive();
            }
            catch (Throwable t) {
                ReportingUtils.logError(t, "in makeActive");
            }
        }
    }

    public final void updateGroupsCombo() {
        String[] groups = this.acqEng_.getAvailableGroups();
        if (groups.length != 0) {
            this.channelGroupCombo_.setModel(new DefaultComboBoxModel<String>(groups));
            if (!this.inArray(this.acqEng_.getChannelGroup(), groups)) {
                this.acqEng_.setChannelGroup(this.acqEng_.getFirstConfigGroup());
            }
            this.channelGroupCombo_.setSelectedItem(this.acqEng_.getChannelGroup());
        }
    }

    public void updateChannelAndGroupCombo() {
        this.updateGroupsCombo();
        this.model_.cleanUpConfigurationList();
    }

    public final synchronized void loadAcqSettings() {
        Component[] comps;
        this.disableGUItoSettings_ = true;
        this.acqEng_.clear();
        int numFrames = this.acqPrefs_.getInt(ACQ_NUMFRAMES, 1);
        double interval = this.acqPrefs_.getDouble(ACQ_INTERVAL, 0.0);
        this.acqEng_.setFrames(numFrames, interval);
        this.acqEng_.enableFramesSetting(this.acqPrefs_.getBoolean(ACQ_ENABLE_MULTI_FRAME, false));
        boolean framesEnabled = this.acqEng_.isFramesSettingEnabled();
        this.framesPanel_.setSelected(framesEnabled);
        this.framesPanel_.setSelected(framesEnabled);
        for (Component c : comps = this.framesSubPanel_.getComponents()) {
            for (Component co : ((JPanel)c).getComponents()) {
                co.setEnabled(framesEnabled);
            }
        }
        this.framesPanel_.repaint();
        this.numFrames_.setValue(this.acqEng_.getNumFrames());
        int unit = this.acqPrefs_.getInt(ACQ_TIME_UNIT, 0);
        this.timeUnitCombo_.setSelectedIndex(unit);
        double bottom = this.acqPrefs_.getDouble(ACQ_ZBOTTOM, 0.0);
        double top = this.acqPrefs_.getDouble(ACQ_ZTOP, 0.0);
        double step = this.acqPrefs_.getDouble(ACQ_ZSTEP, 1.0);
        if (Math.abs(step) < Math.abs(this.acqEng_.getMinZStepUm())) {
            step = this.acqEng_.getMinZStepUm();
        }
        this.zVals_ = this.acqPrefs_.getInt(ACQ_Z_VALUES, 0);
        this.acqEng_.setSlices(bottom, top, step, this.zVals_ != 0);
        this.acqEng_.enableZSliceSetting(this.acqPrefs_.getBoolean(ACQ_ENABLE_SLICE_SETTINGS, this.acqEng_.isZSliceSettingEnabled()));
        this.acqEng_.enableMultiPosition(this.acqPrefs_.getBoolean(ACQ_ENABLE_MULTI_POSITION, this.acqEng_.isMultiPositionEnabled()));
        this.positionsPanel_.setSelected(this.acqEng_.isMultiPositionEnabled());
        this.positionsPanel_.repaint();
        this.slicesPanel_.setSelected(this.acqEng_.isZSliceSettingEnabled());
        this.slicesPanel_.repaint();
        this.acqEng_.enableChannelsSetting(this.acqPrefs_.getBoolean(ACQ_ENABLE_MULTI_CHANNEL, false));
        this.channelsPanel_.setSelected(this.acqEng_.isChannelsSettingEnabled());
        this.channelsPanel_.repaint();
        this.savePanel_.setSelected(this.acqPrefs_.getBoolean(ACQ_SAVE_FILES, false));
        this.nameField_.setText(this.acqPrefs_.get(ACQ_DIR_NAME, "Untitled"));
        String os_name = System.getProperty("os.name", "");
        this.rootField_.setText(this.acqPrefs_.get(ACQ_ROOT_NAME, System.getProperty("user.home") + "/AcquisitionData"));
        this.acqEng_.setAcqOrderMode(this.acqPrefs_.getInt(ACQ_ORDER_MODE, this.acqEng_.getAcqOrderMode()));
        this.acqEng_.setDisplayMode(this.acqPrefs_.getInt(ACQ_DISPLAY_MODE, this.acqEng_.getDisplayMode()));
        this.acqEng_.enableAutoFocus(this.acqPrefs_.getBoolean(ACQ_AF_ENABLE, this.acqEng_.isAutoFocusEnabled()));
        this.acqEng_.setAfSkipInterval(this.acqPrefs_.getInt(ACQ_AF_SKIP_INTERVAL, this.acqEng_.getAfSkipInterval()));
        this.acqEng_.setChannelGroup(this.acqPrefs_.get(ACQ_CHANNEL_GROUP, this.acqEng_.getFirstConfigGroup()));
        this.afPanel_.setSelected(this.acqEng_.isAutoFocusEnabled());
        this.acqEng_.keepShutterOpenForChannels(this.acqPrefs_.getBoolean(ACQ_CHANNELS_KEEP_SHUTTER_OPEN, false));
        this.acqEng_.keepShutterOpenForStack(this.acqPrefs_.getBoolean(ACQ_STACK_KEEP_SHUTTER_OPEN, false));
        ArrayList<Double> customIntervals = new ArrayList<Double>();
        int h = 0;
        while (true) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!(this.acqPrefs_.getDouble(stringBuilder.append(CUSTOM_INTERVAL_PREFIX).append(h).toString(), -1.0) >= 0.0)) break;
            customIntervals.add(this.acqPrefs_.getDouble(CUSTOM_INTERVAL_PREFIX + h, -1.0));
            ++h;
        }
        double[] intervals = new double[customIntervals.size()];
        for (int j = 0; j < intervals.length; ++j) {
            intervals[j] = (Double)customIntervals.get(j);
        }
        this.acqEng_.setCustomTimeIntervals(intervals);
        this.acqEng_.enableCustomTimeIntervals(this.acqPrefs_.getBoolean(ACQ_ENABLE_CUSTOM_INTERVALS, false));
        int numChannels = this.acqPrefs_.getInt(ACQ_NUM_CHANNELS, 0);
        ChannelSpec defaultChannel = new ChannelSpec();
        this.acqEng_.getChannels().clear();
        for (int i = 0; i < numChannels; ++i) {
            String name = this.acqPrefs_.get(CHANNEL_NAME_PREFIX + i, "Undefined");
            boolean use = this.acqPrefs_.getBoolean(CHANNEL_USE_PREFIX + i, true);
            double exp = this.acqPrefs_.getDouble(CHANNEL_EXPOSURE_PREFIX + i, 0.0);
            Boolean doZStack = this.acqPrefs_.getBoolean(CHANNEL_DOZSTACK_PREFIX + i, true);
            double zOffset = this.acqPrefs_.getDouble(CHANNEL_ZOFFSET_PREFIX + i, 0.0);
            ContrastSettings con = new ContrastSettings();
            con.min = this.acqPrefs_.getInt(CHANNEL_CONTRAST_MIN_PREFIX + i, defaultChannel.contrast.min);
            con.max = this.acqPrefs_.getInt(CHANNEL_CONTRAST_MAX_PREFIX + i, defaultChannel.contrast.max);
            con.gamma = this.acqPrefs_.getDouble(CHANNEL_CONTRAST_GAMMA_PREFIX + i, defaultChannel.contrast.gamma);
            int r = this.acqPrefs_.getInt(CHANNEL_COLOR_R_PREFIX + i, defaultChannel.color.getRed());
            int g = this.acqPrefs_.getInt(CHANNEL_COLOR_G_PREFIX + i, defaultChannel.color.getGreen());
            int b = this.acqPrefs_.getInt(CHANNEL_COLOR_B_PREFIX + i, defaultChannel.color.getBlue());
            int skip = this.acqPrefs_.getInt(CHANNEL_SKIP_PREFIX + i, defaultChannel.skipFactorFrame);
            Color c = new Color(r, g, b);
            this.acqEng_.addChannel(name, exp, doZStack, zOffset, con, skip, c, use);
        }
        int columnCount = 7;
        this.columnWidth_ = new int[columnCount];
        this.columnOrder_ = new int[columnCount];
        for (int k = 0; k < columnCount; ++k) {
            this.columnWidth_[k] = this.acqPrefs_.getInt(ACQ_COLUMN_WIDTH + k, 77);
            this.columnOrder_[k] = this.acqPrefs_.getInt(ACQ_COLUMN_ORDER + k, k);
        }
        this.disableGUItoSettings_ = false;
    }

    public synchronized void saveAcqSettings() {
        try {
            this.acqPrefs_.clear();
        }
        catch (BackingStoreException e) {
            ReportingUtils.showError(e);
        }
        this.applySettings();
        this.acqPrefs_.putBoolean(ACQ_ENABLE_MULTI_FRAME, this.acqEng_.isFramesSettingEnabled());
        this.acqPrefs_.putBoolean(ACQ_ENABLE_MULTI_CHANNEL, this.acqEng_.isChannelsSettingEnabled());
        this.acqPrefs_.putInt(ACQ_NUMFRAMES, this.acqEng_.getNumFrames());
        this.acqPrefs_.putDouble(ACQ_INTERVAL, this.acqEng_.getFrameIntervalMs());
        this.acqPrefs_.putInt(ACQ_TIME_UNIT, this.timeUnitCombo_.getSelectedIndex());
        this.acqPrefs_.putDouble(ACQ_ZBOTTOM, this.acqEng_.getSliceZBottomUm());
        this.acqPrefs_.putDouble(ACQ_ZTOP, this.acqEng_.getZTopUm());
        this.acqPrefs_.putDouble(ACQ_ZSTEP, this.acqEng_.getSliceZStepUm());
        this.acqPrefs_.putBoolean(ACQ_ENABLE_SLICE_SETTINGS, this.acqEng_.isZSliceSettingEnabled());
        this.acqPrefs_.putBoolean(ACQ_ENABLE_MULTI_POSITION, this.acqEng_.isMultiPositionEnabled());
        this.acqPrefs_.putInt(ACQ_Z_VALUES, this.zVals_);
        this.acqPrefs_.putBoolean(ACQ_SAVE_FILES, this.savePanel_.isSelected());
        this.acqPrefs_.put(ACQ_DIR_NAME, this.nameField_.getText());
        this.acqPrefs_.put(ACQ_ROOT_NAME, this.rootField_.getText());
        this.acqPrefs_.putInt(ACQ_ORDER_MODE, this.acqEng_.getAcqOrderMode());
        this.acqPrefs_.putInt(ACQ_DISPLAY_MODE, this.acqEng_.getDisplayMode());
        this.acqPrefs_.putBoolean(ACQ_AF_ENABLE, this.acqEng_.isAutoFocusEnabled());
        this.acqPrefs_.putInt(ACQ_AF_SKIP_INTERVAL, this.acqEng_.getAfSkipInterval());
        this.acqPrefs_.putBoolean(ACQ_CHANNELS_KEEP_SHUTTER_OPEN, this.acqEng_.isShutterOpenForChannels());
        this.acqPrefs_.putBoolean(ACQ_STACK_KEEP_SHUTTER_OPEN, this.acqEng_.isShutterOpenForStack());
        this.acqPrefs_.put(ACQ_CHANNEL_GROUP, this.acqEng_.getChannelGroup());
        ArrayList<ChannelSpec> channels = this.acqEng_.getChannels();
        this.acqPrefs_.putInt(ACQ_NUM_CHANNELS, channels.size());
        for (int i = 0; i < channels.size(); ++i) {
            ChannelSpec channel = channels.get(i);
            this.acqPrefs_.put(CHANNEL_NAME_PREFIX + i, channel.config);
            this.acqPrefs_.putBoolean(CHANNEL_USE_PREFIX + i, channel.useChannel);
            this.acqPrefs_.putDouble(CHANNEL_EXPOSURE_PREFIX + i, channel.exposure);
            this.acqPrefs_.putBoolean(CHANNEL_DOZSTACK_PREFIX + i, channel.doZStack);
            this.acqPrefs_.putDouble(CHANNEL_ZOFFSET_PREFIX + i, channel.zOffset);
            this.acqPrefs_.putInt(CHANNEL_CONTRAST_MIN_PREFIX + i, channel.contrast.min);
            this.acqPrefs_.putInt(CHANNEL_CONTRAST_MAX_PREFIX + i, channel.contrast.max);
            this.acqPrefs_.putDouble(CHANNEL_CONTRAST_GAMMA_PREFIX + i, channel.contrast.gamma);
            this.acqPrefs_.putInt(CHANNEL_COLOR_R_PREFIX + i, channel.color.getRed());
            this.acqPrefs_.putInt(CHANNEL_COLOR_G_PREFIX + i, channel.color.getGreen());
            this.acqPrefs_.putInt(CHANNEL_COLOR_B_PREFIX + i, channel.color.getBlue());
            this.acqPrefs_.putInt(CHANNEL_SKIP_PREFIX + i, channel.skipFactorFrame);
        }
        double[] customIntervals = this.acqEng_.getCustomTimeIntervals();
        if (customIntervals != null && customIntervals.length > 0) {
            for (int h = 0; h < customIntervals.length; ++h) {
                this.acqPrefs_.putDouble(CUSTOM_INTERVAL_PREFIX + h, customIntervals[h]);
            }
        }
        this.acqPrefs_.putBoolean(ACQ_ENABLE_CUSTOM_INTERVALS, this.acqEng_.customTimeIntervalsEnabled());
        for (int k = 0; k < this.model_.getColumnCount(); ++k) {
            this.acqPrefs_.putInt(ACQ_COLUMN_WIDTH + k, this.findTableColumn(this.channelTable_, k).getWidth());
            this.acqPrefs_.putInt(ACQ_COLUMN_ORDER + k, this.channelTable_.convertColumnIndexToView(k));
        }
        try {
            this.acqPrefs_.flush();
        }
        catch (BackingStoreException ex) {
            ReportingUtils.logError(ex);
        }
    }

    public TableColumn findTableColumn(JTable table, int columnModelIndex) {
        Enumeration<TableColumn> e = table.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            TableColumn col = e.nextElement();
            if (col.getModelIndex() != columnModelIndex) continue;
            return col;
        }
        return null;
    }

    protected void enableZSliceControls(boolean state) {
        this.zBottom_.setEnabled(state);
        this.zTop_.setEnabled(state);
        this.zStep_.setEnabled(state);
        this.zValCombo_.setEnabled(state);
    }

    protected void setRootDirectory() {
        File result = FileDialogs.openDir(this, "Please choose a directory root for image data", MMStudio.MM_DATA_SET);
        if (result != null) {
            this.rootField_.setText(result.getAbsolutePath());
            this.acqEng_.setRootName(result.getAbsolutePath());
        }
    }

    public void setTopPosition() {
        double z = this.acqEng_.getCurrentZPos();
        this.zTop_.setText(NumberUtils.doubleToDisplayString(z));
        this.applySettings();
        this.summaryTextArea_.setText(this.acqEng_.getVerboseSummary());
    }

    protected void setBottomPosition() {
        double z = this.acqEng_.getCurrentZPos();
        this.zBottom_.setText(NumberUtils.doubleToDisplayString(z));
        this.applySettings();
        this.summaryTextArea_.setText(this.acqEng_.getVerboseSummary());
    }

    protected void loadAcqSettingsFromFile() {
        File f = FileDialogs.openFile(this, "Load acquisition settings", ACQ_SETTINGS_FILE);
        if (f != null) {
            try {
                this.loadAcqSettingsFromFile(f.getAbsolutePath());
            }
            catch (MMScriptException ex) {
                ReportingUtils.showError("Failed to load Acquisition setting file");
            }
        }
    }

    public void loadAcqSettingsFromFile(String path) throws MMScriptException {
        this.acqFile_ = new File(path);
        try {
            FileInputStream in = new FileInputStream(this.acqFile_);
            this.acqPrefs_.clear();
            Preferences.importPreferences(in);
            this.loadAcqSettings();
            GUIUtils.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    AcqControlDlg.this.updateGUIContents();
                }
            });
            this.acqDir_ = this.acqFile_.getParent();
            if (this.acqDir_ != null) {
                this.prefs_.put(ACQ_FILE_DIR, this.acqDir_);
            }
        }
        catch (Exception e) {
            throw new MMScriptException(e);
        }
    }

    protected boolean saveAsAcqSettingsToFile() {
        this.saveAcqSettings();
        File f = FileDialogs.save(this, "Save the acquisition settings file", ACQ_SETTINGS_FILE);
        if (f != null) {
            try {
                FileOutputStream os = new FileOutputStream(f);
                this.acqPrefs_.exportNode(os);
            }
            catch (FileNotFoundException e) {
                ReportingUtils.showError(e);
                return false;
            }
            catch (IOException e) {
                ReportingUtils.showError(e);
                return false;
            }
            catch (BackingStoreException e) {
                ReportingUtils.showError(e);
                return false;
            }
            return true;
        }
        return false;
    }

    private long estimateMemoryUsage() {
        int numImages;
        double zStep;
        double zBottom;
        double zTop;
        boolean channels = this.channelsPanel_.isSelected();
        boolean frames = this.framesPanel_.isSelected();
        boolean slices = this.slicesPanel_.isSelected();
        boolean positions = this.positionsPanel_.isSelected();
        int numFrames = Math.max(1, (Integer)this.numFrames_.getValue());
        if (this.acqEng_.customTimeIntervalsEnabled()) {
            int h = 0;
            while (true) {
                StringBuilder stringBuilder = new StringBuilder();
                if (!(this.acqPrefs_.getDouble(stringBuilder.append(CUSTOM_INTERVAL_PREFIX).append(h).toString(), -1.0) >= 0.0)) break;
                ++h;
            }
            numFrames = Math.max(1, h);
        }
        try {
            zTop = NumberUtils.displayStringToDouble(this.zTop_.getText());
            zBottom = NumberUtils.displayStringToDouble(this.zBottom_.getText());
            zStep = NumberUtils.displayStringToDouble(this.zStep_.getText());
        }
        catch (ParseException ex) {
            ReportingUtils.showError("Invalid Z-Stacks input value");
            return -1L;
        }
        int numSlices = Math.max(1, (int)(1.0 + Math.floor(Math.abs(zTop - zBottom) / zStep)));
        int numPositions = 1;
        try {
            numPositions = Math.max(1, this.studio_.getPositionList().getNumberOfPositions());
        }
        catch (MMScriptException ex) {
            ReportingUtils.showError(ex);
        }
        if (channels) {
            ArrayList<ChannelSpec> list = ((ChannelTableModel)this.channelTable_.getModel()).getChannels();
            ArrayList<Integer> imagesPerChannel = new ArrayList<Integer>();
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get((int)i).useChannel) continue;
                int num = 1;
                if (frames) {
                    num *= Math.max(1, numFrames / (list.get((int)i).skipFactorFrame + 1));
                }
                if (slices && list.get((int)i).doZStack.booleanValue()) {
                    num *= numSlices;
                }
                if (positions) {
                    num *= numPositions;
                }
                imagesPerChannel.add(num);
            }
            numImages = 0;
            for (Integer i : imagesPerChannel) {
                numImages += i.intValue();
            }
        } else {
            numImages = 1;
            if (slices) {
                numImages *= numSlices;
            }
            if (frames) {
                numImages *= numFrames;
            }
            if (positions) {
                numImages *= numPositions;
            }
        }
        CMMCore core = MMStudio.getInstance().getCore();
        long byteDepth = core.getBytesPerPixel();
        long width = core.getImageWidth();
        long height = core.getImageHeight();
        long bytesPerImage = byteDepth * width * height;
        return bytesPerImage * (long)numImages;
    }

    private boolean warnIfMemoryMayNotBeSufficient() {
        long freeRAM;
        if (this.savePanel_.isSelected()) {
            return true;
        }
        long acqTotalBytes = this.estimateMemoryUsage();
        if (acqTotalBytes < 0L) {
            return false;
        }
        OperatingSystemMXBean osMXB = ManagementFactory.getOperatingSystemMXBean();
        try {
            Class<?> sunOSMXBClass = Class.forName("com.sun.management.OperatingSystemMXBean");
            Method freeMemMethod = sunOSMXBClass.getMethod("getFreePhysicalMemorySize", new Class[0]);
            freeRAM = (Long)freeMemMethod.invoke((Object)osMXB, new Object[0]);
        }
        catch (Exception e) {
            return true;
        }
        if ((double)acqTotalBytes > 0.8 * (double)freeRAM) {
            int answer = JOptionPane.showConfirmDialog(this, "<html><body><p width='400'>Available RAM may not be sufficient for this acquisition (the estimate is approximate). After RAM is exhausted, the acquisition may slow down or fail.</p><p>Would you like to start the acquisition anyway?</p></body></html>", "Insufficient memory warning", 0);
            return answer == 0;
        }
        return true;
    }

    public String runAcquisition() {
        if (this.acqEng_.isAcquisitionRunning()) {
            JOptionPane.showMessageDialog(this, "Cannot start acquisition: previous acquisition still in progress.");
            return null;
        }
        if (!this.warnIfMemoryMayNotBeSufficient()) {
            return null;
        }
        try {
            this.applySettings();
            ChannelTableModel model = (ChannelTableModel)this.channelTable_.getModel();
            if (this.acqEng_.isChannelsSettingEnabled() && model.duplicateChannels()) {
                JOptionPane.showMessageDialog(this, "Cannot start acquisition using the same channel twice");
                return null;
            }
            return this.acqEng_.acquire();
        }
        catch (MMException e) {
            ReportingUtils.showError(e);
            return null;
        }
    }

    public String runAcquisition(String acqName, String acqRoot) {
        if (this.acqEng_.isAcquisitionRunning()) {
            JOptionPane.showMessageDialog(this, "Unable to start the new acquisition task: previous acquisition still in progress.");
            return null;
        }
        if (!this.warnIfMemoryMayNotBeSufficient()) {
            return null;
        }
        try {
            this.applySettings();
            ChannelTableModel model = (ChannelTableModel)this.channelTable_.getModel();
            if (this.acqEng_.isChannelsSettingEnabled() && model.duplicateChannels()) {
                JOptionPane.showMessageDialog(this, "Cannot start acquisition using the same channel twice");
                return null;
            }
            this.acqEng_.setDirName(acqName);
            this.acqEng_.setRootName(acqRoot);
            this.acqEng_.setSaveFiles(true);
            return this.acqEng_.acquire();
        }
        catch (MMException e) {
            ReportingUtils.showError(e);
            return null;
        }
    }

    public boolean isAcquisitionRunning() {
        return this.acqEng_.isAcquisitionRunning();
    }

    public static int search(int[] numbers, int key) {
        for (int index = 0; index < numbers.length; ++index) {
            if (numbers[index] != key) continue;
            return index;
        }
        return -1;
    }

    private void checkForCustomTimeIntervals() {
        if (this.acqEng_.customTimeIntervalsEnabled()) {
            this.framesSubPanelLayout_.show(this.framesSubPanel_, OVERRIDE_FRAMES_PANEL_NAME);
        } else {
            this.framesSubPanelLayout_.show(this.framesSubPanel_, DEFAULT_FRAMES_PANEL_NAME);
        }
    }

    public final void updateGUIContents() {
        Component[] comps;
        if (this.disableGUItoSettings_) {
            return;
        }
        this.disableGUItoSettings_ = true;
        this.model_.setChannels(this.acqEng_.getChannels());
        double intervalMs = this.acqEng_.getFrameIntervalMs();
        this.interval_.setText(this.numberFormat_.format(this.convertMsToTime(intervalMs, this.timeUnitCombo_.getSelectedIndex())));
        this.zBottom_.setText(NumberUtils.doubleToDisplayString(this.acqEng_.getSliceZBottomUm()));
        this.zTop_.setText(NumberUtils.doubleToDisplayString(this.acqEng_.getZTopUm()));
        this.zStep_.setText(NumberUtils.doubleToDisplayString(this.acqEng_.getSliceZStepUm()));
        boolean framesEnabled = this.acqEng_.isFramesSettingEnabled();
        this.framesPanel_.setSelected(framesEnabled);
        for (Component c : comps = this.framesSubPanel_.getComponents()) {
            for (Component co : ((JPanel)c).getComponents()) {
                co.setEnabled(framesEnabled);
            }
        }
        this.checkForCustomTimeIntervals();
        this.slicesPanel_.setSelected(this.acqEng_.isZSliceSettingEnabled());
        this.positionsPanel_.setSelected(this.acqEng_.isMultiPositionEnabled());
        this.afPanel_.setSelected(this.acqEng_.isAutoFocusEnabled());
        this.acqOrderBox_.setEnabled(this.positionsPanel_.isSelected() || this.framesPanel_.isSelected() || this.slicesPanel_.isSelected() || this.channelsPanel_.isSelected());
        this.afSkipInterval_.setEnabled(this.acqEng_.isAutoFocusEnabled());
        Integer numFrames = this.acqEng_.getNumFrames();
        Integer afSkipInterval = this.acqEng_.getAfSkipInterval();
        if (this.acqEng_.isFramesSettingEnabled()) {
            this.numFrames_.setValue(numFrames);
        }
        this.afSkipInterval_.setValue(afSkipInterval);
        this.enableZSliceControls(this.acqEng_.isZSliceSettingEnabled());
        this.model_.fireTableStructureChanged();
        this.channelGroupCombo_.setSelectedItem(this.acqEng_.getChannelGroup());
        try {
            this.displayModeCombo_.setSelectedIndex(this.acqEng_.getDisplayMode());
        }
        catch (IllegalArgumentException e) {
            this.displayModeCombo_.setSelectedIndex(0);
        }
        for (AcqOrderMode mode : this.acqOrderModes_) {
            mode.setEnabled(this.framesPanel_.isSelected(), this.positionsPanel_.isSelected(), this.slicesPanel_.isSelected(), this.channelsPanel_.isSelected());
        }
        int selectedIndex = this.acqEng_.getAcqOrderMode();
        this.acqOrderBox_.removeAllItems();
        if (this.framesPanel_.isSelected() && this.positionsPanel_.isSelected() && this.slicesPanel_.isSelected() && this.channelsPanel_.isSelected()) {
            this.acqOrderBox_.addItem(this.acqOrderModes_[0]);
            this.acqOrderBox_.addItem(this.acqOrderModes_[1]);
            this.acqOrderBox_.addItem(this.acqOrderModes_[2]);
            this.acqOrderBox_.addItem(this.acqOrderModes_[3]);
        } else if (this.framesPanel_.isSelected() && this.positionsPanel_.isSelected()) {
            if (selectedIndex == 0 || selectedIndex == 2) {
                this.acqOrderBox_.addItem(this.acqOrderModes_[0]);
                this.acqOrderBox_.addItem(this.acqOrderModes_[2]);
            } else {
                this.acqOrderBox_.addItem(this.acqOrderModes_[1]);
                this.acqOrderBox_.addItem(this.acqOrderModes_[3]);
            }
        } else if (this.channelsPanel_.isSelected() && this.slicesPanel_.isSelected()) {
            if (selectedIndex == 0 || selectedIndex == 1) {
                this.acqOrderBox_.addItem(this.acqOrderModes_[0]);
                this.acqOrderBox_.addItem(this.acqOrderModes_[1]);
            } else {
                this.acqOrderBox_.addItem(this.acqOrderModes_[2]);
                this.acqOrderBox_.addItem(this.acqOrderModes_[3]);
            }
        } else {
            this.acqOrderBox_.addItem(this.acqOrderModes_[selectedIndex]);
        }
        this.acqOrderBox_.setSelectedItem(this.acqOrderModes_[this.acqEng_.getAcqOrderMode()]);
        this.zValCombo_.setSelectedIndex(this.zVals_);
        this.stackKeepShutterOpenCheckBox_.setSelected(this.acqEng_.isShutterOpenForStack());
        this.chanKeepShutterOpenCheckBox_.setSelected(this.acqEng_.isShutterOpenForChannels());
        this.channelTable_.setAutoResizeMode(4);
        boolean selected = this.channelsPanel_.isSelected();
        this.channelTable_.setEnabled(selected);
        this.channelTable_.getTableHeader().setForeground(selected ? Color.black : Color.gray);
        this.updateSavingTypeButtons();
        this.summaryTextArea_.setText(this.acqEng_.getVerboseSummary());
        this.disableGUItoSettings_ = false;
    }

    private void updateDoubleValue(double value, JTextField field) {
        try {
            if (NumberUtils.displayStringToDouble(field.getText()) != value) {
                field.setText(NumberUtils.doubleToDisplayString(value));
            }
        }
        catch (ParseException e) {
            field.setText(NumberUtils.doubleToDisplayString(value));
        }
    }

    private void updateCheckBox(boolean setting, CheckBoxPanel panel) {
        if (panel.isSelected() != setting) {
            panel.setSelected(setting);
        }
    }

    @Override
    public void settingsChanged() {
    }

    private void applySettings() {
        if (this.disableGUItoSettings_) {
            return;
        }
        this.disableGUItoSettings_ = true;
        AbstractCellEditor ae = (AbstractCellEditor)((Object)this.channelTable_.getCellEditor());
        if (ae != null) {
            ae.stopCellEditing();
        }
        try {
            double zStep = NumberUtils.displayStringToDouble(this.zStep_.getText());
            if (Math.abs(zStep) < this.acqEng_.getMinZStepUm()) {
                zStep = this.acqEng_.getMinZStepUm();
            }
            this.acqEng_.setSlices(NumberUtils.displayStringToDouble(this.zBottom_.getText()), NumberUtils.displayStringToDouble(this.zTop_.getText()), zStep, this.zVals_ != 0);
            this.acqEng_.enableZSliceSetting(this.slicesPanel_.isSelected());
            this.acqEng_.enableMultiPosition(this.positionsPanel_.isSelected());
            this.acqEng_.setDisplayMode(((DisplayMode)this.displayModeCombo_.getSelectedItem()).getID());
            this.acqEng_.setAcqOrderMode(((AcqOrderMode)this.acqOrderBox_.getSelectedItem()).getID());
            this.acqEng_.enableChannelsSetting(this.channelsPanel_.isSelected());
            this.acqEng_.setChannels(((ChannelTableModel)this.channelTable_.getModel()).getChannels());
            this.acqEng_.enableFramesSetting(this.framesPanel_.isSelected());
            this.acqEng_.setFrames((Integer)this.numFrames_.getValue(), this.convertTimeToMs(NumberUtils.displayStringToDouble(this.interval_.getText()), this.timeUnitCombo_.getSelectedIndex()));
            this.acqEng_.setAfSkipInterval(NumberUtils.displayStringToInt(this.afSkipInterval_.getValue().toString()));
            this.acqEng_.keepShutterOpenForChannels(this.chanKeepShutterOpenCheckBox_.isSelected());
            this.acqEng_.keepShutterOpenForStack(this.stackKeepShutterOpenCheckBox_.isSelected());
        }
        catch (ParseException p) {
            ReportingUtils.showError(p);
        }
        this.acqEng_.setSaveFiles(this.savePanel_.isSelected());
        String name = this.nameField_.getText().replaceAll("[/\\*!':]", "-");
        this.acqEng_.setDirName(name);
        this.acqEng_.setRootName(this.rootField_.getText());
        this.acqEng_.setComment(this.commentTextArea_.getText());
        this.acqEng_.enableAutoFocus(this.afPanel_.isSelected());
        this.disableGUItoSettings_ = false;
        this.updateGUIContents();
    }

    private void saveSettings() {
        this.savePosition();
    }

    private double convertTimeToMs(double interval, int units) {
        if (units == 1) {
            return interval * 1000.0;
        }
        if (units == 2) {
            return interval * 60.0 * 1000.0;
        }
        if (units == 0) {
            return interval;
        }
        ReportingUtils.showError("Unknown units supplied for acquisition interval!");
        return interval;
    }

    private double convertMsToTime(double intervalMs, int units) {
        if (units == 1) {
            return intervalMs / 1000.0;
        }
        if (units == 2) {
            return intervalMs / 60000.0;
        }
        if (units == 0) {
            return intervalMs;
        }
        ReportingUtils.showError("Unknown units supplied for acquisition interval!");
        return intervalMs;
    }

    private void zValCalcChanged() {
        double newBottom;
        double newTop;
        double zTopUm;
        double zBottomUm;
        if (this.zValCombo_.getSelectedIndex() == 0) {
            this.setTopButton_.setEnabled(false);
            this.setBottomButton_.setEnabled(false);
        } else {
            this.setTopButton_.setEnabled(true);
            this.setBottomButton_.setEnabled(true);
        }
        if (this.zVals_ == this.zValCombo_.getSelectedIndex()) {
            return;
        }
        this.zVals_ = this.zValCombo_.getSelectedIndex();
        try {
            zBottomUm = NumberUtils.displayStringToDouble(this.zBottom_.getText());
            zTopUm = NumberUtils.displayStringToDouble(this.zTop_.getText());
        }
        catch (ParseException e) {
            ReportingUtils.logError(e);
            return;
        }
        double curZ = this.acqEng_.getCurrentZPos();
        if (this.zVals_ == 0) {
            newTop = zTopUm - curZ;
            newBottom = zBottomUm - curZ;
        } else {
            newTop = zTopUm + curZ;
            newBottom = zBottomUm + curZ;
        }
        this.zBottom_.setText(NumberUtils.doubleToDisplayString(newBottom));
        this.zTop_.setText(NumberUtils.doubleToDisplayString(newTop));
        this.applySettings();
    }

    public void setBackgroundStyle(String style) {
        this.setBackground(this.guiColors_.background.get(style));
        this.repaint();
    }

    private void showAdvancedDialog() {
        if (this.advancedOptionsWindow_ == null) {
            this.advancedOptionsWindow_ = new AdvancedOptionsDialog(this.acqEng_, this.studio_);
        }
        this.advancedOptionsWindow_.setVisible(true);
    }

    public class CheckBoxPanel
    extends ComponentTitledPanel {
        JCheckBox checkBox;

        CheckBoxPanel(String title) {
            this.titleComponent = new JCheckBox(title);
            this.checkBox = (JCheckBox)this.titleComponent;
            this.compTitledBorder = new ComponentTitledBorder(this.checkBox, this, BorderFactory.createEtchedBorder());
            this.setBorder(this.compTitledBorder);
            this.borderSet_ = true;
            final CheckBoxPanel thisPanel = this;
            this.checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean enable = CheckBoxPanel.this.checkBox.isSelected();
                    thisPanel.setChildrenEnabled(enable);
                }

                public void writeObject(ObjectOutputStream stream) throws MMException {
                    throw new MMException("Do not serialize this class");
                }
            });
        }

        public void setChildrenEnabled(boolean enabled) {
            Component[] comp = this.getComponents();
            for (int i = 0; i < comp.length; ++i) {
                if (comp[i].getClass().equals(JPanel.class)) {
                    Component[] subComp = ((JPanel)comp[i]).getComponents();
                    for (int c = 0; c < subComp.length; ++c) {
                        subComp[c].setEnabled(enabled);
                    }
                    continue;
                }
                comp[i].setEnabled(enabled);
            }
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void setSelected(boolean selected) {
            this.checkBox.setSelected(selected);
            this.setChildrenEnabled(selected);
        }

        public void addActionListener(ActionListener actionListener) {
            this.checkBox.addActionListener(actionListener);
        }

        public void removeActionListeners() {
            for (ActionListener l : this.checkBox.getActionListeners()) {
                this.checkBox.removeActionListener(l);
            }
        }
    }

    public class LabelPanel
    extends ComponentTitledPanel {
        LabelPanel(String title) {
            this.titleComponent = new JLabel(title);
            JLabel label = (JLabel)this.titleComponent;
            label.setOpaque(true);
            label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.compTitledBorder = new ComponentTitledBorder(label, this, BorderFactory.createEtchedBorder());
            this.setBorder(this.compTitledBorder);
            this.borderSet_ = true;
        }

        public void writeObject(ObjectOutputStream stream) throws MMException {
            throw new MMException("Do not serialize this class");
        }
    }

    public class ComponentTitledPanel
    extends JPanel {
        public ComponentTitledBorder compTitledBorder;
        public boolean borderSet_ = false;
        public Component titleComponent;

        @Override
        public void setBorder(Border border) {
            if (this.compTitledBorder != null && this.borderSet_) {
                this.compTitledBorder.setBorder(border);
            } else {
                super.setBorder(border);
            }
        }

        @Override
        public Border getBorder() {
            return this.compTitledBorder;
        }

        public void setTitleFont(Font font) {
            this.titleComponent.setFont(font);
        }
    }
}

