/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.micromanager.diagnostics.gui.ControlPanel;
import org.micromanager.diagnostics.gui.ProblemReportController;

class SendReportControlPanel
extends ControlPanel {
    private final ProblemReportController controller_;
    private final JTextField nameField_;
    private final JTextField organizationField_;
    private final JTextField emailField_;
    private final JButton cancelButton_;
    private final JButton startOverButton_;
    private final JButton viewButton_;
    private final JButton sendButton_;
    private final JPanel sendingActivityIndicatorPanel_;
    private final JLabel sendingActivityLabel_;
    private JProgressBar sendingActivityIndicator_;
    UIMode mode_ = UIMode.UNSENT;

    SendReportControlPanel(ProblemReportController controller) {
        this(controller, true);
    }

    SendReportControlPanel(ProblemReportController controller, boolean allowRestart) {
        this.controller_ = controller;
        this.cancelButton_ = new JButton("Cancel");
        this.cancelButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendReportControlPanel.this.controller_.cancelRequested();
            }
        });
        if (allowRestart) {
            this.startOverButton_ = new JButton("Start Over");
            this.startOverButton_.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SendReportControlPanel.this.controller_.startLogCapture();
                }
            });
        } else {
            this.startOverButton_ = null;
        }
        this.viewButton_ = new JButton("View Report");
        this.viewButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendReportControlPanel.this.controller_.displayReport();
            }
        });
        this.sendButton_ = new JButton("Send Report...");
        this.sendButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendReportControlPanel.this.controller_.sendRequested();
            }
        });
        this.nameField_ = new JTextField(this.controller_.getName());
        this.nameField_.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SendReportControlPanel.this.controller_.nameChanged(e.getDocument());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SendReportControlPanel.this.controller_.nameChanged(e.getDocument());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SendReportControlPanel.this.controller_.nameChanged(e.getDocument());
            }
        });
        this.organizationField_ = new JTextField(this.controller_.getOrganization());
        this.organizationField_.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SendReportControlPanel.this.controller_.organizationChanged(e.getDocument());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SendReportControlPanel.this.controller_.organizationChanged(e.getDocument());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SendReportControlPanel.this.controller_.organizationChanged(e.getDocument());
            }
        });
        this.emailField_ = new JTextField(this.controller_.getEmail());
        this.emailField_.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SendReportControlPanel.this.controller_.emailChanged(e.getDocument());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SendReportControlPanel.this.controller_.emailChanged(e.getDocument());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SendReportControlPanel.this.controller_.emailChanged(e.getDocument());
            }
        });
        this.sendingActivityIndicatorPanel_ = new JPanel((LayoutManager)new MigLayout("fillx, insets 0"));
        this.sendingActivityLabel_ = new JLabel("Report not yet sent.");
        this.sendingActivityLabel_.setEnabled(false);
        this.sendingActivityIndicatorPanel_.add(this.sendingActivityLabel_);
        this.setLayout((LayoutManager)new MigLayout("fillx, insets 0", "[grow 0,label]rel[grow,fill]", "[][][]unrel[]"));
        this.add(new JLabel("Name:"));
        this.add((Component)this.nameField_, "wrap");
        this.add(new JLabel("Organization:"));
        this.add((Component)this.organizationField_, "wrap");
        this.add(new JLabel("Email:"));
        this.add((Component)this.emailField_, "wrap");
        if (this.startOverButton_ != null) {
            this.add((Component)this.cancelButton_, "span 2, split 4, sizegroup cancelbtns");
            this.add((Component)this.startOverButton_, "gapright push, sizegroup cancelbtns");
        } else {
            this.add((Component)this.cancelButton_, "span 2, split 3, gapright push, sizegroup cancelbtns");
        }
        this.add((Component)this.viewButton_, "sizegroup actionbtns");
        this.add((Component)this.sendButton_, "sizegroup actionbtns");
        this.add((Component)this.sendingActivityIndicatorPanel_, "newline, span 2");
    }

    void setUIMode(UIMode mode) {
        if (mode == this.mode_) {
            return;
        }
        boolean editable = false;
        boolean disabled = true;
        boolean sendable = false;
        switch (mode) {
            case UNSENT: {
                editable = true;
                disabled = false;
                sendable = true;
                break;
            }
            case SENDING: {
                editable = false;
                disabled = true;
                sendable = false;
                break;
            }
            case SENT: {
                editable = true;
                disabled = false;
                sendable = false;
            }
        }
        this.nameField_.setEnabled(editable);
        this.organizationField_.setEnabled(editable);
        this.emailField_.setEnabled(editable);
        this.cancelButton_.setEnabled(!disabled);
        if (this.startOverButton_ != null) {
            this.startOverButton_.setEnabled(!disabled);
        }
        this.sendButton_.setEnabled(sendable);
        switch (mode) {
            case UNSENT: {
                this.sendingActivityLabel_.setEnabled(false);
                this.sendingActivityLabel_.setText("Report not yet sent.");
                this.cancelButton_.setText("Cancel");
                break;
            }
            case SENDING: {
                this.sendingActivityLabel_.setEnabled(true);
                this.sendingActivityLabel_.setText("Sending Report...");
                break;
            }
            case SENT: {
                this.sendingActivityLabel_.setEnabled(false);
                this.sendingActivityLabel_.setText("Report sent to micro-manager.org (thank you!).");
                this.cancelButton_.setText("Close");
            }
        }
        if (this.mode_ != UIMode.SENDING && mode == UIMode.SENDING) {
            if (this.sendingActivityIndicator_ == null) {
                this.sendingActivityIndicator_ = new JProgressBar();
                this.sendingActivityIndicator_.setIndeterminate(true);
            }
            this.sendingActivityIndicatorPanel_.add(this.sendingActivityIndicator_);
        } else if (this.mode_ == UIMode.SENDING && mode != UIMode.SENDING) {
            this.sendingActivityIndicatorPanel_.remove(this.sendingActivityIndicator_);
        }
        this.mode_ = mode;
    }

    static enum UIMode {
        UNSENT,
        SENDING,
        SENT;

    }
}

