/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.micromanager.diagnostics.gui.ControlPanel;
import org.micromanager.diagnostics.gui.InitialControlPanel;
import org.micromanager.diagnostics.gui.ProblemDescriptionPanel;
import org.micromanager.diagnostics.gui.ProblemReportController;

class ProblemReportFrame
extends JFrame {
    private final ProblemReportController controller_;
    private final ProblemDescriptionPanel descriptionPanel_;
    private ControlPanel controlPanel_;
    private final JPanel controlPanelPanel_;

    ProblemReportFrame(ProblemReportController controller) {
        super("Problem Report");
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.controller_ = controller;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProblemReportFrame.this.controller_.cancelRequested();
            }
        });
        this.descriptionPanel_ = new ProblemDescriptionPanel(controller);
        this.controlPanel_ = new InitialControlPanel(controller);
        this.controlPanelPanel_ = new JPanel();
        this.controlPanelPanel_.setLayout((LayoutManager)new MigLayout("fill, insets 0", "[grow, fill]", "[grow, fill]"));
        this.controlPanelPanel_.add(this.controlPanel_);
        this.setLayout((LayoutManager)new MigLayout("fill, insets dialog", "[grow, fill]", "[grow, fill]unrelated[]"));
        this.add((Component)this.descriptionPanel_, "wrap");
        this.add(this.controlPanelPanel_);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
    }

    void close() {
        this.dispose();
    }

    void setControlPanel(ControlPanel newPanel) {
        int saveWidth = this.getWidth();
        int descriptionPanelHeight = this.descriptionPanel_.getHeight();
        int defaultDescriptionPanelHeight = this.descriptionPanel_.getPreferredSize().height;
        int saveExtraHeight = descriptionPanelHeight - defaultDescriptionPanelHeight;
        this.controlPanelPanel_.remove(this.controlPanel_);
        this.controlPanel_ = newPanel;
        this.controlPanelPanel_.add(this.controlPanel_);
        this.validate();
        this.repaint();
        this.setMinimumSize(this.getPreferredSize());
        int newFrameHeight = this.getPreferredSize().height + saveExtraHeight;
        this.setSize(saveWidth, newFrameHeight);
    }

    ControlPanel getControlPanel() {
        return this.controlPanel_;
    }
}

