/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics.gui;

import ij.text.TextPanel;
import ij.text.TextWindow;
import java.io.File;
import java.net.URL;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import mmcorej.CMMCore;
import org.micromanager.diagnostics.ProblemReport;
import org.micromanager.diagnostics.ProblemReportFormatter;
import org.micromanager.diagnostics.ReportSender;
import org.micromanager.diagnostics.gui.ControlPanel;
import org.micromanager.diagnostics.gui.LogCaptureControlPanel;
import org.micromanager.diagnostics.gui.ProblemReportFrame;
import org.micromanager.diagnostics.gui.SendReportControlPanel;

public class ProblemReportController {
    private static ProblemReportController instance_;
    private CMMCore core_;
    private ProblemReportFrame frame_ = null;
    private boolean hasUnsentContent_ = false;
    private JTextArea descriptionTextArea_;
    private boolean useCrashRobustLogging_ = true;
    private volatile ProblemReport report_;

    private static int checkForInterruptedReport(boolean userInitiated) {
        ProblemReport report = ProblemReportController.loadLeftoverReport();
        if (report == null) {
            return 1;
        }
        Object[] options = userInitiated ? new String[]{"Reopen", "Discard", "Cancel"} : new String[]{"Reopen", "Discard", "Not Now"};
        int answer = JOptionPane.showOptionDialog(null, "A Problem Report was in progress when Micro-Manager exited. Would you like to reopen the interrupted report?", "Continue Problem Report", 1, 3, null, options, options[0]);
        if (answer == 0) {
            return 0;
        }
        if (answer == 1) {
            report.deleteStorage();
            return 1;
        }
        return 2;
    }

    public static void startIfInterruptedOnExit() {
        if (instance_ != null && ProblemReportController.instance_.frame_ != null) {
            return;
        }
        int answer = ProblemReportController.checkForInterruptedReport(false);
        if (answer == 0) {
            if (instance_ == null) {
                instance_ = new ProblemReportController();
            }
            instance_.showFrame(true, null);
        }
    }

    public static void start(CMMCore core) {
        if (instance_ == null) {
            instance_ = new ProblemReportController();
        }
        instance_.showFrame(false, core);
    }

    private ProblemReportController() {
    }

    void showFrame(boolean forceReopen, CMMCore core) {
        this.core_ = core;
        if (this.frame_ == null) {
            int reopenAnswer;
            int n = reopenAnswer = forceReopen ? 0 : ProblemReportController.checkForInterruptedReport(true);
            if (reopenAnswer == 2) {
                return;
            }
            this.frame_ = new ProblemReportFrame(this);
            if (reopenAnswer == 0) {
                this.report_ = ProblemReportController.loadLeftoverReport();
                this.descriptionTextArea_.setText(this.report_.getDescription());
                this.frame_.setControlPanel(new SendReportControlPanel(this, false));
                this.markReportUnsent();
            }
        }
        this.frame_.setVisible(true);
        int state = this.frame_.getExtendedState();
        this.frame_.setExtendedState(state &= 0xFFFFFFFE);
        this.frame_.toFront();
        this.frame_.requestFocus();
    }

    private static File getReportDirectory() {
        File homeDir;
        String homePath = System.getProperty("user.home");
        if (homePath != null && !homePath.isEmpty() && (homeDir = new File(homePath)).isDirectory()) {
            return new File(homeDir, "MMProblemReport");
        }
        return null;
    }

    private static ProblemReport loadLeftoverReport() {
        File reportDir = ProblemReportController.getReportDirectory();
        ProblemReport report = ProblemReport.LoadFromPersistence(reportDir);
        if (report.isUsefulReport()) {
            return report;
        }
        report.deleteStorage();
        return null;
    }

    private boolean isContactInfoValid() {
        if (this.getName() == null || this.getName().length() < 1) {
            return false;
        }
        if (this.getOrganization() == null || this.getOrganization().length() < 1) {
            return false;
        }
        return this.getEmail() != null && ProblemReportController.isValidEmailAddress(this.getEmail());
    }

    private static boolean isValidEmailAddress(String addr) {
        Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
        return pattern.matcher(addr).matches();
    }

    private void markReportUnsent() {
        this.hasUnsentContent_ = true;
        if (this.frame_.getControlPanel() instanceof SendReportControlPanel) {
            SendReportControlPanel panel = (SendReportControlPanel)this.frame_.getControlPanel();
            panel.setUIMode(SendReportControlPanel.UIMode.UNSENT);
        }
    }

    private void markReportSent() {
        this.hasUnsentContent_ = false;
        if (this.frame_.getControlPanel() instanceof SendReportControlPanel) {
            SendReportControlPanel panel = (SendReportControlPanel)this.frame_.getControlPanel();
            panel.setUIMode(SendReportControlPanel.UIMode.SENT);
        }
    }

    void markDescriptionModified() {
        this.copyDescriptionToReport();
        this.markReportUnsent();
    }

    void setDescriptionTextArea(JTextArea textArea) {
        this.descriptionTextArea_ = textArea;
    }

    JTextArea getDescriptionTextArea() {
        return this.descriptionTextArea_;
    }

    void setName(String name) {
        if (this.report_ != null) {
            this.report_.setUserName(name);
        }
    }

    String getName() {
        return this.report_ == null ? null : this.report_.getUserName();
    }

    void setOrganization(String organization) {
        if (this.report_ != null) {
            this.report_.setUserOrganization(organization);
        }
    }

    String getOrganization() {
        return this.report_ == null ? null : this.report_.getUserOrganization();
    }

    void setEmail(String email) {
        if (this.report_ != null) {
            this.report_.setUserEmail(email);
        }
    }

    String getEmail() {
        return this.report_ == null ? null : this.report_.getUserEmail();
    }

    void setUseCrashRobustLogging(boolean flag) {
        this.useCrashRobustLogging_ = flag;
    }

    boolean getUseCrashRobustLogging() {
        return this.useCrashRobustLogging_;
    }

    void controlPanelDidChangeSize(ControlPanel panel) {
        this.frame_.setControlPanel(panel);
    }

    void cancelRequested() {
        int result;
        if (this.hasUnsentContent_ && (result = JOptionPane.showConfirmDialog(this.frame_, "Discard this report?", "Cancel Problem Report", 0)) != 0) {
            return;
        }
        if (this.report_ != null) {
            this.report_.cancelLogCapture();
            this.report_.deleteStorage();
            this.report_ = null;
        }
        this.frame_.close();
        this.frame_ = null;
    }

    void startLogCapture() {
        if (this.report_ != null) {
            this.report_.cancelLogCapture();
            this.report_.deleteStorage();
            this.report_ = null;
        }
        final LogCaptureControlPanel panel = new LogCaptureControlPanel(this);
        panel.setStatus("Collecting system information...");
        panel.setButtonsEnabled(false);
        this.frame_.setControlPanel(panel);
        File reportDir = ProblemReportController.getReportDirectory();
        this.report_ = ProblemReport.NewPersistentReport(this.core_, reportDir);
        this.copyDescriptionToReport();
        this.report_.startCapturingLog(this.useCrashRobustLogging_);
        new SwingWorker<Object, Object>(){

            @Override
            public Object doInBackground() {
                try {
                    ProblemReportController.this.report_.logSystemInfo(false);
                }
                catch (Exception e) {
                    ProblemReportController.this.core_.logMessage("Logging system info failed: " + e.getMessage());
                }
                return null;
            }

            @Override
            public void done() {
                if (ProblemReportController.this.report_ == null) {
                    return;
                }
                if (ProblemReportController.this.frame_ != null) {
                    panel.setStatus("Capturing log...");
                    panel.setInstructions("<html><b>Please perform the steps that reproduce the problem.</b></html>");
                    panel.setButtonsEnabled(true);
                    ProblemReportController.this.frame_.setControlPanel(panel);
                }
                ProblemReportController.this.core_.logMessage("User has been prompted to reproduce problem");
            }
        }.execute();
        this.markReportUnsent();
    }

    void insertTimestampedRemark(String remark) {
        if (this.report_ == null) {
            return;
        }
        this.report_.logUserComment(remark);
    }

    void finishLogCapture() {
        if (this.report_ == null) {
            return;
        }
        this.core_.logMessage("User has stopped log capture");
        if (this.frame_ != null) {
            LogCaptureControlPanel panel = (LogCaptureControlPanel)this.frame_.getControlPanel();
            panel.setButtonsEnabled(false);
            panel.setStatus("Collecting system information...");
            panel.setInstructions("Please wait.");
            this.frame_.setControlPanel(panel);
        }
        new SwingWorker<Object, Object>(){

            @Override
            public Object doInBackground() {
                try {
                    ProblemReportController.this.report_.logSystemInfo(true);
                }
                catch (Exception e) {
                    ProblemReportController.this.core_.logMessage("Logging system info failed: " + e.getMessage());
                }
                ProblemReportController.this.report_.finishCapturingLog();
                return null;
            }

            @Override
            public void done() {
                if (ProblemReportController.this.report_ == null) {
                    return;
                }
                if (ProblemReportController.this.frame_ != null) {
                    ProblemReportController.this.frame_.setControlPanel(new SendReportControlPanel(ProblemReportController.this));
                }
            }
        }.execute();
    }

    void finishWithoutReproducing() {
        if (this.report_ == null) {
            return;
        }
        this.core_.logMessage("User has indicated that the problem cannot be reproduced");
        if (this.frame_ != null) {
            LogCaptureControlPanel panel = (LogCaptureControlPanel)this.frame_.getControlPanel();
            panel.setButtonsEnabled(false);
            panel.setStatus("Saving log...");
            panel.setInstructions("Please wait.");
            this.frame_.setControlPanel(panel);
        }
        new SwingWorker<Object, Object>(){

            @Override
            public Object doInBackground() {
                ProblemReportController.this.report_.finishCapturingLog();
                return null;
            }

            @Override
            public void done() {
                if (ProblemReportController.this.report_ == null) {
                    return;
                }
                if (ProblemReportController.this.frame_ != null) {
                    ProblemReportController.this.frame_.setControlPanel(new SendReportControlPanel(ProblemReportController.this));
                }
            }
        }.execute();
    }

    void nameChanged(Document nameDocument) {
        try {
            this.setName(nameDocument.getText(0, nameDocument.getLength()));
            this.markReportUnsent();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void organizationChanged(Document organizationDocument) {
        try {
            this.setOrganization(organizationDocument.getText(0, organizationDocument.getLength()));
            this.markReportUnsent();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void emailChanged(Document emailDocument) {
        try {
            this.setEmail(emailDocument.getText(0, emailDocument.getLength()));
            this.markReportUnsent();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void displayReport() {
        if (this.report_ == null) {
            return;
        }
        ProblemReportFormatter formatter = new ProblemReportFormatter();
        String reportStr = formatter.format(this.report_);
        this.openReportWindow(reportStr);
    }

    void sendRequested() {
        if (this.report_ == null) {
            return;
        }
        if (this.descriptionTextArea_.getDocument().getLength() == 0) {
            JOptionPane.showMessageDialog(this.frame_, "Please enter a description.");
            return;
        }
        if (!this.isContactInfoValid()) {
            JOptionPane.showMessageDialog(this.frame_, "Please enter your name, organization, and valid email address.");
            return;
        }
        if (!this.confirmEmailAddress()) {
            return;
        }
        final SendReportControlPanel panel = (SendReportControlPanel)this.frame_.getControlPanel();
        panel.setUIMode(SendReportControlPanel.UIMode.SENDING);
        this.getDescriptionTextArea().setEnabled(false);
        new SwingWorker<1Result, Object>(){

            private boolean tooManyLines(String str, int limit) {
                int index = -1;
                for (int count = 0; count < limit; ++count) {
                    if ((index = str.indexOf(10, index + 1)) != -1) continue;
                    return false;
                }
                return true;
            }

            @Override
            public 1Result doInBackground() throws Exception {
                ProblemReportFormatter formatter = new ProblemReportFormatter();
                String reportStr = formatter.format(ProblemReportController.this.report_);
                String reportFileName = formatter.generateFileName(ProblemReportController.this.report_);
                URL url = ReportSender.getProblemReportUploadURL();
                ReportSender sender = new ReportSender();
                sender.sendReport(reportStr, reportFileName, url);
                class Result {
                    public boolean success;
                    public String warning;

                    Result() {
                    }
                }
                Result r = new Result();
                r.success = true;
                r.warning = null;
                if (this.tooManyLines(reportStr, 10000)) {
                    r.warning = "<html><body><p style='width: 400px;'>The report has been sent, but may have been truncated due to exceeding the size limit. It is recommended that you keep a backup by clicking on View Report and saving a copy.</p></body></html>";
                }
                return r;
            }

            @Override
            public void done() {
                Result result = null;
                try {
                    result = (Result)this.get();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(ProblemReportController.this.frame_, "Failed to generate or send report:\n" + e.getMessage());
                    panel.setUIMode(SendReportControlPanel.UIMode.UNSENT);
                    ProblemReportController.this.getDescriptionTextArea().setEnabled(true);
                    return;
                }
                if (!result.success) {
                    return;
                }
                if (result.warning != null) {
                    JOptionPane.showMessageDialog(ProblemReportController.this.frame_, result.warning);
                }
                ProblemReportController.this.report_.deleteStorage();
                ProblemReportController.this.markReportSent();
                panel.setUIMode(SendReportControlPanel.UIMode.SENT);
                ProblemReportController.this.getDescriptionTextArea().setEnabled(true);
            }
        }.execute();
    }

    private boolean confirmEmailAddress() {
        String confirmEmail = JOptionPane.showInputDialog(this.frame_, "Please enter your email address once more:", "Send Problem Report", 3);
        if (confirmEmail == null) {
            return false;
        }
        if (!confirmEmail.equals(this.getEmail())) {
            JOptionPane.showMessageDialog(this.frame_, "Email address does not match; please check your typing.");
            return false;
        }
        return true;
    }

    private void copyDescriptionToReport() {
        if (this.report_ == null) {
            return;
        }
        this.report_.setDescription(this.descriptionTextArea_.getText());
    }

    private void openReportWindow(String report) {
        int width = 640;
        int height = 480;
        TextWindow window = new TextWindow("Problem Report", report, 640, 480);
        TextPanel panel = window.getTextPanel();
        panel.scrollToTop();
        window.setVisible(true);
    }
}

