/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.micromanager.diagnostics.gui.ProblemReportController;

class ProblemDescriptionPanel
extends JPanel {
    private final ProblemReportController controller_;

    ProblemDescriptionPanel(ProblemReportController controller) {
        super((LayoutManager)new MigLayout("fillx, filly, insets 0", "[grow, fill]", "[]related[grow, fill]"));
        this.controller_ = controller;
        JTextArea descriptionTextArea = this.makeDescriptionTextArea();
        JScrollPane scrollPane = new JScrollPane(descriptionTextArea, 20, 31);
        this.controller_.setDescriptionTextArea(descriptionTextArea);
        this.add((Component)new JLabel("Problem Description:"), "gapafter push, wrap");
        this.add((Component)scrollPane, "width 400:400, height 200:200");
    }

    private JTextArea makeDescriptionTextArea() {
        JTextArea textArea = new JTextArea();
        textArea.setFont(new Font("Monospaced", 0, 12));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setBorder(new LineBorder(Color.BLACK));
        textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProblemDescriptionPanel.this.controller_.markDescriptionModified();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProblemDescriptionPanel.this.controller_.markDescriptionModified();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProblemDescriptionPanel.this.controller_.markDescriptionModified();
            }
        });
        return textArea;
    }
}

