/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.micromanager.diagnostics.gui.ControlPanel;
import org.micromanager.diagnostics.gui.ProblemReportController;

class LogCaptureControlPanel
extends ControlPanel {
    private final ProblemReportController controller_;
    private final JButton startOverButton_;
    private final JButton doneButton_;
    private final JButton cannotReproButton_;
    private final JLabel statusLabel_;
    private final JLabel instructionsLabel_;

    LogCaptureControlPanel(ProblemReportController controller) {
        this.controller_ = controller;
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogCaptureControlPanel.this.controller_.cancelRequested();
            }
        });
        this.startOverButton_ = new JButton("Start Over");
        this.startOverButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogCaptureControlPanel.this.controller_.startLogCapture();
            }
        });
        this.doneButton_ = new JButton("Done");
        this.doneButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogCaptureControlPanel.this.controller_.finishLogCapture();
            }
        });
        this.cannotReproButton_ = new JButton("Cannot Reproduce");
        this.cannotReproButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogCaptureControlPanel.this.controller_.finishWithoutReproducing();
            }
        });
        this.statusLabel_ = new JLabel();
        this.statusLabel_.setHorizontalAlignment(4);
        this.setStatus("Preparing report...");
        this.instructionsLabel_ = new JLabel();
        this.instructionsLabel_.setHorizontalAlignment(0);
        this.setInstructions("Please wait.");
        final JTextField remarkTextField = new JTextField();
        JButton remarkButton = new JButton("Insert");
        remarkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String remark = remarkTextField.getText();
                if (!remark.isEmpty()) {
                    LogCaptureControlPanel.this.controller_.insertTimestampedRemark(remark);
                }
            }
        });
        this.setLayout((LayoutManager)new MigLayout("fillx, insets 0", "[fill]", "unrel[]unrel[]unrel[][]"));
        JProgressBar activityIndicator = new JProgressBar();
        activityIndicator.setIndeterminate(true);
        this.add((Component)this.statusLabel_, "split 2, grow, gapright related");
        this.add((Component)activityIndicator, "wrap");
        this.add((Component)this.instructionsLabel_, "grow, wrap");
        this.add((Component)this.startOverButton_, "split 3, sizegroup btns, gapright push");
        this.add((Component)this.cannotReproButton_, "sizegroup btns");
        this.add((Component)this.doneButton_, "sizegroup btns, wrap");
        this.add((Component)cancelButton, "gapright push, wrap");
        this.add((Component)new JSeparator(), "grow, wrap");
        this.add((Component)new JLabel("Insert timestamped remark into log:"), "align left, wrap");
        this.add((Component)remarkTextField, "split 2, grow, gapright related");
        this.add((Component)remarkButton, "");
    }

    void setStatus(String status) {
        this.statusLabel_.setText(status);
    }

    void setInstructions(String instructions) {
        this.instructionsLabel_.setText(instructions);
    }

    void setButtonsEnabled(boolean flag) {
        this.startOverButton_.setEnabled(flag);
        this.cannotReproButton_.setEnabled(flag);
        this.doneButton_.setEnabled(flag);
    }
}

