/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics;

import org.micromanager.utils.ReportingUtils;

public class ThreadExceptionLogger
implements Thread.UncaughtExceptionHandler {
    private static boolean setUp_ = false;
    private final Thread.UncaughtExceptionHandler chainedHandler_;

    public static void setUp() {
        if (setUp_) {
            return;
        }
        Thread.setDefaultUncaughtExceptionHandler(new ThreadExceptionLogger(Thread.getDefaultUncaughtExceptionHandler()));
        if (System.getProperty("sun.awt.exception.handler") == null) {
            System.setProperty("sun.awt.exception.handler", ThreadExceptionLogger.class.getName());
        }
        setUp_ = true;
    }

    public ThreadExceptionLogger(Thread.UncaughtExceptionHandler chained) {
        this.chainedHandler_ = chained;
    }

    public ThreadExceptionLogger() {
        this.chainedHandler_ = null;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        ReportingUtils.logMessage("Thread " + t.getId() + " (" + t.getName() + ") terminated with uncaught exception");
        this.logException(e);
        if (this.chainedHandler_ != null) {
            this.chainedHandler_.uncaughtException(t, e);
        }
    }

    public void handle(Throwable e) {
        ReportingUtils.logMessage("Uncaught exception in AWT/Swing event dispatch thread:");
        this.logException(e);
    }

    private void logException(Throwable e) {
        ReportingUtils.logMessage(e.toString());
        for (StackTraceElement frame : e.getStackTrace()) {
            ReportingUtils.logMessage("  at " + frame.toString());
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            ReportingUtils.logMessage("Caused by exception:");
            this.logException(cause);
        }
    }
}

