/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics;

import java.util.ArrayList;
import java.util.List;
import mmcorej.CMMCore;
import org.micromanager.MMStudio;
import org.micromanager.diagnostics.CoreBasicInfoSection;
import org.micromanager.diagnostics.CorePropertyCacheInfoSection;
import org.micromanager.diagnostics.ImageJInfoSection;
import org.micromanager.diagnostics.JVMArgumentsInfoSection;
import org.micromanager.diagnostics.JVMDeadlockedThreadInfoSection;
import org.micromanager.diagnostics.JVMInfoSection;
import org.micromanager.diagnostics.JVMMemoryInfoSection;
import org.micromanager.diagnostics.JVMThreadInfoSection;
import org.micromanager.diagnostics.JavaSystemPropertiesInfoSection;
import org.micromanager.diagnostics.MMVersionInfoSection;
import org.micromanager.diagnostics.OperatingSystemInfoSection;
import org.micromanager.diagnostics.PhysicalMemoryInfoSection;
import org.micromanager.diagnostics.ProcessorInfoSection;

public final class SystemInfo {
    public static void dumpAllToCoreLog(boolean includeUnchanging) {
        List<SystemInfoSection> sections = SystemInfo.getAllSections(includeUnchanging);
        for (SystemInfoSection section : sections) {
            CMMCore core = MMStudio.getInstance().getCore();
            core.logMessage(section.getReport());
        }
    }

    public static String getAllAsText(boolean includeUnchanging) {
        StringBuilder sb = new StringBuilder();
        List<SystemInfoSection> sections = SystemInfo.getAllSections(includeUnchanging);
        for (SystemInfoSection section : sections) {
            sb.append(section.getReport());
        }
        return sb.toString();
    }

    private static List<SystemInfoSection> getAllSections(boolean includeUnchanging) {
        ArrayList<SystemInfoSection> sections = new ArrayList<SystemInfoSection>();
        if (includeUnchanging) {
            sections.add(new MMVersionInfoSection());
            sections.add(new ImageJInfoSection());
            sections.add(new OperatingSystemInfoSection());
            sections.add(new JVMInfoSection());
            sections.add(new JVMArgumentsInfoSection());
            sections.add(new JavaSystemPropertiesInfoSection());
            sections.add(new ProcessorInfoSection());
        }
        sections.add(new PhysicalMemoryInfoSection());
        sections.add(new JVMMemoryInfoSection());
        sections.add(new JVMThreadInfoSection());
        sections.add(new JVMDeadlockedThreadInfoSection());
        sections.add(new CoreBasicInfoSection());
        sections.add(new CorePropertyCacheInfoSection());
        return sections;
    }

    public static interface SystemInfoSection {
        public String getTitle();

        public String getReport();
    }
}

