/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPOutputStream;
import org.micromanager.utils.HttpUtils;
import org.micromanager.utils.MMUUEncoder;

public class ReportSender {
    private static URL problemReportUploadURL_;

    public static URL getProblemReportUploadURL() {
        return problemReportUploadURL_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendReport(String report, String fileName, URL uploadURL) throws IOException, FileNotFoundException, Exception {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempFile = new File(tempDir, fileName);
        tempFile.deleteOnExit();
        try {
            this.saveReportToUUEncodedGZIPFile(report, tempFile);
            new HttpUtils().upload(uploadURL, tempFile);
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReportToUUEncodedGZIPFile(String report, File file) throws IOException, FileNotFoundException {
        InputStream gzipInputFromPipe = this.getGZIPInputFromString(report);
        FileOutputStream uuencodedOutputToFile = new FileOutputStream(file);
        try {
            new MMUUEncoder().encodeBuffer(gzipInputFromPipe, uuencodedOutputToFile);
        }
        finally {
            try {
                ((OutputStream)uuencodedOutputToFile).close();
                gzipInputFromPipe.close();
            }
            catch (IOException iOException) {}
        }
    }

    private InputStream getGZIPInputFromString(final String str) throws IOException {
        PipedOutputStream gzipOutputToPipe = new PipedOutputStream();
        PipedInputStream gzipInputFromPipe = new PipedInputStream(gzipOutputToPipe);
        GZIPOutputStream outputToGZIP = new GZIPOutputStream(gzipOutputToPipe);
        final OutputStreamWriter writerToGZIP = new OutputStreamWriter((OutputStream)outputToGZIP, "UTF-8");
        new Thread(){

            @Override
            public void run() {
                try {
                    writerToGZIP.write(str);
                    writerToGZIP.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        return gzipInputFromPipe;
    }

    static {
        try {
            problemReportUploadURL_ = new URL("http://valelab.ucsf.edu/~MM/upload_corelog.php");
        }
        catch (MalformedURLException impossible) {
            System.exit(1);
        }
    }
}

