/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.micromanager.diagnostics.ProblemReport;

public class ProblemReportFormatter {
    static final String FORMAT_VERSION = "2.1";

    public String generateFileName(ProblemReport report) {
        String shortTZName = TimeZone.getDefault().getDisplayName(false, 0);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = dateFormat.format(report.getDate()) + shortTZName;
        String physAddr = report.getMACAddress();
        if (physAddr == null) {
            physAddr = "00-00-00-00-00-00";
        }
        return this.sanitizeFileName(date + "_" + physAddr + ".log");
    }

    public String format(ProblemReport report) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatPreamble(report));
        if (report.hasStartingConfig()) {
            sb.append(ProblemReportFormatter.fileSection("Starting Config (" + report.getStartingConfigFileName() + ")", report.getStartingConfig()));
        }
        if (report.configChangedDuringLogCapture() && report.hasEndingConfig()) {
            sb.append(ProblemReportFormatter.fileSection("Ending Config (" + report.getEndingConfigFileName() + ")", report.getEndingConfig()));
        }
        sb.append(ProblemReportFormatter.fileSection("Captured Log", report.getCapturedLogContent()));
        if (report.hasHotSpotErrorLog()) {
            sb.append(ProblemReportFormatter.fileSection("HotSpot Error Log (" + report.getHotSpotErrorLogFileName() + ")", report.getHotSpotErrorLogContent()));
        }
        sb.append("***** END OF PROBLEM REPORT *****");
        return sb.toString();
    }

    private String sanitizeFileName(String name) {
        return name.replaceAll("[ !\"#$%&'()*/:;<>?@\\[\\\\\\]^`{|}~]", "_");
    }

    private String formatPreamble(ProblemReport report) {
        StringBuilder sb = new StringBuilder(512);
        sb.append(ProblemReportFormatter.preambleKeyValue("Report Format Version", FORMAT_VERSION));
        sb.append(ProblemReportFormatter.preambleKeyValue("User Name", report.getUserName()));
        sb.append(ProblemReportFormatter.preambleKeyValue("Organization", report.getUserOrganization()));
        sb.append(ProblemReportFormatter.preambleKeyValue("User e-mail", report.getUserEmail()));
        String description = report.getDescription();
        if (description == null) {
            description = "null";
        }
        description = description.replaceAll("\\s+$", "");
        sb.append(ProblemReportFormatter.preambleKeyValue("User Description", (description = description.replaceAll("(?m)^", "|  ")).isEmpty() ? "" : "\n" + description));
        String reportMACAddress = report.getMACAddress();
        if (reportMACAddress != null && reportMACAddress.length() > 0) {
            sb.append(ProblemReportFormatter.preambleKeyValue("MAC", report.getMACAddress()));
        } else {
            sb.append(ProblemReportFormatter.preambleKeyValue("MAC", "00-00-00-00-00-00"));
        }
        String reportHost = report.getHostName();
        if (reportHost != null && reportHost.length() > 0) {
            sb.append(ProblemReportFormatter.preambleKeyValue("Host", reportHost));
        }
        sb.append(ProblemReportFormatter.preambleKeyValue("User", report.getUserId()));
        sb.append(ProblemReportFormatter.preambleKeyValue("Pid", Integer.toString(report.getPid())));
        sb.append(ProblemReportFormatter.preambleKeyValue("Starting Config File", report.getStartingConfigFileName()));
        if (report.configChangedDuringLogCapture()) {
            sb.append(ProblemReportFormatter.preambleKeyValue("Config Changed", "yes"));
            sb.append(ProblemReportFormatter.preambleKeyValue("Ending Configuration File", report.getEndingConfigFileName()));
        } else {
            sb.append(ProblemReportFormatter.preambleKeyValue("Config Changed", "no"));
        }
        return sb.toString();
    }

    private static String preambleKeyValue(String key, String value) {
        return "#" + key + ": " + value + "\n";
    }

    private static String fileSection(String title, String content) {
        if (title == null) {
            title = "null";
        }
        if (content == null) {
            content = "null";
        }
        StringBuilder sb = new StringBuilder(title.length() + content.length() + 128);
        sb.append("***** BEGIN " + title + " *****\n");
        sb.append(content);
        if (sb.charAt(sb.length() - 1) != '\n') {
            sb.append('\n');
        }
        sb.append("***** END " + title + " *****\n");
        return sb.toString();
    }
}

