/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import mmcorej.CMMCore;
import mmcorej.StrVector;
import org.micromanager.MMStudio;
import org.micromanager.diagnostics.SystemInfo;

public class ProblemReport {
    private final CMMCore core_;
    private File reportDir_;
    private File leftoverDir_;
    private Metadata metadata_;
    private Integer logFileHandle_;
    private String logFileName_;
    private NamedTextFile startCfg_;
    private String capturedLogContent_;
    private NamedTextFile endCfg_;
    private NamedTextFile hotSpotErrorLog_;
    private Timer deferredSyncTimer_ = null;
    private static final String LOG_CAPTURE_FILENAME = "CoreLogCapture.txt";
    private static final String START_CFG_FILENAME = "StartConfig.cfg";
    private static final String END_CFG_FILENAME = "EndConfig.cfg";
    private static final String METADATA_FILENAME = "ReportInfo.txt";
    private static final String README_FILENAME = "README.txt";

    public static ProblemReport NewReport(CMMCore core) {
        return new ProblemReport(core);
    }

    public static ProblemReport NewPersistentReport(CMMCore core, File storageDirectory) {
        return new ProblemReport(core, storageDirectory);
    }

    public static ProblemReport LoadFromPersistence(File storageDirectory) {
        return new ProblemReport(storageDirectory);
    }

    private ProblemReport(CMMCore core) {
        this.core_ = core;
        this.metadata_ = new Metadata();
        this.metadata_.date = new Date();
        this.collectHostInformation();
    }

    private ProblemReport(CMMCore core, File storageDirectory) {
        this(core);
        this.reportDir_ = storageDirectory;
        this.syncMetadata();
    }

    private ProblemReport(File storageDirectory) {
        this.core_ = null;
        this.reportDir_ = null;
        this.loadReport(storageDirectory);
    }

    public boolean isUsefulReport() {
        if (this.metadata_ == null) {
            return false;
        }
        return this.capturedLogContent_ != null && !this.capturedLogContent_.isEmpty();
    }

    public void setUserName(String name) {
        this.metadata_.userName = name;
        this.deferredSyncMetadata();
    }

    public String getUserName() {
        return this.metadata_.userName;
    }

    public void setUserOrganization(String organization) {
        this.metadata_.userOrganization = organization;
        this.deferredSyncMetadata();
    }

    public String getUserOrganization() {
        return this.metadata_.userOrganization;
    }

    public void setUserEmail(String email) {
        this.metadata_.userEmail = email;
        this.deferredSyncMetadata();
    }

    public String getUserEmail() {
        return this.metadata_.userEmail;
    }

    public void setDescription(String description) {
        this.metadata_.description = description;
        this.deferredSyncMetadata();
    }

    public String getDescription() {
        return this.metadata_.description;
    }

    public void startCapturingLog(boolean useCrashRobust) {
        this.startCfg_ = ProblemReport.getCurrentConfigFile();
        this.syncStartingConfig();
        if (this.logFileHandle_ != null) {
            this.cancelLogCapture();
        }
        File logFile = null;
        if (this.reportDir_ != null) {
            logFile = new File(this.reportDir_, LOG_CAPTURE_FILENAME);
            if (!logFile.exists()) {
                try {
                    new FileOutputStream(logFile).close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {}
            }
        } else {
            try {
                logFile = File.createTempFile("MMCoreLogCapture", ".txt");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (logFile == null || !logFile.canWrite()) {
            this.capturedLogContent_ = "<<<Cannot write to temporary file for log capture>>>";
            return;
        }
        String filename = logFile.getAbsolutePath();
        try {
            this.logFileHandle_ = this.core_.startSecondaryLogFile(filename, true, true, useCrashRobust);
        }
        catch (Exception e) {
            this.capturedLogContent_ = "<<<Failed to start log capture>>>";
        }
        this.logFileName_ = filename;
        this.core_.logMessage("Problem Report: Start of log capture");
    }

    public void cancelLogCapture() {
        if (this.logFileHandle_ == null) {
            return;
        }
        this.core_.logMessage("Problem Report: Canceling log capture");
        try {
            this.core_.stopSecondaryLogFile(this.logFileHandle_.intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logFileHandle_ = null;
        new File(this.logFileName_).delete();
        this.logFileName_ = null;
    }

    public void finishCapturingLog() {
        if (this.logFileHandle_ == null) {
            this.endCfg_ = ProblemReport.getCurrentConfigFile();
            this.syncEndingConfig();
            return;
        }
        String logFileName = this.logFileName_;
        this.core_.logMessage("Problem Report: End of log capture");
        try {
            this.core_.stopSecondaryLogFile(this.logFileHandle_.intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logFileHandle_ = null;
        this.logFileName_ = null;
        File logFile = new File(logFileName);
        this.capturedLogContent_ = ProblemReport.readTextFile(logFile);
        if (this.capturedLogContent_ == null) {
            this.capturedLogContent_ = "<<<Failed to read captured log file>>>";
        }
        if (this.reportDir_ == null) {
            logFile.delete();
        }
        this.endCfg_ = ProblemReport.getCurrentConfigFile();
        this.syncEndingConfig();
    }

    public void deleteStorage() {
        this.deleteReportDir(this.reportDir_);
        this.reportDir_ = null;
        this.deleteReportDir(this.leftoverDir_);
        this.leftoverDir_ = null;
    }

    public void logSystemInfo(boolean incremental) {
        String inc = incremental ? " (incremental)" : "";
        this.core_.logMessage("***** BEGIN Problem Report System Info" + inc + " *****");
        SystemInfo.dumpAllToCoreLog(!incremental);
        this.core_.logMessage("***** END Problem Report System Info" + inc + " *****");
    }

    public void logUserComment(String comment) {
        this.core_.logMessage("##### User remark: " + comment);
    }

    boolean hasStartingConfig() {
        return this.startCfg_ != null;
    }

    boolean hasEndingConfig() {
        return this.endCfg_ != null;
    }

    boolean configChangedDuringLogCapture() {
        if (this.startCfg_ == null || this.endCfg_ == null) {
            return this.startCfg_ != this.endCfg_;
        }
        return !this.startCfg_.equals(this.endCfg_);
    }

    String getStartingConfigFileName() {
        if (this.startCfg_ == null) {
            return null;
        }
        return this.startCfg_.getFilename();
    }

    String getEndingConfigFileName() {
        if (this.endCfg_ == null) {
            return null;
        }
        return this.endCfg_.getFilename();
    }

    String getStartingConfig() {
        if (this.startCfg_ == null) {
            return null;
        }
        return this.startCfg_.getContent();
    }

    String getEndingConfig() {
        if (this.endCfg_ == null) {
            return null;
        }
        return this.endCfg_.getContent();
    }

    String getCapturedLogContent() {
        return this.capturedLogContent_;
    }

    boolean hasHotSpotErrorLog() {
        return this.hotSpotErrorLog_ != null;
    }

    String getHotSpotErrorLogFileName() {
        if (this.hotSpotErrorLog_ == null) {
            return null;
        }
        return this.hotSpotErrorLog_.getFilename();
    }

    String getHotSpotErrorLogContent() {
        if (this.hotSpotErrorLog_ == null) {
            return null;
        }
        return this.hotSpotErrorLog_.getContent();
    }

    String getMACAddress() {
        return this.metadata_.macAddress;
    }

    String getHostName() {
        return this.metadata_.hostName;
    }

    String getIPAddress() {
        return this.metadata_.ipAddress;
    }

    String getUserId() {
        return this.metadata_.userLogin;
    }

    int getPid() {
        return this.metadata_.pid;
    }

    Date getDate() {
        return (Date)this.metadata_.date.clone();
    }

    private void collectHostInformation() {
        String addr;
        RuntimeMXBean rtMXB = ManagementFactory.getRuntimeMXBean();
        String jvmName = rtMXB.getName();
        try {
            this.metadata_.pid = Integer.parseInt(jvmName.split("@")[0]);
        }
        catch (NumberFormatException e) {
            this.metadata_.pid = null;
        }
        this.metadata_.macAddress = null;
        StrVector addrs = this.core_.getMACAddresses();
        if (addrs.size() > 0L && (addr = addrs.get(0)).length() > 0) {
            this.metadata_.macAddress = addr;
        }
        this.metadata_.hostName = null;
        try {
            this.metadata_.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.metadata_.ipAddress = null;
        try {
            this.metadata_.ipAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.metadata_.userLogin = this.core_.getUserId();
        this.metadata_.currentDir = System.getProperty("user.dir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readTextFile(File file) {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            return e.getMessage();
        }
        StringBuilder sb = new StringBuilder();
        try {
            int read;
            char[] buf = new char[8192];
            while ((read = reader.read(buf)) > 0) {
                sb.append(buf, 0, read);
            }
        }
        catch (IOException e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void writeTextFile(File file, String text) {
        block14: {
            FileOutputStream outputStream;
            try {
                outputStream = new FileOutputStream(file);
            }
            catch (FileNotFoundException e) {
                return;
            }
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            writer.write(text);
            try {
                writer.close();
            }
            catch (IOException iOException) {}
            break block14;
            catch (IOException e) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    private void createReportDir() {
        File readmeFile;
        if (this.reportDir_ == null) {
            return;
        }
        if (this.reportDir_.mkdirs() && !(readmeFile = new File(this.reportDir_, README_FILENAME)).isFile()) {
            String readme = "This directory contains an in-progress (or crashed) \nMicro-Manager Problem Report. It is safe to delete.";
            ProblemReport.writeTextFile(readmeFile, readme);
        }
    }

    private void deleteReportDir(File directory) {
        if (directory != null) {
            new File(directory, LOG_CAPTURE_FILENAME).delete();
            new File(directory, START_CFG_FILENAME).delete();
            new File(directory, END_CFG_FILENAME).delete();
            new File(directory, METADATA_FILENAME).delete();
            new File(directory, README_FILENAME).delete();
            directory.delete();
        }
    }

    private Gson makeGson() {
        final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        class MyDateSerializer
        implements JsonSerializer<Date> {
            MyDateSerializer() {
            }

            public JsonElement serialize(Date src, Type srcType, JsonSerializationContext context) {
                return new JsonPrimitive(format.format(src));
            }
        }
        class MyDateDeserializer
        implements JsonDeserializer<Date> {
            MyDateDeserializer() {
            }

            public Date deserialize(JsonElement json, Type dstType, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return format.parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    return null;
                }
            }
        }
        return new GsonBuilder().registerTypeAdapter(Date.class, (Object)new MyDateSerializer()).registerTypeAdapter(Date.class, (Object)new MyDateDeserializer()).create();
    }

    private synchronized void deferredSyncMetadata() {
        if (this.reportDir_ == null) {
            return;
        }
        if (this.deferredSyncTimer_ == null) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    ProblemReport.this.syncMetadata();
                }
            };
            this.deferredSyncTimer_ = new Timer("ProblemReportMetadataSync", true);
            this.deferredSyncTimer_.schedule(task, 1000L);
        }
    }

    private synchronized void syncMetadata() {
        if (this.reportDir_ == null) {
            return;
        }
        this.createReportDir();
        File metadataFile = new File(this.reportDir_, METADATA_FILENAME);
        Gson gson = this.makeGson();
        ProblemReport.writeTextFile(metadataFile, gson.toJson((Object)this.metadata_));
        if (this.deferredSyncTimer_ != null) {
            this.deferredSyncTimer_.cancel();
            this.deferredSyncTimer_ = null;
        }
    }

    private void syncStartingConfig() {
        if (this.reportDir_ == null) {
            return;
        }
        this.createReportDir();
        if (this.startCfg_ != null) {
            this.metadata_.startCfgFilename = this.startCfg_.getFilename();
            this.syncMetadata();
            ProblemReport.writeTextFile(new File(this.reportDir_, START_CFG_FILENAME), this.startCfg_.getContent());
        } else if (this.metadata_.startCfgFilename != null) {
            new File(this.reportDir_, START_CFG_FILENAME).delete();
            this.metadata_.startCfgFilename = null;
        }
    }

    private void syncEndingConfig() {
        if (this.reportDir_ == null) {
            return;
        }
        this.createReportDir();
        if (this.endCfg_ != null) {
            this.metadata_.endCfgFilename = this.endCfg_.getFilename();
            this.syncMetadata();
            ProblemReport.writeTextFile(new File(this.reportDir_, END_CFG_FILENAME), this.endCfg_.getContent());
        } else if (this.metadata_.endCfgFilename != null) {
            new File(this.reportDir_, END_CFG_FILENAME).delete();
            this.metadata_.endCfgFilename = null;
        }
    }

    private void loadReport(File directory) {
        if (!directory.isDirectory()) {
            return;
        }
        this.leftoverDir_ = directory;
        File metadataFile = new File(directory, METADATA_FILENAME);
        if (!metadataFile.isFile()) {
            return;
        }
        String metadataJson = ProblemReport.readTextFile(metadataFile);
        if (metadataJson == null) {
            return;
        }
        Gson gson = this.makeGson();
        this.metadata_ = (Metadata)gson.fromJson(metadataJson, Metadata.class);
        if (this.metadata_.startCfgFilename != null) {
            this.startCfg_ = new NamedTextFile(this.metadata_.startCfgFilename, new File(directory, START_CFG_FILENAME));
        }
        if (this.metadata_.endCfgFilename != null) {
            this.endCfg_ = new NamedTextFile(this.metadata_.endCfgFilename, new File(directory, END_CFG_FILENAME));
        }
        this.capturedLogContent_ = ProblemReport.readTextFile(new File(directory, LOG_CAPTURE_FILENAME));
        if (this.metadata_.pid != null) {
            this.loadHotSpotErrorLogForPid(this.metadata_.pid);
        }
    }

    private void loadHotSpotErrorLogForPid(int pid) {
        String logFilename;
        File logDir = this.metadata_.currentDir != null ? new File(this.metadata_.currentDir) : new File(System.getProperty("user.dir"));
        File logFile = new File(logDir, logFilename = "hs_err_pid" + Integer.toString(pid) + ".log");
        if (logFile.isFile()) {
            this.hotSpotErrorLog_ = new NamedTextFile(logFile);
        }
    }

    private static NamedTextFile getCurrentConfigFile() {
        String fileName = MMStudio.getInstance().getSysConfigFile();
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        return new NamedTextFile(fileName);
    }

    private static class NamedTextFile {
        private final String filename_;
        private final String content_;

        public NamedTextFile(String filename) {
            this(filename, new File(filename));
        }

        public NamedTextFile(File file) {
            this(file.getAbsolutePath(), file);
        }

        public NamedTextFile(String filename, File file) {
            this.filename_ = filename;
            this.content_ = ProblemReport.readTextFile(file);
        }

        public boolean equals(NamedTextFile rhs) {
            if (this == rhs) {
                return true;
            }
            if (!this.filename_.equals(rhs.filename_)) {
                return false;
            }
            return this.content_.equals(rhs.content_);
        }

        public String getFilename() {
            return this.filename_;
        }

        public String getContent() {
            return this.content_;
        }
    }

    private static class Metadata {
        public Integer pid;
        public Date date;
        public String mmStudioVersion;
        public String startCfgFilename;
        public String endCfgFilename;
        public String userName;
        public String userOrganization;
        public String userEmail;
        public String description;
        public String macAddress;
        public String ipAddress;
        public String hostName;
        public String userLogin;
        public String currentDir;

        private Metadata() {
        }
    }
}

