/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import org.micromanager.diagnostics.SystemInfo;

class PhysicalMemoryInfoSection
implements SystemInfo.SystemInfoSection {
    PhysicalMemoryInfoSection() {
    }

    @Override
    public String getTitle() {
        return "Physical memory information";
    }

    @Override
    public String getReport() {
        StringBuilder sb = new StringBuilder();
        OperatingSystemMXBean osMXB = ManagementFactory.getOperatingSystemMXBean();
        try {
            Class<?> sunOSMXBClass = Class.forName("com.sun.management.OperatingSystemMXBean");
            Method totalMemMethod = sunOSMXBClass.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            long totalRAM = (Long)totalMemMethod.invoke((Object)osMXB, new Object[0]);
            sb.append("Total physical memory (caveats apply if JVM is 32-bit): ").append(this.formatMemSize(totalRAM)).append('\n');
            try {
                Method committedMemMethod = sunOSMXBClass.getMethod("getCommittedVirtualMemorySize", new Class[0]);
                long committedVM = (Long)committedMemMethod.invoke((Object)osMXB, new Object[0]);
                sb.append("Committed virtual memory size: ").append(this.formatMemSize(committedVM)).append('\n');
            }
            catch (Exception e) {
                sb.append("Committed virtual memory size: unavailable\n");
            }
            Method freeMemMethod = sunOSMXBClass.getMethod("getFreePhysicalMemorySize", new Class[0]);
            long freeRAM = (Long)freeMemMethod.invoke((Object)osMXB, new Object[0]);
            sb.append("Free physical memory (may be meaningless if JVM is 32-bit): ").append(this.formatMemSize(freeRAM)).append('\n');
        }
        catch (Exception e) {
            sb.append("Physical memory information: unavailable");
        }
        return sb.toString();
    }

    private String formatMemSize(long size) {
        if (size == -1L) {
            return "unavailable";
        }
        if (size < 1024L) {
            return Long.toString(size) + " bytes";
        }
        double bytes = size;
        DecimalFormat format = new DecimalFormat("#.0");
        if (size < 0x100000L) {
            return Long.toString(size) + " (" + format.format(bytes / 1024.0) + " KiB)";
        }
        if (size < 0x40000000L) {
            return Long.toString(size) + " (" + format.format(bytes / 1048576.0) + " MiB)";
        }
        return Long.toString(size) + " (" + format.format(bytes / 1.073741824E9) + " GiB)";
    }
}

