/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.micromanager.diagnostics.SystemInfo;

class JavaSystemPropertiesInfoSection
implements SystemInfo.SystemInfoSection {
    private static final Set<String> pathListProperties_ = new HashSet<String>();

    JavaSystemPropertiesInfoSection() {
    }

    @Override
    public String getTitle() {
        return "Java system properties";
    }

    @Override
    public String getReport() {
        String pathSep = System.getProperty("path.separator");
        if (pathSep.length() == 0) {
            pathSep = null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Java system properties:\n");
        Properties sysProps = System.getProperties();
        ArrayList<String> propKeys = new ArrayList<String>();
        Enumeration<Object> e = sysProps.keys();
        while (e.hasMoreElements()) {
            propKeys.add((String)e.nextElement());
        }
        Collections.sort(propKeys);
        for (String k : propKeys) {
            if (pathSep != null && pathListProperties_.contains(k)) {
                String[] paths;
                sb.append("  ").append(k).append(" (split at '").append(pathSep).append("') =\n");
                for (String path : paths = sysProps.getProperty(k).split(pathSep)) {
                    sb.append("    ").append(path).append('\n');
                }
                continue;
            }
            sb.append("  ").append(k).append(" = ").append(sysProps.getProperty(k)).append('\n');
        }
        sb.append("(End Java system properties)");
        return sb.toString();
    }

    static {
        pathListProperties_.add("java.class.path");
        pathListProperties_.add("java.library.path");
        pathListProperties_.add("sun.boot.class.path");
        pathListProperties_.add("sun.boot.library.path");
    }
}

