/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import org.micromanager.diagnostics.SystemInfo;

class JVMThreadInfoSection
implements SystemInfo.SystemInfoSection {
    JVMThreadInfoSection() {
    }

    @Override
    public String getTitle() {
        return "Java thread information";
    }

    @Override
    public String getReport() {
        ThreadInfo[] threadInfos;
        StringBuilder sb = new StringBuilder();
        sb.append("All Java threads:\n");
        ThreadMXBean threadMXB = ManagementFactory.getThreadMXBean();
        long[] tids = threadMXB.getAllThreadIds();
        Arrays.sort(tids);
        for (ThreadInfo tInfo : threadInfos = threadMXB.getThreadInfo(tids)) {
            sb.append("  id ").append(Long.toString(tInfo.getThreadId())).append(" (\"").append(tInfo.getThreadName()).append("\"): ").append(tInfo.getThreadState().name()).append('\n');
        }
        sb.append("(End all Java threads)");
        return sb.toString();
    }
}

