/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import org.micromanager.diagnostics.SystemInfo;

class JVMMemoryInfoSection
implements SystemInfo.SystemInfoSection {
    JVMMemoryInfoSection() {
    }

    @Override
    public String getTitle() {
        return "JVM memory information";
    }

    @Override
    public String getReport() {
        StringBuilder sb = new StringBuilder();
        MemoryMXBean memMXB = ManagementFactory.getMemoryMXBean();
        sb.append("JVM heap memory usage: ").append(this.formatMemUsage(memMXB.getHeapMemoryUsage())).append('\n');
        sb.append("JVM non-heap memory usage: ").append(this.formatMemUsage(memMXB.getNonHeapMemoryUsage()));
        return sb.toString();
    }

    private String formatMemUsage(MemoryUsage usage) {
        StringBuilder sb = new StringBuilder();
        sb.append("used = ").append(this.formatMemSize(usage.getUsed())).append("; committed = ").append(this.formatMemSize(usage.getCommitted())).append("; max = ").append(this.formatMemSize(usage.getMax()));
        return sb.toString();
    }

    private String formatMemSize(long size) {
        if (size == -1L) {
            return "unavailable";
        }
        if (size < 1024L) {
            return Long.toString(size) + " bytes";
        }
        double bytes = size;
        DecimalFormat format = new DecimalFormat("#.0");
        if (size < 0x100000L) {
            return Long.toString(size) + " (" + format.format(bytes / 1024.0) + " KiB)";
        }
        if (size < 0x40000000L) {
            return Long.toString(size) + " (" + format.format(bytes / 1048576.0) + " MiB)";
        }
        return Long.toString(size) + " (" + format.format(bytes / 1.073741824E9) + " GiB)";
    }
}

