/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import org.micromanager.diagnostics.SystemInfo;

class JVMDeadlockedThreadInfoSection
implements SystemInfo.SystemInfoSection {
    JVMDeadlockedThreadInfoSection() {
    }

    @Override
    public String getTitle() {
        return "Deadlocked Java threads";
    }

    @Override
    public String getReport() {
        StringBuilder sb = new StringBuilder();
        ThreadMXBean threadMXB = ManagementFactory.getThreadMXBean();
        long[] deadlockedThreadIds = threadMXB.findDeadlockedThreads();
        if (deadlockedThreadIds != null && deadlockedThreadIds.length > 0) {
            ThreadInfo[] deadlockedInfos;
            sb.append("Deadlocked Java threads: ").append(Integer.toString(deadlockedThreadIds.length)).append(" detected\n");
            Arrays.sort(deadlockedThreadIds);
            for (ThreadInfo tInfo : deadlockedInfos = threadMXB.getThreadInfo(deadlockedThreadIds, true, true)) {
                sb.append("Deadlocked Java thread: id ").append(Long.toString(tInfo.getThreadId())).append(" (\"").append(tInfo.getThreadName()).append("\"):").append('\n');
                LockInfo blockingLock = tInfo.getLockInfo();
                sb.append("  Blocked waiting to lock ").append(blockingLock.getClassName()).append(' ').append(Integer.toString(blockingLock.getIdentityHashCode())).append('\n');
                MonitorInfo[] monitors = tInfo.getLockedMonitors();
                LockInfo[] synchronizers = tInfo.getLockedSynchronizers();
                StackTraceElement[] trace = tInfo.getStackTrace();
                for (StackTraceElement frame : trace) {
                    sb.append("    at ").append(frame.toString()).append('\n');
                    for (MonitorInfo monitor : monitors) {
                        if (!monitor.getLockedStackFrame().equals(frame)) continue;
                        sb.append("      where monitor was locked: ").append(monitor.getClassName()).append(' ').append(Integer.toString(monitor.getIdentityHashCode())).append('\n');
                    }
                }
                for (LockInfo sync : synchronizers) {
                    sb.append("  Ownable synchronizer is locked: ").append(sync.getClassName()).append(' ').append(Integer.toString(sync.getIdentityHashCode())).append('\n');
                }
            }
        } else {
            sb.append("Deadlocked Java threads: none detected");
        }
        return sb.toString();
    }

    private void createDeadlockedThreadPair() {
        final Object a = new Object();
        final Object b = new Object();
        Thread th0 = new Thread("DeadLockTestThread0"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = a;
                    synchronized (object) {
                        Thread.sleep(100L);
                        Object object2 = b;
                        synchronized (object2) {
                            Thread.sleep(1L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        Thread th1 = new Thread("DeadLockTestThread1"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = b;
                    synchronized (object) {
                        Thread.sleep(100L);
                        Object object2 = a;
                        synchronized (object2) {
                            Thread.sleep(1L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        th0.start();
        th1.start();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

