/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import mmcorej.CMMCore;

public class EDTHangLogger {
    private CMMCore core_;
    private Timer timer_;
    private final long NEVER = -1L;
    private final long MS_PER_NS = 1000000L;
    private long heartbeatTimeoutMs_;
    private long hangCheckIntervalMs_;
    private long heartbeatTimebaseNs_ = -1L;
    private long lastHeartbeatNs_ = -1L;
    private long hangCheckStartNs_ = -1L;
    private boolean missedHeartbeat_ = false;
    private WeakReference<AWTEvent> nextEventWeakRef_;
    private static EDTHangLogger instance_;
    private static int DEBUG_LEVEL;

    public static void startDefault(CMMCore core, long heartbeatTimeoutMs, long hangCheckIntervalMs) {
        if (instance_ != null) {
            EDTHangLogger.stopDefault();
        }
        instance_ = new EDTHangLogger(core, heartbeatTimeoutMs, hangCheckIntervalMs);
    }

    public static void stopDefault() {
        if (instance_ != null) {
            instance_.stop();
            instance_ = null;
        }
    }

    private void logDebug(int level, String message) {
        if (this.core_ != null && level <= DEBUG_LEVEL) {
            this.core_.logMessage("EDTHangLogger DEBUG: " + message, true);
        }
    }

    private void logMessage(String message) {
        if (this.core_ != null) {
            this.core_.logMessage("EDTHangLogger: " + message);
        }
    }

    public EDTHangLogger(CMMCore core, long heartbeatTimeoutMs, long hangCheckIntervalMs) {
        this.core_ = core;
        this.timer_ = new Timer("EDTHangLogger timer", true);
        this.heartbeatTimeoutMs_ = Math.max(0L, heartbeatTimeoutMs);
        this.hangCheckIntervalMs_ = Math.max(0L, hangCheckIntervalMs);
        this.setupHeartbeat();
        this.logMessage("Started monitoring of EDT hangs\n[heartbeat timeout = " + this.heartbeatTimeoutMs_ + " ms, hang check interval = " + this.hangCheckIntervalMs_ + " ms]");
    }

    public synchronized void stop() {
        if (this.timer_ == null) {
            return;
        }
        this.logMessage("Stopping monitoring of EDT hangs");
        this.timer_.cancel();
        this.timer_ = null;
        this.core_ = null;
    }

    private synchronized void setupHeartbeat() {
        if (this.missedHeartbeat_) {
            this.logDebug(1, "Setting up first new heartbeat after transient hang");
            this.missedHeartbeat_ = false;
        }
        this.heartbeatTimebaseNs_ = System.nanoTime();
        this.lastHeartbeatNs_ = -1L;
        this.logDebug(2, "Setting up heartbeat");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EDTHangLogger.this.heartbeat();
            }
        });
        TimerTask checkTask = new TimerTask(){

            @Override
            public void run() {
                EDTHangLogger.this.checkForHeartbeat(true);
            }
        };
        if (this.timer_ != null) {
            this.timer_.schedule(checkTask, this.heartbeatTimeoutMs_);
        }
    }

    private synchronized void heartbeat() {
        this.lastHeartbeatNs_ = System.nanoTime();
        if (this.missedHeartbeat_) {
            long elapsedSinceTimebaseMs = (this.lastHeartbeatNs_ - this.heartbeatTimebaseNs_) / 1000000L;
            this.logMessage("First heartbeat after miss (" + elapsedSinceTimebaseMs + " ms since timebase)");
        }
        this.logDebug(2, "Heartbeat after " + (this.lastHeartbeatNs_ - this.heartbeatTimebaseNs_) + " ns");
    }

    private synchronized void checkForHeartbeat(boolean firstCheck) {
        if (this.lastHeartbeatNs_ != -1L) {
            this.logDebug(2, "Heartbeat detected");
            this.setupHeartbeat();
            return;
        }
        this.missedHeartbeat_ = true;
        this.logDebug(1, "Heartbeat missed");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
        AWTEvent nextEvent = this.peekEvent();
        if (nextEvent == null) {
            if (this.lastHeartbeatNs_ != -1L) {
                this.logDebug(1, "Appears to have unstuck, heartbeat detected after all");
            } else {
                this.logDebug(1, "UNEXPECTED: Found no next event despite missing heartbeat");
            }
            this.setupHeartbeat();
            return;
        }
        this.nextEventWeakRef_ = new WeakReference<AWTEvent>(nextEvent);
        if (firstCheck) {
            this.logMessage("Missed heartbeat; waiting to see if we are stuck on a single event");
        }
        this.logDebug(1, "Scheduling hang check");
        this.hangCheckStartNs_ = System.nanoTime();
        TimerTask recheckTask = new TimerTask(){

            @Override
            public void run() {
                EDTHangLogger.this.checkForHang(true);
            }
        };
        if (this.timer_ != null) {
            this.timer_.schedule(recheckTask, this.hangCheckIntervalMs_);
        }
    }

    private synchronized void checkForHang(boolean firstCheck) {
        this.logDebug(1, "Checking if still hung");
        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
        AWTEvent previousNextEvent = (AWTEvent)this.nextEventWeakRef_.get();
        AWTEvent nextEvent = this.peekEvent();
        if (previousNextEvent == null || previousNextEvent != nextEvent) {
            this.logDebug(1, "Next event has changed, may not be a hang");
            this.checkForHeartbeat(false);
            return;
        }
        if (firstCheck) {
            long now = System.nanoTime();
            long elapsedTimeMs = (now - this.hangCheckStartNs_) / 1000000L;
            long elapsedSinceTimebaseMs = (now - this.heartbeatTimebaseNs_) / 1000000L;
            this.logMessage("Event handling has exceeded at least " + elapsedTimeMs + " ms (currently " + elapsedSinceTimebaseMs + " ms since heartbeat timebase)\n" + "Stack traces follow " + "(note: thread states queried later than stack traces)" + this.formatStackTraces(traces));
        }
        this.logDebug(1, "Scheduling hang recheck");
        TimerTask recheckTask = new TimerTask(){

            @Override
            public void run() {
                EDTHangLogger.this.checkForHang(false);
            }
        };
        if (this.timer_ != null) {
            this.timer_.schedule(recheckTask, this.hangCheckIntervalMs_);
        }
    }

    private AWTEvent peekEvent() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent();
    }

    private String formatStackTraces(Map<Thread, StackTraceElement[]> traces) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Thread> threads = new ArrayList<Thread>(traces.keySet());
        Collections.sort(threads, new Comparator<Thread>(){

            @Override
            public int compare(Thread t1, Thread t2) {
                return new Long(t1.getId()).compareTo(t2.getId());
            }
        });
        for (Thread thread : threads) {
            this.formatThreadStackTrace(sb, thread, traces.get(thread));
        }
        return sb.toString();
    }

    private void formatThreadStackTrace(StringBuilder sb, Thread thread, StackTraceElement[] trace) {
        sb.append("\n");
        sb.append("Thread " + thread.getId() + " [" + thread.getName() + "] " + thread.getState().toString());
        for (StackTraceElement frame : trace) {
            sb.append("\n  at ");
            sb.append(frame);
        }
    }

    static {
        DEBUG_LEVEL = 0;
    }
}

