/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.diagnostics;

import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.PropertySetting;
import org.micromanager.MMStudio;
import org.micromanager.diagnostics.SystemInfo;

class CorePropertyCacheInfoSection
implements SystemInfo.SystemInfoSection {
    CorePropertyCacheInfoSection() {
    }

    @Override
    public String getTitle() {
        return "Core information";
    }

    @Override
    public String getReport() {
        CMMCore c = MMStudio.getInstance().getMMCore();
        StringBuilder sb = new StringBuilder();
        sb.append("Core property cache (\"system state cache\") contents:\n");
        Configuration cachedProps = c.getSystemStateCache();
        long count = cachedProps.size();
        for (long i = 0L; i < count; ++i) {
            try {
                PropertySetting s = cachedProps.getSetting(i);
                String device = s.getDeviceLabel();
                String name = s.getPropertyName();
                String value = s.getPropertyValue();
                String roString = s.getReadOnly() ? " [RO]" : "";
                sb.append("  ").append(device).append("/").append(name).append(roString).append(" = ").append(value).append('\n');
                continue;
            }
            catch (Exception e) {
                sb.append("  Error while getting cache item ").append(Long.toString(i)).append(": ").append(e.getMessage()).append('\n');
            }
        }
        return sb.toString();
    }
}

