/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mmcorej.DeviceType;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import net.miginfocom.swing.MigLayout;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.PagePanel;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.ReportingUtils;

public class RolesPage
extends PagePanel {
    private static final long serialVersionUID = 1L;
    private JComboBox focusComboBox_;
    private JComboBox shutterComboBox_;
    private JComboBox cameraComboBox_;
    private JCheckBox autoshutterCheckBox_;
    private final JPanel focusDirectionPanel_;
    private static final String HELP_FILE_NAME = "conf_roles_page.html";

    public RolesPage(Preferences prefs) {
        this.title_ = "Select default devices and choose auto-shutter setting";
        this.helpText_ = "Default device roles must be defined so that GUI can send adequate commands to them.\nThis is especially important for systems with multiple cameras, shutters or stages. The GUI needs to know which ones are going to be treated as default.\n\nThese roles can be changed on-the-fly thorugh configuration presets (in one of the subsequent steps).";
        this.setHelpFileName(HELP_FILE_NAME);
        this.prefs_ = prefs;
        this.setLayout(null);
        JLabel cameraLabel = new JLabel();
        cameraLabel.setText("Default camera");
        cameraLabel.setBounds(21, 11, 120, 24);
        this.add(cameraLabel);
        this.cameraComboBox_ = new JComboBox();
        this.cameraComboBox_.setAutoscrolls(true);
        this.cameraComboBox_.setBounds(20, 35, 120, 22);
        this.cameraComboBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    RolesPage.this.model_.setDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreCamera(), (String)RolesPage.this.cameraComboBox_.getSelectedItem());
                }
                catch (MMConfigFileException e) {
                    ReportingUtils.showError(e);
                }
            }
        });
        this.add(this.cameraComboBox_);
        JLabel cameraLabel_1 = new JLabel();
        cameraLabel_1.setText("Default shutter");
        cameraLabel_1.setBounds(22, 69, 120, 24);
        this.add(cameraLabel_1);
        this.shutterComboBox_ = new JComboBox();
        this.shutterComboBox_.setBounds(21, 93, 120, 22);
        this.shutterComboBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    RolesPage.this.model_.setDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreShutter(), (String)RolesPage.this.shutterComboBox_.getSelectedItem());
                }
                catch (MMConfigFileException e) {
                    RolesPage.this.handleError(e.getMessage());
                }
            }
        });
        this.add(this.shutterComboBox_);
        JLabel cameraLabel_2 = new JLabel();
        cameraLabel_2.setText("Default focus stage");
        cameraLabel_2.setBounds(23, 128, 150, 24);
        this.add(cameraLabel_2);
        this.focusComboBox_ = new JComboBox();
        this.focusComboBox_.setBounds(22, 152, 120, 22);
        this.focusComboBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    RolesPage.this.model_.setDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreFocus(), (String)RolesPage.this.focusComboBox_.getSelectedItem());
                }
                catch (MMConfigFileException e) {
                    RolesPage.this.handleError(e.getMessage());
                }
            }
        });
        this.add(this.focusComboBox_);
        this.autoshutterCheckBox_ = new JCheckBox();
        this.autoshutterCheckBox_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    String as = new String();
                    as = RolesPage.this.autoshutterCheckBox_.isSelected() ? "1" : "0";
                    RolesPage.this.model_.setDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreAutoShutter(), as);
                }
                catch (MMConfigFileException e) {
                    ReportingUtils.showError(e);
                }
            }
        });
        this.autoshutterCheckBox_.setText("Auto-shutter");
        this.autoshutterCheckBox_.setBounds(21, 192, 141, 23);
        this.add(this.autoshutterCheckBox_);
        this.focusDirectionPanel_ = new JPanel((LayoutManager)new MigLayout());
        JScrollPane scrollPane = new JScrollPane(this.focusDirectionPanel_);
        scrollPane.setBounds(21, 232, 512, 300);
        this.add(scrollPane);
    }

    @Override
    public boolean enterPage(boolean next) {
        int i2;
        String[] items;
        StrVector cameras = null;
        StrVector shutters = null;
        StrVector stages = null;
        try {
            cameras = this.core_.getLoadedDevicesOfType(DeviceType.CameraDevice);
            shutters = this.core_.getLoadedDevicesOfType(DeviceType.ShutterDevice);
            stages = this.core_.getLoadedDevicesOfType(DeviceType.StageDevice);
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
            return false;
        }
        if (cameras != null) {
            items = new String[(int)cameras.size() + 1];
            items[0] = "";
            i2 = 0;
            while ((long)i2 < cameras.size()) {
                items[i2 + 1] = cameras.get(i2);
                ++i2;
            }
            if (1L == cameras.size()) {
                try {
                    this.model_.setDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreCamera(), cameras.get(0));
                }
                catch (Exception i2) {
                    // empty catch block
                }
            }
            GUIUtils.replaceComboContents(this.cameraComboBox_, items);
        }
        if (shutters != null) {
            items = new String[(int)shutters.size() + 1];
            items[0] = "";
            i2 = 0;
            while ((long)i2 < shutters.size()) {
                items[i2 + 1] = shutters.get(i2);
                ++i2;
            }
            if (1L == shutters.size()) {
                try {
                    this.model_.setDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreShutter(), shutters.get(0));
                }
                catch (Exception i3) {
                    // empty catch block
                }
            }
            GUIUtils.replaceComboContents(this.shutterComboBox_, items);
        }
        if (stages != null) {
            items = new String[(int)stages.size() + 1];
            items[0] = "";
            i2 = 0;
            while ((long)i2 < stages.size()) {
                items[i2 + 1] = stages.get(i2);
                ++i2;
            }
            if (1L == stages.size()) {
                try {
                    this.model_.setDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreFocus(), stages.get(0));
                }
                catch (Exception i4) {
                    // empty catch block
                }
            }
            GUIUtils.replaceComboContents(this.focusComboBox_, items);
        }
        try {
            String camera = this.model_.getDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreCamera());
            if (this.model_.findDevice(camera) != null) {
                this.cameraComboBox_.setSelectedItem(camera);
            } else {
                this.cameraComboBox_.setSelectedItem("");
            }
            String shutter = this.model_.getDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreShutter());
            if (this.model_.findDevice(shutter) != null) {
                this.shutterComboBox_.setSelectedItem(shutter);
            } else {
                this.shutterComboBox_.setSelectedItem("");
            }
            String focus = this.model_.getDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreFocus());
            if (this.model_.findDevice(focus) != null) {
                this.focusComboBox_.setSelectedItem(focus);
            } else {
                this.focusComboBox_.setSelectedItem("");
            }
            String as = this.model_.getDeviceSetupProperty(MMCoreJ.getG_Keyword_CoreDevice(), MMCoreJ.getG_Keyword_CoreAutoShutter());
            if (as.compareTo("1") == 0) {
                this.autoshutterCheckBox_.setSelected(true);
            } else {
                this.autoshutterCheckBox_.setSelected(false);
            }
        }
        catch (MMConfigFileException e) {
            ReportingUtils.showError(e);
        }
        this.focusDirectionPanel_.removeAll();
        if (stages != null && stages.size() > 0L) {
            JLabel focusDirectionLabel = new JLabel("Stage focus directions (advanced)");
            this.focusDirectionPanel_.add((Component)focusDirectionLabel, "wrap");
            try {
                this.model_.loadFocusDirectionsFromHardware(this.core_);
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
            for (final String stageLabel : Arrays.asList(stages.toArray())) {
                final Device stage = this.model_.findDevice(stageLabel);
                if (stage == null) continue;
                int direction = stage.getFocusDirection();
                final JComboBox<String> comboBox = new JComboBox<String>(new String[]{"Unknown", "Positive Toward Sample", "Positive Away From Sample"});
                comboBox.setSelectedIndex(direction < 0 ? 2 : direction);
                comboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int i = comboBox.getSelectedIndex();
                        if (i == 2) {
                            i = -1;
                        }
                        stage.setFocusDirection(i);
                        RolesPage.this.core_.setFocusDirection(stageLabel, i);
                    }
                });
                this.focusDirectionPanel_.add(new JLabel(stageLabel + ":"));
                this.focusDirectionPanel_.add(comboBox, "wrap");
            }
        }
        return true;
    }

    @Override
    public boolean exitPage(boolean next) {
        return true;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void loadSettings() {
    }

    @Override
    public void saveSettings() {
    }
}

