/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import mmcorej.MMCoreJ;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.DeviceSetupDlg;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.Setting;
import org.micromanager.utils.MMPropertyTableModel;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;

class PropertyTableModel
extends AbstractTableModel
implements MMPropertyTableModel {
    private static final long serialVersionUID = 1L;
    public final String[] COLUMN_NAMES = new String[]{"Device", "Property", "Value"};
    public static final int ALL = 0;
    public static final int PREINIT = 1;
    public static final int COMPORT = 2;
    MicroscopeModel model_;
    Device[] devices_;
    PropertyItem[] props_;
    String[] devNames_;
    DeviceSetupDlg setupDlg_;

    public PropertyTableModel(MicroscopeModel model, int mode) {
        this.setupDlg_ = null;
        this.updateValues(model, mode, null);
    }

    public PropertyTableModel(MicroscopeModel model, Device dev, DeviceSetupDlg dlg) {
        this.setupDlg_ = dlg;
        this.updateValues(model, 1, dev);
    }

    public void updateValues(MicroscopeModel model, int mode, Device dev) {
        int i;
        this.model_ = model;
        if (dev == null) {
            this.devices_ = mode == 2 ? model.getAvailableSerialPorts() : model.getDevices();
        } else {
            this.devices_ = new Device[1];
            this.devices_[0] = dev;
        }
        this.model_.dumpComPortsSetupProps();
        ArrayList<PropertyItem> props = new ArrayList<PropertyItem>();
        ArrayList<String> dn = new ArrayList<String>();
        for (i = 0; i < this.devices_.length; ++i) {
            for (int j = 0; j < this.devices_[i].getNumberOfProperties(); ++j) {
                PropertyItem setupProp;
                PropertyItem p = this.devices_[i].getProperty(j);
                if (mode == 1) {
                    if (p.readOnly || !p.preInit || this.devices_[i].isSerialPort() || p.readOnly) continue;
                    props.add(p);
                    dn.add(this.devices_[i].getName());
                    setupProp = this.devices_[i].findSetupProperty(p.name);
                    if (setupProp == null) continue;
                    p.value = setupProp.value;
                    continue;
                }
                if (mode == 2) {
                    if (!this.devices_[i].isSerialPort() || !this.model_.isPortInUse(this.devices_[i]) || p.readOnly) continue;
                    props.add(p);
                    dn.add(this.devices_[i].getName());
                    setupProp = this.devices_[i].findSetupProperty(p.name);
                    if (setupProp == null) continue;
                    p.value = setupProp.value;
                    continue;
                }
                if (p.readOnly || this.devices_[i].isSerialPort()) continue;
                props.add(p);
                dn.add(this.devices_[i].getName());
                setupProp = this.devices_[i].findSetupProperty(p.name);
                if (setupProp == null) continue;
                p.value = setupProp.value;
            }
        }
        this.props_ = new PropertyItem[props.size()];
        this.devNames_ = new String[dn.size()];
        for (i = 0; i < props.size(); ++i) {
            this.props_[i] = (PropertyItem)props.get(i);
            this.devNames_[i] = (String)dn.get(i);
        }
    }

    @Override
    public int getRowCount() {
        return this.props_.length;
    }

    @Override
    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.COLUMN_NAMES[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.devNames_[rowIndex];
        }
        if (columnIndex == 1) {
            return this.props_[rowIndex].name;
        }
        return this.props_[rowIndex].value;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 2) {
            try {
                this.props_[row].value = (String)value;
                this.fireTableCellUpdated(row, col);
                if (this.props_[row].name.compareTo(MMCoreJ.getG_Keyword_Port()) == 0 && this.setupDlg_ != null) {
                    this.setupDlg_.rebuildComTable(this.props_[row].value);
                }
            }
            catch (Exception e) {
                ReportingUtils.logError(e.getMessage());
            }
        }
    }

    @Override
    public boolean isCellEditable(int nRow, int nCol) {
        return nCol == 2 && !this.props_[nRow].readOnly;
    }

    public void refresh() {
        this.fireTableDataChanged();
    }

    @Override
    public PropertyItem getPropertyItem(int rowIndex) {
        return this.props_[rowIndex];
    }

    public Setting getSetting(int rowIndex) {
        return new Setting(this.devNames_[rowIndex], this.props_[rowIndex].name, this.props_[rowIndex].value);
    }

    public PropertyItem getProperty(Setting s) {
        for (int i = 0; i < this.devices_.length; ++i) {
            if (this.devices_[i].getName().compareTo(s.deviceName_) != 0) continue;
            return this.devices_[i].findSetupProperty(s.propertyName_);
        }
        return null;
    }
}

