/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import mmcorej.CMMCore;
import mmcorej.MMCoreJ;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.utils.MMDialog;

public class PeripheralSetupDlg
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private static final int NAMECOLUMN = 0;
    private static final int ADAPTERCOLUMN = 1;
    private static final int DESCRIPTIONCOLUMN = 2;
    private static final int SELECTIONCOLUMN = 3;
    private JTable deviceTable_;
    private JScrollPane scrollPane_;
    private MicroscopeModel model_;
    private String hub_;
    private final JPanel contentPanel = new JPanel();
    private Vector<Device> peripherals_;

    public PeripheralSetupDlg(MicroscopeModel mod, CMMCore c, String hub, Vector<Device> per) {
        this.setTitle("Peripheral Devices Setup");
        this.setBounds(100, 100, 479, 353);
        this.loadPosition(100, 100);
        this.setModal(true);
        this.setResizable(false);
        this.hub_ = hub;
        this.model_ = mod;
        this.peripherals_ = per;
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        this.scrollPane_ = new JScrollPane();
        this.scrollPane_.setBounds(10, 36, 453, 236);
        this.contentPanel.add(this.scrollPane_);
        this.deviceTable_ = new JTable();
        this.deviceTable_.setSelectionMode(0);
        this.scrollPane_.setViewportView(this.deviceTable_);
        JLabel lblNewLabel = new JLabel("HUB (parent device):");
        lblNewLabel.setBounds(10, 11, 111, 14);
        this.contentPanel.add(lblNewLabel);
        JLabel lblParentDev = new JLabel(this.hub_);
        lblParentDev.setBounds(131, 11, 332, 14);
        this.contentPanel.add(lblParentDev);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeripheralSetupDlg.this.onOK();
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeripheralSetupDlg.this.onCancel();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PeripheralSetupDlg.this.savePosition();
            }
        });
        this.rebuildTable();
    }

    public void handleError(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    protected void removeDevice() {
        int sel = this.deviceTable_.getSelectedRow();
        if (sel < 0) {
            return;
        }
        String devName = (String)this.deviceTable_.getValueAt(sel, 0);
        if (devName.contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreDevice()))) {
            this.handleError(MMCoreJ.getG_Keyword_CoreDevice() + " device can't be removed!");
            return;
        }
        this.model_.removeDevice(devName);
        this.rebuildTable();
    }

    public final void rebuildTable() {
        DeviceTable_TableModel tmd = new DeviceTable_TableModel();
        this.deviceTable_.setModel(tmd);
        tmd.fireTableStructureChanged();
        tmd.fireTableDataChanged();
    }

    public void refresh() {
        this.rebuildTable();
    }

    public void onOK() {
        this.savePosition();
        this.dispose();
    }

    public void onCancel() {
        this.savePosition();
        this.dispose();
    }

    public Device[] getSelectedPeripherals() {
        DeviceTable_TableModel tmd = (DeviceTable_TableModel)this.deviceTable_.getModel();
        Vector<Device> sel = new Vector<Device>();
        Vector<Boolean> selFlags = tmd.getSelected();
        for (int i = 0; i < this.peripherals_.size(); ++i) {
            if (!selFlags.get(i).booleanValue()) continue;
            sel.add(this.peripherals_.get(i));
        }
        return sel.toArray(new Device[sel.size()]);
    }

    private class DeviceTable_TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"Name", "Adapter/Library", "Description", "Selected"};
        Vector<Boolean> selected_ = new Vector();

        public DeviceTable_TableModel() {
            for (int i = 0; i < PeripheralSetupDlg.this.peripherals_.size(); ++i) {
                this.selected_.add(false);
            }
        }

        @Override
        public int getRowCount() {
            return PeripheralSetupDlg.this.peripherals_.size();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.COLUMN_NAMES[columnIndex];
        }

        public Class getColumnClass(int c) {
            Class ret = String.class;
            if (3 == c) {
                ret = Boolean.class;
            }
            return ret;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ((Device)PeripheralSetupDlg.this.peripherals_.get(rowIndex)).getName();
            }
            if (columnIndex == 1) {
                return new String(((Device)PeripheralSetupDlg.this.peripherals_.get(rowIndex)).getAdapterName() + "/" + ((Device)PeripheralSetupDlg.this.peripherals_.get(rowIndex)).getLibrary());
            }
            if (columnIndex == 2) {
                return ((Device)PeripheralSetupDlg.this.peripherals_.get(rowIndex)).getDescription();
            }
            if (3 == columnIndex) {
                return this.selected_.get(rowIndex);
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            switch (col) {
                case 0: {
                    String n = (String)value;
                    String o = ((Device)PeripheralSetupDlg.this.peripherals_.get(row)).getName();
                    ((Device)PeripheralSetupDlg.this.peripherals_.get(row)).setName(n);
                    try {
                        this.fireTableCellUpdated(row, col);
                    }
                    catch (Exception e) {
                        PeripheralSetupDlg.this.handleError(e.getMessage());
                    }
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.selected_.set(row, (Boolean)value);
                }
            }
        }

        @Override
        public boolean isCellEditable(int nRow, int nCol) {
            boolean ret = false;
            switch (nCol) {
                case 0: {
                    ret = true;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    ret = true;
                }
            }
            return ret;
        }

        public void refresh() {
            this.fireTableDataChanged();
        }

        Vector<Boolean> getSelected() {
            return this.selected_;
        }
    }
}

