/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.MMCoreJ;
import mmcorej.PropertySetting;
import mmcorej.StrVector;
import org.micromanager.conf2.ConfigGroup;
import org.micromanager.conf2.ConfigPreset;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.Label;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.Setting;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;

public class MicroscopeModel {
    ArrayList<Device> devices_ = new ArrayList();
    Device[] availableDevices_ = new Device[0];
    Device[] availableComPorts_;
    Device[] availableHubs_;
    Vector<String> badLibraries_ = new Vector();
    Hashtable<String, Device> comPortInUse_;
    boolean modified_ = false;
    String fileName_ = "";
    Hashtable<String, ConfigGroup> configGroups_;
    ConfigGroup pixelSizeGroup_;
    ArrayList<String> synchroDevices_;
    public static final String DEVLIST_FILE_NAME = "MMDeviceList.txt";
    public static final String PIXEL_SIZE_GROUP = "PixelSizeGroup";
    boolean sendConfiguration_ = false;

    public static boolean generateDeviceListFile(StringBuffer deviceListFileName, CMMCore c) {
        try {
            deviceListFileName.delete(0, deviceListFileName.length());
            deviceListFileName.append(DEVLIST_FILE_NAME);
            CMMCore core = null == c ? new CMMCore() : c;
            core.enableDebugLog(true);
            StrVector libs = core.getDeviceAdapterNames();
            ArrayList<Device> devs = new ArrayList<Device>();
            int i = 0;
            while ((long)i < libs.size()) {
                try {
                    Device[] devList = Device.getLibraryContents(libs.get(i), core);
                    for (int j = 0; j < devList.length; ++j) {
                        devs.add(devList[j]);
                    }
                }
                catch (Exception e) {
                    ReportingUtils.logError(e);
                }
                ++i;
            }
            if (null == c) {
                core.delete();
            }
            File f = new File(deviceListFileName.toString());
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(f.getAbsolutePath()));
                for (int i2 = 0; i2 < devs.size(); ++i2) {
                    Device dev = (Device)devs.get(i2);
                    if (dev.isSerialPort()) continue;
                    String descr = dev.getDescription().replaceAll(",", ";");
                    out.write(dev.getLibrary() + "," + dev.getAdapterName() + "," + descr + "," + dev.getTypeAsInt());
                    out.newLine();
                }
                out.close();
            }
            catch (IOException e1) {
                ReportingUtils.showError((Throwable)e1, "Unable to open the output file: " + deviceListFileName);
                return false;
            }
        }
        catch (Exception e2) {
            ReportingUtils.showError(e2);
        }
        return true;
    }

    public MicroscopeModel() {
        this.availableHubs_ = new Device[0];
        this.configGroups_ = new Hashtable();
        this.synchroDevices_ = new ArrayList();
        this.availableComPorts_ = new Device[0];
        this.pixelSizeGroup_ = new ConfigGroup(PIXEL_SIZE_GROUP);
        Device coreDev = new Device(MMCoreJ.getG_Keyword_CoreDevice(), "Default", "MMCore", "Core controller");
        this.devices_.add(coreDev);
        this.addMissingProperties();
        this.addSystemConfigs();
    }

    public boolean isModified() {
        return this.modified_;
    }

    public void setModified(boolean mod) {
        this.modified_ = mod;
    }

    public String getFileName() {
        return this.fileName_;
    }

    public void setFileName(String fname) {
        this.fileName_ = fname;
    }

    public void loadDeviceDataFromHardware(CMMCore core) throws Exception {
        int i;
        for (i = 0; i < this.devices_.size(); ++i) {
            Device dev = this.devices_.get(i);
            dev.loadDataFromHardware(core);
        }
        for (i = 0; i < this.availableComPorts_.length; ++i) {
            this.availableComPorts_[i].loadDataFromHardware(core);
        }
    }

    public void loadStateLabelsFromHardware(CMMCore core) throws Exception {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device dev = this.devices_.get(i);
            if (dev.getNumberOfSetupLabels() != 0) continue;
            dev.getSetupLabelsFromHardware(core);
        }
    }

    public void loadFocusDirectionsFromHardware(CMMCore core) throws Exception {
        for (Device dev : this.devices_) {
            if (!dev.isStage()) continue;
            dev.getFocusDirectionFromHardware(core);
        }
    }

    public void loadAvailableDeviceList(CMMCore core) {
        try {
            ArrayList<Device> devsTotal = new ArrayList<Device>();
            ArrayList<Device> ports = new ArrayList<Device>();
            this.availableDevices_ = new Device[0];
            ArrayList<Device> hubs = new ArrayList<Device>();
            this.badLibraries_ = new Vector();
            StrVector libs = core.getDeviceAdapterNames();
            int i = 0;
            while ((long)i < libs.size()) {
                boolean good = false;
                if (!this.isLibraryAvailable(libs.get(i))) {
                    ReportingUtils.logMessage(libs.get(i));
                    Device[] devs = new Device[]{};
                    try {
                        devs = Device.getLibraryContents(libs.get(i), core);
                        for (int j = 0; j < devs.length; ++j) {
                            ReportingUtils.logMessage("   " + devs[j].getAdapterName() + ", " + devs[j].getDescription());
                            if (!devs[j].isSerialPort()) {
                                devsTotal.add(devs[j]);
                            } else {
                                devs[j].setName(devs[j].getAdapterName());
                                if (!ports.contains(devs[j])) {
                                    ports.add(devs[j]);
                                }
                            }
                            good = true;
                        }
                    }
                    catch (Exception e) {
                        ReportingUtils.logError(null, "Unable to load " + libs.get(i) + " library: " + e.getMessage());
                    }
                }
                if (!good) {
                    this.badLibraries_.add(libs.get(i));
                }
                ++i;
            }
            this.availableDevices_ = new Device[devsTotal.size()];
            for (i = 0; i < devsTotal.size(); ++i) {
                this.availableDevices_[i] = (Device)devsTotal.get(i);
                if (!this.availableDevices_[i].isHub()) continue;
                hubs.add(this.availableDevices_[i]);
            }
            this.availableHubs_ = new Device[hubs.size()];
            hubs.toArray(this.availableHubs_);
            this.availableComPorts_ = new Device[ports.size()];
            this.comPortInUse_ = new Hashtable();
            for (i = 0; i < ports.size(); ++i) {
                this.availableComPorts_[i] = (Device)ports.get(i);
            }
        }
        catch (Exception e3) {
            ReportingUtils.showError(e3);
        }
    }

    public Device[] getAvailableDeviceList() {
        return this.availableDevices_;
    }

    public Device[] getAvailableHubs() {
        return this.availableHubs_;
    }

    public Device[] getAvailableDevicesCompact() {
        ArrayList<Device> compactList = new ArrayList<Device>();
        for (int i = 0; i < this.availableDevices_.length; ++i) {
            boolean include = true;
            for (int j = 0; j < this.availableHubs_.length; ++j) {
                if (this.availableHubs_[j].getLibrary().compareTo(this.availableDevices_[i].getLibrary()) != 0 || this.availableDevices_[i].isHub()) continue;
                include = false;
            }
            if (!include) continue;
            compactList.add(this.availableDevices_[i]);
        }
        return compactList.toArray(new Device[compactList.size()]);
    }

    public Device[] getAvailableSerialPorts() {
        return this.availableComPorts_;
    }

    public String[] getBadLibraries() {
        return this.badLibraries_.toArray(new String[this.badLibraries_.size()]);
    }

    public boolean isPortInUse(int index) {
        return this.comPortInUse_.containsKey(this.availableComPorts_[index].getName());
    }

    public boolean isPortInUse(Device device) {
        return this.comPortInUse_.containsKey(device.getName());
    }

    void useSerialPort(int portIndex, boolean use) {
        if (use) {
            this.comPortInUse_.put(this.availableComPorts_[portIndex].getName(), this.availableComPorts_[portIndex]);
        } else {
            this.comPortInUse_.remove(this.availableComPorts_[portIndex].getName());
        }
    }

    void useSerialPort(Device dev, boolean use) {
        if (use) {
            this.comPortInUse_.put(dev.getName(), dev);
        } else {
            this.comPortInUse_.remove(dev.getName());
        }
    }

    public void addSetupProperty(String deviceName, PropertyItem prop) throws MMConfigFileException {
        Device dev = this.findDevice(deviceName);
        if (dev == null) {
            throw new MMConfigFileException("Device " + deviceName + " not defined.");
        }
        PropertyItem p = dev.findSetupProperty(prop.name);
        if (p == null) {
            dev.addSetupProperty(prop);
        } else {
            p.value = prop.value;
        }
    }

    public void addSetupLabel(String deviceName, Label lab) throws MMConfigFileException {
        Device dev = this.findDevice(deviceName);
        if (dev != null) {
            dev.addSetupLabel(lab);
            this.modified_ = true;
            return;
        }
        throw new MMConfigFileException("Device " + deviceName + " not defined.");
    }

    public void applySetupLabelsToHardware(CMMCore core) throws Exception {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device dev = this.devices_.get(i);
            Label[] setupLabels = dev.getAllSetupLabels();
            for (int j = 0; j < setupLabels.length; ++j) {
                core.defineStateLabel(dev.getName(), setupLabels[j].state_, setupLabels[j].label_);
            }
        }
    }

    public void applySetupConfigsToHardware(CMMCore core) throws Exception {
        StrVector curGroups = core.getAvailableConfigGroups();
        int i = 0;
        while ((long)i < curGroups.size()) {
            core.deleteConfigGroup(curGroups.get(i));
            ++i;
        }
        Object[] groups = this.configGroups_.values().toArray();
        for (int i2 = 0; i2 < groups.length; ++i2) {
            ConfigGroup group = (ConfigGroup)groups[i2];
            core.defineConfigGroup(group.getName());
            ConfigPreset[] presets = group.getConfigPresets();
            for (int j = 0; j < presets.length; ++j) {
                for (int k = 0; k < presets[j].getNumberOfSettings(); ++k) {
                    Setting s = presets[j].getSetting(k);
                    core.defineConfig(group.getName(), presets[j].getName(), s.deviceName_, s.propertyName_, s.propertyValue_);
                }
            }
        }
    }

    public void createSetupConfigsFromHardware(CMMCore core) throws MMConfigFileException {
        this.configGroups_.clear();
        StrVector curGroups = core.getAvailableConfigGroups();
        try {
            int i = 0;
            while ((long)i < curGroups.size()) {
                ConfigGroup grp = new ConfigGroup(curGroups.get(i));
                StrVector presets = core.getAvailableConfigs(curGroups.get(i));
                int j = 0;
                while ((long)j < presets.size()) {
                    Configuration cfg = core.getConfigData(curGroups.get(i), presets.get(j));
                    ConfigPreset p = new ConfigPreset(presets.get(j));
                    int k = 0;
                    while ((long)k < cfg.size()) {
                        PropertySetting ps = cfg.getSetting((long)k);
                        Setting s = new Setting(ps.getDeviceLabel(), ps.getPropertyName(), ps.getPropertyValue());
                        p.addSetting(s);
                        ++k;
                    }
                    grp.addConfigPreset(p);
                    ++j;
                }
                this.configGroups_.put(curGroups.get(i), grp);
                this.modified_ = true;
                ++i;
            }
        }
        catch (Exception e) {
            throw new MMConfigFileException(e);
        }
    }

    public void updateLabelsInPreset(String deviceName, String oldLabel, String newLabel) {
        Enumeration<ConfigGroup> e = this.configGroups_.elements();
        while (e.hasMoreElements()) {
            ConfigPreset[] cps;
            ConfigGroup grp = e.nextElement();
            for (ConfigPreset cp : cps = grp.getConfigPresets()) {
                for (int i = 0; i < cp.getNumberOfSettings(); ++i) {
                    Setting s = cp.getSetting(i);
                    if (!s.propertyName_.equals("Label") || !s.deviceName_.equals(deviceName) || !s.propertyValue_.equals(oldLabel)) continue;
                    s.propertyValue_ = newLabel;
                }
            }
        }
    }

    public void createResolutionsFromHardware(CMMCore core) throws MMConfigFileException {
        this.pixelSizeGroup_ = new ConfigGroup(PIXEL_SIZE_GROUP);
        try {
            StrVector pixelSizeConfigs = core.getAvailablePixelSizeConfigs();
            int j = 0;
            while ((long)j < pixelSizeConfigs.size()) {
                Configuration pcfg = core.getPixelSizeConfigData(pixelSizeConfigs.get(j));
                ConfigPreset p = new ConfigPreset(pixelSizeConfigs.get(j));
                p.setPixelSizeUm(core.getPixelSizeUmByID(pixelSizeConfigs.get(j)));
                int k = 0;
                while ((long)k < pcfg.size()) {
                    PropertySetting ps = pcfg.getSetting((long)k);
                    Setting s = new Setting(ps.getDeviceLabel(), ps.getPropertyName(), ps.getPropertyValue());
                    p.addSetting(s);
                    ++k;
                }
                this.pixelSizeGroup_.addConfigPreset(p);
                ++j;
            }
            this.modified_ = true;
        }
        catch (Exception e) {
            throw new MMConfigFileException(e);
        }
    }

    public void applyDelaysToHardware(CMMCore core) throws Exception {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device dev = this.devices_.get(i);
            core.setDeviceDelayMs(dev.getName(), dev.getDelay());
        }
    }

    public boolean addConfigGroup(String name) {
        ConfigGroup cg = new ConfigGroup(name);
        ConfigGroup obj = this.configGroups_.get(name);
        if (obj == null) {
            this.configGroups_.put(cg.getName(), cg);
            this.modified_ = true;
            return true;
        }
        return false;
    }

    public void loadFromFile(String path) throws MMConfigFileException {
        this.reset();
        File configFile = new File(path);
        if (!configFile.exists()) {
            throw new MMConfigFileException("Configuration file does not exist.");
        }
        boolean initialized = false;
        try {
            BufferedReader input = null;
            input = new BufferedReader(new FileReader(configFile));
            String line = null;
            while ((line = input.readLine()) != null) {
                Device dev;
                String[] tokens = line.split(",");
                if (tokens.length == 0 || tokens[0].startsWith("#")) continue;
                if (tokens[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_Device()))) {
                    if (tokens.length != 4) {
                        throw new MMConfigFileException("Invalid number of parameters (4 required):\n" + line);
                    }
                    dev = new Device(tokens[1], tokens[2], tokens[3], this.getDeviceDescription(tokens[2], tokens[3]));
                    this.devices_.add(dev);
                    continue;
                }
                if (tokens[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_Property()))) {
                    PropertyItem prop;
                    if (tokens.length != 4 && tokens.length != 3) {
                        throw new MMConfigFileException("Invalid number of parameters (4 required):\n" + line);
                    }
                    if (tokens.length == 3) {
                        String[] extTokens = new String[4];
                        for (int i = 0; i < 3; ++i) {
                            extTokens[i] = tokens[i];
                        }
                        extTokens[3] = "";
                        tokens = extTokens;
                    }
                    if (tokens[1].contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreDevice()))) {
                        if (tokens[2].contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreInitialize()))) {
                            if (tokens[3].contentEquals(new StringBuffer().append("0"))) {
                                initialized = false;
                                continue;
                            }
                            initialized = true;
                            continue;
                        }
                        prop = new PropertyItem();
                        prop.name = tokens[2];
                        prop.value = tokens[3];
                        this.addSetupProperty(tokens[1], prop);
                        continue;
                    }
                    prop = new PropertyItem();
                    prop.preInit = !initialized;
                    prop.name = tokens[2];
                    prop.value = tokens[3];
                    this.addSetupProperty(tokens[1], prop);
                    continue;
                }
                if (tokens[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_Label()))) {
                    if (tokens.length != 4) {
                        throw new MMConfigFileException("Invalid number of parameters (4 required):\n" + line);
                    }
                    Label lab = new Label(tokens[3], Integer.parseInt(tokens[2]));
                    this.addSetupLabel(tokens[1], lab);
                    continue;
                }
                if (tokens[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_ImageSynchro()))) {
                    if (tokens.length != 2) {
                        throw new MMConfigFileException("Invalid number of parameters (2 required):\n" + line);
                    }
                    this.synchroDevices_.add(tokens[1]);
                    continue;
                }
                if (tokens[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_ConfigGroup()))) {
                    if (tokens.length != 6 && tokens.length != 5) {
                        throw new MMConfigFileException("Invalid number of parameters (6 required):\n" + line);
                    }
                    this.addConfigGroup(tokens[1]);
                    ConfigGroup cg = this.findConfigGroup(tokens[1]);
                    if (tokens.length == 6) {
                        cg.addConfigSetting(tokens[2], tokens[3], tokens[4], tokens[5]);
                        continue;
                    }
                    cg.addConfigSetting(tokens[2], tokens[3], tokens[4], "");
                    continue;
                }
                if (tokens[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_ConfigPixelSize()))) {
                    if (tokens.length != 5) {
                        throw new MMConfigFileException("Invalid number of parameters (5 required):\n" + line);
                    }
                    this.pixelSizeGroup_.addConfigSetting(tokens[1], tokens[2], tokens[3], tokens[4]);
                    continue;
                }
                if (tokens[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_PixelSize_um()))) {
                    if (tokens.length != 3) {
                        throw new MMConfigFileException("Invalid number of parameters (3 required):\n" + line);
                    }
                    ConfigPreset cp = this.pixelSizeGroup_.findConfigPreset(tokens[1]);
                    if (cp == null) continue;
                    cp.setPixelSizeUm(Double.parseDouble(tokens[2]));
                    continue;
                }
                if (tokens[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_Delay()))) {
                    if (tokens.length != 3) {
                        throw new MMConfigFileException("Invalid number of parameters (3 required):\n" + line);
                    }
                    dev = this.findDevice(tokens[1]);
                    if (dev == null) continue;
                    dev.setDelay(Double.parseDouble(tokens[2]));
                    continue;
                }
                if (tokens[0].equals(MMCoreJ.getG_CFGCommand_FocusDirection())) {
                    if (tokens.length != 3) {
                        throw new MMConfigFileException("Invalid number of parameters (3 required):\n" + line);
                    }
                    dev = this.findDevice(tokens[1]);
                    if (dev == null) continue;
                    dev.setFocusDirection(Integer.parseInt(tokens[2]));
                    continue;
                }
                if (!tokens[0].contentEquals(new StringBuffer().append(MMCoreJ.getG_CFGCommand_ParentID()))) continue;
                if (tokens.length != 3) {
                    throw new MMConfigFileException("Invalid number of parameters (3 required):\n" + line);
                }
                dev = this.findDevice(tokens[1]);
                if (dev == null) continue;
                dev.setParentHub(tokens[2]);
            }
        }
        catch (IOException e) {
            this.reset();
            throw new MMConfigFileException(e);
        }
        finally {
            this.modified_ = false;
            this.fileName_ = path;
            this.addMissingProperties();
            this.addSystemConfigs();
            for (int i = 0; i < this.availableComPorts_.length; ++i) {
                Device dev = this.findDevice(this.availableComPorts_[i].getName());
                if (dev == null) continue;
                this.useSerialPort(dev, true);
            }
        }
    }

    public String getDeviceDescription(String library, String adapter) {
        Device dev = this.findAvailableDevice(library, adapter);
        if (dev != null) {
            return dev.getDescription();
        }
        return "";
    }

    private Device findAvailableDevice(String library, String adapter) {
        for (int i = 0; i < this.availableDevices_.length; ++i) {
            if (this.availableDevices_[i].getLibrary().compareTo(library) != 0 || this.availableDevices_[i].getAdapterName().compareTo(adapter) != 0) continue;
            return this.availableDevices_[i];
        }
        return null;
    }

    private boolean isLibraryAvailable(String library) {
        for (int i = 0; i < this.availableDevices_.length; ++i) {
            if (this.availableDevices_[i].getLibrary().compareTo(library) != 0) continue;
            return true;
        }
        return false;
    }

    private void addMissingProperties() {
        PropertyItem p;
        Device c = this.findDevice(MMCoreJ.getG_Keyword_CoreDevice());
        if (c == null) {
            c = new Device(MMCoreJ.getG_Keyword_CoreDevice(), "MMCore", "CoreDevice");
        }
        if ((p = c.findSetupProperty(MMCoreJ.getG_Keyword_CoreCamera())) == null) {
            c.addSetupProperty(new PropertyItem(MMCoreJ.getG_Keyword_CoreCamera(), ""));
        }
        if ((p = c.findSetupProperty(MMCoreJ.getG_Keyword_CoreShutter())) == null) {
            c.addSetupProperty(new PropertyItem(MMCoreJ.getG_Keyword_CoreShutter(), ""));
        }
        if ((p = c.findSetupProperty(MMCoreJ.getG_Keyword_CoreFocus())) == null) {
            c.addSetupProperty(new PropertyItem(MMCoreJ.getG_Keyword_CoreFocus(), ""));
        }
        if ((p = c.findSetupProperty(MMCoreJ.getG_Keyword_CoreAutoShutter())) == null) {
            c.addSetupProperty(new PropertyItem(MMCoreJ.getG_Keyword_CoreAutoShutter(), "1"));
        }
    }

    private void addSystemConfigs() {
        ConfigPreset cp;
        ConfigGroup cg = this.findConfigGroup(MMCoreJ.getG_CFGGroup_System());
        if (cg == null) {
            this.addConfigGroup(MMCoreJ.getG_CFGGroup_System());
        }
        if ((cg = this.findConfigGroup(MMCoreJ.getG_Keyword_Channel())) == null) {
            this.addConfigGroup(MMCoreJ.getG_Keyword_Channel());
        }
        if ((cp = (cg = this.findConfigGroup(MMCoreJ.getG_CFGGroup_System())).findConfigPreset(MMCoreJ.getG_CFGGroup_System_Startup())) == null) {
            cp = new ConfigPreset(MMCoreJ.getG_CFGGroup_System_Startup());
            cg.addConfigPreset(cp);
        }
    }

    public void saveToFile(String path) throws MMConfigFileException {
        try {
            int i;
            PropertyItem prop;
            int j;
            Device dev2;
            int i2;
            BufferedWriter out = new BufferedWriter(new FileWriter(path));
            out.write("# Generated by Configurator on " + GregorianCalendar.getInstance().getTime());
            out.newLine();
            out.newLine();
            out.write("# Reset");
            out.newLine();
            out.write("Property,Core,Initialize,0");
            out.newLine();
            out.newLine();
            out.write("# Devices");
            out.newLine();
            for (i2 = 0; i2 < this.availableComPorts_.length; ++i2) {
                dev2 = this.availableComPorts_[i2];
                if (!this.isPortInUse(dev2)) continue;
                out.write(MMCoreJ.getG_CFGCommand_Device() + "," + dev2.getName() + "," + dev2.getLibrary() + "," + dev2.getAdapterName());
                out.newLine();
            }
            for (i2 = 0; i2 < this.devices_.size(); ++i2) {
                dev2 = this.devices_.get(i2);
                if (dev2.isCore()) continue;
                out.write(MMCoreJ.getG_CFGCommand_Device() + "," + dev2.getName() + "," + dev2.getLibrary() + "," + dev2.getAdapterName());
                out.newLine();
            }
            out.newLine();
            out.write("# Pre-init settings for devices");
            out.newLine();
            for (i2 = 0; i2 < this.devices_.size(); ++i2) {
                dev2 = this.devices_.get(i2);
                for (j = 0; j < dev2.getNumberOfSetupProperties(); ++j) {
                    prop = dev2.getSetupProperty(j);
                    if (!prop.preInit) continue;
                    out.write(MMCoreJ.getG_CFGCommand_Property() + "," + dev2.getName() + "," + prop.name + "," + prop.value);
                    out.newLine();
                }
            }
            out.newLine();
            out.write("# Pre-init settings for COM ports");
            out.newLine();
            for (i2 = 0; i2 < this.availableComPorts_.length; ++i2) {
                dev2 = this.availableComPorts_[i2];
                for (j = 0; j < dev2.getNumberOfSetupProperties(); ++j) {
                    prop = dev2.getSetupProperty(j);
                    if (!this.isPortInUse(dev2) || !prop.preInit) continue;
                    out.write(MMCoreJ.getG_CFGCommand_Property() + "," + dev2.getName() + "," + prop.name + "," + prop.value);
                    out.newLine();
                }
            }
            out.newLine();
            out.write("# Hub (parent) references");
            out.newLine();
            for (i2 = 0; i2 < this.devices_.size(); ++i2) {
                dev2 = this.devices_.get(i2);
                String parentID = dev2.getParentHub();
                if (parentID.length() == 0) continue;
                out.write(MMCoreJ.getG_CFGCommand_ParentID() + "," + dev2.getName() + "," + parentID);
                out.newLine();
            }
            out.newLine();
            out.write("# Initialize");
            out.newLine();
            out.write("Property,Core,Initialize,1");
            out.newLine();
            out.newLine();
            out.write("# Delays");
            out.newLine();
            for (i2 = 0; i2 < this.devices_.size(); ++i2) {
                dev2 = this.devices_.get(i2);
                if (!(dev2.getDelay() > 0.0)) continue;
                out.write(MMCoreJ.getG_CFGCommand_Delay() + "," + dev2.getName() + "," + dev2.getDelay());
                out.newLine();
            }
            out.newLine();
            out.write("# Focus directions");
            out.newLine();
            for (Device dev2 : this.devices_) {
                if (!dev2.isStage()) continue;
                int direction = dev2.getFocusDirection();
                out.write(MMCoreJ.getG_CFGCommand_FocusDirection() + "," + dev2.getName() + "," + direction);
                out.newLine();
            }
            out.newLine();
            out.write("# Roles");
            out.newLine();
            Device coreDev = this.findDevice(MMCoreJ.getG_Keyword_CoreDevice());
            PropertyItem p = coreDev.findSetupProperty(MMCoreJ.getG_Keyword_CoreCamera());
            if (p.value.length() > 0) {
                out.write(MMCoreJ.getG_CFGCommand_Property() + "," + MMCoreJ.getG_Keyword_CoreDevice() + "," + MMCoreJ.getG_Keyword_CoreCamera() + "," + p.value);
                out.newLine();
            }
            p = coreDev.findSetupProperty(MMCoreJ.getG_Keyword_CoreShutter());
            if (p.value.length() > 0) {
                out.write(MMCoreJ.getG_CFGCommand_Property() + "," + MMCoreJ.getG_Keyword_CoreDevice() + "," + MMCoreJ.getG_Keyword_CoreShutter() + "," + p.value);
                out.newLine();
            }
            p = coreDev.findSetupProperty(MMCoreJ.getG_Keyword_CoreFocus());
            if (p.value.length() > 0) {
                out.write(MMCoreJ.getG_CFGCommand_Property() + "," + MMCoreJ.getG_Keyword_CoreDevice() + "," + MMCoreJ.getG_Keyword_CoreFocus() + "," + p.value);
                out.newLine();
            }
            p = coreDev.findSetupProperty(MMCoreJ.getG_Keyword_CoreAutoShutter());
            if (p.value.length() > 0) {
                out.write(MMCoreJ.getG_CFGCommand_Property() + "," + MMCoreJ.getG_Keyword_CoreDevice() + "," + MMCoreJ.getG_Keyword_CoreAutoShutter() + "," + p.value);
                out.newLine();
            }
            out.newLine();
            out.write("# Camera-synchronized devices");
            out.newLine();
            for (i = 0; i < this.synchroDevices_.size(); ++i) {
                out.write(MMCoreJ.getG_CFGCommand_ImageSynchro() + "," + this.synchroDevices_.get(i));
                out.newLine();
            }
            out.newLine();
            out.write("# Labels");
            out.newLine();
            for (i = 0; i < this.devices_.size(); ++i) {
                Device dev3 = this.devices_.get(i);
                if (dev3.getNumberOfSetupLabels() > 0) {
                    out.write("# " + dev3.getName());
                    out.newLine();
                }
                Label[] labels = dev3.getAllSetupLabels();
                for (int j2 = 0; j2 < labels.length; ++j2) {
                    out.write(MMCoreJ.getG_CFGCommand_Label() + "," + dev3.getName() + "," + labels[j2].state_ + "," + labels[j2].label_);
                    out.newLine();
                }
            }
            out.newLine();
            out.write("# Configuration presets");
            out.newLine();
            Object[] groups = this.configGroups_.values().toArray();
            for (int i3 = 0; i3 < groups.length; ++i3) {
                ConfigGroup group = (ConfigGroup)groups[i3];
                out.write("# Group: " + group.getName());
                out.newLine();
                ConfigPreset[] presets = group.getConfigPresets();
                for (int j3 = 0; j3 < presets.length; ++j3) {
                    out.write("# Preset: " + presets[j3].getName());
                    out.newLine();
                    for (int k = 0; k < presets[j3].getNumberOfSettings(); ++k) {
                        Setting s = presets[j3].getSetting(k);
                        out.write(MMCoreJ.getG_CFGCommand_ConfigGroup() + "," + group.getName() + "," + presets[j3].getName() + "," + s.deviceName_ + "," + s.propertyName_ + "," + s.propertyValue_);
                        out.newLine();
                    }
                    out.newLine();
                }
                out.newLine();
            }
            out.newLine();
            out.write("# PixelSize settings");
            out.newLine();
            ConfigPreset[] presets = this.pixelSizeGroup_.getConfigPresets();
            for (int j4 = 0; j4 < presets.length; ++j4) {
                out.write("# Resolution preset: " + presets[j4].getName());
                out.newLine();
                for (int k = 0; k < presets[j4].getNumberOfSettings(); ++k) {
                    Setting s = presets[j4].getSetting(k);
                    out.write(MMCoreJ.getG_CFGCommand_ConfigPixelSize() + "," + presets[j4].getName() + "," + s.deviceName_ + "," + s.propertyName_ + "," + s.propertyValue_);
                    out.newLine();
                    out.write(MMCoreJ.getG_CFGGroup_PixelSizeUm() + "," + presets[j4].getName() + "," + Double.toString(presets[j4].getPixelSize()));
                    out.newLine();
                }
                out.newLine();
            }
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            throw new MMConfigFileException(e);
        }
        this.fileName_ = path;
        this.modified_ = false;
    }

    public void dumpSetupConf() {
        PropertyItem prop;
        int j;
        Device dev;
        int i;
        ReportingUtils.logMessage("\nStep 1: load devices");
        for (i = 0; i < this.devices_.size(); ++i) {
            dev = this.devices_.get(i);
            ReportingUtils.logMessage(dev.getName() + " from library " + dev.getLibrary() + ", using adapter " + dev.getAdapterName());
        }
        ReportingUtils.logMessage("\nStep 2: set pre-initialization properties");
        for (i = 0; i < this.devices_.size(); ++i) {
            dev = this.devices_.get(i);
            for (j = 0; j < dev.getNumberOfSetupProperties(); ++j) {
                prop = dev.getSetupProperty(j);
                if (!prop.preInit) continue;
                ReportingUtils.logMessage(dev.getName() + ", property " + prop.name + "=" + prop.value);
            }
        }
        ReportingUtils.logMessage("\nStep 3: initialize");
        ReportingUtils.logMessage("\nStep 4: define device labels");
        for (i = 0; i < this.devices_.size(); ++i) {
            dev = this.devices_.get(i);
            ReportingUtils.logMessage(dev.getName() + " labels:");
            for (j = 0; j < dev.getNumberOfSetupLabels(); ++j) {
                Label lab = dev.getSetupLabelByState(j);
                ReportingUtils.logMessage("    State " + lab.state_ + "=" + lab.label_);
            }
        }
        ReportingUtils.logMessage("\nStep 5: set initial properties");
        for (i = 0; i < this.devices_.size(); ++i) {
            dev = this.devices_.get(i);
            for (j = 0; j < dev.getNumberOfSetupProperties(); ++j) {
                prop = dev.getSetupProperty(j);
                if (prop.preInit) continue;
                ReportingUtils.logMessage(dev.getName() + ", property " + prop.name + "=" + prop.value);
            }
        }
    }

    public void dumpDeviceProperties(String device) {
        Device d = this.findDevice(device);
        if (d == null) {
            return;
        }
        for (int i = 0; i < d.getNumberOfSetupProperties(); ++i) {
            PropertyItem prop = d.getSetupProperty(i);
            ReportingUtils.logMessage(d.getName() + ", property " + prop.name + "=" + prop.value);
            for (int j = 0; j < prop.allowed.length; ++j) {
                ReportingUtils.logMessage("   " + prop.allowed[j]);
            }
        }
    }

    public void dumpComPortProperties(String device) {
        Device d = this.findSerialPort(device);
        if (d == null) {
            return;
        }
        for (int i = 0; i < d.getNumberOfSetupProperties(); ++i) {
            PropertyItem prop = d.getSetupProperty(i);
            ReportingUtils.logMessage(d.getName() + ", property " + prop.name + "=" + prop.value);
            for (int j = 0; j < prop.allowed.length; ++j) {
                ReportingUtils.logMessage("   " + prop.allowed[j]);
            }
        }
    }

    public void dumpComPortsSetupProps() {
        for (int i = 0; i < this.availableComPorts_.length; ++i) {
            this.dumpDeviceProperties(this.availableComPorts_[i].getName());
            this.dumpComPortProperties(this.availableComPorts_[i].getName());
        }
    }

    public void reset() {
        this.devices_.clear();
        this.configGroups_.clear();
        this.synchroDevices_.clear();
        this.pixelSizeGroup_.clear();
        Device coreDev = new Device(MMCoreJ.getG_Keyword_CoreDevice(), "Default", "MMCore", "Core controller");
        this.devices_.add(coreDev);
        this.addMissingProperties();
        this.addSystemConfigs();
        this.modified_ = true;
    }

    public Device[] getDevices() {
        Device[] devs = new Device[this.devices_.size()];
        for (int i = 0; i < devs.length; ++i) {
            devs[i] = this.devices_.get(i);
        }
        return devs;
    }

    public Device[] getPeripheralDevices() {
        int len = 0;
        Device[] devs = new Device[len];
        return devs;
    }

    public Device[] getChildDevices(Device hub) {
        ArrayList<Device> children = new ArrayList<Device>();
        for (int i = 0; i < this.devices_.size(); ++i) {
            if (!this.devices_.get(i).getParentHub().contentEquals(hub.getName())) continue;
            children.add(this.devices_.get(i));
        }
        return children.toArray(new Device[children.size()]);
    }

    public void removePeripherals(String hubName, CMMCore core) {
        Device d = this.findDevice(hubName);
        ArrayList<String> toRemove = new ArrayList<String>();
        if (d != null) {
            int i;
            for (i = 0; i < this.devices_.size(); ++i) {
                if (this.devices_.get(i).getParentHub().compareTo(d.getName()) != 0) continue;
                toRemove.add(this.devices_.get(i).getName());
            }
            for (i = 0; i < toRemove.size(); ++i) {
                this.removeDevice((String)toRemove.get(i));
                try {
                    core.unloadDevice((String)toRemove.get(i));
                    continue;
                }
                catch (Exception e) {
                    ReportingUtils.logError(e);
                }
            }
        }
    }

    public void removeDevice(String devName) {
        Device dev = this.findDevice(devName);
        if (dev != null) {
            String port = dev.getPort();
            this.devices_.remove(dev);
            if (port.length() != 0) {
                boolean inUse = false;
                for (Device device : this.devices_) {
                    String port2 = device.getPort();
                    if (!port.equals(port2)) continue;
                    inUse = true;
                }
                if (!inUse) {
                    this.comPortInUse_.remove(port);
                }
            }
            this.modified_ = true;
        }
    }

    Device findDevice(String devName) {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device dev = this.devices_.get(i);
            if (!dev.getName().contentEquals(new StringBuffer().append(devName))) continue;
            return dev;
        }
        return null;
    }

    boolean hasAdapterName(String library, String adapterName) {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device dev = this.devices_.get(i);
            if (!dev.getAdapterName().contentEquals(adapterName) || !dev.getLibrary().contentEquals(library)) continue;
            return true;
        }
        return false;
    }

    boolean hasAdapterName(String library, String hubName, String adapterName) {
        for (int i = 0; i < this.devices_.size(); ++i) {
            Device dev = this.devices_.get(i);
            if (!dev.getAdapterName().contentEquals(adapterName) || !dev.getLibrary().contentEquals(library) || !dev.getParentHub().contentEquals(hubName)) continue;
            return true;
        }
        return false;
    }

    Device findSerialPort(String name) {
        for (int i = 0; i < this.availableComPorts_.length; ++i) {
            if (!this.availableComPorts_[i].getName().contentEquals(new StringBuffer().append(name))) continue;
            return this.availableComPorts_[i];
        }
        return null;
    }

    ConfigGroup findConfigGroup(String name) {
        return this.configGroups_.get(name);
    }

    String[] getConfigGroupList() {
        String[] cgList = new String[this.configGroups_.size()];
        Object[] cgs = this.configGroups_.values().toArray();
        for (int i = 0; i < cgs.length; ++i) {
            cgList[i] = ((ConfigGroup)cgs[i]).getName();
        }
        return cgList;
    }

    String[] getSynchroList() {
        String[] synchro = new String[this.synchroDevices_.size()];
        for (int i = 0; i < this.synchroDevices_.size(); ++i) {
            synchro[i] = this.synchroDevices_.get(i);
        }
        return synchro;
    }

    public void addSynchroDevice(String name) {
        this.synchroDevices_.add(name);
        this.modified_ = true;
    }

    public void clearSynchroDevices() {
        this.synchroDevices_.clear();
        this.modified_ = true;
    }

    public void addDevice(Device dev) throws MMConfigFileException {
        if (dev.getName().length() == 0) {
            throw new MMConfigFileException("Empty device names are not allowed, please choose a different name.");
        }
        if (this.findDevice(dev.getName()) != null) {
            throw new MMConfigFileException(dev.getName() + " already defined, please choose a different name.");
        }
        this.devices_.add(dev);
        this.modified_ = true;
    }

    public void changeDeviceName(String oldName, String newName) throws MMConfigFileException {
        Device dev = this.findDevice(oldName);
        if (dev == null) {
            throw new MMConfigFileException("Device " + oldName + " is not defined");
        }
        dev.setName(newName);
        this.modified_ = true;
    }

    public String getDeviceSetupProperty(String devName, String propName) throws MMConfigFileException {
        Device c = this.findDevice(devName);
        if (c == null) {
            return null;
        }
        return c.getSetupPropertyValue(propName);
    }

    public void setDeviceSetupProperty(String devName, String propName, String value) throws MMConfigFileException {
        Device c = this.findDevice(devName);
        if (c == null) {
            throw new MMConfigFileException("Device " + devName + " is not defined");
        }
        c.setSetupPropertyValue(propName, value);
        this.modified_ = true;
    }

    public void removeGroup(String name) {
        this.configGroups_.remove(name);
        this.modified_ = true;
    }

    public void renameGroup(ConfigGroup grp, String name) {
        this.configGroups_.remove(grp.getName());
        grp.setName(name);
        this.configGroups_.put(name, grp);
        this.modified_ = true;
    }

    public void removeDuplicateComPorts() {
        for (int i = 0; i < this.availableComPorts_.length; ++i) {
            Device dev = this.findDevice(this.availableComPorts_[i].getName());
            if (dev == null) continue;
            this.availableComPorts_[i] = dev;
            this.removeDevice(dev.getName());
        }
        for (Device device : new ArrayList<Device>(this.devices_)) {
            if (!device.isSerialPort()) continue;
            this.removeDevice(device.getName());
        }
    }

    public void removeInvalidConfigurations() {
        Object[] groups = this.configGroups_.values().toArray();
        block0: for (int i = 0; i < groups.length; ++i) {
            ConfigGroup group = (ConfigGroup)groups[i];
            ConfigPreset[] presets = group.getConfigPresets();
            for (int j = 0; j < presets.length; ++j) {
                for (int k = 0; k < presets[j].getNumberOfSettings(); ++k) {
                    Setting s = presets[j].getSetting(k);
                    if (null != this.findDevice(s.deviceName_)) continue;
                    this.removeGroup(group.name_);
                    continue block0;
                }
            }
        }
    }

    public boolean getSendConfiguration() {
        return this.sendConfiguration_;
    }

    public void setSendConfiguration(boolean value) {
        this.sendConfiguration_ = value;
    }

    public void AddSelectedPeripherals(CMMCore c, Vector<Device> pd, Vector<String> hubs, Vector<Boolean> sel) {
        for (int idit = 0; idit < pd.size(); ++idit) {
            if (sel.get(idit).booleanValue()) {
                Device newDev = new Device(pd.get(idit).getName(), pd.get(idit).getLibrary(), pd.get(idit).getAdapterName(), pd.get(idit).getDescription());
                newDev.setParentHub(hubs.get(idit));
                try {
                    this.addDevice(newDev);
                    c.loadDevice(newDev.getName(), newDev.getLibrary(), newDev.getAdapterName());
                    for (int i = 0; i < newDev.getNumberOfSetupProperties(); ++i) {
                        PropertyItem p = newDev.getSetupProperty(i);
                        c.setProperty(newDev.getName(), p.name, p.value);
                    }
                    continue;
                }
                catch (Exception e) {
                    ReportingUtils.showError(e);
                    continue;
                }
            }
            try {
                c.unloadDevice(pd.get(idit).getName());
                continue;
            }
            catch (Exception e) {
                ReportingUtils.logError(e.getMessage());
            }
        }
    }

    public boolean loadModel(CMMCore c) {
        boolean status = true;
        try {
            int i;
            StrVector ld = c.getLoadedDevices();
            Device[] ports = this.getAvailableSerialPorts();
            for (int i2 = 0; i2 < ports.length; ++i2) {
                c.loadDevice(ports[i2].getName(), ports[i2].getLibrary(), ports[i2].getAdapterName());
            }
            Device[] devs = this.getDevices();
            for (i = 0; i < devs.length; ++i) {
                if (devs[i].isCore()) continue;
                c.loadDevice(devs[i].getName(), devs[i].getLibrary(), devs[i].getAdapterName());
                c.setParentLabel(devs[i].getName(), devs[i].getParentHub());
            }
            for (i = 0; i < devs.length; ++i) {
                for (int j = 0; j < devs[i].getNumberOfProperties(); ++j) {
                    PropertyItem pi = devs[i].getProperty(j);
                    for (int k = 0; k < ports.length; ++k) {
                        if (!pi.value.contentEquals(ports[k].getName())) continue;
                        this.comPortInUse_.put(ports[k].getName(), ports[k]);
                    }
                }
            }
            this.loadDeviceDataFromHardware(c);
            this.removeDuplicateComPorts();
            for (Device dev : devs) {
                if (!dev.isStage()) continue;
                c.setFocusDirection(dev.getName(), dev.getFocusDirection());
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
            try {
                c.unloadAllDevices();
            }
            catch (Exception ex) {
                ReportingUtils.logError(e.getMessage());
            }
            status = false;
        }
        return status;
    }

    public void initializeModel(CMMCore core_) {
        for (String key : this.comPortInUse_.keySet()) {
            try {
                Device portDev = this.comPortInUse_.get(key);
                for (int i = 0; i < portDev.getNumberOfSetupProperties(); ++i) {
                    PropertyItem pi = portDev.getSetupProperty(i);
                    if (!pi.preInit) continue;
                    core_.setProperty(portDev.getName(), pi.name, pi.value);
                }
                core_.initializeDevice(portDev.getName());
                portDev.loadDataFromHardware(core_);
            }
            catch (Exception e) {
                ReportingUtils.showError(e);
            }
        }
        for (Device d : this.devices_) {
            for (int i = 0; i < d.getNumberOfSetupProperties(); ++i) {
                PropertyItem pi = d.getSetupProperty(i);
                if (!pi.preInit) continue;
                try {
                    core_.setProperty(d.getName(), pi.name, pi.value);
                    continue;
                }
                catch (Exception e) {
                    ReportingUtils.showError(e);
                }
            }
        }
        for (Device d : new ArrayList<Device>(this.devices_)) {
            if (!d.isHub() || d.isInitialized()) continue;
            try {
                core_.initializeDevice(d.getName());
                d.loadDataFromHardware(core_);
                d.setInitialized(true);
                d.discoverPeripherals(core_);
            }
            catch (Exception e) {
                int sel = JOptionPane.showConfirmDialog(null, e.getMessage() + "\nRemove device " + d.getName() + " from the list?", "Initialization Error", 0);
                if (sel != 0) continue;
                this.removePeripherals(d.getName(), core_);
                this.removeDevice(d.getName());
                try {
                    core_.unloadDevice(d.getName());
                }
                catch (Exception e1) {
                    ReportingUtils.showError(e1);
                }
            }
        }
        for (Device d : new ArrayList<Device>(this.devices_)) {
            if (d.isInitialized() || d.isCore()) continue;
            try {
                String parentHub = d.getParentHub();
                if (parentHub.length() != 0) {
                    core_.setParentLabel(d.getName(), parentHub);
                }
                core_.initializeDevice(d.getName());
                d.loadDataFromHardware(core_);
                d.setInitialized(true);
            }
            catch (Exception e) {
                int sel = JOptionPane.showConfirmDialog(null, e.getMessage() + "\nRemove device " + d.getName() + " from the list?", "Initialization Error", 0);
                if (sel != 0) continue;
                this.removePeripherals(d.getName(), core_);
                this.removeDevice(d.getName());
                try {
                    core_.unloadDevice(d.getName());
                }
                catch (Exception e1) {
                    ReportingUtils.showError(e1);
                }
            }
        }
    }
}

