/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.prefs.Preferences;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.Label;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.PagePanel;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.ReportingUtils;

public class LabelsPage
extends PagePanel {
    private static final long serialVersionUID = 1L;
    private String[] labels_ = new String[0];
    private Hashtable<String, String[]> originalLabels_ = new Hashtable();
    ArrayList<Device> devices_ = new ArrayList();
    boolean originalLabelsStored_ = false;
    private JTable devTable_;
    private JTable labelTable_;

    public LabelsPage(Preferences prefs) {
        this.title_ = "Define position labels for state devices";
        this.helpText_ = "State devices with discrete positions, such as filter changers or objective turrets, etc. can have mnemonic labels assigned for each position.\n\nSelect the device in the left-hand list and edit corresponding position labels in the right-hand list.\n\nUse the 'Read' button to read label info from the hardware. This will override your changes!\n\n";
        this.setHelpFileName("conf_labels_page.html");
        this.prefs_ = prefs;
        this.setLayout(null);
        JScrollPane labelsScrollPane = new JScrollPane();
        labelsScrollPane.setBounds(182, 30, 269, 482);
        this.add(labelsScrollPane);
        this.labelTable_ = new JTable();
        this.labelTable_.setModel(new LabelTableModel());
        this.labelTable_.setAutoCreateColumnsFromModel(false);
        this.labelTable_.setSelectionMode(0);
        InputMap im = this.labelTable_.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 0), "none");
        labelsScrollPane.setViewportView(this.labelTable_);
        GUIUtils.setClickCountToStartEditing(this.labelTable_, 1);
        GUIUtils.stopEditingOnLosingFocus(this.labelTable_);
        JScrollPane devScrollPane = new JScrollPane();
        devScrollPane.setBounds(10, 30, 162, 482);
        this.add(devScrollPane);
        this.devTable_ = new JTable();
        DevTableModel m = new DevTableModel();
        this.devTable_.setModel(m);
        this.devTable_.getSelectionModel().addListSelectionListener(new SelectionListener(this.devTable_));
        this.devTable_.setSelectionMode(0);
        devScrollPane.setViewportView(this.devTable_);
        JButton readButton = new JButton();
        readButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LabelsPage.this.readFromHardware();
            }
        });
        readButton.setText("Read");
        readButton.setBounds(457, 30, 93, 23);
        this.add(readButton);
        JButton resetButton = new JButton();
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LabelsPage.this.resetLabels();
            }
        });
        resetButton.setText("Reset");
        resetButton.setBounds(457, 53, 93, 23);
        this.add(resetButton);
    }

    public void readFromHardware() {
        LabelTableModel labelTableModel = (LabelTableModel)this.labelTable_.getModel();
        Device selectedDevice = labelTableModel.getCurrentDevice();
        if (selectedDevice != null) {
            try {
                selectedDevice.getSetupLabelsFromHardware(this.core_);
                labelTableModel.setData(this.model_, selectedDevice.getName());
                labelTableModel.fireTableStructureChanged();
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
        }
    }

    public void resetLabels() {
        LabelTableModel labelTableModel = (LabelTableModel)this.labelTable_.getModel();
        Device selectedDevice = labelTableModel.getCurrentDevice();
        if (selectedDevice != null) {
            for (int j = 0; j < this.devices_.size(); ++j) {
                String[] orgLabs;
                if (selectedDevice != this.devices_.get(j) || (orgLabs = this.originalLabels_.get(this.devices_.get(j).getName())) == null) continue;
                for (int k = 0; k < this.labels_.length; ++k) {
                    selectedDevice.setSetupLabel(k, orgLabs[k]);
                    this.labels_[k] = orgLabs[k];
                }
                labelTableModel.fireTableStructureChanged();
            }
        }
    }

    public void storeLabels() {
        for (int j = 0; j < this.devices_.size(); ++j) {
            Device dev = this.devices_.get(j);
            if (this.originalLabels_.containsKey(dev.getName())) continue;
            String[] labels = new String[dev.getNumberOfStates()];
            for (int i = 0; i < dev.getNumberOfStates(); ++i) {
                Label lab = dev.getSetupLabelByState(i);
                labels[i] = lab != null ? lab.label_ : "State-" + i;
            }
            this.originalLabels_.put(dev.getName(), labels);
        }
    }

    @Override
    public boolean enterPage(boolean next) {
        DevTableModel tm = (DevTableModel)this.devTable_.getModel();
        tm.setData(this.model_);
        try {
            TableModel m2;
            try {
                this.model_.loadStateLabelsFromHardware(this.core_);
            }
            catch (Throwable t) {
                ReportingUtils.logError(t);
            }
            if (this.devTable_.getSelectedRowCount() < 1 && 0 < (m2 = this.devTable_.getModel()).getRowCount()) {
                this.devTable_.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean exitPage(boolean toNextPage) {
        try {
            if (this.labelTable_.isEditing()) {
                this.labelTable_.getDefaultEditor(String.class).stopCellEditing();
            }
            this.model_.applySetupLabelsToHardware(this.core_);
            this.model_.loadDeviceDataFromHardware(this.core_);
        }
        catch (Exception e) {
            this.handleError(e.getMessage());
            return !toNextPage;
        }
        return true;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void loadSettings() {
    }

    @Override
    public void saveSettings() {
    }

    static /* synthetic */ String[] access$102(LabelsPage x0, String[] x1) {
        x0.labels_ = x1;
        return x1;
    }

    class DevTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"State devices"};

        DevTableModel() {
        }

        public void setData(MicroscopeModel model) {
            Device[] devs = model.getDevices();
            LabelsPage.this.devices_.clear();
            for (int i = 0; i < devs.length; ++i) {
                if (!devs[i].isStateDevice()) continue;
                LabelsPage.this.devices_.add(devs[i]);
            }
            LabelsPage.this.storeLabels();
        }

        @Override
        public int getRowCount() {
            return LabelsPage.this.devices_.size();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.COLUMN_NAMES[columnIndex];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return LabelsPage.this.devices_.get(rowIndex).getName();
        }
    }

    class LabelTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"State", "Label"};
        private Device curDevice_;

        LabelTableModel() {
        }

        public Device getCurrentDevice() {
            return this.curDevice_;
        }

        public void setData(MicroscopeModel model, String selDevice) {
            this.curDevice_ = model.findDevice(selDevice);
            String[] newLabels = new String[]{};
            if (this.curDevice_ == null) {
                LabelsPage.access$102(LabelsPage.this, newLabels);
                return;
            }
            newLabels = new String[this.curDevice_.getNumberOfStates()];
            for (int i = 0; i < newLabels.length; ++i) {
                newLabels[i] = "State-" + i;
            }
            Label[] sLabels = this.curDevice_.getAllSetupLabels();
            for (int i = 0; i < sLabels.length; ++i) {
                newLabels[sLabels[i].state_] = sLabels[i].label_;
                if (LabelsPage.this.labels_.length <= sLabels[i].state_) continue;
                LabelsPage.this.model_.updateLabelsInPreset(this.curDevice_.getName(), LabelsPage.this.labels_[sLabels[i].state_], newLabels[sLabels[i].state_]);
            }
            LabelsPage.access$102(LabelsPage.this, newLabels);
        }

        @Override
        public int getRowCount() {
            return LabelsPage.this.labels_.length;
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.COLUMN_NAMES[columnIndex];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return Integer.toString(rowIndex);
            }
            return LabelsPage.this.labels_[rowIndex];
        }

        @Override
        public boolean isCellEditable(int nRow, int nCol) {
            return nCol == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                try {
                    String oldLabel = LabelsPage.this.labels_[row];
                    ((LabelsPage)LabelsPage.this).labels_[row] = (String)value;
                    this.curDevice_.setSetupLabel(row, (String)value);
                    this.fireTableCellUpdated(row, col);
                    LabelsPage.this.model_.updateLabelsInPreset(this.curDevice_.getName(), oldLabel, LabelsPage.this.labels_[row]);
                }
                catch (Exception e) {
                    ReportingUtils.showError(e);
                }
            }
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            LabelTableModel ltm = (LabelTableModel)LabelsPage.this.labelTable_.getModel();
            if (lsm.isSelectionEmpty()) {
                ltm.setData(LabelsPage.this.model_, null);
            } else {
                if (ltm.getColumnCount() > 0 && LabelsPage.this.labelTable_.isEditing()) {
                    LabelsPage.this.labelTable_.getDefaultEditor(String.class).stopCellEditing();
                }
                String devName = (String)this.table.getValueAt(lsm.getMinSelectionIndex(), 0);
                ltm.setData(LabelsPage.this.model_, devName);
            }
            ltm.fireTableStructureChanged();
            LabelsPage.this.labelTable_.getColumnModel().getColumn(0).setWidth(40);
        }
    }
}

