/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.micromanager.MMStudio;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.PagePanel;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.ReportingUtils;

public class FinishPage
extends PagePanel {
    private static final long serialVersionUID = 1L;
    private JButton browseButton_;
    private JTextField fileNameField_;
    private boolean overwrite_ = false;
    JCheckBox sendCheck_;

    public FinishPage(Preferences prefs) {
        this.title_ = "Save configuration and exit";
        this.setHelpFileName("conf_finish_page.html");
        this.prefs_ = prefs;
        this.setLayout(null);
        JLabel configurationWillBeLabel = new JLabel();
        configurationWillBeLabel.setText("Configuration file:");
        configurationWillBeLabel.setBounds(14, 11, 123, 21);
        this.add(configurationWillBeLabel);
        this.fileNameField_ = new JTextField();
        this.fileNameField_.setBounds(12, 30, 429, 24);
        this.add(this.fileNameField_);
        this.browseButton_ = new JButton();
        this.browseButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinishPage.this.browseConfigurationFile();
            }
        });
        this.browseButton_.setText("Browse...");
        this.browseButton_.setBounds(450, 31, 100, 23);
        this.add(this.browseButton_);
        this.sendCheck_ = new JCheckBox();
        this.sendCheck_.setBounds(10, 100, 360, 33);
        this.sendCheck_.setFont(new Font("", 0, 12));
        this.sendCheck_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FinishPage.this.model_.setSendConfiguration(FinishPage.this.sendCheck_.isSelected());
            }
        });
        this.sendCheck_.setText("Send configuration to Micro-manager.org");
        this.add(this.sendCheck_);
        JLabel sendConfigExplain = new JLabel();
        sendConfigExplain.setAutoscrolls(true);
        sendConfigExplain.setText("Providing the configuration data will assist securing further project funding.");
        sendConfigExplain.setBounds(14, 127, 500, 21);
        sendConfigExplain.setFont(this.sendCheck_.getFont());
        this.add(sendConfigExplain);
    }

    @Override
    public boolean enterPage(boolean next) {
        this.sendCheck_.setSelected(this.model_.getSendConfiguration());
        this.fileNameField_.setText(this.model_.getFileName());
        return true;
    }

    @Override
    public boolean exitPage(boolean toNext) {
        if (toNext) {
            this.saveConfiguration();
        }
        return true;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void loadSettings() {
    }

    @Override
    public void saveSettings() {
    }

    private void browseConfigurationFile() {
        String[] suffixes = new String[]{".cfg"};
        File f = FileDialogs.save(this.parent_, "Select a configuration file name", MMStudio.MM_CONFIG_FILE);
        if (f != null) {
            this.setFilePath(f);
            this.overwrite_ = true;
        }
    }

    private void setFilePath(File f) {
        String absolutePath = f.getAbsolutePath();
        if (!absolutePath.endsWith(".cfg")) {
            absolutePath = absolutePath + ".cfg";
        }
        this.fileNameField_.setText(absolutePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfiguration() {
        Container ancestor = this.getTopLevelAncestor();
        Cursor oldc = null;
        if (null != ancestor) {
            oldc = ancestor.getCursor();
            Cursor waitc = new Cursor(3);
            ancestor.setCursor(waitc);
        }
        try {
            int sel;
            this.core_.unloadAllDevices();
            GUIUtils.preventDisplayAdapterChangeExceptions();
            File f = new File(this.fileNameField_.getText());
            if (f.exists() && !this.overwrite_ && (sel = JOptionPane.showConfirmDialog(this, "Overwrite " + f.getName() + "?", "File Save", 0)) == 1) {
                ReportingUtils.logMessage("All changes are going to be lost!");
                return;
            }
            this.setFilePath(f);
            this.model_.removeInvalidConfigurations();
            this.model_.saveToFile(this.fileNameField_.getText());
        }
        catch (MMConfigFileException e) {
            ReportingUtils.showError(e);
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
        finally {
            if (null != ancestor && null != oldc) {
                ancestor.setCursor(oldc);
            }
        }
    }
}

