/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import ij.plugin.BrowserLauncher;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import mmcorej.MMCoreJ;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.DeviceSetupDlg;
import org.micromanager.conf2.DeviceTreeNode;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.PagePanel;
import org.micromanager.conf2.PeripheralSetupDlg;
import org.micromanager.utils.ReportingUtils;

public class DevicesPage
extends PagePanel
implements ListSelectionListener,
MouseListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private JTable deviceTable_;
    private JScrollPane installedScrollPane_;
    private static final String HELP_FILE_NAME = "conf_devices_page.html";
    private JButton editButton;
    private JButton removeButton;
    private JButton peripheralsButton;
    private boolean listByLib_;
    private TreeWContextMenu theTree_;
    private JScrollPane availableScrollPane_;
    final String documentationURLroot_;
    String libraryDocumentationName_;
    private JComboBox hubsCombo_;
    private JComboBox byLibCombo_;

    public DevicesPage(Preferences prefs) {
        this.title_ = "Add or remove devices";
        this.helpText_ = "The list of selected devices is displayed above. You can add or remove devices to/from this list.\nThe first column shows the device's assigned name for this particular configuration. In subsequent steps devices will be referred to by their assigned names.\n\nYou can edit device names by double-clicking in the first column. Device name must be unique and should not contain any special characters.";
        this.listByLib_ = true;
        this.setLayout(null);
        this.prefs_ = prefs;
        this.setHelpFileName(HELP_FILE_NAME);
        this.documentationURLroot_ = "https://micro-manager.org/wiki/";
        this.installedScrollPane_ = new JScrollPane();
        this.installedScrollPane_.setBounds(10, 21, 431, 241);
        this.add(this.installedScrollPane_);
        this.deviceTable_ = new JTable();
        this.deviceTable_.setSelectionMode(0);
        this.installedScrollPane_.setViewportView(this.deviceTable_);
        this.deviceTable_.getSelectionModel().addListSelectionListener(this);
        this.deviceTable_.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DevicesPage.this.editDevice();
                }
            }
        });
        JButton addButton = new JButton();
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DevicesPage.this.addDevice();
            }
        });
        addButton.setText("Add...");
        addButton.setBounds(451, 291, 99, 23);
        this.add(addButton);
        this.removeButton = new JButton();
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DevicesPage.this.removeDevice();
            }
        });
        this.removeButton.setText("Remove");
        this.removeButton.setBounds(451, 72, 99, 23);
        this.add(this.removeButton);
        this.removeButton.setEnabled(false);
        this.editButton = new JButton("Edit...");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevicesPage.this.editDevice();
            }
        });
        this.editButton.setBounds(451, 21, 99, 23);
        this.add(this.editButton);
        this.editButton.setEnabled(false);
        this.peripheralsButton = new JButton("Peripherals...");
        this.peripheralsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevicesPage.this.editPeripherals();
            }
        });
        this.peripheralsButton.setEnabled(false);
        this.peripheralsButton.setBounds(451, 46, 99, 23);
        this.add(this.peripheralsButton);
        JLabel lblNewLabel = new JLabel("Installed Devices:");
        lblNewLabel.setFont(new Font("Tahoma", 1, 11));
        lblNewLabel.setBounds(10, 0, 431, 14);
        this.add(lblNewLabel);
        JLabel lblNewLabel_1 = new JLabel("Available Devices:");
        lblNewLabel_1.setFont(new Font("Tahoma", 1, 11));
        lblNewLabel_1.setBounds(10, 273, 128, 14);
        this.add(lblNewLabel_1);
        this.availableScrollPane_ = new JScrollPane(null);
        this.availableScrollPane_.setBounds(10, 299, 431, 250);
        this.add(this.availableScrollPane_);
        JButton helpButton = new JButton("Help");
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevicesPage.this.displayDocumentation();
            }
        });
        helpButton.setBounds(451, 319, 99, 23);
        this.add(helpButton);
        this.byLibCombo_ = new JComboBox();
        this.byLibCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DevicesPage.this.byLibCombo_.getSelectedIndex() == 0) {
                    DevicesPage.this.listByLib_ = true;
                } else {
                    DevicesPage.this.listByLib_ = false;
                    DevicesPage.this.hubsCombo_.setSelectedIndex(1);
                }
                DevicesPage.this.buildTree();
            }
        });
        this.byLibCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"list by vendor", "list by type"}));
        this.byLibCombo_.setBounds(146, 270, 146, 20);
        this.add(this.byLibCombo_);
        this.hubsCombo_ = new JComboBox();
        this.hubsCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevicesPage.this.buildTree();
            }
        });
        this.hubsCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"compact view", "show all"}));
        this.hubsCombo_.setBounds(302, 270, 139, 20);
        this.add(this.hubsCombo_);
    }

    protected void editPeripherals() {
        int selRow = this.deviceTable_.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        String devName = (String)this.deviceTable_.getValueAt(selRow, 0);
        Device dev = this.model_.findDevice(devName);
        String[] installed = dev.getPeripherals();
        Vector<Device> peripherals = new Vector<Device>();
        for (int i = 0; i < installed.length; ++i) {
            try {
                if (this.model_.hasAdapterName(dev.getLibrary(), dev.getName(), installed[i])) continue;
                String description = this.model_.getDeviceDescription(dev.getLibrary(), installed[i]);
                Device newDev = new Device(installed[i], dev.getLibrary(), installed[i], description);
                peripherals.add(newDev);
                continue;
            }
            catch (Exception e) {
                ReportingUtils.logError(e.getMessage());
            }
        }
        if (peripherals.size() > 0) {
            PeripheralSetupDlg dlgp = new PeripheralSetupDlg(this.model_, this.core_, dev.getName(), peripherals);
            dlgp.setVisible(true);
            Device[] sel = dlgp.getSelectedPeripherals();
            for (int i = 0; i < sel.length; ++i) {
                try {
                    this.core_.loadDevice(sel[i].getName(), sel[i].getLibrary(), sel[i].getAdapterName());
                    sel[i].setParentHub(dev.getName());
                    this.core_.setParentLabel(sel[i].getName(), dev.getName());
                    sel[i].loadDataFromHardware(this.core_);
                    this.model_.addDevice(sel[i]);
                    String[] props = sel[i].getPreInitProperties();
                    if (props.length > 0) {
                        DeviceSetupDlg dlgProps = new DeviceSetupDlg(this.model_, this.core_, sel[i]);
                        dlgProps.setVisible(true);
                        if (sel[i].isInitialized()) continue;
                        this.core_.unloadDevice(sel[i].getName());
                        this.model_.removeDevice(sel[i].getName());
                        continue;
                    }
                    this.core_.initializeDevice(sel[i].getName());
                    sel[i].setInitialized(true);
                    continue;
                }
                catch (MMConfigFileException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, e.getMessage());
                }
            }
            this.rebuildDevicesTable();
        } else {
            this.handleError("There are no available peripheral devices.");
        }
    }

    private void editDevice() {
        int ret;
        int selRow = this.deviceTable_.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        String devName = (String)this.deviceTable_.getValueAt(selRow, 0);
        Device dev = this.model_.findDevice(devName);
        try {
            dev.loadDataFromHardware(this.core_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DeviceSetupDlg dlg = new DeviceSetupDlg(this.model_, this.core_, dev);
        dlg.setVisible(true);
        this.model_.setModified(true);
        if (!dev.isInitialized() && (ret = JOptionPane.showConfirmDialog(this, "Device setup did not work out. Remove from the list?", "Device failed", 0)) == 0) {
            this.model_.removeDevice(dev.getName());
            try {
                this.core_.unloadDevice(dev.getName());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
            }
        }
        this.rebuildDevicesTable();
    }

    protected void removeDevice() {
        int sel = this.deviceTable_.getSelectedRow();
        if (sel < 0) {
            return;
        }
        String devName = (String)this.deviceTable_.getValueAt(sel, 0);
        if (devName.contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreDevice()))) {
            this.handleError(MMCoreJ.getG_Keyword_CoreDevice() + " device can't be removed!");
            return;
        }
        this.model_.removePeripherals(devName, this.core_);
        this.model_.removeDevice(devName);
        try {
            this.core_.unloadDevice(devName);
        }
        catch (Exception e) {
            this.handleError(e.getMessage());
        }
        this.rebuildDevicesTable();
    }

    public void rebuildDevicesTable() {
        DeviceTable_TableModel tmd;
        TableModel tm = this.deviceTable_.getModel();
        if (tm instanceof DeviceTable_TableModel) {
            tmd = (DeviceTable_TableModel)this.deviceTable_.getModel();
            tmd.refresh();
        } else {
            tmd = new DeviceTable_TableModel(this.model_);
            this.deviceTable_.setModel(tmd);
        }
        tmd.fireTableStructureChanged();
        tmd.fireTableDataChanged();
    }

    @Override
    public void refresh() {
        this.rebuildDevicesTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enterPage(boolean fromNextPage) {
        Cursor oldCur = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.core_.getDeviceAdapterNames();
            this.model_.removeDuplicateComPorts();
            this.rebuildDevicesTable();
            if (!fromNextPage) {
                this.model_.loadModel(this.core_);
                this.model_.initializeModel(this.core_);
            }
            this.buildTree();
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            ReportingUtils.showError(e2);
            this.setCursor(Cursor.getDefaultCursor());
        }
        finally {
            this.setCursor(oldCur);
        }
        return false;
    }

    @Override
    public boolean exitPage(boolean toNextPage) {
        Device[] devs;
        for (Device d : devs = this.model_.getDevices()) {
            if (!d.isCore() && !d.isInitialized()) {
                JOptionPane.showMessageDialog(this, "Unable to continue: at least one device failed.\nTo proceed to next step, either remove failed device(s) from the list,\nor edit settings until the status reads OK.\nTo avoid making any changes exit the wizard without saving the configuration.");
                return !toNextPage;
            }
            try {
                if (d.getParentHub().length() != 0) continue;
                String parentID = this.core_.getParentLabel(d.getName());
                d.setParentHub(parentID);
                if (!d.isStage()) continue;
                d.setFocusDirection(this.core_.getFocusDirection(d.getName()));
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
        }
        return true;
    }

    @Override
    public void loadSettings() {
    }

    @Override
    public void saveSettings() {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this.deviceTable_.getSelectedRow();
        if (row < 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            return;
        }
        String devName = (String)this.deviceTable_.getValueAt(row, 0);
        Device dev = this.model_.findDevice(devName);
        if (dev == null) {
            ReportingUtils.logError("Internal error in PeripheralSetupDlg: device not found");
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.peripheralsButton.setEnabled(false);
            return;
        }
        this.peripheralsButton.setEnabled(dev.isHub() && dev.getPeripherals().length > 0);
        this.editButton.setEnabled(!dev.isCore());
        this.removeButton.setEnabled(!dev.isCore());
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        DeviceTreeNode node;
        Object uo;
        int[] srows = this.theTree_.getSelectionRows();
        if (null != srows && 0 < srows.length && 0 < srows[0] && (uo = (node = (DeviceTreeNode)this.theTree_.getLastSelectedPathComponent()).getUserObject()) != null) {
            this.libraryDocumentationName_ = uo.getClass().isArray() ? ((Object[])uo)[0].toString() : uo.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDevice() {
        int[] srows = this.theTree_.getSelectionRows();
        if (srows == null) {
            return false;
        }
        if (0 < srows.length && 0 < srows[0]) {
            Device dev;
            DeviceTreeNode node = (DeviceTreeNode)this.theTree_.getLastSelectedPathComponent();
            Object[] userData = node.getUserDataArray();
            if (null == userData && 1 == node.getLeafCount() && null == (userData = (node = (DeviceTreeNode)node.getChildAt(0)).getUserDataArray())) {
                return false;
            }
            if (userData == null) {
                JOptionPane.showMessageDialog(this, "Multiple devices available in this node!\nPlease expand the node and select a specific device to add.");
                return false;
            }
            String adapterName = userData[1].toString();
            String lib = userData[0].toString();
            String descr = userData[2].toString();
            String label = new String(adapterName);
            Device d = this.model_.findDevice(label);
            int retries = 0;
            while (d != null) {
                label = new String(adapterName + "-" + ++retries);
                d = this.model_.findDevice(label);
            }
            try {
                this.core_.loadDevice(label, lib, adapterName);
                dev = new Device(label, lib, adapterName, descr);
                dev.loadDataFromHardware(this.core_);
                this.model_.addDevice(dev);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
                return false;
            }
            DeviceSetupDlg dlg = new DeviceSetupDlg(this.model_, this.core_, dev);
            dlg.setVisible(true);
            if (!dev.isInitialized()) {
                this.model_.removeDevice(dev.getName());
                try {
                    this.core_.unloadDevice(dev.getName());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, e.getMessage());
                }
                return false;
            }
            this.refresh();
            if (dev.isHub() && !dev.getName().equals("Core")) {
                String[] installed = dev.getPeripherals();
                Vector<Device> peripherals = new Vector<Device>();
                for (int i = 0; i < installed.length; ++i) {
                    try {
                        if (this.model_.hasAdapterName(dev.getLibrary(), dev.getName(), installed[i])) continue;
                        String description = this.model_.getDeviceDescription(dev.getLibrary(), installed[i]);
                        Device newDev = new Device(installed[i], dev.getLibrary(), installed[i], description);
                        peripherals.add(newDev);
                        continue;
                    }
                    catch (Exception e) {
                        ReportingUtils.logError(e.getMessage());
                    }
                }
                if (peripherals.size() > 0) {
                    PeripheralSetupDlg dlgp = new PeripheralSetupDlg(this.model_, this.core_, dev.getName(), peripherals);
                    dlgp.setVisible(true);
                    Device[] sel = dlgp.getSelectedPeripherals();
                    for (int i = 0; i < sel.length; ++i) {
                        try {
                            this.core_.loadDevice(sel[i].getName(), sel[i].getLibrary(), sel[i].getAdapterName());
                            sel[i].setParentHub(dev.getName());
                            this.core_.setParentLabel(sel[i].getName(), dev.getName());
                            this.model_.addDevice(sel[i]);
                            sel[i].loadDataFromHardware(this.core_);
                            String[] props = sel[i].getPreInitProperties();
                            if (props.length > 0) {
                                DeviceSetupDlg dlgProps = new DeviceSetupDlg(this.model_, this.core_, sel[i]);
                                dlgProps.setVisible(true);
                                if (sel[i].isInitialized()) continue;
                                this.core_.unloadDevice(sel[i].getName());
                                this.model_.removeDevice(sel[i].getName());
                                continue;
                            }
                            this.core_.initializeDevice(sel[i].getName());
                            sel[i].setInitialized(true);
                            continue;
                        }
                        catch (MMConfigFileException e) {
                            JOptionPane.showMessageDialog(this, e.getMessage());
                            continue;
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(this, e.getMessage());
                            continue;
                        }
                        finally {
                            this.refresh();
                        }
                    }
                }
            }
        }
        return true;
    }

    private void buildTree() {
        if (this.listByLib_) {
            this.buildTreeByLib(this.model_);
        } else {
            this.buildTreeByType(this.model_);
        }
        this.availableScrollPane_.setViewportView(this.theTree_);
    }

    private void buildTreeByType(MicroscopeModel model) {
        Object[] nodeNames;
        Device[] devices_ = null;
        devices_ = this.hubsCombo_.getSelectedIndex() == 1 ? model.getAvailableDeviceList() : model.getAvailableDevicesCompact();
        Hashtable nodes = new Hashtable();
        for (int i = 0; i < devices_.length; ++i) {
            if (nodes.containsKey(devices_[i].getTypeAsString())) {
                ((Vector)nodes.get(devices_[i].getTypeAsString())).add(devices_[i]);
                continue;
            }
            Vector<Device> v = new Vector<Device>();
            v.add(devices_[i]);
            nodes.put(devices_[i].getTypeAsString(), v);
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Devices supported by \u00b5Manager");
        DeviceTreeNode node = null;
        for (Object nodeName : nodeNames = nodes.keySet().toArray()) {
            node = new DeviceTreeNode((String)nodeName, false);
            root.add(node);
            Vector devs = (Vector)nodes.get(nodeName);
            for (int i = 0; i < devs.size(); ++i) {
                Object[] userObject = new Object[]{((Device)devs.get(i)).getLibrary(), ((Device)devs.get(i)).getAdapterName(), ((Device)devs.get(i)).getDescription(), new Boolean(((Device)devs.get(i)).isHub())};
                DeviceTreeNode aLeaf = new DeviceTreeNode("", false);
                aLeaf.setUserObject(userObject);
                node.add(aLeaf);
            }
        }
        this.theTree_ = new TreeWContextMenu(root, this);
        this.theTree_.addTreeSelectionListener(this);
        TreeMouseListener ml = new TreeMouseListener();
        this.theTree_.addMouseListener(ml);
        this.theTree_.setRootVisible(false);
        this.theTree_.setShowsRootHandles(true);
    }

    private void buildTreeByLib(MicroscopeModel model) {
        String[] badLibs;
        Device[] devices_ = null;
        devices_ = this.hubsCombo_.getSelectedIndex() == 1 ? model.getAvailableDeviceList() : model.getAvailableDevicesCompact();
        String thisLibrary = "";
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Devices supported by \u00b5Manager");
        DeviceTreeNode node = null;
        for (int idd = 0; idd < devices_.length; ++idd) {
            if (0 != thisLibrary.compareTo(devices_[idd].getLibrary())) {
                node = new DeviceTreeNode(devices_[idd].getLibrary(), true);
                root.add(node);
                thisLibrary = devices_[idd].getLibrary();
            }
            Object[] userObject = new Object[]{devices_[idd].getLibrary(), devices_[idd].getAdapterName(), devices_[idd].getDescription(), new Boolean(devices_[idd].isHub())};
            DeviceTreeNode aLeaf = new DeviceTreeNode("", true);
            aLeaf.setUserObject(userObject);
            node.add(aLeaf);
        }
        for (String lib : badLibs = model.getBadLibraries()) {
            DeviceTreeNode nd = new DeviceTreeNode(lib + " (unavailable)", true);
            root.add(nd);
        }
        this.theTree_ = new TreeWContextMenu(root, this);
        this.theTree_.addTreeSelectionListener(this);
        TreeMouseListener ml = new TreeMouseListener();
        this.theTree_.addMouseListener(ml);
        this.theTree_.setRootVisible(false);
        this.theTree_.setShowsRootHandles(true);
    }

    private void displayDocumentation() {
        try {
            BrowserLauncher.openURL((String)(this.documentationURLroot_ + this.libraryDocumentationName_));
        }
        catch (IOException e1) {
            ReportingUtils.showError(e1);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class TreeMouseListener
    extends MouseAdapter {
        TreeMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (2 == e.getClickCount() && DevicesPage.this.addDevice()) {
                DevicesPage.this.rebuildDevicesTable();
            }
        }
    }

    class TreeWContextMenu
    extends JTree
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        JPopupMenu popupMenu_;
        DevicesPage dp_;

        public TreeWContextMenu(DefaultMutableTreeNode n, DevicesPage d) {
            super(n);
            this.dp_ = d;
            this.popupMenu_ = new JPopupMenu();
            JMenuItem jmi = new JMenuItem("Add");
            jmi.setActionCommand("add");
            jmi.addActionListener(this);
            this.popupMenu_.add(jmi);
            jmi = new JMenuItem("Help");
            jmi.setActionCommand("help");
            jmi.addActionListener(this);
            this.popupMenu_.add(jmi);
            this.popupMenu_.setOpaque(true);
            this.popupMenu_.setLightWeightPopupEnabled(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        TreeWContextMenu.this.popupMenu_.show((JComponent)e.getSource(), e.getX(), e.getY());
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand().equals("help")) {
                this.dp_.displayDocumentation();
            } else if (ae.getActionCommand().equals("add") && this.dp_.addDevice()) {
                this.dp_.rebuildDevicesTable();
            }
        }
    }

    class DeviceTable_TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"Name", "Adapter/Library", "Description", "Status"};
        MicroscopeModel model_;
        Device[] devices_;

        public DeviceTable_TableModel(MicroscopeModel model) {
            this.setMicroscopeModel(model);
        }

        public final void setMicroscopeModel(MicroscopeModel mod) {
            this.devices_ = mod.getDevices();
            this.model_ = mod;
        }

        @Override
        public int getRowCount() {
            return this.devices_.length;
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.COLUMN_NAMES[columnIndex];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.devices_[rowIndex].getName();
            }
            if (columnIndex == 1) {
                return new String(this.devices_[rowIndex].getAdapterName() + "/" + this.devices_[rowIndex].getLibrary());
            }
            if (columnIndex == 2) {
                return this.devices_[rowIndex].getDescription();
            }
            if (this.devices_[rowIndex].isCore()) {
                return "Default";
            }
            return this.devices_[rowIndex].isInitialized() ? "OK" : "Failed";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            String newName = (String)value;
            String oldName = this.devices_[row].getName();
            if (col == 0) {
                try {
                    this.model_.changeDeviceName(oldName, newName);
                    this.fireTableCellUpdated(row, col);
                }
                catch (Exception e) {
                    DevicesPage.this.handleError(e.getMessage());
                }
            }
        }

        @Override
        public boolean isCellEditable(int nRow, int nCol) {
            return false;
        }

        public void refresh() {
            this.devices_ = this.model_.getDevices();
            this.fireTableDataChanged();
        }
    }
}

