/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import mmcorej.CMMCore;
import mmcorej.DeviceDetectionStatus;
import mmcorej.DeviceType;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import org.micromanager.conf2.ComPropTableModel;
import org.micromanager.conf2.DetectorJDialog;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.PropertyTableModel;
import org.micromanager.conf2.Setting;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.PropertyNameCellRenderer;
import org.micromanager.utils.PropertyValueCellEditor;
import org.micromanager.utils.PropertyValueCellRenderer;
import org.micromanager.utils.ReportingUtils;

public class DeviceSetupDlg
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private CMMCore core;
    private Device portDev;
    private MicroscopeModel model;
    private Device dev;
    private JTable propTable;
    private JButton detectButton;
    private DetectorJDialog progressDialog;
    private DetectionTask dt;
    private final String DETECT_PORTS = "Scan";
    private final JTable comTable;
    private JTextField devLabel;

    public DeviceSetupDlg(MicroscopeModel mod, CMMCore c, Device d) {
        this.setModal(true);
        this.setBounds(100, 100, 478, 528);
        this.loadPosition(100, 100);
        this.model = mod;
        this.core = c;
        this.portDev = null;
        this.dev = d;
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        JLabel lblNewLabel = new JLabel("Label");
        lblNewLabel.setBounds(10, 11, 35, 14);
        this.contentPanel.add(lblNewLabel);
        this.devLabel = new JTextField(this.dev.getName());
        this.devLabel.setBounds(47, 8, 165, 20);
        this.contentPanel.add(this.devLabel);
        this.devLabel.setColumns(10);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceSetupDlg.this.onOK();
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceSetupDlg.this.onCancel();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DeviceSetupDlg.this.savePosition();
            }
        });
        this.setTitle("Device: " + this.dev.getAdapterName() + " | Library: " + this.dev.getLibrary());
        JScrollPane scrollPaneProp = new JScrollPane();
        scrollPaneProp.setBounds(10, 64, 442, 164);
        this.contentPanel.add(scrollPaneProp);
        this.propTable = new JTable();
        this.propTable.setSelectionMode(0);
        this.propTable.setAutoCreateColumnsFromModel(false);
        scrollPaneProp.setViewportView(this.propTable);
        this.detectButton = new JButton("Scan");
        this.detectButton.setEnabled(false);
        this.detectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeviceSetupDlg.this.dt != null && DeviceSetupDlg.this.dt.isAlive()) {
                    return;
                }
                DeviceSetupDlg.this.progressDialog = new DetectorJDialog((Dialog)DeviceSetupDlg.this, false);
                DeviceSetupDlg.this.progressDialog.setTitle("\u00b5Manager device detection");
                DeviceSetupDlg.this.progressDialog.setLocationRelativeTo(DeviceSetupDlg.this);
                DeviceSetupDlg.this.progressDialog.setSize(483, 288);
                DeviceSetupDlg.this.progressDialog.setVisible(true);
                DeviceSetupDlg.this.dt = new DetectionTask("serial_detect");
                DeviceSetupDlg.this.dt.start();
            }
        });
        this.detectButton.setToolTipText("Scan COM ports to detect this device");
        this.detectButton.setBounds(359, 247, 93, 23);
        this.contentPanel.add(this.detectButton);
        JLabel portLbl = new JLabel("Port Properties (RS 232 settings)");
        portLbl.setBounds(10, 251, 442, 14);
        this.contentPanel.add(portLbl);
        JScrollPane scrollPaneCOM = new JScrollPane();
        scrollPaneCOM.setBounds(10, 281, 442, 169);
        this.contentPanel.add(scrollPaneCOM);
        this.comTable = new JTable();
        scrollPaneCOM.setViewportView(this.comTable);
        this.comTable.setSelectionMode(0);
        this.comTable.setAutoCreateColumnsFromModel(false);
        JLabel lblNewLabel_2 = new JLabel("Initialization Properties");
        lblNewLabel_2.setBounds(10, 49, 442, 14);
        this.contentPanel.add(lblNewLabel_2);
        JLabel parentHub = new JLabel(this.dev.getParentHub().length() == 0 ? "" : "Parent: " + this.dev.getParentHub());
        parentHub.setBounds(227, 11, 225, 14);
        this.contentPanel.add(parentHub);
        this.loadSettings();
    }

    protected void onCancel() {
        this.savePosition();
        this.dispose();
    }

    protected void onOK() {
        Device d;
        this.propTable.editingStopped(null);
        this.savePosition();
        String oldName = this.dev.getName();
        String newName = this.devLabel.getText();
        if (this.dev.getName().compareTo(this.devLabel.getText()) != 0) {
            if (this.model.findDevice(this.devLabel.getText()) != null) {
                this.showMessage("Device name " + this.devLabel.getText() + " is already in use.\nPress Cancel and try again.");
                return;
            }
            try {
                this.core.unloadDevice(this.dev.getName());
                this.dev.setInitialized(false);
                this.core.loadDevice(this.devLabel.getText(), this.dev.getLibrary(), this.dev.getAdapterName());
                this.core.setParentLabel(this.devLabel.getText(), this.dev.getParentHub());
            }
            catch (Exception e) {
                this.showMessage("Device failed to re-load with changed name.");
                return;
            }
            this.dev.setName(this.devLabel.getText());
        }
        if ((d = this.model.findDevice(this.devLabel.getText())) == null) {
            this.showMessage("Device " + this.devLabel.getText() + " is not loaded properly.\nPress Cancel and try again.");
            return;
        }
        if (d.isInitialized()) {
            try {
                this.core.unloadDevice(d.getName());
                this.core.loadDevice(d.getName(), d.getLibrary(), d.getAdapterName());
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
        }
        if (this.initializeDevice()) {
            this.dispose();
            if (this.portDev != null) {
                this.model.useSerialPort(this.portDev, true);
            }
        } else {
            this.dev.setInitialized(false);
            return;
        }
        this.model.setModified(true);
        if (!oldName.contentEquals(newName)) {
            Device[] devs = this.model.getDevices();
            for (int i = 0; i < devs.length; ++i) {
                if (!devs[i].getParentHub().contentEquals(oldName)) continue;
                devs[i].setParentHub(newName);
            }
        }
    }

    private void loadSettings() {
        this.rebuildPropTable();
        ArrayList<Device> ports = new ArrayList<Device>();
        Device[] avPorts = this.model.getAvailableSerialPorts();
        for (int i = 0; i < avPorts.length; ++i) {
            ports.add(avPorts[i]);
        }
        boolean anyPorts = false;
        boolean anyProps = false;
        for (int i = 0; i < this.dev.getNumberOfProperties(); ++i) {
            PropertyItem p = this.dev.getProperty(i);
            if (p.preInit) {
                anyProps = true;
            }
            if (p.name.compareTo(MMCoreJ.getG_Keyword_Port()) != 0) continue;
            anyPorts = true;
            if (ports.size() == 0) {
                JOptionPane.showMessageDialog(null, "There are no unused ports available!");
                return;
            }
            String[] allowed = new String[ports.size()];
            for (int k = 0; k < ports.size(); ++k) {
                allowed[k] = ((Device)ports.get(k)).getName();
            }
            p.allowed = allowed;
            this.rebuildComTable(p.value);
        }
        if (anyProps && !anyPorts) {
            Rectangle r = this.getBounds();
            r.height = 300;
            this.setBounds(r);
        } else if (!anyProps && !anyPorts) {
            Rectangle r = this.getBounds();
            r.height = 112;
            this.setBounds(r);
        }
    }

    private void rebuildPropTable() {
        PropertyTableModel tm = new PropertyTableModel(this.model, this.dev, this);
        this.propTable.setModel(tm);
        PropertyValueCellEditor propValueEditor = new PropertyValueCellEditor();
        PropertyValueCellRenderer propValueRenderer = new PropertyValueCellRenderer();
        PropertyNameCellRenderer propNameRenderer = new PropertyNameCellRenderer();
        if (this.propTable.getColumnCount() == 0) {
            TableColumn column = new TableColumn(0, 200, propNameRenderer, null);
            this.propTable.addColumn(column);
            column = new TableColumn(1, 200, propNameRenderer, null);
            this.propTable.addColumn(column);
            column = new TableColumn(2, 200, propValueRenderer, propValueEditor);
            this.propTable.addColumn(column);
        }
        tm.fireTableStructureChanged();
        tm.fireTableDataChanged();
        boolean any = false;
        Device[] devices = this.model.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            for (int j = 0; j < devices[i].getNumberOfProperties(); ++j) {
                PropertyItem p = devices[i].getProperty(j);
                if (p.name.compareTo(MMCoreJ.getG_Keyword_Port()) != 0) continue;
                any = true;
                break;
            }
            if (any) break;
        }
        this.detectButton.setEnabled(any);
        this.propTable.repaint();
    }

    public void rebuildComTable(String portName) {
        if (portName == null) {
            return;
        }
        this.portDev = this.model.findSerialPort(portName);
        if (this.portDev == null) {
            return;
        }
        StrVector loadedPorts = this.core.getLoadedDevicesOfType(DeviceType.SerialDevice);
        Iterator lp = loadedPorts.iterator();
        boolean loaded = false;
        while (lp.hasNext()) {
            ((String)lp.next()).compareTo(portName);
            loaded = true;
        }
        if (!loaded) {
            try {
                this.core.loadDevice(this.portDev.getName(), this.portDev.getLibrary(), this.portDev.getAdapterName());
                this.portDev.loadDataFromHardware(this.core);
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
        }
        try {
            System.out.println("rebuild " + this.portDev.getPropertyValue("BaudRate"));
        }
        catch (MMConfigFileException e1) {
            ReportingUtils.logMessage("Property BaudRate is not defined");
        }
        ComPropTableModel tm = new ComPropTableModel(this.model, this.portDev);
        this.comTable.setModel(tm);
        PropertyValueCellEditor propValueEditor = new PropertyValueCellEditor();
        PropertyValueCellRenderer propValueRenderer = new PropertyValueCellRenderer();
        PropertyNameCellRenderer propNameRenderer = new PropertyNameCellRenderer();
        if (this.comTable.getColumnCount() == 0) {
            TableColumn column = new TableColumn(0, 200, propNameRenderer, null);
            this.comTable.addColumn(column);
            column = new TableColumn(1, 200, propNameRenderer, null);
            this.comTable.addColumn(column);
            column = new TableColumn(2, 200, propValueRenderer, propValueEditor);
            this.comTable.addColumn(column);
        }
        tm.fireTableStructureChanged();
        tm.fireTableDataChanged();
        this.comTable.repaint();
    }

    private boolean initializeDevice() {
        try {
            if (this.dev.isInitialized()) {
                this.core.unloadDevice(this.dev.getName());
                this.core.loadDevice(this.dev.getName(), this.dev.getLibrary(), this.dev.getAdapterName());
            }
            PropertyTableModel ptm = (PropertyTableModel)this.propTable.getModel();
            for (int i = 0; i < ptm.getRowCount(); ++i) {
                Setting s = ptm.getSetting(i);
                this.core.setProperty(this.dev.getName(), s.propertyName_, s.propertyValue_);
            }
            this.dev.loadDataFromHardware(this.core);
            if (this.initializePort()) {
                this.dev.setName(this.devLabel.getText());
                this.core.initializeDevice(this.dev.getName());
                this.dev.loadDataFromHardware(this.core);
                this.dev.setInitialized(true);
                this.dev.updateSetupProperties();
                this.dev.discoverPeripherals(this.core);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.showMessage(e.getMessage());
            try {
                this.core.unloadDevice(this.dev.getName());
                this.core.loadDevice(this.dev.getName(), this.dev.getLibrary(), this.dev.getAdapterName());
            }
            catch (Exception e1) {
                ReportingUtils.logError(e1);
            }
            return false;
        }
    }

    private boolean initializePort() {
        if (this.portDev != null) {
            try {
                this.core.unloadDevice(this.portDev.getName());
                Thread.sleep(1000L);
                this.core.loadDevice(this.portDev.getName(), this.portDev.getLibrary(), this.portDev.getAdapterName());
                for (int j = 0; j < this.portDev.getNumberOfProperties(); ++j) {
                    PropertyItem prop = this.portDev.getProperty(j);
                    if (!prop.preInit) continue;
                    this.core.setProperty(this.portDev.getName(), prop.name, prop.value);
                    if (this.portDev.findSetupProperty(prop.name) == null) {
                        this.portDev.addSetupProperty(new PropertyItem(prop.name, prop.value, true));
                        continue;
                    }
                    this.portDev.setSetupPropertyValue(prop.name, prop.value);
                }
                this.core.initializeDevice(this.portDev.getName());
                Thread.sleep(1000L);
                this.portDev.loadDataFromHardware(this.core);
                this.model.useSerialPort(this.portDev, true);
            }
            catch (Exception e) {
                this.showMessage(e.getMessage());
                return false;
            }
        }
        return true;
    }

    public void showMessage(String msg) {
        JOptionPane.showMessageDialog(this, msg);
    }

    public String getDeviceName() {
        return this.devLabel.getText();
    }

    private class DetectionTask
    extends Thread {
        private String[] foundPorts;
        private String selectedPort;

        DetectionTask(String id) {
            super(id);
            this.foundPorts = new String[0];
            this.selectedPort = new String();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean currentDebugLogSetting = DeviceSetupDlg.this.core.debugLogEnabled();
            try {
                ArrayList<Device> ports = new ArrayList<Device>();
                DeviceSetupDlg.this.model.removeDuplicateComPorts();
                Device[] availablePorts = DeviceSetupDlg.this.model.getAvailableSerialPorts();
                String portsInModel = "Serial ports available in configuration: ";
                for (int ip = 0; ip < availablePorts.length; ++ip) {
                    ports.add(availablePorts[ip]);
                }
                for (Device p1 : ports) {
                    if (0 < portsInModel.length()) {
                        portsInModel = portsInModel + " ";
                    }
                    portsInModel = portsInModel + p1.getName();
                }
                HashMap<String, ArrayList<String>> portsFoundCommunicating = new HashMap<String, ArrayList<String>>();
                String looking = "";
                ReportingUtils.logMessage("Starting port scanning; expect lots of spurious error messages");
                for (int i = 0; i < ports.size(); ++i) {
                    looking = "";
                    try {
                        DeviceSetupDlg.this.core.setProperty(DeviceSetupDlg.this.dev.getName(), MMCoreJ.getG_Keyword_Port(), ((Device)ports.get(i)).getName());
                        if (0 < looking.length()) {
                            looking = looking + "\n";
                        }
                        looking = looking + DeviceSetupDlg.this.dev.getName() + " on " + ((Device)ports.get(i)).getName();
                    }
                    catch (Exception e) {
                        ReportingUtils.logError(e);
                    }
                    DeviceSetupDlg.this.progressDialog.ProgressText("Looking for:\n" + looking);
                    DeviceDetectionStatus st = DeviceSetupDlg.this.core.detectDevice(DeviceSetupDlg.this.dev.getName());
                    if (st == DeviceDetectionStatus.Unimplemented) {
                        JOptionPane.showMessageDialog(null, "This device does not support auto-detection.\nYou have to manually choose port and settings.");
                        return;
                    }
                    if (DeviceSetupDlg.this.progressDialog.CancelRequest()) {
                        System.out.print("cancel request");
                        return;
                    }
                    if (DeviceDetectionStatus.CanCommunicate != st) continue;
                    ArrayList<String> llist = (ArrayList<String>)portsFoundCommunicating.get(DeviceSetupDlg.this.dev.getName());
                    if (null == llist) {
                        llist = new ArrayList<String>();
                        portsFoundCommunicating.put(DeviceSetupDlg.this.dev.getName(), llist);
                    }
                    llist.add(((Device)ports.get(i)).getName());
                }
                String foundem = "";
                ArrayList communicating = (ArrayList)portsFoundCommunicating.get(DeviceSetupDlg.this.dev.getName());
                this.foundPorts = new String[0];
                if (null != communicating) {
                    if (0 < communicating.size()) {
                        this.foundPorts = new String[communicating.size()];
                        int aiterator = 0;
                        foundem = foundem + DeviceSetupDlg.this.dev.getName() + " on ";
                        for (String ss : communicating) {
                            foundem = foundem + ss + "\n";
                            this.foundPorts[aiterator++] = ss;
                        }
                    }
                    PropertyItem p = DeviceSetupDlg.this.dev.findProperty(MMCoreJ.getG_Keyword_Port());
                    p.allowed = this.foundPorts;
                    p.value = "";
                    this.selectedPort = "";
                    if (0 < this.foundPorts.length) {
                        String selectedValue;
                        p.value = this.foundPorts.length > 1 ? (selectedValue = (String)JOptionPane.showInputDialog(null, "Multiple ports found, choose one", "Port", 1, null, this.foundPorts, this.foundPorts[0])) : this.foundPorts[0];
                        this.selectedPort = p.value;
                    }
                }
                DeviceSetupDlg.this.progressDialog.ProgressText("Found:\n " + foundem);
                try {
                    Thread.sleep(900L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                DeviceSetupDlg.this.progressDialog.setVisible(false);
                ReportingUtils.logMessage("Finished port scanning; spurious error messages no longer expected");
                DeviceSetupDlg.this.rebuildPropTable();
                if (this.selectedPort.length() != 0) {
                    Device pd = DeviceSetupDlg.this.model.findSerialPort(this.selectedPort);
                    if (pd != null) {
                        try {
                            pd.loadDataFromHardware(DeviceSetupDlg.this.core);
                        }
                        catch (Exception e) {
                            ReportingUtils.logError(e);
                        }
                    }
                    DeviceSetupDlg.this.rebuildComTable(this.selectedPort);
                }
                DeviceSetupDlg.this.detectButton.setText("Scan");
            }
        }

        public void finish() {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

