/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import mmcorej.CMMCore;
import mmcorej.DeviceType;
import mmcorej.LongVector;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import org.micromanager.conf2.Label;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;

public class Device {
    private String name_;
    private String adapterName_;
    private String library_;
    private PropertyItem[] properties_;
    private ArrayList<PropertyItem> setupProperties_;
    private String description_;
    private DeviceType type_;
    private Hashtable<Integer, Label> setupLabels_;
    private double delayMs_;
    private boolean usesDelay_;
    private int focusDirection_ = 0;
    private int numPos_ = 0;
    private String parentHub_;
    private String[] childDevices_;
    private boolean initialized_;

    public Device(String name, String lib, String adapterName, String descr, boolean discoverable, String master, Vector<String> slaves) {
        this.name_ = name;
        this.library_ = lib;
        this.adapterName_ = adapterName;
        this.description_ = descr;
        this.type_ = DeviceType.AnyType;
        this.setupLabels_ = new Hashtable();
        this.properties_ = new PropertyItem[0];
        this.setupProperties_ = new ArrayList();
        this.usesDelay_ = false;
        this.delayMs_ = 0.0;
        this.parentHub_ = new String();
        this.childDevices_ = new String[0];
        this.initialized_ = false;
    }

    public Device(String name, String lib, String adapterName, String descr) {
        this.name_ = name;
        this.library_ = lib;
        this.adapterName_ = adapterName;
        this.description_ = descr;
        this.type_ = DeviceType.AnyType;
        this.setupLabels_ = new Hashtable();
        this.properties_ = new PropertyItem[0];
        this.setupProperties_ = new ArrayList();
        this.usesDelay_ = false;
        this.delayMs_ = 0.0;
        this.parentHub_ = new String();
        this.childDevices_ = new String[0];
    }

    public Device(String name, String lib, String adapterName) {
        this(name, lib, adapterName, "");
    }

    public void setTypeByInt(int typeNum) {
        this.type_ = DeviceType.swigToEnum((int)typeNum);
    }

    public int getTypeAsInt() {
        return this.type_.swigValue();
    }

    public String getTypeAsString() {
        String devType = new String("Unknown");
        if (this.type_ == DeviceType.CameraDevice) {
            devType = "Camera";
        } else if (this.type_ == DeviceType.SerialDevice) {
            devType = "Serial Port";
        } else if (this.type_ == DeviceType.ShutterDevice) {
            devType = "Shutter";
        } else if (this.type_ == DeviceType.CoreDevice) {
            devType = "Micro-manager Core";
        } else if (this.type_ == DeviceType.AutoFocusDevice) {
            devType = "Autofocus";
        } else if (this.type_ == DeviceType.HubDevice) {
            devType = "Motorized scope or Hub";
        } else if (this.type_ == DeviceType.GenericDevice) {
            devType = "Generic Device";
        } else if (this.type_ == DeviceType.AnyType) {
            devType = "Misc.";
        } else if (this.type_ == DeviceType.ImageProcessorDevice) {
            devType = "Image Processor";
        } else if (this.type_ == DeviceType.SignalIODevice) {
            devType = "Signal I/O Device";
        } else if (this.type_ == DeviceType.SLMDevice) {
            devType = "SLM";
        } else if (this.type_ == DeviceType.StageDevice) {
            devType = "Single Axis Stage";
        } else if (this.type_ == DeviceType.XYStageDevice) {
            devType = "XY Stage";
        } else if (this.type_ == DeviceType.StateDevice) {
            devType = "Discrete State Device";
        } else if (this.type_ == DeviceType.MagnifierDevice) {
            devType = "Magnifier";
        } else if (this.type_ == DeviceType.GalvoDevice) {
            devType = "Galvo";
        } else {
            ReportingUtils.logError("Unercongized device type: " + this.adapterName_);
        }
        return devType;
    }

    public void loadDataFromHardware(CMMCore core) throws Exception {
        StrVector propNames = core.getDevicePropertyNames(this.name_);
        this.properties_ = new PropertyItem[(int)propNames.size()];
        this.type_ = core.getDeviceType(this.name_);
        this.usesDelay_ = core.usesDeviceDelay(this.name_);
        int j = 0;
        while ((long)j < propNames.size()) {
            this.properties_[j] = new PropertyItem();
            this.properties_[j].name = propNames.get(j);
            this.properties_[j].value = core.getProperty(this.name_, propNames.get(j));
            this.properties_[j].readOnly = core.isPropertyReadOnly(this.name_, propNames.get(j));
            this.properties_[j].preInit = core.isPropertyPreInit(this.name_, propNames.get(j));
            this.properties_[j].type = core.getPropertyType(this.name_, propNames.get(j));
            StrVector values = core.getAllowedPropertyValues(this.name_, propNames.get(j));
            this.properties_[j].allowed = new String[(int)values.size()];
            int k = 0;
            while ((long)k < values.size()) {
                this.properties_[j].allowed[k] = values.get(k);
                ++k;
            }
            this.properties_[j].sort();
            ++j;
        }
        this.numPos_ = this.type_ == DeviceType.StateDevice ? core.getNumberOfStates(this.name_) : 0;
    }

    public static Device[] getLibraryContents(String libName, CMMCore core) throws Exception {
        StrVector adapterNames = core.getAvailableDevices(libName);
        StrVector devDescrs = core.getAvailableDeviceDescriptions(libName);
        LongVector devTypes = core.getAvailableDeviceTypes(libName);
        Device[] devList = new Device[(int)adapterNames.size()];
        int i = 0;
        while ((long)i < adapterNames.size()) {
            devList[i] = new Device("Undefined", libName, adapterNames.get(i), devDescrs.get(i));
            devList[i].setTypeByInt(devTypes.get(i));
            ++i;
        }
        return devList;
    }

    public void discoverPeripherals(CMMCore core) throws Exception {
        if (this.isHub() && !this.getName().equals("Core") && this.childDevices_.length == 0) {
            StrVector installed = core.getInstalledDevices(this.getName());
            this.childDevices_ = installed.toArray();
        }
    }

    public String[] getPreInitProperties() {
        Vector<String> piProps = new Vector<String>();
        for (PropertyItem p : this.properties_) {
            if (!p.preInit) continue;
            piProps.add(p.name);
        }
        return piProps.toArray(new String[piProps.size()]);
    }

    public String[] getPeripherals() {
        return this.childDevices_;
    }

    public String getName() {
        return this.name_;
    }

    public String getAdapterName() {
        return this.adapterName_;
    }

    public String getDescription() {
        return this.description_;
    }

    public void addSetupProperty(PropertyItem prop) {
        this.setupProperties_.add(prop);
    }

    public void addSetupLabel(Label lab) {
        this.setupLabels_.put(new Integer(lab.state_), lab);
    }

    public void getFocusDirectionFromHardware(CMMCore core) throws Exception {
        if (this.type_ == DeviceType.StageDevice) {
            this.focusDirection_ = core.getFocusDirection(this.name_);
        }
    }

    public void getSetupLabelsFromHardware(CMMCore core) throws Exception {
        if (this.type_ == DeviceType.StateDevice) {
            StrVector stateLabels = core.getStateLabels(this.name_);
            this.numPos_ = (int)stateLabels.size();
            this.setupLabels_.clear();
            for (int state = 0; state < this.numPos_; ++state) {
                this.setSetupLabel(state, stateLabels.get(state));
            }
        }
    }

    public String getLibrary() {
        return this.library_;
    }

    public int getNumberOfProperties() {
        return this.properties_.length;
    }

    public PropertyItem getProperty(int idx) {
        return this.properties_[idx];
    }

    public String getPropertyValue(String propName) throws MMConfigFileException {
        PropertyItem p = this.findProperty(propName);
        if (p == null) {
            throw new MMConfigFileException("Property " + propName + " is not defined");
        }
        return p.value;
    }

    public void setPropertyValue(String name, String value) throws MMConfigFileException {
        PropertyItem p = this.findProperty(name);
        if (p == null) {
            throw new MMConfigFileException("Property " + name + " is not defined");
        }
        p.value = value;
    }

    public int getNumberOfSetupProperties() {
        return this.setupProperties_.size();
    }

    public PropertyItem getSetupProperty(int idx) {
        return this.setupProperties_.get(idx);
    }

    public String getSetupPropertyValue(String propName) throws MMConfigFileException {
        PropertyItem p = this.findSetupProperty(propName);
        if (p == null) {
            throw new MMConfigFileException("Property " + propName + " is not defined");
        }
        return p.value;
    }

    public void setSetupPropertyValue(String name, String value) throws MMConfigFileException {
        PropertyItem p = this.findSetupProperty(name);
        if (p == null) {
            throw new MMConfigFileException("Property " + name + " is not defined");
        }
        p.value = value;
    }

    public boolean isStateDevice() {
        return this.type_ == DeviceType.StateDevice;
    }

    public boolean isStage() {
        return this.type_ == DeviceType.StageDevice;
    }

    public boolean isSerialPort() {
        return this.type_ == DeviceType.SerialDevice;
    }

    public boolean isCamera() {
        return this.type_ == DeviceType.CameraDevice;
    }

    public boolean isHub() {
        return this.type_ == DeviceType.HubDevice;
    }

    public int getNumberOfSetupLabels() {
        return this.setupLabels_.size();
    }

    public Label getSetupLabelByState(int j) {
        return this.setupLabels_.get(new Integer(j));
    }

    public void setSetupLabel(int pos, String label) {
        Label l = this.setupLabels_.get(new Integer(pos));
        if (l == null) {
            this.setupLabels_.put(new Integer(pos), new Label(label, pos));
        } else {
            l.label_ = label;
        }
    }

    public boolean isCore() {
        return this.name_.contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreDevice()));
    }

    public void setName(String newName) {
        this.name_ = newName;
    }

    public PropertyItem findProperty(String name) {
        for (int i = 0; i < this.properties_.length; ++i) {
            PropertyItem p = this.properties_[i];
            if (!p.name.contentEquals(new StringBuffer().append(name))) continue;
            return p;
        }
        return null;
    }

    public PropertyItem findSetupProperty(String name) {
        for (int i = 0; i < this.setupProperties_.size(); ++i) {
            PropertyItem p = this.setupProperties_.get(i);
            if (!p.name.contentEquals(new StringBuffer().append(name))) continue;
            return p;
        }
        return null;
    }

    public double getDelay() {
        return this.delayMs_;
    }

    public void setDelay(double delayMs) {
        this.delayMs_ = delayMs;
    }

    public boolean usesDelay() {
        return this.usesDelay_;
    }

    public void setFocusDirection(int direction) {
        this.focusDirection_ = direction > 0 ? 1 : (direction < 0 ? -1 : 0);
    }

    public int getFocusDirection() {
        return this.focusDirection_;
    }

    public int getNumberOfStates() {
        return this.numPos_;
    }

    public void setParentHub(String hub) {
        this.parentHub_ = hub;
    }

    public String getParentHub() {
        return this.parentHub_;
    }

    public boolean isInitialized() {
        return this.initialized_;
    }

    public void setInitialized(boolean state) {
        this.initialized_ = state;
    }

    public void updateSetupProperties() {
        this.setupProperties_.clear();
        for (int i = 0; i < this.properties_.length; ++i) {
            this.setupProperties_.add(new PropertyItem(this.properties_[i].name, this.properties_[i].value, this.properties_[i].preInit));
        }
    }

    public String getPort() {
        for (int i = 0; i < this.getNumberOfProperties(); ++i) {
            PropertyItem p = this.getProperty(i);
            if (p == null || p.name.compareTo(MMCoreJ.getG_Keyword_Port()) != 0) continue;
            return p.value;
        }
        return "";
    }

    public Label[] getAllSetupLabels() {
        Label[] lblArray = new Label[this.setupLabels_.size()];
        return this.setupLabels_.values().toArray(lblArray);
    }
}

