/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.DevicesPage;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.PagePanel;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.ReportingUtils;

public class DelayPage
extends PagePanel {
    private static final long serialVersionUID = 1L;
    private JTable deviceTable_;

    public DelayPage(Preferences prefs) {
        this.title_ = "Set delays for devices without synchronization capabilities";
        this.helpText_ = "Some devices can't signal when they are done with the command, so that we have to guess by manually setting the delay. This means that the device will signal to be busy for the specified delay time after extecuting each command. Devices that may require setting the delay manually are mostly shutters or filter wheels. \n\nIf device has normal synchronization capabilities, or you are not sure about it, leave this parameter at 0.";
        this.setHelpFileName("conf_delays_page.html");
        this.prefs_ = prefs;
        this.setLayout(null);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(22, 21, 517, 337);
        this.add(scrollPane);
        this.deviceTable_ = new JTable();
        this.deviceTable_.setSelectionMode(0);
        InputMap im = this.deviceTable_.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(10, 0), "none");
        scrollPane.setViewportView(this.deviceTable_);
        GUIUtils.setClickCountToStartEditing(this.deviceTable_, 1);
        GUIUtils.stopEditingOnLosingFocus(this.deviceTable_);
    }

    @Override
    public boolean enterPage(boolean next) {
        this.rebuildTable();
        return true;
    }

    @Override
    public boolean exitPage(boolean next) {
        block3: {
            TableCellEditor ce = this.deviceTable_.getCellEditor();
            if (ce != null) {
                this.deviceTable_.getCellEditor().stopCellEditing();
            }
            try {
                this.model_.applyDelaysToHardware(this.core_);
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
                if (!next) break block3;
                return false;
            }
        }
        return true;
    }

    private void rebuildTable() {
        DelayTableModel tmd;
        TableModel tm = this.deviceTable_.getModel();
        if (tm instanceof DevicesPage.DeviceTable_TableModel) {
            tmd = (DelayTableModel)this.deviceTable_.getModel();
            tmd.refresh();
        } else {
            tmd = new DelayTableModel(this.model_);
            this.deviceTable_.setModel(tmd);
        }
        tmd.fireTableStructureChanged();
        tmd.fireTableDataChanged();
    }

    @Override
    public void refresh() {
        this.rebuildTable();
    }

    @Override
    public void loadSettings() {
    }

    @Override
    public void saveSettings() {
    }

    class DelayTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"Name", "Adapter", "Delay [ms]"};
        MicroscopeModel model_;
        ArrayList<Device> devices_ = new ArrayList();

        public DelayTableModel(MicroscopeModel model) {
            Device[] allDevices = model.getDevices();
            for (int i = 0; i < allDevices.length; ++i) {
                if (!allDevices[i].usesDelay()) continue;
                this.devices_.add(allDevices[i]);
            }
            this.model_ = model;
        }

        public void setMicroscopeModel(MicroscopeModel mod) {
            Device[] allDevices = mod.getDevices();
            for (int i = 0; i < allDevices.length; ++i) {
                if (!allDevices[i].usesDelay()) continue;
                this.devices_.add(allDevices[i]);
            }
            this.model_ = mod;
        }

        @Override
        public int getRowCount() {
            return this.devices_.size();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.COLUMN_NAMES[columnIndex];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.devices_.get(rowIndex).getName();
            }
            if (columnIndex == 1) {
                return this.devices_.get(rowIndex).getAdapterName();
            }
            return new Double(this.devices_.get(rowIndex).getDelay());
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 2) {
                try {
                    this.devices_.get(row).setDelay(Double.parseDouble((String)value));
                    this.fireTableCellUpdated(row, col);
                }
                catch (Exception e) {
                    ReportingUtils.logError(e);
                }
            }
        }

        @Override
        public boolean isCellEditable(int nRow, int nCol) {
            return nCol == 2;
        }

        public void refresh() {
            Device[] allDevices = this.model_.getDevices();
            for (int i = 0; i < allDevices.length; ++i) {
                if (!allDevices[i].usesDelay()) continue;
                this.devices_.add(allDevices[i]);
            }
            this.fireTableDataChanged();
        }
    }
}

