/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.text.DefaultCaret;
import mmcorej.CMMCore;
import mmcorej.StrVector;
import org.micromanager.MMStudio;
import org.micromanager.conf2.DelayPage;
import org.micromanager.conf2.DevicesPage;
import org.micromanager.conf2.FinishPage;
import org.micromanager.conf2.IntroPage;
import org.micromanager.conf2.LabelsPage;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.PagePanel;
import org.micromanager.conf2.RolesPage;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.HotKeys;
import org.micromanager.utils.HttpUtils;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.ReportingUtils;

public class ConfiguratorDlg2
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private JLabel pagesLabel_;
    private JButton backButton_;
    private JButton nextButton_;
    private PagePanel[] pages_;
    private int curPage_ = 0;
    private MicroscopeModel microModel_;
    private final CMMCore core_;
    private Preferences prefs_;
    private static final String APP_NAME = "Configurator";
    private JLabel titleLabel_;
    private JEditorPane helpTextPane_;
    private final String defaultPath_;
    private static final String CFG_OKAY_TO_SEND = "CFG_Okay_To_Send";

    public ConfiguratorDlg2(CMMCore core, String defFile) {
        this.core_ = core;
        this.defaultPath_ = defFile;
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.initialize();
    }

    private void initialize() {
        this.prefs_ = Preferences.userNodeForPackage(this.getClass());
        HotKeys.active_ = false;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                ConfiguratorDlg2.this.onCloseWindow();
            }
        });
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.setTitle("Hardware Configuration Wizard");
        this.setBounds(50, 100, 859, 641);
        this.loadPosition(50, 100);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBounds(584, 28, 259, 526);
        this.getContentPane().add(scrollPane);
        scrollPane.getViewport().setViewPosition(new Point(0, 0));
        this.helpTextPane_ = new JEditorPane();
        scrollPane.setViewportView(this.helpTextPane_);
        this.helpTextPane_.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.helpTextPane_.getCaret();
        caret.setUpdatePolicy(1);
        this.helpTextPane_.setContentType("text/html; charset=ISO-8859-1");
        this.nextButton_ = new JButton();
        this.nextButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ConfiguratorDlg2.this.curPage_ == ConfiguratorDlg2.this.pages_.length - 1) {
                    ConfiguratorDlg2.this.pages_[ConfiguratorDlg2.this.curPage_].exitPage(true);
                    ConfiguratorDlg2.this.onCloseWindow();
                } else {
                    ConfiguratorDlg2.this.setPage(ConfiguratorDlg2.this.curPage_ + 1);
                }
            }
        });
        this.nextButton_.setText("Next >");
        this.nextButton_.setBounds(750, 565, 93, 23);
        this.getContentPane().add(this.nextButton_);
        this.getRootPane().setDefaultButton(this.nextButton_);
        this.backButton_ = new JButton();
        this.backButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConfiguratorDlg2.this.setPage(ConfiguratorDlg2.this.curPage_ - 1);
            }
        });
        this.backButton_.setText("< Back");
        this.backButton_.setBounds(647, 565, 93, 23);
        this.getContentPane().add(this.backButton_);
        this.pagesLabel_ = new JLabel();
        this.pagesLabel_.setBorder(new LineBorder(Color.black, 1, false));
        this.pagesLabel_.setBounds(9, 28, 565, 560);
        this.getContentPane().add(this.pagesLabel_);
        this.pages_ = new PagePanel[6];
        int pageNumber = 0;
        this.pages_[pageNumber++] = new IntroPage(this.prefs_);
        this.pages_[pageNumber++] = new DevicesPage(this.prefs_);
        this.pages_[pageNumber++] = new RolesPage(this.prefs_);
        this.pages_[pageNumber++] = new DelayPage(this.prefs_);
        this.pages_[pageNumber++] = new LabelsPage(this.prefs_);
        this.pages_[pageNumber++] = new FinishPage(this.prefs_);
        this.microModel_ = new MicroscopeModel();
        boolean bvalue = this.prefs_.getBoolean(CFG_OKAY_TO_SEND, true);
        this.microModel_.setSendConfiguration(bvalue);
        this.microModel_.loadAvailableDeviceList(this.core_);
        this.microModel_.setFileName(this.defaultPath_);
        Rectangle r = this.pagesLabel_.getBounds();
        this.titleLabel_ = new JLabel();
        this.titleLabel_.setText("Title");
        this.titleLabel_.setBounds(9, 4, 578, 21);
        this.getContentPane().add(this.titleLabel_);
        for (int i = 0; i < this.pages_.length; ++i) {
            try {
                this.pages_[i].setModel(this.microModel_, this.core_);
                this.pages_[i].loadSettings();
                this.pages_[i].setBounds(r);
                this.pages_[i].setTitle("Step " + (i + 1) + " of " + this.pages_.length + ": " + this.pages_[i].getTitle());
                this.pages_[i].setParentDialog(this);
                continue;
            }
            catch (Exception e) {
                ReportingUtils.logError(e);
            }
        }
        this.setPage(0);
    }

    private void setPage(int i) {
        if (i > 0 && !this.pages_[this.curPage_].exitPage(this.curPage_ < i)) {
            return;
        }
        int newPage = i < 0 ? 0 : (i >= this.pages_.length ? this.pages_.length - 1 : i);
        if (!this.pages_[newPage].enterPage(this.curPage_ > newPage)) {
            return;
        }
        this.getContentPane().remove(this.pages_[this.curPage_]);
        this.curPage_ = newPage;
        this.getContentPane().add(this.pages_[this.curPage_]);
        this.getContentPane().repaint();
        this.pages_[this.curPage_].refresh();
        if (this.curPage_ == 0) {
            this.backButton_.setEnabled(false);
        } else {
            this.backButton_.setEnabled(true);
        }
        if (this.curPage_ == this.pages_.length - 1) {
            this.nextButton_.setText("Finish");
        } else {
            this.nextButton_.setText("Next >");
        }
        this.titleLabel_.setText(this.pages_[this.curPage_].getTitle());
        this.helpTextPane_.setContentType("text/plain");
        this.helpTextPane_.setText(this.pages_[this.curPage_].getHelpText());
        try {
            File curDir = new File(".");
            String helpFileName = this.pages_[this.curPage_].getHelpFileName();
            if (helpFileName == null) {
                return;
            }
            URL htmlURL = ConfiguratorDlg2.class.getResource(helpFileName);
            String helpText = ConfiguratorDlg2.readStream(ConfiguratorDlg2.class.getResourceAsStream(helpFileName));
            this.helpTextPane_.setContentType("text/html; charset=ISO-8859-1");
            this.helpTextPane_.setText(helpText);
        }
        catch (MalformedURLException e1) {
            ReportingUtils.showError(e1);
        }
        catch (IOException e) {
            ReportingUtils.showError(e);
        }
    }

    private String UploadCurrentConfigFile() {
        String returnValue;
        block21: {
            returnValue = "";
            try {
                int c;
                HttpUtils httpu = new HttpUtils();
                ArrayList list = new ArrayList();
                File conff = new File(this.getFileName());
                if (!conff.exists()) break block21;
                String prependedLine = "#";
                String qualifiedConfigFileName = "";
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
                    qualifiedConfigFileName = qualifiedConfigFileName + df.format(new Date());
                    String shortTZName = TimeZone.getDefault().getDisplayName(false, 0);
                    qualifiedConfigFileName = qualifiedConfigFileName + shortTZName;
                    qualifiedConfigFileName = qualifiedConfigFileName + "@";
                    try {
                        String pa2;
                        String physicalAddress = "00-00-00-00-00-00";
                        StrVector ss = this.core_.getMACAddresses();
                        if (0L < ss.size() && null != (pa2 = ss.get(0)) && 0 < pa2.length()) {
                            physicalAddress = pa2;
                        }
                        qualifiedConfigFileName = qualifiedConfigFileName + physicalAddress;
                        prependedLine = prependedLine + "Host: " + InetAddress.getLocalHost().getHostName() + " ";
                    }
                    catch (UnknownHostException physicalAddress) {
                        // empty catch block
                    }
                    prependedLine = prependedLine + "User: " + this.core_.getUserId() + " configuration file: " + conff.getName() + "\n";
                }
                catch (Throwable df) {
                    // empty catch block
                }
                qualifiedConfigFileName = qualifiedConfigFileName.replace(':', '_');
                qualifiedConfigFileName = qualifiedConfigFileName.replace(';', '_');
                File fileToSend = new File(qualifiedConfigFileName);
                FileReader reader = new FileReader(conff);
                FileWriter writer = new FileWriter(fileToSend);
                writer.append(prependedLine);
                while (-1 != (c = reader.read())) {
                    writer.write(c);
                }
                try {
                    reader.close();
                }
                catch (Exception e) {
                    ReportingUtils.logError(e);
                }
                try {
                    writer.close();
                }
                catch (Exception e) {
                    ReportingUtils.logError(e);
                }
                try {
                    URL url = new URL("http://valelab.ucsf.edu/~MM/upload_file.php");
                    ArrayList<File> flist = new ArrayList<File>();
                    flist.add(fileToSend);
                    for (Object e : flist) {
                        File f0 = (File)e;
                        try {
                            httpu.upload(url, f0);
                        }
                        catch (UnknownHostException e2) {
                            returnValue = e2.toString();
                        }
                        catch (IOException e3) {
                            returnValue = e3.toString();
                        }
                        catch (SecurityException e4) {
                            returnValue = e4.toString();
                        }
                        catch (Exception e5) {
                            returnValue = e5.toString();
                        }
                    }
                }
                catch (MalformedURLException e) {
                    returnValue = e.toString();
                }
                if (!fileToSend.delete()) {
                    ReportingUtils.logError("Couldn't delete temporary file " + qualifiedConfigFileName);
                }
            }
            catch (IOException e) {
                returnValue = e.toString();
            }
        }
        return returnValue;
    }

    private void onCloseWindow() {
        for (int i = 0; i < this.pages_.length; ++i) {
            this.pages_[i].saveSettings();
        }
        this.savePosition();
        if (this.microModel_.isModified()) {
            int result = JOptionPane.showConfirmDialog(this, "Save changes to the configuration file?\nIf you press YES you will get a chance to change the file name.", APP_NAME, 1, 1);
            switch (result) {
                case 0: {
                    this.saveConfiguration();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        if (this.microModel_.getSendConfiguration()) {
            class Uploader
            extends Thread {
                private String statusMessage_;

                public Uploader() {
                    super("uploader");
                    this.statusMessage_ = "";
                }

                @Override
                public void run() {
                    this.statusMessage_ = ConfiguratorDlg2.this.UploadCurrentConfigFile();
                }

                public String Status() {
                    return this.statusMessage_;
                }
            }
            Uploader u = new Uploader();
            u.start();
            try {
                u.join();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ConfiguratorDlg2.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (0 < u.Status().length()) {
                ReportingUtils.logError("Error uploading configuration file: " + u.Status());
            }
        }
        this.prefs_.putBoolean(CFG_OKAY_TO_SEND, this.microModel_.getSendConfiguration());
        HotKeys.active_ = true;
        this.dispose();
    }

    private void saveConfiguration() {
        File f = FileDialogs.save(this, "Create a config file", MMStudio.MM_CONFIG_FILE);
        if (f == null) {
            return;
        }
        try {
            this.microModel_.saveToFile(f.getAbsolutePath());
        }
        catch (MMConfigFileException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    public String getFileName() {
        return this.microModel_.getFileName();
    }

    private static String readStream(InputStream is) throws IOException {
        String line;
        StringBuffer bf = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            bf.append(line);
            bf.append("\n");
        }
        return bf.toString();
    }
}

