/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.util.ArrayList;
import org.micromanager.conf2.Setting;

public class ConfigPreset {
    private String name_;
    private ArrayList<Setting> settings_;
    private double pixelSizeUm_ = 0.0;

    public ConfigPreset() {
        this.name_ = new String("Undefined");
        this.settings_ = new ArrayList();
    }

    public ConfigPreset(String name) {
        this.name_ = name;
        this.settings_ = new ArrayList();
    }

    public String getName() {
        return this.name_;
    }

    public boolean addSetting(Setting s) {
        for (int i = 0; i < this.settings_.size(); ++i) {
            if (this.getSetting(i).isEqualTo(s)) {
                return false;
            }
            if (!this.getSetting(i).matches(s)) continue;
            this.settings_.set(i, s);
            return true;
        }
        this.settings_.add(s);
        return true;
    }

    public boolean matchSetting(Setting s) {
        for (int i = 0; i < this.settings_.size(); ++i) {
            if (!this.getSetting(i).matches(s)) continue;
            return true;
        }
        return false;
    }

    public boolean removeSetting(Setting s) {
        for (int i = 0; i < this.settings_.size(); ++i) {
            if (!this.getSetting(i).isEqualTo(s)) continue;
            this.settings_.remove(i);
            return true;
        }
        return false;
    }

    public int getNumberOfSettings() {
        return this.settings_.size();
    }

    public Setting getSetting(int i) {
        return this.settings_.get(i);
    }

    public String toString() {
        return new String("Preset: " + this.name_);
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public void setPixelSizeUm(double ps) {
        this.pixelSizeUm_ = ps;
    }

    public double getPixelSize() {
        return this.pixelSizeUm_;
    }
}

