/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.util.Hashtable;
import org.micromanager.conf2.ConfigPreset;
import org.micromanager.conf2.Setting;

public class ConfigGroup {
    String name_;
    Hashtable<String, ConfigPreset> configs_;

    public ConfigGroup(String name) {
        this.name_ = new String(name);
        this.configs_ = new Hashtable();
    }

    public void addConfigPreset(ConfigPreset p) {
        this.configs_.put(p.getName(), p);
    }

    public String getName() {
        return this.name_;
    }

    public void addConfigSetting(String presetName, String device, String property, String value) {
        ConfigPreset cp = this.configs_.get(presetName);
        if (cp == null) {
            cp = new ConfigPreset(presetName);
            this.configs_.put(presetName, cp);
        }
        cp.addSetting(new Setting(device, property, value));
    }

    public ConfigPreset[] getConfigPresets() {
        Object[] objs = this.configs_.values().toArray();
        ConfigPreset[] cps = new ConfigPreset[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            cps[i] = (ConfigPreset)objs[i];
        }
        return cps;
    }

    public String toString() {
        return new String("Group: " + this.name_);
    }

    public void removePreset(String name) {
        this.configs_.remove(name);
    }

    public ConfigPreset findConfigPreset(String name) {
        return this.configs_.get(name);
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public void renamePreset(ConfigPreset prs, String name) {
        this.configs_.remove(prs.getName());
        prs.setName(name);
        this.configs_.put(name, prs);
    }

    public void clear() {
        this.configs_.clear();
    }
}

