/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.Setting;
import org.micromanager.utils.MMPropertyTableModel;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;

class ComPropTableModel
extends AbstractTableModel
implements MMPropertyTableModel {
    private static final long serialVersionUID = 1L;
    public final String[] COLUMN_NAMES = new String[]{"Device", "Property", "Value"};
    MicroscopeModel model_;
    Device dev_;
    PropertyItem[] props_;

    public ComPropTableModel(MicroscopeModel model, Device portDev) {
        this.updateValues(model, portDev);
    }

    public void updateValues(MicroscopeModel model, Device dev) {
        int i;
        this.model_ = model;
        this.dev_ = dev;
        try {
            System.out.println("InitPort " + this.dev_.getPropertyValue("BaudRate"));
        }
        catch (MMConfigFileException e) {
            ReportingUtils.logMessage("Property Baudrate is not defined");
        }
        if (!dev.isSerialPort()) {
            return;
        }
        this.model_.dumpComPortsSetupProps();
        ArrayList<PropertyItem> props = new ArrayList<PropertyItem>();
        ArrayList<String> dn = new ArrayList<String>();
        for (i = 0; i < this.dev_.getNumberOfProperties(); ++i) {
            PropertyItem p = this.dev_.getProperty(i);
            if (p.readOnly) continue;
            props.add(p);
            dn.add(this.dev_.getName());
            PropertyItem setupProp = this.dev_.findSetupProperty(p.name);
            if (setupProp == null) continue;
            p.value = setupProp.value;
        }
        this.props_ = new PropertyItem[props.size()];
        for (i = 0; i < props.size(); ++i) {
            this.props_[i] = (PropertyItem)props.get(i);
        }
    }

    @Override
    public int getRowCount() {
        return this.props_.length;
    }

    @Override
    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.COLUMN_NAMES[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.dev_.getName();
        }
        if (columnIndex == 1) {
            return this.props_[rowIndex].name;
        }
        return this.props_[rowIndex].value;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 2) {
            try {
                this.props_[row].value = (String)value;
                this.dev_.setPropertyValue(this.props_[row].name, this.props_[row].value);
                this.fireTableCellUpdated(row, col);
                System.out.println("setVal " + this.dev_.getPropertyValue("BaudRate"));
            }
            catch (Exception e) {
                ReportingUtils.logError(e.getMessage());
            }
        }
    }

    @Override
    public boolean isCellEditable(int nRow, int nCol) {
        return nCol == 2 && !this.props_[nRow].readOnly;
    }

    public void refresh() {
        this.fireTableDataChanged();
    }

    @Override
    public PropertyItem getPropertyItem(int rowIndex) {
        return this.props_[rowIndex];
    }

    public Setting getSetting(int rowIndex) {
        return new Setting(this.dev_.getName(), this.props_[rowIndex].name, this.props_[rowIndex].value);
    }

    public PropertyItem getProperty(Setting s) {
        if (this.dev_.getName().compareTo(s.deviceName_) == 0) {
            return this.dev_.findSetupProperty(s.propertyName_);
        }
        return null;
    }

    public Device getPortDevice() {
        return this.dev_;
    }
}

