/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import org.micromanager.utils.ChannelSpec;

public class SequenceSettings {
    public static final double Version = 1.0;
    public int numFrames = 1;
    public double intervalMs = 0.0;
    public ArrayList<Double> customIntervalsMs = null;
    public ArrayList<ChannelSpec> channels = new ArrayList();
    public ArrayList<Double> slices = new ArrayList();
    public boolean relativeZSlice = false;
    public boolean slicesFirst = false;
    public boolean timeFirst = false;
    public boolean keepShutterOpenSlices = false;
    public boolean keepShutterOpenChannels = false;
    public boolean useAutofocus = false;
    public int skipAutofocusCount = 0;
    public boolean save = false;
    public String root = null;
    public String prefix = null;
    public double zReference = 0.0;
    public String comment = "";
    public String channelGroup = "";
    public boolean usePositionList = false;
    public int cameraTimeout = 20000;

    public static String toJSONStream(SequenceSettings settings) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)settings);
    }

    public static SequenceSettings fromJSONStream(String stream) {
        Gson gson = new Gson();
        return (SequenceSettings)gson.fromJson(stream, SequenceSettings.class);
    }

    public static synchronized void main(String[] args) {
        SequenceSettings s = new SequenceSettings();
        String channelGroup = "Channel";
        s.numFrames = 20;
        s.slices = new ArrayList();
        s.slices.add(-1.0);
        s.slices.add(0.0);
        s.slices.add(1.0);
        s.relativeZSlice = true;
        s.channels = new ArrayList();
        ChannelSpec ch1 = new ChannelSpec();
        ch1.config = "DAPI";
        ch1.exposure = 5.0;
        s.channels.add(ch1);
        ChannelSpec ch2 = new ChannelSpec();
        ch2.config = "FITC";
        ch2.exposure = 15.0;
        s.channels.add(ch2);
        s.prefix = "ACQ-TEST-B";
        s.root = "C:/AcquisitionData";
        s.channelGroup = channelGroup;
        String stream = SequenceSettings.toJSONStream(s);
        System.out.println("Encoded:\n" + stream);
        SequenceSettings resultSs = SequenceSettings.fromJSONStream(stream);
        System.out.println("Decoded:\n" + SequenceSettings.toJSONStream(resultSs));
    }
}

