/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.api.MultiStagePosition;
import org.micromanager.api.StagePosition;
import org.micromanager.utils.MMException;
import org.micromanager.utils.MMSerializationException;

public class PositionList {
    private ArrayList<MultiStagePosition> positions_;
    private static final String ID = "Micro-Manager XY-position list";
    private static final String ID_KEY = "ID";
    private static final int VERSION = 3;
    private static final String VERSION_KEY = "VERSION";
    private static final String LABEL_KEY = "LABEL";
    private static final String DEVICE_KEY = "DEVICE";
    private static final String X_KEY = "X";
    private static final String Y_KEY = "Y";
    private static final String Z_KEY = "Z";
    private static final String NUMAXES_KEY = "AXES";
    private static final String POSARRAY_KEY = "POSITIONS";
    private static final String DEVARRAY_KEY = "DEVICES";
    private static final String GRID_ROW_KEY = "GRID_ROW";
    private static final String GRID_COL_KEY = "GRID_COL";
    private static final String PROPERTIES_KEY = "PROPERTIES";
    private static final String DEFAULT_XY_STAGE = "DEFAULT_XY_STAGE";
    private static final String DEFAULT_Z_STAGE = "DEFAULT_Z_STAGE";
    public static final String AF_KEY = "AUTOFOCUS";
    public static final String AF_VALUE_FULL = "full";
    public static final String AF_VALUE_INCREMENTAL = "incremental";
    public static final String AF_VALUE_NONE = "none";
    private HashSet<ChangeListener> listeners_ = new HashSet();

    public PositionList() {
        this.positions_ = new ArrayList();
    }

    public static PositionList newInstance(PositionList aPl) {
        PositionList pl = new PositionList();
        Iterator<MultiStagePosition> it = aPl.positions_.iterator();
        while (it.hasNext()) {
            pl.addPosition(MultiStagePosition.newInstance(it.next()));
        }
        return pl;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners_.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners_.remove(listener);
    }

    public void notifyChangeListeners() {
        for (ChangeListener listener : this.listeners_) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    public MultiStagePosition getPosition(int idx) {
        if (idx < 0 || idx >= this.positions_.size()) {
            return null;
        }
        return this.positions_.get(idx);
    }

    public MultiStagePosition getPositionCopy(int idx) {
        if (idx < 0 || idx >= this.positions_.size()) {
            return null;
        }
        return MultiStagePosition.newInstance(this.positions_.get(idx));
    }

    public int getPositionIndex(String posLabel) {
        for (int i = 0; i < this.positions_.size(); ++i) {
            if (this.positions_.get(i).getLabel().compareTo(posLabel) != 0) continue;
            return i;
        }
        return -1;
    }

    public void addPosition(MultiStagePosition pos) {
        String label = pos.getLabel();
        if (!this.isLabelUnique(label)) {
            pos.setLabel(this.generateLabel(label));
        }
        this.positions_.add(pos);
        this.notifyChangeListeners();
    }

    public void addPosition(int in0, MultiStagePosition pos) {
        String label = pos.getLabel();
        if (!this.isLabelUnique(label)) {
            pos.setLabel(this.generateLabel(label));
        }
        this.positions_.add(in0, pos);
        this.notifyChangeListeners();
    }

    public void replacePosition(int index, MultiStagePosition pos) {
        if (index >= 0 && index < this.positions_.size()) {
            this.positions_.set(index, pos);
            this.notifyChangeListeners();
        }
    }

    public int getNumberOfPositions() {
        return this.positions_.size();
    }

    public void clearAllPositions() {
        this.positions_.clear();
        this.notifyChangeListeners();
    }

    public void removePosition(int idx) {
        if (idx >= 0 && idx < this.positions_.size()) {
            this.positions_.remove(idx);
        }
        this.notifyChangeListeners();
    }

    public void setPositions(MultiStagePosition[] posArray) {
        this.positions_.clear();
        for (int i = 0; i < posArray.length; ++i) {
            this.positions_.add(posArray[i]);
        }
        this.notifyChangeListeners();
    }

    public MultiStagePosition[] getPositions() {
        MultiStagePosition[] list = new MultiStagePosition[this.positions_.size()];
        for (int i = 0; i < this.positions_.size(); ++i) {
            list[i] = this.positions_.get(i);
        }
        return list;
    }

    public void setLabel(int idx, String label) {
        if (idx < 0 || idx >= this.positions_.size()) {
            return;
        }
        this.positions_.get(idx).setLabel(label);
        this.notifyChangeListeners();
    }

    public String serialize() throws MMSerializationException {
        JSONObject meta = new JSONObject();
        try {
            meta.put(ID_KEY, ID);
            meta.put(VERSION_KEY, 3);
            JSONArray listOfPositions = new JSONArray();
            for (int i = 0; i < this.positions_.size(); ++i) {
                MultiStagePosition msp = this.positions_.get(i);
                JSONObject mspData = new JSONObject();
                mspData.put(LABEL_KEY, this.positions_.get(i).getLabel());
                mspData.put(GRID_ROW_KEY, msp.getGridRow());
                mspData.put(GRID_COL_KEY, msp.getGridColumn());
                mspData.put(DEFAULT_XY_STAGE, msp.getDefaultXYStage());
                mspData.put(DEFAULT_Z_STAGE, msp.getDefaultZStage());
                JSONArray devicePosData = new JSONArray();
                for (int j = 0; j < msp.size(); ++j) {
                    StagePosition sp = msp.get(j);
                    JSONObject stage = new JSONObject();
                    stage.put(X_KEY, sp.x);
                    stage.put(Y_KEY, sp.y);
                    stage.put(Z_KEY, sp.z);
                    stage.put(NUMAXES_KEY, sp.numAxes);
                    stage.put(DEVICE_KEY, sp.stageName);
                    devicePosData.put(j, stage);
                }
                mspData.put(DEVARRAY_KEY, devicePosData);
                JSONObject props = new JSONObject();
                String[] keys = msp.getPropertyNames();
                for (int k = 0; k < keys.length; ++k) {
                    String val = msp.getProperty(keys[k]);
                    props.put(keys[k], val);
                }
                mspData.put(PROPERTIES_KEY, props);
                listOfPositions.put(i, mspData);
            }
            meta.put(POSARRAY_KEY, listOfPositions);
            return meta.toString(3);
        }
        catch (JSONException e) {
            throw new MMSerializationException("Unable to serialize XY positition data into formatted string.");
        }
    }

    public void restore(String stream) throws MMSerializationException {
        try {
            JSONObject meta = new JSONObject(stream);
            JSONArray posArray = meta.getJSONArray(POSARRAY_KEY);
            int version = meta.getInt(VERSION_KEY);
            this.positions_.clear();
            for (int i = 0; i < posArray.length(); ++i) {
                JSONObject mspData = posArray.getJSONObject(i);
                MultiStagePosition msp = new MultiStagePosition();
                msp.setLabel(mspData.getString(LABEL_KEY));
                if (version >= 2) {
                    msp.setGridCoordinates(mspData.getInt(GRID_ROW_KEY), mspData.getInt(GRID_COL_KEY));
                }
                if (version >= 3) {
                    msp.setDefaultXYStage(mspData.getString(DEFAULT_XY_STAGE));
                    msp.setDefaultZStage(mspData.getString(DEFAULT_Z_STAGE));
                }
                JSONArray devicePosData = mspData.getJSONArray(DEVARRAY_KEY);
                for (int j = 0; j < devicePosData.length(); ++j) {
                    JSONObject stage = devicePosData.getJSONObject(j);
                    StagePosition pos = new StagePosition();
                    pos.x = stage.getDouble(X_KEY);
                    pos.y = stage.getDouble(Y_KEY);
                    pos.z = stage.getDouble(Z_KEY);
                    pos.stageName = stage.getString(DEVICE_KEY);
                    pos.numAxes = stage.getInt(NUMAXES_KEY);
                    msp.add(pos);
                }
                JSONObject props = mspData.getJSONObject(PROPERTIES_KEY);
                Iterator<String> it = props.keys();
                while (it.hasNext()) {
                    String key = it.next();
                    msp.setProperty(key, props.getString(key));
                }
                this.positions_.add(msp);
            }
        }
        catch (JSONException e) {
            throw new MMSerializationException("Invalid or corrupted serialization data.");
        }
        this.notifyChangeListeners();
    }

    public String generateLabel() {
        return this.generateLabel("Pos");
    }

    public String generateLabel(String proposal) {
        String label = proposal + this.positions_.size();
        int i = 1;
        while (!this.isLabelUnique(label)) {
            label = proposal + (this.positions_.size() + i++);
        }
        return label;
    }

    public boolean isLabelUnique(String label) {
        for (int i = 0; i < this.positions_.size(); ++i) {
            if (this.positions_.get(i).getLabel().compareTo(label) != 0) continue;
            return false;
        }
        return true;
    }

    public void save(String path) throws MMException {
        File f = new File(path);
        try {
            String serList = this.serialize();
            FileWriter fw = new FileWriter(f);
            fw.write(serList);
            fw.close();
        }
        catch (Exception e) {
            throw new MMException(e.getMessage());
        }
    }

    public void load(String path) throws MMException {
        File f = new File(path);
        try {
            StringBuffer contents = new StringBuffer();
            BufferedReader input = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
            this.restore(contents.toString());
        }
        catch (Exception e) {
            throw new MMException(e.getMessage());
        }
        this.notifyChangeListeners();
    }
}

