/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.api;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import mmcorej.CMMCore;
import org.micromanager.api.StagePosition;

public final class MultiStagePosition {
    private ArrayList<StagePosition> stagePosList_ = new ArrayList();
    private String label_ = "Undefined";
    private String defaultZStage_ = "";
    private String defaultXYStage_ = "";
    private int gridRow_ = 0;
    private int gridCol_ = 0;
    private Hashtable<String, String> properties_ = new Hashtable();

    public MultiStagePosition() {
    }

    public MultiStagePosition(String xyStage, double x, double y, String zStage, double z) {
        this();
        StagePosition xyPos = new StagePosition();
        xyPos.numAxes = 2;
        xyPos.stageName = xyStage;
        xyPos.x = x;
        xyPos.y = y;
        this.defaultXYStage_ = xyStage;
        this.add(xyPos);
        StagePosition zPos = new StagePosition();
        zPos.numAxes = 1;
        zPos.stageName = zStage;
        zPos.x = z;
        this.defaultZStage_ = zStage;
        this.add(zPos);
    }

    public static MultiStagePosition newInstance(MultiStagePosition aMps) {
        MultiStagePosition mps = new MultiStagePosition();
        mps.label_ = aMps.label_;
        mps.defaultXYStage_ = aMps.defaultXYStage_;
        mps.defaultZStage_ = aMps.defaultZStage_;
        Enumeration<String> e = aMps.properties_.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String val = aMps.properties_.get(key);
            mps.properties_.put(key, val);
        }
        Iterator<StagePosition> it = aMps.stagePosList_.iterator();
        while (it.hasNext()) {
            mps.add(StagePosition.newInstance(it.next()));
        }
        return mps;
    }

    public void add(StagePosition sp) {
        this.stagePosList_.add(sp);
    }

    public void remove(StagePosition sp) {
        this.stagePosList_.remove(sp);
    }

    public int size() {
        return this.stagePosList_.size();
    }

    public StagePosition get(int idx) {
        return this.stagePosList_.get(idx);
    }

    public void setProperty(String key, String value) {
        this.properties_.put(key, value);
    }

    public String[] getPropertyNames() {
        String[] keys = new String[this.properties_.size()];
        int i = 0;
        Enumeration<String> e = this.properties_.keys();
        while (e.hasMoreElements()) {
            keys[i++] = e.nextElement();
        }
        return keys;
    }

    public boolean hasProperty(String key) {
        return this.properties_.containsKey(key);
    }

    public String getProperty(String key) {
        if (this.properties_.containsKey(key)) {
            return this.properties_.get(key);
        }
        return null;
    }

    public StagePosition get(String stageName) {
        for (int i = 0; i < this.stagePosList_.size(); ++i) {
            StagePosition sp = this.stagePosList_.get(i);
            if (sp.stageName.compareTo(stageName) != 0) continue;
            return sp;
        }
        return null;
    }

    public String getLabel() {
        return this.label_;
    }

    public void setLabel(String lab) {
        this.label_ = lab;
    }

    public void setDefaultZStage(String stage) {
        this.defaultZStage_ = stage;
    }

    public String getDefaultZStage() {
        return this.defaultZStage_;
    }

    public String getDefaultXYStage() {
        return this.defaultXYStage_;
    }

    public void setDefaultXYStage(String stage) {
        this.defaultXYStage_ = stage;
    }

    public static void goToPosition(MultiStagePosition msp, CMMCore core_) throws Exception {
        for (int i = 0; i < msp.size(); ++i) {
            try {
                StagePosition sp = msp.get(i);
                if (sp.numAxes == 1) {
                    core_.setPosition(sp.stageName, sp.x);
                } else if (sp.numAxes == 2) {
                    core_.setXYPosition(sp.stageName, sp.x, sp.y);
                }
                core_.waitForDevice(sp.stageName);
                continue;
            }
            catch (Exception e) {
                throw new Exception("XY stage error");
            }
        }
    }

    public double getX() {
        for (int i = 0; i < this.stagePosList_.size(); ++i) {
            StagePosition sp = this.stagePosList_.get(i);
            if (sp.numAxes != 2 || sp.stageName.compareTo(this.defaultXYStage_) != 0) continue;
            return sp.x;
        }
        return 0.0;
    }

    public double getY() {
        for (int i = 0; i < this.stagePosList_.size(); ++i) {
            StagePosition sp = this.stagePosList_.get(i);
            if (sp.numAxes != 2 || sp.stageName.compareTo(this.defaultXYStage_) != 0) continue;
            return sp.y;
        }
        return 0.0;
    }

    public double getZ() {
        for (int i = 0; i < this.stagePosList_.size(); ++i) {
            StagePosition sp = this.stagePosList_.get(i);
            if (sp.numAxes != 1 || sp.stageName.compareTo(this.defaultZStage_) != 0) continue;
            return sp.x;
        }
        return 0.0;
    }

    public void setGridCoordinates(int row, int col) {
        this.gridRow_ = row;
        this.gridCol_ = col;
    }

    public int getGridRow() {
        return this.gridRow_;
    }

    public int getGridColumn() {
        return this.gridCol_;
    }
}

