/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.api;

import ij.ImagePlus;
import ij.process.ImageProcessor;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.imagedisplay.VirtualAcquisitionDisplay;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class MMWindow {
    private final VirtualAcquisitionDisplay virtAcq_;
    private final ImagePlus imp_;

    public MMWindow(ImagePlus imp) {
        this.imp_ = imp;
        this.virtAcq_ = VirtualAcquisitionDisplay.getDisplay(imp);
    }

    public boolean isMMWindow() {
        return this.virtAcq_ != null;
    }

    public int getNumberOfPositions() {
        if (this.virtAcq_ == null) {
            return 0;
        }
        int nrPositions = 1;
        try {
            nrPositions = this.virtAcq_.getNumPositions();
        }
        catch (JSONException jex) {
            ReportingUtils.logError(jex, "Error in MMWindow.getNumberOfPositions");
        }
        return nrPositions;
    }

    public int getNumberOfChannels() {
        if (this.virtAcq_ == null) {
            return 0;
        }
        return this.virtAcq_.getNumGrayChannels();
    }

    public int getNumberOfSlices() {
        if (this.virtAcq_ == null) {
            return 0;
        }
        return this.virtAcq_.getImagePlus().getNSlices();
    }

    public int getNumberOfFrames() {
        if (this.virtAcq_ == null) {
            return 0;
        }
        return this.virtAcq_.getImagePlus().getNFrames();
    }

    public void setPosition(int position) throws MMScriptException {
        if (position < 1 || position > this.getNumberOfPositions()) {
            throw new MMScriptException("Invalid position requested");
        }
        if (this.virtAcq_ != null) {
            this.virtAcq_.setPosition(position - 1);
        }
    }

    public int getPosition() throws MMScriptException {
        if (this.virtAcq_ != null) {
            return this.virtAcq_.getCurrentPosition() + 1;
        }
        throw new MMScriptException("This is not a MMWindow");
    }

    public ImagePlus getImagePlus(int position) {
        return this.virtAcq_.getImagePlus(position);
    }

    public ImageProcessor getImageProcessor(int channel, int slice, int frame, int position) throws MMScriptException {
        this.setPosition(position);
        if (channel >= this.getNumberOfChannels() || slice >= this.getNumberOfSlices() || frame >= this.getNumberOfFrames()) {
            throw new MMScriptException("Parameters out of bounds");
        }
        if (this.virtAcq_ == null) {
            return null;
        }
        ImagePlus hyperImage = this.virtAcq_.getImagePlus();
        return hyperImage.getImageStack().getProcessor(hyperImage.getStackIndex(channel + 1, slice, frame));
    }

    public JSONObject getSummaryMetaData() {
        return this.virtAcq_.getSummaryMetadata();
    }

    public JSONObject getImageMetadata(int channel, int slice, int frame, int position) {
        return this.virtAcq_.getImageCache().getImageTags(channel, slice, frame, position);
    }

    public TaggedImage getTaggedImage(int channel, int slice, int frame, int position) {
        return this.virtAcq_.getImageCache().getImage(channel, slice, frame, position);
    }
}

