/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.api;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.micromanager.api.ScriptInterface;
import org.micromanager.events.EventManager;
import org.micromanager.events.ProcessorEnabledEvent;
import org.micromanager.utils.ReportingUtils;

public abstract class DataProcessor<E>
extends Thread {
    private BlockingQueue<E> input_;
    private BlockingQueue<E> output_;
    private boolean stopRequested_ = false;
    private boolean started_ = false;
    private boolean isEnabled_ = true;
    protected ScriptInterface gui_;

    protected abstract void process();

    public void makeConfigurationGUI() {
    }

    public void dispose() {
    }

    public void setApp(ScriptInterface gui) {
        this.gui_ = gui;
    }

    @Override
    public void run() {
        this.setStarted(true);
        while (!this.stopRequested_) {
            this.process();
        }
    }

    public synchronized void requestStop() {
        this.stopRequested_ = true;
    }

    private synchronized void setStarted(boolean started) {
        this.started_ = started;
    }

    public synchronized boolean isStarted() {
        return this.started_;
    }

    public synchronized void setInput(BlockingQueue<E> input) {
        this.input_ = input;
    }

    public void setOutput(BlockingQueue<E> output) {
        this.output_ = output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected E poll() {
        while (!this.stopRequested()) {
            try {
                E datum;
                BlockingQueue<E> tmpQueue;
                DataProcessor dataProcessor = this;
                synchronized (dataProcessor) {
                    tmpQueue = this.input_;
                }
                if (tmpQueue != null && (datum = tmpQueue.poll(100L, TimeUnit.MILLISECONDS)) != null) {
                    return datum;
                }
                if (tmpQueue != null) continue;
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                ReportingUtils.logError(ex);
            }
        }
        return null;
    }

    protected void drainTo(Collection<E> data) {
        this.input_.drainTo(data);
    }

    protected void produce(E datum) {
        try {
            this.output_.put(datum);
        }
        catch (InterruptedException ex) {
            ReportingUtils.logError(ex);
        }
    }

    protected synchronized boolean stopRequested() {
        return this.stopRequested_;
    }

    public void setEnabled(boolean isEnabled) {
        if (this.isEnabled_ == isEnabled) {
            return;
        }
        boolean liveWasOn = this.gui_.isLiveModeOn();
        if (liveWasOn) {
            this.gui_.enableLiveMode(false);
        }
        this.isEnabled_ = isEnabled;
        EventManager.post(new ProcessorEnabledEvent(this, isEnabled));
        if (liveWasOn) {
            this.gui_.enableLiveMode(true);
        }
    }

    public boolean getIsEnabled() {
        return this.isEnabled_;
    }
}

