/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.MMStudio;
import org.micromanager.acquisition.InvalidIndexMapException;
import org.micromanager.acquisition.MultipageTiffReader;
import org.micromanager.acquisition.MultipageTiffWriter;
import org.micromanager.acquisition.OMEMetadata;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.imagedisplay.DisplaySettings;
import org.micromanager.utils.ImageLabelComparator;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ProgressBar;
import org.micromanager.utils.ReportingUtils;

public final class TaggedImageStorageMultipageTiff
implements TaggedImageStorage {
    private static final int SPACE_FOR_PARTIAL_OME_MD = 2000;
    private JSONObject summaryMetadata_;
    private String summaryMetadataString_ = null;
    private JSONObject displayAndComments_;
    private boolean newDataSet_;
    private int lastFrameOpenedDataSet_ = -1;
    private String directory_;
    public final boolean omeTiff_;
    private final boolean separateMetadataFile_;
    private boolean splitByXYPosition_ = true;
    private volatile boolean finished_ = false;
    private boolean expectedImageOrder_ = true;
    private int numChannels_;
    private int numSlices_;
    private OMEMetadata omeMetadata_;
    private int lastFrame_ = 0;
    private boolean fixIndexMap_ = false;
    private final boolean fastStorageMode_;
    private int lastAcquiredPosition_ = 0;
    private ThreadPoolExecutor writingExecutor_;
    private ConcurrentHashMap<String, TaggedImage> writePendingImages_ = new ConcurrentHashMap();
    private HashMap<Integer, FileSet> fileSets_;
    private TreeMap<String, MultipageTiffReader> tiffReadersByLabel_;

    public TaggedImageStorageMultipageTiff(String dir, Boolean newDataSet, JSONObject summaryMetadata) throws IOException {
        this(dir, newDataSet, summaryMetadata, MMStudio.getInstance().getMetadataFileWithMultipageTiff(), MMStudio.getInstance().getSeparateFilesForPositionsMPTiff(), true);
    }

    public TaggedImageStorageMultipageTiff(String dir, boolean newDataSet, JSONObject summaryMetadata, boolean separateMDFile, boolean separateFilesForPositions, boolean fastStorageMode) throws IOException {
        this.fastStorageMode_ = fastStorageMode;
        this.omeTiff_ = true;
        this.separateMetadataFile_ = separateMDFile;
        this.splitByXYPosition_ = separateFilesForPositions;
        this.newDataSet_ = newDataSet;
        this.directory_ = dir;
        this.tiffReadersByLabel_ = new TreeMap(new ImageLabelComparator());
        this.setSummaryMetadata(summaryMetadata);
        if (!this.newDataSet_) {
            this.openExistingDataSet();
        }
    }

    private void processSummaryMD() {
        try {
            this.displayAndComments_ = DisplaySettings.getDisplaySettingsFromSummary(this.summaryMetadata_);
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex, "Problems setting displaySettings from Summery");
        }
        if (this.newDataSet_) {
            try {
                this.numChannels_ = MDUtils.getNumChannels(this.summaryMetadata_);
                this.numSlices_ = MDUtils.getNumSlices(this.summaryMetadata_);
            }
            catch (Exception ex) {
                ReportingUtils.logError("Error estimating total number of image planes");
            }
        }
    }

    public ThreadPoolExecutor getWritingExecutor() {
        return this.writingExecutor_;
    }

    boolean slicesFirst() {
        return ((ImageLabelComparator)this.tiffReadersByLabel_.comparator()).getSlicesFirst();
    }

    boolean timeFirst() {
        return ((ImageLabelComparator)this.tiffReadersByLabel_.comparator()).getTimeFirst();
    }

    public boolean getFixIndexMap() {
        return this.fixIndexMap_;
    }

    public void setFixIndexMap() {
        this.fixIndexMap_ = true;
    }

    private void openExistingDataSet() {
        MultipageTiffReader reader = null;
        File dir = new File(this.directory_);
        ProgressBar progressBar = new ProgressBar("Reading " + this.directory_, 0, dir.listFiles().length);
        int numRead = 0;
        progressBar.setProgress(numRead);
        progressBar.setVisible(true);
        for (File f : dir.listFiles()) {
            if (f.getName().endsWith(".tif") || f.getName().endsWith(".TIF")) {
                reader = this.loadFile(f);
            }
            progressBar.setProgress(++numRead);
        }
        progressBar.setVisible(false);
        if (reader != null) {
            this.setSummaryMetadata(reader.getSummaryMetadata(), true);
            this.displayAndComments_ = reader.getDisplayAndComments();
        }
        progressBar.setProgress(1);
        progressBar.setVisible(false);
    }

    private MultipageTiffReader loadFile(File f) {
        MultipageTiffReader reader = null;
        try {
            try {
                reader = new MultipageTiffReader(f);
            }
            catch (InvalidIndexMapException e) {
                int choice = JOptionPane.showConfirmDialog(null, "This file cannot be opened bcause it appears to have \nbeen improperly saved. Would you like Micro-Manger to attempt to fix it?", "Micro-Manager", 0);
                if (choice != 0) {
                    return null;
                }
                reader = new MultipageTiffReader(f, true);
                reader.close();
                reader = new MultipageTiffReader(f);
            }
            Set<String> labels = reader.getIndexKeys();
            for (String label : labels) {
                this.tiffReadersByLabel_.put(label, reader);
                int frameIndex = Integer.parseInt(label.split("_")[2]);
                this.lastFrameOpenedDataSet_ = Math.max(frameIndex, this.lastFrameOpenedDataSet_);
            }
        }
        catch (IOException ex) {
            ReportingUtils.showError("Couldn't open file: " + f.toString());
        }
        return reader;
    }

    @Override
    public TaggedImage getImage(int channelIndex, int sliceIndex, int frameIndex, int positionIndex) {
        String label = MDUtils.generateLabel(channelIndex, sliceIndex, frameIndex, positionIndex);
        TaggedImage image = this.writePendingImages_.get(label);
        if (image != null) {
            return image;
        }
        MultipageTiffReader reader = this.tiffReadersByLabel_.get(label);
        if (reader == null) {
            return null;
        }
        return reader.readImage(label);
    }

    @Override
    public JSONObject getImageTags(int channelIndex, int sliceIndex, int frameIndex, int positionIndex) {
        TaggedImage image = this.getImage(channelIndex, sliceIndex, frameIndex, positionIndex);
        if (image == null) {
            return null;
        }
        return image.tags;
    }

    public void overwritePixels(Object pix, int channel, int slice, int frame, int position) throws IOException {
        this.fileSets_.get(position).overwritePixels(pix, channel, slice, frame, position);
    }

    @Override
    public void putImage(TaggedImage taggedImage) throws MMException, IOException {
        final String label = MDUtils.getLabel(taggedImage.tags);
        this.startWritingTask(label, taggedImage);
        this.writePendingImages_.put(label, taggedImage);
        this.writingExecutor_.submit(new Runnable(){

            @Override
            public void run() {
                TaggedImageStorageMultipageTiff.this.writePendingImages_.remove(label);
            }
        });
    }

    private void startWritingTask(String label, TaggedImage taggedImage) throws MMException, IOException {
        int frame;
        if (!this.newDataSet_) {
            ReportingUtils.showError("Tried to write image to a finished data set");
            throw new MMException("This ImageFileManager is read-only.");
        }
        if (this.fastStorageMode_ && this.writingExecutor_ == null) {
            this.writingExecutor_ = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>());
        }
        int fileSetIndex = 0;
        if (this.splitByXYPosition_) {
            try {
                fileSetIndex = MDUtils.getPositionIndex(taggedImage.tags);
            }
            catch (JSONException ex) {
                ReportingUtils.logError(ex);
            }
        }
        if (this.fileSets_ == null) {
            try {
                this.fileSets_ = new HashMap();
                JavaUtils.createDirectory(this.directory_);
            }
            catch (Exception ex) {
                ReportingUtils.logError(ex);
            }
        }
        if (this.omeTiff_ && this.omeMetadata_ == null) {
            this.omeMetadata_ = new OMEMetadata(this);
        }
        if (this.fileSets_.get(fileSetIndex) == null) {
            this.fileSets_.put(fileSetIndex, new FileSet(taggedImage.tags, this));
        }
        FileSet set = this.fileSets_.get(fileSetIndex);
        try {
            set.writeImage(taggedImage);
            this.tiffReadersByLabel_.put(label, set.getCurrentReader());
        }
        catch (IOException ex) {
            ReportingUtils.showError("problem writing image to file");
        }
        try {
            frame = MDUtils.getFrameIndex(taggedImage.tags);
        }
        catch (JSONException ex) {
            frame = 0;
        }
        this.lastFrameOpenedDataSet_ = Math.max(frame, this.lastFrameOpenedDataSet_);
    }

    @Override
    public Set<String> imageKeys() {
        return this.tiffReadersByLabel_.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void finished() {
        block17: {
            if (this.finished_) {
                return;
            }
            this.newDataSet_ = false;
            if (this.fileSets_ == null) {
                this.finished_ = true;
                return;
            }
            ProgressBar progressBar = new ProgressBar("Finishing Files", 0, this.fileSets_.size());
            try {
                int count = 0;
                progressBar.setProgress(count);
                progressBar.setVisible(true);
                for (FileSet p : this.fileSets_.values()) {
                    p.finishAbortedAcqIfNeeded();
                }
                try {
                    for (int p = 0; p <= this.lastAcquiredPosition_; ++p) {
                        int currentFrame = this.fileSets_.get(this.splitByXYPosition_ ? p : 0).getCurrentFrame();
                        this.omeMetadata_.setNumFrames(p, currentFrame + 1);
                        this.omeMetadata_.fillInMissingTiffDatas(this.lastAcquiredFrame(), p);
                    }
                }
                catch (Exception e) {
                    ReportingUtils.logError("Couldn't fill in missing frames in OME");
                }
                String fullOMEXMLMetadata = this.omeMetadata_.toString();
                int length = fullOMEXMLMetadata.length();
                String uuid = null;
                String filename = null;
                FileSet master = null;
                for (FileSet p : this.fileSets_.values()) {
                    if (!p.hasSpaceForFullOMEXML(length)) continue;
                    uuid = p.getCurrentUUID();
                    filename = p.getCurrentFilename();
                    p.finished(fullOMEXMLMetadata);
                    master = p;
                    progressBar.setProgress(++count);
                    break;
                }
                if (uuid == null) {
                    filename = "OMEXMLMetadata.ome";
                    uuid = "urn:uuid:" + UUID.randomUUID().toString();
                    PrintWriter pw = new PrintWriter(this.directory_ + File.separator + filename);
                    pw.print(fullOMEXMLMetadata);
                    pw.close();
                }
                String partialOME = OMEMetadata.getOMEStringPointerToMasterFile(filename, uuid);
                for (FileSet p : this.fileSets_.values()) {
                    if (p == master) continue;
                    p.finished(partialOME);
                    progressBar.setProgress(++count);
                }
                if (this.writingExecutor_ == null || this.writingExecutor_.isShutdown()) break block17;
                this.writingExecutor_.shutdown();
                try {
                    while (!this.writingExecutor_.awaitTermination(4L, TimeUnit.SECONDS)) {
                        ReportingUtils.logMessage("Waiting for image stack file finishing to complete");
                    }
                }
                catch (InterruptedException e) {
                    ReportingUtils.logError("File finishing thread interrupted");
                    Thread.interrupted();
                }
            }
            catch (IOException ex) {
                ReportingUtils.logError(ex);
            }
            finally {
                progressBar.setVisible(false);
            }
        }
        this.finished_ = true;
    }

    @Override
    public void close() {
        for (MultipageTiffReader r : new HashSet<MultipageTiffReader>(this.tiffReadersByLabel_.values())) {
            try {
                r.close();
            }
            catch (IOException ex) {
                ReportingUtils.logError(ex);
            }
        }
    }

    @Override
    public boolean isFinished() {
        return !this.newDataSet_;
    }

    @Override
    public void setSummaryMetadata(JSONObject md) {
        this.setSummaryMetadata(md, false);
    }

    private void setSummaryMetadata(JSONObject md, boolean showProgress) {
        this.summaryMetadata_ = md;
        this.summaryMetadataString_ = null;
        if (this.summaryMetadata_ != null) {
            this.summaryMetadataString_ = md.toString();
            boolean slicesFirst = this.summaryMetadata_.optBoolean("SlicesFirst", true);
            boolean timeFirst = this.summaryMetadata_.optBoolean("TimeFirst", false);
            TreeMap<String, MultipageTiffReader> oldImageMap = this.tiffReadersByLabel_;
            this.tiffReadersByLabel_ = new TreeMap(new ImageLabelComparator(slicesFirst, timeFirst));
            if (showProgress) {
                ProgressBar progressBar = new ProgressBar("Building image location map", 0, oldImageMap.keySet().size());
                progressBar.setProgress(0);
                progressBar.setVisible(true);
                int i = 1;
                for (String label : oldImageMap.keySet()) {
                    this.tiffReadersByLabel_.put(label, oldImageMap.get(label));
                    progressBar.setProgress(i);
                    ++i;
                }
                progressBar.setVisible(false);
            } else {
                this.tiffReadersByLabel_.putAll(oldImageMap);
            }
            if (this.summaryMetadata_ != null && this.summaryMetadata_.length() > 0) {
                this.processSummaryMD();
            }
        }
    }

    @Override
    public JSONObject getSummaryMetadata() {
        return this.summaryMetadata_;
    }

    public String getSummaryMetadataString() {
        return this.summaryMetadataString_;
    }

    @Override
    public JSONObject getDisplayAndComments() {
        return this.displayAndComments_;
    }

    @Override
    public void setDisplayAndComments(JSONObject settings) {
        this.displayAndComments_ = settings;
    }

    @Override
    public void writeDisplaySettings() {
        for (MultipageTiffReader r : new HashSet<MultipageTiffReader>(this.tiffReadersByLabel_.values())) {
            try {
                r.rewriteDisplaySettings(this.displayAndComments_.getJSONArray("Channels"));
                r.rewriteComments(this.displayAndComments_.getJSONObject("Comments"));
            }
            catch (JSONException ex) {
                ReportingUtils.logError("Error writing display settings");
            }
            catch (IOException ex) {
                ReportingUtils.logError(ex);
            }
        }
    }

    @Override
    public String getDiskLocation() {
        return this.directory_;
    }

    @Override
    public int lastAcquiredFrame() {
        if (this.newDataSet_) {
            return this.lastFrame_;
        }
        return this.lastFrameOpenedDataSet_;
    }

    @Override
    public long getDataSetSize() {
        File dir = new File(this.directory_);
        LinkedList<File> list = new LinkedList<File>();
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                for (File fi : f.listFiles()) {
                    list.add(f);
                }
                continue;
            }
            list.add(f);
        }
        long size = 0L;
        for (File f : list) {
            size += f.length();
        }
        return size;
    }

    public boolean hasExpectedImageOrder() {
        return false;
    }

    private class FileSet {
        private LinkedList<MultipageTiffWriter> tiffWriters_ = new LinkedList();
        private FileWriter mdWriter_;
        private String baseFilename_;
        private String currentTiffFilename_;
        private String currentTiffUUID_;
        private String metadataFileFullPath_;
        private boolean finished_ = false;
        private int ifdCount_ = 0;
        private TaggedImageStorageMultipageTiff mpTiff_;
        int nextExpectedChannel_ = 0;
        int nextExpectedSlice_ = 0;
        int nextExpectedFrame_ = 0;
        int currentFrame_ = 0;

        public FileSet(JSONObject firstImageTags, TaggedImageStorageMultipageTiff mpt) throws IOException {
            this.mpTiff_ = mpt;
            this.baseFilename_ = this.createBaseFilename(firstImageTags);
            this.currentTiffFilename_ = this.baseFilename_ + (TaggedImageStorageMultipageTiff.this.omeTiff_ ? ".ome.tif" : ".tif");
            this.currentTiffUUID_ = "urn:uuid:" + UUID.randomUUID().toString();
            this.tiffWriters_.add(new MultipageTiffWriter(TaggedImageStorageMultipageTiff.this.directory_, this.currentTiffFilename_, TaggedImageStorageMultipageTiff.this.summaryMetadata_, mpt, TaggedImageStorageMultipageTiff.this.fastStorageMode_, TaggedImageStorageMultipageTiff.this.splitByXYPosition_));
            try {
                if (TaggedImageStorageMultipageTiff.this.separateMetadataFile_) {
                    this.startMetadataFile();
                }
            }
            catch (JSONException ex) {
                ReportingUtils.showError("Problem with summary metadata");
            }
        }

        public String getCurrentUUID() {
            return this.currentTiffUUID_;
        }

        public String getCurrentFilename() {
            return this.currentTiffFilename_;
        }

        public boolean hasSpaceForFullOMEXML(int mdLength) {
            return this.tiffWriters_.getLast().hasSpaceForFullOMEMetadata(mdLength);
        }

        public void finished(String omeXML) throws IOException {
            if (this.finished_) {
                return;
            }
            if (TaggedImageStorageMultipageTiff.this.separateMetadataFile_) {
                try {
                    this.finishMetadataFile();
                }
                catch (JSONException ex) {
                    ReportingUtils.logError("Problem finishing metadata.txt");
                }
            }
            this.tiffWriters_.getLast().finish();
            for (MultipageTiffWriter w : this.tiffWriters_) {
                w.close(omeXML);
            }
            this.finished_ = true;
        }

        public MultipageTiffReader getCurrentReader() {
            return this.tiffWriters_.getLast().getReader();
        }

        public void overwritePixels(Object pixels, int channel, int slice, int frame, int position) throws IOException {
            for (MultipageTiffWriter w : this.tiffWriters_) {
                if (!w.getIndexMap().containsKey(MDUtils.generateLabel(channel, slice, frame, position))) continue;
                w.overwritePixels(pixels, channel, slice, frame, position);
            }
        }

        public int getCurrentFrame() {
            return this.currentFrame_;
        }

        public void writeImage(TaggedImage img) throws IOException {
            if (!this.tiffWriters_.getLast().hasSpaceToWrite(img, TaggedImageStorageMultipageTiff.this.omeTiff_ ? 2000 : 0)) {
                this.tiffWriters_.getLast().finish();
                this.currentTiffFilename_ = this.baseFilename_ + "_" + this.tiffWriters_.size() + (TaggedImageStorageMultipageTiff.this.omeTiff_ ? ".ome.tif" : ".tif");
                this.currentTiffUUID_ = "urn:uuid:" + UUID.randomUUID().toString();
                this.ifdCount_ = 0;
                this.tiffWriters_.add(new MultipageTiffWriter(TaggedImageStorageMultipageTiff.this.directory_, this.currentTiffFilename_, TaggedImageStorageMultipageTiff.this.summaryMetadata_, this.mpTiff_, TaggedImageStorageMultipageTiff.this.fastStorageMode_, TaggedImageStorageMultipageTiff.this.splitByXYPosition_));
            }
            try {
                img.tags.put("FileName", this.currentTiffFilename_);
            }
            catch (JSONException ex) {
                ReportingUtils.logError("Error adding filename to metadata");
            }
            this.tiffWriters_.getLast().writeImage(img);
            if (TaggedImageStorageMultipageTiff.this.expectedImageOrder_) {
                if (TaggedImageStorageMultipageTiff.this.splitByXYPosition_) {
                    this.checkForExpectedImageOrder(img.tags);
                } else {
                    TaggedImageStorageMultipageTiff.this.expectedImageOrder_ = false;
                }
            }
            if (TaggedImageStorageMultipageTiff.this.omeTiff_) {
                try {
                    int position;
                    int frame = MDUtils.getFrameIndex(img.tags);
                    try {
                        position = MDUtils.getPositionIndex(img.tags);
                    }
                    catch (Exception e) {
                        position = 0;
                    }
                    if (frame > this.currentFrame_) {
                        TaggedImageStorageMultipageTiff.this.omeMetadata_.fillInMissingTiffDatas(this.currentFrame_, position);
                    }
                    this.currentFrame_ = frame;
                    TaggedImageStorageMultipageTiff.this.omeMetadata_.addImageTagsToOME(img.tags, this.ifdCount_, this.baseFilename_, this.currentTiffFilename_, this.currentTiffUUID_);
                }
                catch (Exception ex) {
                    ReportingUtils.logError("Problem writing OME metadata");
                }
            }
            try {
                int frame = MDUtils.getFrameIndex(img.tags);
                TaggedImageStorageMultipageTiff.this.lastFrame_ = Math.max(frame, TaggedImageStorageMultipageTiff.this.lastFrame_);
            }
            catch (JSONException ex) {
                ReportingUtils.showError("Couldn't find frame index in image tags");
            }
            try {
                int pos = MDUtils.getPositionIndex(img.tags);
                TaggedImageStorageMultipageTiff.this.lastAcquiredPosition_ = Math.max(pos, TaggedImageStorageMultipageTiff.this.lastAcquiredPosition_);
            }
            catch (JSONException ex) {
                ReportingUtils.showError("Couldn't find position index in image tags");
            }
            try {
                if (TaggedImageStorageMultipageTiff.this.separateMetadataFile_) {
                    this.writeToMetadataFile(img.tags);
                }
            }
            catch (JSONException ex) {
                ReportingUtils.logError("Problem with image metadata");
            }
            ++this.ifdCount_;
        }

        private void writeToMetadataFile(JSONObject md) throws JSONException {
            try {
                this.mdWriter_.write(",\n\"FrameKey-" + MDUtils.getFrameIndex(md) + "-" + MDUtils.getChannelIndex(md) + "-" + MDUtils.getSliceIndex(md) + "\": ");
                this.mdWriter_.write(md.toString(2));
            }
            catch (IOException ex) {
                ReportingUtils.logError("Problem writing to metadata.txt file");
            }
        }

        private void startMetadataFile() throws JSONException {
            this.metadataFileFullPath_ = TaggedImageStorageMultipageTiff.this.directory_ + "/" + this.baseFilename_ + "_metadata.txt";
            try {
                this.mdWriter_ = new FileWriter(this.metadataFileFullPath_);
                this.mdWriter_.write("{\n");
                this.mdWriter_.write("\"Summary\": ");
                this.mdWriter_.write(TaggedImageStorageMultipageTiff.this.summaryMetadata_.toString(2));
            }
            catch (IOException ex) {
                ReportingUtils.logError("Problem creating metadata.txt file");
            }
        }

        private void finishMetadataFile() throws JSONException {
            try {
                this.mdWriter_.write("\n}\n");
                this.mdWriter_.close();
            }
            catch (IOException ex) {
                ReportingUtils.logError("Problem creating metadata.txt file");
            }
        }

        private String createBaseFilename(JSONObject firstImageTags) {
            String baseFilename;
            try {
                String prefix = TaggedImageStorageMultipageTiff.this.summaryMetadata_.getString("Prefix");
                baseFilename = prefix.length() == 0 ? "MMStack" : prefix + "_MMStack";
            }
            catch (JSONException ex) {
                ReportingUtils.logError("Can't find Prefix in summary metadata");
                baseFilename = "MMStack";
            }
            if (TaggedImageStorageMultipageTiff.this.splitByXYPosition_) {
                try {
                    baseFilename = MDUtils.hasPositionName(firstImageTags) ? baseFilename + "_" + MDUtils.getPositionName(firstImageTags) : baseFilename + "_Pos" + MDUtils.getPositionIndex(firstImageTags);
                }
                catch (JSONException ex) {
                    ReportingUtils.showError("No position name or index in metadata");
                }
            }
            return baseFilename;
        }

        private void finishAbortedAcqIfNeeded() {
            if (TaggedImageStorageMultipageTiff.this.expectedImageOrder_ && TaggedImageStorageMultipageTiff.this.splitByXYPosition_ && !TaggedImageStorageMultipageTiff.this.timeFirst()) {
                try {
                    this.completeFrameWithBlankImages(TaggedImageStorageMultipageTiff.this.lastAcquiredFrame());
                }
                catch (Exception e) {
                    ReportingUtils.logError("Problem finishing aborted acq with blank images");
                }
            }
        }

        private void completeFrameWithBlankImages(int frame) throws JSONException, MMScriptException {
            int numFrames = MDUtils.getNumFrames(TaggedImageStorageMultipageTiff.this.summaryMetadata_);
            int numSlices = MDUtils.getNumSlices(TaggedImageStorageMultipageTiff.this.summaryMetadata_);
            int numChannels = MDUtils.getNumChannels(TaggedImageStorageMultipageTiff.this.summaryMetadata_);
            if (numFrames > frame + 1) {
                TreeSet<String> writtenImages = new TreeSet<String>();
                for (MultipageTiffWriter w : this.tiffWriters_) {
                    writtenImages.addAll(w.getIndexMap().keySet());
                    w.setAbortedNumFrames(frame + 1);
                }
                int positionIndex = MDUtils.getIndices((String)writtenImages.first())[3];
                if (TaggedImageStorageMultipageTiff.this.omeTiff_) {
                    TaggedImageStorageMultipageTiff.this.omeMetadata_.setNumFrames(positionIndex, frame + 1);
                }
                TreeSet<String> lastFrameLabels = new TreeSet<String>();
                for (int c = 0; c < numChannels; ++c) {
                    for (int z = 0; z < numSlices; ++z) {
                        lastFrameLabels.add(MDUtils.generateLabel(c, z, frame, positionIndex));
                    }
                }
                lastFrameLabels.removeAll(writtenImages);
                try {
                    for (String label : lastFrameLabels) {
                        this.tiffWriters_.getLast().writeBlankImage(label);
                        if (!TaggedImageStorageMultipageTiff.this.omeTiff_) continue;
                        JSONObject dummyTags = new JSONObject();
                        int channel = Integer.parseInt(label.split("_")[0]);
                        int slice = Integer.parseInt(label.split("_")[1]);
                        MDUtils.setChannelIndex(dummyTags, channel);
                        MDUtils.setFrameIndex(dummyTags, frame);
                        MDUtils.setSliceIndex(dummyTags, slice);
                        TaggedImageStorageMultipageTiff.this.omeMetadata_.addImageTagsToOME(dummyTags, this.ifdCount_, this.baseFilename_, this.currentTiffFilename_, this.currentTiffUUID_);
                    }
                }
                catch (IOException ex) {
                    ReportingUtils.logError("problem writing dummy image");
                }
            }
        }

        void checkForExpectedImageOrder(JSONObject tags) {
            try {
                int channel = MDUtils.getChannelIndex(tags);
                int frame = MDUtils.getFrameIndex(tags);
                int slice = MDUtils.getSliceIndex(tags);
                if (slice != this.nextExpectedSlice_ || channel != this.nextExpectedChannel_ || frame != this.nextExpectedFrame_) {
                    TaggedImageStorageMultipageTiff.this.expectedImageOrder_ = false;
                }
                if (TaggedImageStorageMultipageTiff.this.slicesFirst()) {
                    this.nextExpectedSlice_ = slice + 1;
                    if (this.nextExpectedSlice_ == TaggedImageStorageMultipageTiff.this.numSlices_) {
                        this.nextExpectedSlice_ = 0;
                        this.nextExpectedChannel_ = channel + 1;
                        if (this.nextExpectedChannel_ == TaggedImageStorageMultipageTiff.this.numChannels_) {
                            this.nextExpectedChannel_ = 0;
                            this.nextExpectedFrame_ = frame + 1;
                        }
                    }
                } else {
                    this.nextExpectedChannel_ = channel + 1;
                    if (this.nextExpectedChannel_ == TaggedImageStorageMultipageTiff.this.numChannels_) {
                        this.nextExpectedChannel_ = 0;
                        this.nextExpectedSlice_ = slice + 1;
                        if (this.nextExpectedSlice_ == TaggedImageStorageMultipageTiff.this.numSlices_) {
                            this.nextExpectedSlice_ = 0;
                            this.nextExpectedFrame_ = frame + 1;
                        }
                    }
                }
            }
            catch (JSONException ex) {
                ReportingUtils.logError("Couldnt find channel, slice, or frame index in Image tags");
                TaggedImageStorageMultipageTiff.this.expectedImageOrder_ = false;
            }
        }
    }
}

