/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.ReportingUtils;

public class TaggedImageStorageLive
implements TaggedImageStorage {
    private HashMap<Integer, TaggedImage> channelToImage_ = new HashMap();
    private JSONObject summaryMetadata_ = new JSONObject();
    private JSONObject displayAndComments_ = new JSONObject();

    @Override
    public TaggedImage getImage(int channel, int slice, int frame, int position) {
        if (this.channelToImage_.containsKey(channel)) {
            TaggedImage result = this.channelToImage_.get(channel);
            try {
                MDUtils.setSliceIndex(result.tags, slice);
                MDUtils.setFrameIndex(result.tags, frame);
                MDUtils.setPositionIndex(result.tags, position);
            }
            catch (JSONException e) {
                ReportingUtils.logError(e, "Couldn't adjust image's location data");
            }
            return result;
        }
        return null;
    }

    @Override
    public JSONObject getImageTags(int channel, int slice, int frame, int position) {
        TaggedImage image = this.getImage(channel, slice, frame, position);
        if (image != null) {
            return image.tags;
        }
        return null;
    }

    @Override
    public void putImage(TaggedImage image) {
        try {
            int channel = MDUtils.getChannelIndex(image.tags);
            this.channelToImage_.put(channel, image);
        }
        catch (JSONException e) {
            ReportingUtils.logError(e, "Couldn't extract channel from tags");
        }
    }

    @Override
    public Set<String> imageKeys() {
        HashSet<String> result = new HashSet<String>();
        for (int channel : this.channelToImage_.keySet()) {
            result.add(String.format("%d_0_0_0", channel));
        }
        return result;
    }

    @Override
    public void finished() {
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public void setSummaryMetadata(JSONObject summary) {
        this.summaryMetadata_ = summary;
    }

    @Override
    public JSONObject getSummaryMetadata() {
        return this.summaryMetadata_;
    }

    @Override
    public void setDisplayAndComments(JSONObject settings) {
        this.displayAndComments_ = settings;
    }

    @Override
    public JSONObject getDisplayAndComments() {
        return this.displayAndComments_;
    }

    @Override
    public void close() {
    }

    @Override
    public String getDiskLocation() {
        return null;
    }

    @Override
    public int lastAcquiredFrame() {
        return 0;
    }

    @Override
    public long getDataSetSize() {
        return 0L;
    }

    @Override
    public void writeDisplaySettings() {
    }
}

