/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileSaver;
import ij.io.Opener;
import ij.io.TiffDecoder;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.MMStudio;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.utils.ImageLabelComparator;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.TextUtils;

public class TaggedImageStorageDiskDefault
implements TaggedImageStorage {
    private final String dir_;
    private boolean firstElement_;
    private HashMap<Integer, Writer> metadataStreams_;
    private boolean newDataSet_;
    private JSONObject summaryMetadata_;
    private TreeMap<String, String> filenameTable_;
    private HashMap<String, JSONObject> metadataTable_ = null;
    private JSONObject displaySettings_;
    private int lastFrame_ = -1;
    private Thread shutdownHook_;
    private HashMap<Integer, String> positionNames_;

    public TaggedImageStorageDiskDefault(String dir) throws Exception {
        this(dir, false, null);
    }

    public TaggedImageStorageDiskDefault(String dir, Boolean newDataSet, JSONObject summaryMetadata) throws Exception {
        this.dir_ = dir;
        this.newDataSet_ = newDataSet;
        this.filenameTable_ = new TreeMap(new ImageLabelComparator());
        this.metadataStreams_ = new HashMap();
        this.metadataTable_ = new HashMap();
        this.displaySettings_ = new JSONObject();
        this.positionNames_ = new HashMap();
        this.setSummaryMetadata(summaryMetadata);
        if (!this.newDataSet_) {
            this.openExistingDataSet();
        }
        this.shutdownHook_ = new Thread(){

            @Override
            public void run() {
                TaggedImageStorageDiskDefault.this.writeDisplaySettings();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook_);
    }

    @Override
    public int lastAcquiredFrame() {
        return this.lastFrame_;
    }

    private String getPosition(TaggedImage taggedImg) {
        return this.getPosition(taggedImg.tags);
    }

    private String getPosition(JSONObject tags) {
        try {
            String pos = MDUtils.getPositionName(tags);
            if (pos == null) {
                return "";
            }
            return pos;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public void putImage(TaggedImage taggedImg) throws MMException {
        try {
            if (!this.newDataSet_) {
                throw new MMException("This ImageFileManager is read-only.");
            }
            if (!this.metadataStreams_.containsKey(MDUtils.getPositionIndex(taggedImg.tags))) {
                try {
                    this.openNewDataSet(taggedImg);
                }
                catch (Exception ex) {
                    ReportingUtils.logError(ex);
                }
            }
            JSONObject md = taggedImg.tags;
            Object img = taggedImg.pix;
            String tiffFileName = this.createFileName(md);
            MDUtils.setFileName(md, tiffFileName);
            String fileName = tiffFileName;
            try {
                String posName = this.positionNames_.get(MDUtils.getPositionIndex(md));
                if (posName != null && posName.length() > 0 && !posName.contentEquals("null")) {
                    JavaUtils.createDirectory(this.dir_ + "/" + posName);
                    fileName = posName + "/" + tiffFileName;
                } else {
                    fileName = tiffFileName;
                }
            }
            catch (Exception ex) {
                ReportingUtils.logError(ex);
            }
            File saveFile = new File(this.dir_, fileName);
            if (saveFile.exists()) {
                MMStudio.getInstance().stopAllActivity();
                throw new IOException("Image saving failed: " + saveFile.getAbsolutePath());
            }
            this.saveImageFile(img, md, this.dir_, fileName);
            this.writeFrameMetadata(md);
            String label = MDUtils.getLabel(md);
            this.filenameTable_.put(label, fileName);
        }
        catch (Exception ex) {
            ReportingUtils.showError(ex);
        }
    }

    @Override
    public TaggedImage getImage(int channel, int slice, int frame, int position) {
        String label = MDUtils.generateLabel(channel, slice, frame, position);
        if (this.filenameTable_.get(label) == null) {
            return null;
        }
        ImagePlus imp = new Opener().openImage(this.dir_ + "/" + this.filenameTable_.get(label));
        if (imp != null) {
            try {
                Object img;
                JSONObject md;
                ImageProcessor proc;
                block12: {
                    proc = imp.getProcessor();
                    md = null;
                    try {
                        md = imp.getProperty("Info") != null ? new JSONObject((String)imp.getProperty("Info")) : this.metadataTable_.get(label);
                    }
                    catch (Exception e) {
                        if (this.metadataTable_.size() <= 0) break block12;
                        md = this.metadataTable_.get(label);
                        return null;
                    }
                }
                String pixelType = MDUtils.getPixelType(md);
                if (pixelType.contentEquals("GRAY8") || pixelType.contentEquals("GRAY16")) {
                    img = proc.getPixels();
                } else if (pixelType.contentEquals("RGB32")) {
                    img = proc.getPixels();
                    img = ImageUtils.convertRGB32IntToBytes((int[])img);
                } else if (pixelType.contentEquals("RGB64")) {
                    ImageStack stack = ((CompositeImage)imp).getStack();
                    short[] r = (short[])stack.getProcessor(1).getPixels();
                    short[] g = (short[])stack.getProcessor(2).getPixels();
                    short[] b = (short[])stack.getProcessor(3).getPixels();
                    short[][] planes = new short[][]{r, g, b};
                    img = ImageUtils.getRGB64PixelsFromColorPlanes(planes);
                } else {
                    return null;
                }
                TaggedImage taggedImg = new TaggedImage(img, md);
                return taggedImg;
            }
            catch (Exception ex) {
                ReportingUtils.logError(ex);
                return null;
            }
        }
        return null;
    }

    @Override
    public JSONObject getImageTags(int channel, int slice, int frame, int position) {
        String label = MDUtils.generateLabel(channel, slice, frame, position);
        TiffDecoder td = new TiffDecoder(this.dir_, this.filenameTable_.get(label));
        try {
            return new JSONObject(td.getTiffInfo()[0].info);
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
            return null;
        }
    }

    @Override
    public Set<String> imageKeys() {
        return this.filenameTable_.keySet();
    }

    private String createFileName(JSONObject md) {
        try {
            int slice;
            String channel;
            int frame;
            try {
                frame = MDUtils.getFrameIndex(md);
            }
            catch (Exception e) {
                frame = 0;
            }
            try {
                channel = MDUtils.getChannelName(md);
            }
            catch (Exception e) {
                channel = "";
            }
            try {
                slice = MDUtils.getSliceIndex(md);
            }
            catch (Exception e) {
                slice = 0;
            }
            return String.format("img_%09d_%s_%03d.tif", frame, channel, slice);
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
            return "";
        }
    }

    private void writeFrameMetadata(JSONObject md) {
        try {
            String title = "FrameKey-" + MDUtils.getFrameIndex(md) + "-" + MDUtils.getChannelIndex(md) + "-" + MDUtils.getSliceIndex(md);
            int pos = MDUtils.getPositionIndex(md);
            this.writeMetadata(pos, md, title);
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
        }
    }

    private void writeMetadata(int pos, JSONObject md, String title) {
        try {
            Writer metadataStream = this.metadataStreams_.get(pos);
            if (!this.firstElement_) {
                metadataStream.write(",\n");
            }
            metadataStream.write("\"" + title + "\": ");
            metadataStream.write(md.toString(2));
            metadataStream.flush();
            this.firstElement_ = false;
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
    }

    private void saveImageFile(Object img, JSONObject md, String path, String tiffFileName) {
        try {
            int width = MDUtils.getWidth(md);
            int height = MDUtils.getHeight(md);
            String pixelType = MDUtils.getPixelType(md);
            if (pixelType.equals("GRAY8")) {
                ByteProcessor ip = new ByteProcessor(width, height);
                ip.setPixels((Object)((byte[])img));
                this.saveImageProcessor((ImageProcessor)ip, md, path, tiffFileName);
            } else if (pixelType.equals("GRAY16")) {
                ShortProcessor ip = new ShortProcessor(width, height);
                ip.setPixels((Object)((short[])img));
                this.saveImageProcessor((ImageProcessor)ip, md, path, tiffFileName);
            } else if (pixelType.equals("RGB32")) {
                byte[][] planes = ImageUtils.getColorPlanesFromRGB32((byte[])img);
                ColorProcessor cp = new ColorProcessor(width, height);
                cp.setRGB(planes[0], planes[1], planes[2]);
                this.saveImageProcessor((ImageProcessor)cp, md, path, tiffFileName);
            } else if (pixelType.equals("RGB64")) {
                short[][] planes = ImageUtils.getColorPlanesFromRGB64((short[])img);
                ImageStack stack = new ImageStack(width, height);
                stack.addSlice("Red", (Object)planes[0]);
                stack.addSlice("Green", (Object)planes[1]);
                stack.addSlice("Blue", (Object)planes[2]);
                ImagePlus imp = new ImagePlus(path + "/" + tiffFileName, stack);
                imp.setDimensions(3, 1, 1);
                imp = new CompositeImage(imp, 2);
                this.saveImagePlus(imp, md, path, tiffFileName);
            }
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
        }
    }

    private void saveImageProcessor(ImageProcessor ip, JSONObject md, String path, String tiffFileName) {
        if (ip != null) {
            ImagePlus imp = new ImagePlus(path + "/" + tiffFileName, ip);
            this.applyPixelSizeCalibration(imp);
            this.saveImagePlus(imp, md, path, tiffFileName);
        }
    }

    private void applyPixelSizeCalibration(ImagePlus ip) {
        try {
            JSONObject summary = this.getSummaryMetadata();
            double pixSizeUm = summary.getDouble("PixelSize_um");
            if (pixSizeUm > 0.0) {
                String zStepUm;
                Calibration cal = new Calibration();
                cal.setUnit("um");
                cal.pixelWidth = pixSizeUm;
                cal.pixelHeight = pixSizeUm;
                String intMs = "Interval_ms";
                if (summary.has(intMs)) {
                    cal.frameInterval = summary.getDouble(intMs) / 1000.0;
                }
                if (summary.has(zStepUm = "z-step_um")) {
                    cal.pixelDepth = summary.getDouble(zStepUm);
                }
                ip.setCalibration(cal);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void saveImagePlus(ImagePlus imp, JSONObject md, String path, String tiffFileName) {
        try {
            imp.setProperty("Info", (Object)md.toString(2));
        }
        catch (JSONException ex) {
            ReportingUtils.logError(ex);
        }
        FileSaver fs = new FileSaver(imp);
        fs.saveAsTiff(path + "/" + tiffFileName);
    }

    private void openNewDataSet(TaggedImage firstImage) throws IOException, Exception {
        int pos;
        String time = MDUtils.getImageTime(firstImage.tags);
        String posName = this.getPosition(firstImage);
        try {
            pos = MDUtils.getPositionIndex(firstImage.tags);
        }
        catch (JSONException e) {
            pos = 0;
            posName = "";
        }
        if (this.positionNames_.containsKey(pos) && this.positionNames_.get(pos) != null && !this.positionNames_.get(pos).contentEquals(posName)) {
            throw new IOException("Position name changed during acquisition.");
        }
        this.positionNames_.put(pos, posName);
        JavaUtils.createDirectory(this.dir_ + "/" + posName);
        this.firstElement_ = true;
        BufferedWriter metadataStream = new BufferedWriter(new FileWriter(this.dir_ + "/" + posName + "/metadata.txt"));
        this.metadataStreams_.put(pos, metadataStream);
        metadataStream.write("{\n");
        JSONObject summaryMetadata = this.getSummaryMetadata();
        summaryMetadata.put("Time", time);
        summaryMetadata.put("Date", time.split(" ")[0]);
        summaryMetadata.put("PositionIndex", MDUtils.getPositionIndex(firstImage.tags));
        this.writeMetadata(pos, summaryMetadata, "Summary");
    }

    @Override
    public void finished() {
        this.closeMetadataStreams();
        this.newDataSet_ = false;
    }

    @Override
    public boolean isFinished() {
        return !this.newDataSet_;
    }

    private void closeMetadataStreams() {
        if (this.newDataSet_) {
            try {
                for (Writer metadataStream : this.metadataStreams_.values()) {
                    metadataStream.write("\n}\n");
                    metadataStream.close();
                }
            }
            catch (IOException ex) {
                ReportingUtils.logError(ex);
            }
        }
    }

    private void openExistingDataSet() throws Exception {
        File metadataFile = new File(this.dir_ + "/metadata.txt");
        ArrayList<String> positions = new ArrayList<String>();
        if (metadataFile.exists()) {
            positions.add("");
        } else {
            for (File f : new File(this.dir_).listFiles()) {
                if (!f.isDirectory()) continue;
                positions.add(f.getName());
            }
        }
        for (int positionIndex = 0; positionIndex < positions.size(); ++positionIndex) {
            String position = (String)positions.get(positionIndex);
            JSONObject data = this.readJsonMetadata(position);
            if (data != null) {
                try {
                    this.summaryMetadata_ = this.jsonToMetadata(data.getJSONObject("Summary"));
                    int metadataVersion = 0;
                    try {
                        metadataVersion = this.summaryMetadata_.getInt("MetadataVersion");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    for (String key : this.makeJsonIterableKeys(data)) {
                        JSONObject chunk = data.getJSONObject(key);
                        if (!key.startsWith("FrameKey")) continue;
                        JSONObject md = this.jsonToMetadata(chunk);
                        try {
                            if (!md.has("ChannelIndex")) {
                                md.put("ChannelIndex", this.getChannelIndex(MDUtils.getChannelName(md)));
                            }
                            if (!md.has("PositionIndex")) {
                                md.put("PositionIndex", positionIndex);
                            }
                            if (!md.has("PixelType") && !md.has("IJType")) {
                                md.put("PixelType", MDUtils.getPixelType(this.summaryMetadata_));
                            }
                            this.lastFrame_ = Math.max(MDUtils.getFrameIndex(md), this.lastFrame_);
                            String fileName = MDUtils.getFileName(md);
                            if (fileName == null) {
                                fileName = "img_" + String.format("%9d", MDUtils.getFrameIndex(md)) + "_" + MDUtils.getChannelName(md) + "_" + String.format("%3d", MDUtils.getSliceIndex(md));
                            }
                            if (position.length() > 0) {
                                fileName = position + "/" + fileName;
                            }
                            this.filenameTable_.put(MDUtils.getLabel(md), fileName);
                            if (metadataVersion >= 10) continue;
                            this.metadataTable_.put(MDUtils.getLabel(md), md);
                        }
                        catch (Exception ex) {
                            ReportingUtils.showError(ex);
                        }
                    }
                    continue;
                }
                catch (JSONException ex) {
                    ReportingUtils.showError(ex);
                    continue;
                }
            }
            throw new IOException("No metadata file found");
        }
        this.readDisplaySettings();
    }

    /*
     * Loose catch block
     */
    private int getChannelIndex(String channelName) {
        try {
            Object tmp = this.getSummaryMetadata().get("ChNames");
            JSONArray channelNames = tmp instanceof String ? new JSONArray((String)tmp) : (JSONArray)tmp;
            for (int i = 0; i < channelNames.length(); ++i) {
                if (!channelNames.getString(i).contentEquals(channelName)) continue;
                return i;
            }
            channelNames.put(channelName);
            return channelNames.length();
        }
        catch (JSONException ex) {
            JSONArray channelNames = new JSONArray();
            channelNames.put(channelName);
            this.getSummaryMetadata().put("ChNames", channelNames);
            return 0;
            {
                catch (JSONException ex2) {
                    ReportingUtils.logError(ex2);
                    return 0;
                }
            }
        }
    }

    private Iterable<String> makeJsonIterableKeys(final JSONObject data) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return data.keys();
            }
        };
    }

    private JSONObject jsonToMetadata(JSONObject data) {
        JSONObject md = new JSONObject();
        try {
            Iterable<String> keys = this.makeJsonIterableKeys(data);
            for (String key : keys) {
                md.put(key, data.getString(key));
            }
        }
        catch (JSONException ex) {
            ReportingUtils.showError(ex);
        }
        return md;
    }

    private JSONObject readJsonMetadata(String pos) throws Exception {
        String fileStr = TextUtils.readTextFile(this.dir_ + "/" + pos + "/metadata.txt");
        try {
            return new JSONObject(fileStr);
        }
        catch (JSONException ex) {
            return new JSONObject(fileStr.concat("}"));
        }
    }

    @Override
    public JSONObject getSummaryMetadata() {
        return this.summaryMetadata_;
    }

    @Override
    public final void setSummaryMetadata(JSONObject summaryMetadata) {
        this.summaryMetadata_ = summaryMetadata;
        if (this.summaryMetadata_ != null) {
            boolean slicesFirst = this.summaryMetadata_.optBoolean("SlicesFirst", true);
            boolean timeFirst = this.summaryMetadata_.optBoolean("TimeFirst", false);
            TreeMap<String, String> oldFilenameTable = this.filenameTable_;
            this.filenameTable_ = new TreeMap(new ImageLabelComparator(slicesFirst, timeFirst));
            this.filenameTable_.putAll(oldFilenameTable);
        }
    }

    @Override
    public void setDisplayAndComments(JSONObject settings) {
        this.displaySettings_ = settings;
    }

    @Override
    public JSONObject getDisplayAndComments() {
        return this.displaySettings_;
    }

    @Override
    public void writeDisplaySettings() {
        if (this.displaySettings_ == null) {
            return;
        }
        if (!new File(this.dir_).exists()) {
            try {
                JavaUtils.createDirectory(this.dir_);
            }
            catch (Exception ex) {
                ReportingUtils.logError(ex);
            }
        }
        File displayFile = new File(this.dir_ + "/" + "display_and_comments.txt");
        try {
            FileWriter displayFileWriter = new FileWriter(displayFile);
            ((Writer)displayFileWriter).append(this.displaySettings_.toString(2));
            ((Writer)displayFileWriter).close();
        }
        catch (Exception e) {
            ReportingUtils.showError(e);
        }
    }

    private void readDisplaySettings() {
        this.displaySettings_ = null;
        String path = this.dir_ + "/" + "display_and_comments.txt";
        try {
            String jsonText = JavaUtils.readTextFile(path);
            if (jsonText != null) {
                JSONObject tmp = new JSONObject(jsonText);
                JSONArray channels = (JSONArray)tmp.get("Channels");
                if (channels != null) {
                    this.displaySettings_ = tmp;
                } else {
                    this.displaySettings_.put("Comments", tmp.get("Comments"));
                }
            }
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.writeDisplaySettings();
            if (this.shutdownHook_ != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook_);
            }
        }
        catch (Exception e) {
            ReportingUtils.logError(e);
        }
    }

    @Override
    public String getDiskLocation() {
        return this.dir_;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public long getDataSetSize() {
        File[] files = new File(this.dir_).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".tif");
            }
        });
        int numTiffFiles = files.length;
        long tiffSize = numTiffFiles > 0 ? files[0].length() : 0L;
        return (long)numTiffFiles * tiffSize;
    }
}

