/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import mmcorej.TaggedImage;
import org.micromanager.api.DataProcessor;
import org.micromanager.utils.ReportingUtils;

public class ProcessorStack<E> {
    private final List<DataProcessor<E>> processors_;
    private final BlockingQueue<E> input_;
    private final BlockingQueue<E> output_;
    private static Object processorInputOutputLock_ = new Object();

    public ProcessorStack(BlockingQueue<E> input, List<DataProcessor<E>> processors) {
        BlockingQueue<E> left;
        this.processors_ = processors;
        BlockingQueue<E> right = left = (this.input_ = input);
        if (this.processors_ != null) {
            for (DataProcessor<E> processor : this.processors_) {
                if (!processor.getIsEnabled()) continue;
                right = new LinkedBlockingQueue(1);
                processor.setInput(left);
                processor.setOutput(right);
                left = right;
            }
        }
        this.output_ = right;
    }

    public BlockingQueue<E> begin() {
        this.start();
        return this.output_;
    }

    public void start() {
        for (DataProcessor<E> processor : this.processors_) {
            if (processor.isAlive()) continue;
            if (processor.isStarted()) {
                ReportingUtils.showError("Processor: " + processor.getName() + " is no longer running. Remove and re-insert to get it to go again");
                continue;
            }
            processor.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockingQueue<TaggedImage> run(BlockingQueue<TaggedImage> inputTaggedImageQueue, List<DataProcessor<TaggedImage>> imageProcessors) {
        Object object = processorInputOutputLock_;
        synchronized (object) {
            ProcessorStack<TaggedImage> processorStack = new ProcessorStack<TaggedImage>(inputTaggedImageQueue, imageProcessors);
            return processorStack.begin();
        }
    }
}

