/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.nio.ByteOrder;
import java.util.TreeMap;
import loci.common.DateTools;
import loci.common.services.ServiceFactory;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.acquisition.MultipageTiffWriter;
import org.micromanager.acquisition.TaggedImageStorageMultipageTiff;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class OMEMetadata {
    private IMetadata metadata_;
    private TaggedImageStorageMultipageTiff mptStorage_;
    private TreeMap<Integer, Indices> seriesIndices_ = new TreeMap();
    private int numSlices_;
    private int numChannels_;
    private TreeMap<String, Integer> tiffDataIndexMap_;

    public OMEMetadata(TaggedImageStorageMultipageTiff mpt) {
        this.mptStorage_ = mpt;
        this.tiffDataIndexMap_ = new TreeMap();
        this.metadata_ = MetadataTools.createOMEXMLMetadata();
    }

    public static String getOMEStringPointerToMasterFile(String filename, String uuid) {
        try {
            IMetadata md = MetadataTools.createOMEXMLMetadata();
            md.setBinaryOnlyMetadataFile(filename);
            md.setBinaryOnlyUUID(uuid);
            return ((OMEXMLService)new ServiceFactory().getInstance(OMEXMLService.class)).getOMEXML((MetadataRetrieve)md) + " ";
        }
        catch (Exception ex) {
            ReportingUtils.logError("Couldn't generate partial OME block");
            return " ";
        }
    }

    public String toString() {
        try {
            OMEXMLService service = (OMEXMLService)new ServiceFactory().getInstance(OMEXMLService.class);
            return service.getOMEXML((MetadataRetrieve)this.metadata_) + " ";
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
            return "";
        }
    }

    public void setNumFrames(int seriesIndex, int numFrames) {
        this.metadata_.setPixelsSizeT(new PositiveInteger(Integer.valueOf(numFrames)), seriesIndex);
    }

    private void startSeriesMetadata(JSONObject firstImageTags, int seriesIndex, String baseFileName) throws JSONException, MMScriptException {
        String positionName;
        double interval;
        double zStep;
        double pixelSize;
        Indices indices = new Indices();
        indices.planeIndex_ = 0;
        indices.tiffDataIndex_ = 0;
        this.seriesIndices_.put(seriesIndex, indices);
        JSONObject summaryMD = this.mptStorage_.getSummaryMetadata();
        this.numSlices_ = MDUtils.getNumSlices(summaryMD);
        this.numChannels_ = MDUtils.getNumChannels(summaryMD);
        MetadataTools.populateMetadata((MetadataStore)this.metadata_, (int)seriesIndex, (String)baseFileName, (boolean)MultipageTiffWriter.BYTE_ORDER.equals(ByteOrder.LITTLE_ENDIAN), (String)(this.mptStorage_.slicesFirst() ? "XYZCT" : "XYCZT"), (String)("uint" + (MDUtils.isGRAY8(summaryMD) ? "8" : "16")), (int)MDUtils.getWidth(summaryMD), (int)MDUtils.getHeight(summaryMD), (int)this.numSlices_, (int)MDUtils.getNumChannels(summaryMD), (int)MDUtils.getNumFrames(summaryMD), (int)1);
        if (MDUtils.hasPixelSizeUm(summaryMD) && (pixelSize = MDUtils.getPixelSizeUm(summaryMD)) > 0.0) {
            this.metadata_.setPixelsPhysicalSizeX(new Length((Number)pixelSize, UNITS.MICROM), seriesIndex);
            this.metadata_.setPixelsPhysicalSizeY(new Length((Number)pixelSize, UNITS.MICROM), seriesIndex);
        }
        if (MDUtils.hasZStepUm(summaryMD) && (zStep = MDUtils.getZStepUm(summaryMD)) != 0.0) {
            this.metadata_.setPixelsPhysicalSizeZ(new Length((Number)Math.abs(zStep), UNITS.MICROM), seriesIndex);
        }
        if (MDUtils.hasIntervalMs(summaryMD) && (interval = MDUtils.getIntervalMs(summaryMD)) > 0.0) {
            this.metadata_.setPixelsTimeIncrement(new Time((Number)interval, UNITS.MS), seriesIndex);
        }
        try {
            positionName = MDUtils.getPositionName(firstImageTags);
        }
        catch (JSONException ex) {
            ReportingUtils.logError("Couldn't find position name in image metadata");
            positionName = "pos" + MDUtils.getPositionIndex(firstImageTags);
        }
        this.metadata_.setStageLabelName(positionName, seriesIndex);
        String instrumentID = MetadataTools.createLSID((String)"Microscope", (int[])new int[0]);
        this.metadata_.setInstrumentID(instrumentID, 0);
        this.metadata_.setImageInstrumentRef(instrumentID, seriesIndex);
        JSONObject comments = this.mptStorage_.getDisplayAndComments().getJSONObject("Comments");
        if (comments.has("Summary") && !comments.isNull("Summary")) {
            this.metadata_.setImageDescription(comments.getString("Summary"), seriesIndex);
        }
        JSONArray channels = this.mptStorage_.getDisplayAndComments().getJSONArray("Channels");
        for (int channelIndex = 0; channelIndex < channels.length(); ++channelIndex) {
            JSONObject channel = channels.getJSONObject(channelIndex);
            this.metadata_.setChannelColor(new Color(Integer.valueOf(channel.getInt("Color"))), seriesIndex, channelIndex);
            this.metadata_.setChannelName(channel.getString("Name"), seriesIndex, channelIndex);
        }
    }

    public void fillInMissingTiffDatas(int frame, int position) {
        try {
            for (int slice = 0; slice < this.numSlices_; ++slice) {
                for (int channel = 0; channel < this.numChannels_; ++channel) {
                    Integer tiffDataIndex = this.tiffDataIndexMap_.get(MDUtils.generateLabel(channel, slice, frame, position));
                    if (tiffDataIndex != null) continue;
                    int s = slice;
                    int backIndex = slice - 1;
                    int forwardIndex = slice + 1;
                    int frameSearchIndex = frame;
                    while (tiffDataIndex == null && (tiffDataIndex = this.tiffDataIndexMap_.get(MDUtils.generateLabel(channel, s, frameSearchIndex, position))) == null) {
                        if (backIndex >= 0) {
                            tiffDataIndex = this.tiffDataIndexMap_.get(MDUtils.generateLabel(channel, backIndex, frameSearchIndex, position));
                            if (tiffDataIndex != null) break;
                            --backIndex;
                        }
                        if (forwardIndex < this.numSlices_) {
                            tiffDataIndex = this.tiffDataIndexMap_.get(MDUtils.generateLabel(channel, forwardIndex, frameSearchIndex, position));
                            if (tiffDataIndex != null) break;
                            ++forwardIndex;
                        }
                        if (backIndex >= 0 || forwardIndex < this.numSlices_) continue;
                        backIndex = slice - 1;
                        forwardIndex = slice + 1;
                        if (--frameSearchIndex >= 0) continue;
                    }
                    NonNegativeInteger ifd = this.metadata_.getTiffDataIFD(position, tiffDataIndex.intValue());
                    String filename = this.metadata_.getUUIDFileName(position, tiffDataIndex.intValue());
                    String uuid = this.metadata_.getUUIDValue(position, tiffDataIndex.intValue());
                    Indices indices = this.seriesIndices_.get(position);
                    this.metadata_.setTiffDataFirstZ(new NonNegativeInteger(Integer.valueOf(slice)), position, indices.tiffDataIndex_);
                    this.metadata_.setTiffDataFirstC(new NonNegativeInteger(Integer.valueOf(channel)), position, indices.tiffDataIndex_);
                    this.metadata_.setTiffDataFirstT(new NonNegativeInteger(Integer.valueOf(frame)), position, indices.tiffDataIndex_);
                    this.metadata_.setTiffDataIFD(ifd, position, indices.tiffDataIndex_);
                    this.metadata_.setUUIDFileName(filename, position, indices.tiffDataIndex_);
                    this.metadata_.setUUIDValue(uuid, position, indices.tiffDataIndex_);
                    this.metadata_.setTiffDataPlaneCount(new NonNegativeInteger(Integer.valueOf(1)), position, indices.tiffDataIndex_);
                    ++indices.tiffDataIndex_;
                }
            }
        }
        catch (Exception e) {
            ReportingUtils.logError("Couldn't fill in missing tiffdata entries in ome metadata");
        }
    }

    public void addImageTagsToOME(JSONObject tags, int ifdCount, String baseFileName, String currentFileName, String uuid) throws JSONException, MMScriptException {
        int position;
        try {
            position = MDUtils.getPositionIndex(tags);
        }
        catch (Exception e) {
            position = 0;
        }
        if (!this.seriesIndices_.containsKey(position)) {
            this.startSeriesMetadata(tags, position, baseFileName);
            try {
                this.setOMEDetectorMetadata(tags);
                if (MDUtils.hasImageTime(tags)) {
                    String imageDate = MDUtils.getImageTime(tags);
                    String reformattedDate = DateTools.formatDate((String)imageDate, (String)"yyyy-MM-dd HH:mm:ss Z", (boolean)true);
                    if (reformattedDate == null) {
                        reformattedDate = DateTools.formatDate((String)imageDate, (String)"yyyy-MM-dd E HH:mm:ss Z", (boolean)true);
                    }
                    if (reformattedDate != null) {
                        this.metadata_.setImageAcquisitionDate(new Timestamp(reformattedDate), position);
                    }
                }
            }
            catch (Exception e) {
                ReportingUtils.logError(e, "Problem adding System state cache metadata to OME Metadata: " + e);
            }
        }
        Indices indices = this.seriesIndices_.get(position);
        try {
            int slice = MDUtils.getSliceIndex(tags);
            int frame = MDUtils.getFrameIndex(tags);
            int channel = MDUtils.getChannelIndex(tags);
            this.metadata_.setTiffDataFirstZ(new NonNegativeInteger(Integer.valueOf(slice)), position, indices.tiffDataIndex_);
            this.metadata_.setTiffDataFirstC(new NonNegativeInteger(Integer.valueOf(channel)), position, indices.tiffDataIndex_);
            this.metadata_.setTiffDataFirstT(new NonNegativeInteger(Integer.valueOf(frame)), position, indices.tiffDataIndex_);
            this.metadata_.setTiffDataIFD(new NonNegativeInteger(Integer.valueOf(ifdCount)), position, indices.tiffDataIndex_);
            this.metadata_.setUUIDFileName(currentFileName, position, indices.tiffDataIndex_);
            this.metadata_.setUUIDValue(uuid, position, indices.tiffDataIndex_);
            this.tiffDataIndexMap_.put(MDUtils.generateLabel(channel, slice, frame, position), indices.tiffDataIndex_);
            this.metadata_.setTiffDataPlaneCount(new NonNegativeInteger(Integer.valueOf(1)), position, indices.tiffDataIndex_);
            this.metadata_.setPlaneTheZ(new NonNegativeInteger(Integer.valueOf(slice)), position, indices.planeIndex_);
            this.metadata_.setPlaneTheC(new NonNegativeInteger(Integer.valueOf(channel)), position, indices.planeIndex_);
            this.metadata_.setPlaneTheT(new NonNegativeInteger(Integer.valueOf(frame)), position, indices.planeIndex_);
        }
        catch (JSONException ex) {
            ReportingUtils.showError("Image Metadata missing ChannelIndex, SliceIndex, or FrameIndex");
        }
        catch (Exception e) {
            ReportingUtils.logError("Couldn't add to OME metadata");
        }
        try {
            if (MDUtils.hasExposureMs(tags)) {
                this.metadata_.setPlaneExposureTime(new Time((Number)MDUtils.getExposureMs(tags), UNITS.MS), position, indices.planeIndex_);
            }
            if (MDUtils.hasXPositionUm(tags)) {
                Length xPosition = new Length((Number)MDUtils.getXPositionUm(tags), UNITS.MICROM);
                this.metadata_.setPlanePositionX(xPosition, position, indices.planeIndex_);
                if (indices.planeIndex_ == 0) {
                    this.metadata_.setStageLabelX(xPosition, position);
                }
            }
            if (MDUtils.hasYPositionUm(tags)) {
                Length yPosition = new Length((Number)MDUtils.getYPositionUm(tags), UNITS.MICROM);
                this.metadata_.setPlanePositionY(yPosition, position, indices.planeIndex_);
                if (indices.planeIndex_ == 0) {
                    this.metadata_.setStageLabelY(yPosition, position);
                }
            }
            if (MDUtils.hasZPositionUm(tags)) {
                this.metadata_.setPlanePositionZ(new Length((Number)MDUtils.getZPositionUm(tags), UNITS.MICROM), position, indices.planeIndex_);
            }
            if (MDUtils.hasElapsedTimeMs(tags)) {
                this.metadata_.setPlaneDeltaT(new Time((Number)MDUtils.getElapsedTimeMs(tags), UNITS.MS), position, indices.planeIndex_);
            }
        }
        catch (JSONException e) {
            ReportingUtils.logError("Problem adding tags to OME Metadata");
        }
        ++indices.planeIndex_;
        ++indices.tiffDataIndex_;
    }

    private void setOMEDetectorMetadata(JSONObject tags) throws JSONException {
        String[] cameras;
        if (!MDUtils.hasCoreCamera(tags)) {
            return;
        }
        String coreCam = MDUtils.getCoreCamera(tags);
        if (tags.has(coreCam + "-Physical Camera 1")) {
            int numCams = 1;
            if (!tags.getString(coreCam + "-Physical Camera 3").equals("Undefined")) {
                numCams = 3;
            } else if (!tags.getString(coreCam + "-Physical Camera 2").equals("Undefined")) {
                numCams = 2;
            }
            cameras = new String[numCams];
            for (int i = 0; i < numCams; ++i) {
                cameras[i] = tags.getString(coreCam + "-Physical Camera " + (1 + i));
            }
        } else {
            cameras = new String[]{coreCam};
        }
        for (int detectorIndex = 0; detectorIndex < cameras.length; ++detectorIndex) {
            String camera = cameras[detectorIndex];
            String detectorID = MetadataTools.createLSID((String)camera, (int[])new int[0]);
            this.metadata_.setDetectorID(detectorID, 0, detectorIndex);
            if (tags.has(camera + "-Name") && !tags.isNull(camera + "-Name")) {
                this.metadata_.setDetectorManufacturer(tags.getString(camera + "-Name"), 0, detectorIndex);
            }
            if (tags.has(camera + "-CameraName") && !tags.isNull(camera + "-CameraName")) {
                this.metadata_.setDetectorModel(tags.getString(camera + "-CameraName"), 0, detectorIndex);
            }
            if (tags.has(camera + "-Offset") && !tags.isNull(camera + "-Offset")) {
                this.metadata_.setDetectorOffset(Double.valueOf(Double.parseDouble(tags.getString(camera + "-Offset"))), 0, detectorIndex);
            }
            if (!tags.has(camera + "-CameraID") || tags.isNull(camera + "-CameraID")) continue;
            this.metadata_.setDetectorSerialNumber(tags.getString(camera + "-CameraID"), 0, detectorIndex);
        }
    }

    private class Indices {
        int tiffDataIndex_ = -1;
        int planeIndex_ = 0;

        private Indices() {
        }
    }
}

