/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import ij.process.LUT;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.MMStudio;
import org.micromanager.acquisition.MultipageTiffReader;
import org.micromanager.acquisition.TaggedImageStorageMultipageTiff;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class MultipageTiffWriter {
    private static final long BYTES_PER_GIG = 0x40000000L;
    private static final long MAX_FILE_SIZE = 0x100000000L;
    public static final int DISPLAY_SETTINGS_BYTES_PER_CHANNEL = 256;
    public static final long SPACE_FOR_COMMENTS = 0x100000L;
    public static final int INDEX_MAP_OFFSET_HEADER = 54773648;
    public static final int INDEX_MAP_HEADER = 3453623;
    public static final int DISPLAY_SETTINGS_OFFSET_HEADER = 483765892;
    public static final int DISPLAY_SETTINGS_HEADER = 347834724;
    public static final int COMMENTS_OFFSET_HEADER = 99384722;
    public static final int COMMENTS_HEADER = 84720485;
    public static final char ENTRIES_PER_IFD = '\r';
    public static final char WIDTH = '\u0100';
    public static final char HEIGHT = '\u0101';
    public static final char BITS_PER_SAMPLE = '\u0102';
    public static final char COMPRESSION = '\u0103';
    public static final char PHOTOMETRIC_INTERPRETATION = '\u0106';
    public static final char IMAGE_DESCRIPTION = '\u010e';
    public static final char STRIP_OFFSETS = '\u0111';
    public static final char SAMPLES_PER_PIXEL = '\u0115';
    public static final char ROWS_PER_STRIP = '\u0116';
    public static final char STRIP_BYTE_COUNTS = '\u0117';
    public static final char X_RESOLUTION = '\u011a';
    public static final char Y_RESOLUTION = '\u011b';
    public static final char RESOLUTION_UNIT = '\u0128';
    public static final char IJ_METADATA_BYTE_COUNTS = '\uc696';
    public static final char IJ_METADATA = '\uc697';
    public static final char MM_METADATA = '\uc7b3';
    public static final int SUMMARY_MD_HEADER = 2355492;
    public static final ByteOrder BYTE_ORDER = ByteOrder.nativeOrder();
    private final boolean omeTiff_;
    private TaggedImageStorageMultipageTiff masterMPTiffStorage_;
    private RandomAccessFile raFile_;
    private FileChannel fileChannel_;
    private ThreadPoolExecutor writingExecutor_;
    private long filePosition_ = 0L;
    private long indexMapPosition_;
    private long indexMapFirstEntry_;
    private int bufferPosition_;
    private int numChannels_ = 1;
    private int numFrames_ = 1;
    private int numSlices_ = 1;
    private HashMap<String, Long> indexMap_;
    private long nextIFDOffsetLocation_ = -1L;
    private boolean rgb_ = false;
    private int byteDepth_;
    private int imageWidth_;
    private int imageHeight_;
    private int bytesPerImagePixels_;
    private long resNumerator_ = 1L;
    private long resDenomenator_ = 1L;
    private double zStepUm_ = 1.0;
    private LinkedList<ByteBuffer> buffers_;
    private boolean firstIFD_ = true;
    private long omeDescriptionTagPosition_;
    private long ijDescriptionTagPosition_;
    private long ijMetadataCountsTagPosition_;
    private long ijMetadataTagPosition_;
    private MultipageTiffReader reader_;
    private long blankPixelsOffset_ = -1L;
    private boolean fastStorageMode_;
    private BlockingQueue<ByteBuffer> currentImageByteBuffers_ = new LinkedBlockingQueue<ByteBuffer>(10);
    private int currentImageByteBufferCapacity_ = 0;

    public MultipageTiffWriter(String directory, String filename, JSONObject summaryMD, TaggedImageStorageMultipageTiff mpTiffStorage, boolean fastStorageMode, boolean splitByPositions) throws IOException {
        this.fastStorageMode_ = fastStorageMode;
        this.masterMPTiffStorage_ = mpTiffStorage;
        this.omeTiff_ = mpTiffStorage.omeTiff_;
        this.reader_ = new MultipageTiffReader(summaryMD);
        File f = new File(directory + "/" + filename);
        try {
            this.processSummaryMD(summaryMD, splitByPositions);
        }
        catch (MMScriptException ex1) {
            ReportingUtils.logError(ex1);
        }
        catch (JSONException ex) {
            ReportingUtils.logError(ex);
        }
        long fileSize = Math.min(0x100000000L, (long)(summaryMD.toString().length() + 2000000) + (long)(this.numFrames_ * this.numChannels_ * this.numSlices_) * ((long)this.bytesPerImagePixels_ + 2000L));
        f.createNewFile();
        this.raFile_ = new RandomAccessFile(f, "rw");
        try {
            this.raFile_.setLength(fileSize);
        }
        catch (IOException e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    MMStudio.getInstance().getAcquisitionEngine().abortRequest();
                }
            }).start();
            ReportingUtils.showError("Insufficent space on disk: no room to write data");
        }
        this.fileChannel_ = this.raFile_.getChannel();
        this.writingExecutor_ = this.masterMPTiffStorage_.getWritingExecutor();
        this.indexMap_ = new HashMap();
        this.reader_.setFileChannel(this.fileChannel_);
        this.reader_.setIndexMap(this.indexMap_);
        this.buffers_ = new LinkedList();
        this.writeMMHeaderAndSummaryMD(summaryMD);
    }

    private ByteBuffer allocateByteBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(BYTE_ORDER);
    }

    private ByteBuffer allocateByteBufferMemo(int capacity) {
        ByteBuffer cachedBuf;
        if (System.getProperty("sun.arch.data.model").equals("32")) {
            return this.allocateByteBuffer(capacity);
        }
        if (capacity != this.currentImageByteBufferCapacity_) {
            this.currentImageByteBuffers_.clear();
            this.currentImageByteBufferCapacity_ = capacity;
        }
        return (cachedBuf = (ByteBuffer)this.currentImageByteBuffers_.poll()) != null ? cachedBuf : this.allocateByteBuffer(capacity);
    }

    private void executeWritingTask(Runnable writingTask) {
        if (this.fastStorageMode_) {
            this.writingExecutor_.execute(writingTask);
        } else {
            writingTask.run();
        }
    }

    private void fileChannelWrite(final ByteBuffer buffer, final long position) {
        this.executeWritingTask(new Runnable(){

            @Override
            public void run() {
                try {
                    buffer.rewind();
                    MultipageTiffWriter.this.fileChannel_.write(buffer, position);
                    if (buffer.limit() == MultipageTiffWriter.this.currentImageByteBufferCapacity_) {
                        MultipageTiffWriter.this.currentImageByteBuffers_.offer(buffer);
                    }
                }
                catch (IOException e) {
                    ReportingUtils.logError(e);
                }
            }
        });
    }

    private void fileChannelWrite(final ByteBuffer[] buffers) {
        this.executeWritingTask(new Runnable(){

            @Override
            public void run() {
                try {
                    MultipageTiffWriter.this.fileChannel_.write(buffers);
                    for (ByteBuffer buffer : buffers) {
                        if (buffer.limit() != MultipageTiffWriter.this.currentImageByteBufferCapacity_) continue;
                        MultipageTiffWriter.this.currentImageByteBuffers_.offer(buffer);
                    }
                }
                catch (IOException e) {
                    ReportingUtils.logError(e);
                }
            }
        });
    }

    public MultipageTiffReader getReader() {
        return this.reader_;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel_;
    }

    public HashMap<String, Long> getIndexMap() {
        return this.indexMap_;
    }

    private void writeMMHeaderAndSummaryMD(JSONObject summaryMD) throws IOException {
        if (summaryMD.has("Comment")) {
            summaryMD.remove("Comment");
        }
        byte[] summaryMDBytes = this.getBytesFromString(summaryMD.toString());
        int mdLength = summaryMDBytes.length;
        long maxImagesInFile = 0x100000000L / (long)this.bytesPerImagePixels_;
        long indexMapSpace = 8L + 20L * maxImagesInFile;
        ByteBuffer headerBuffer = this.allocateByteBuffer(40);
        if (BYTE_ORDER.equals(ByteOrder.BIG_ENDIAN)) {
            headerBuffer.asCharBuffer().put(0, '\u4d4d');
        } else {
            headerBuffer.asCharBuffer().put(0, '\u4949');
        }
        headerBuffer.asCharBuffer().put(1, '*');
        headerBuffer.putInt(4, 40 + (int)((long)mdLength + indexMapSpace));
        headerBuffer.putInt(8, 54773648);
        headerBuffer.putInt(12, headerBuffer.capacity() + mdLength);
        headerBuffer.putInt(32, 2355492);
        headerBuffer.putInt(36, mdLength);
        ByteBuffer indexMapBuffer = this.allocateByteBuffer((int)indexMapSpace);
        indexMapBuffer.putInt(0, 3453623);
        indexMapBuffer.putInt(4, (int)maxImagesInFile);
        this.indexMapFirstEntry_ = this.indexMapPosition_ = (long)(headerBuffer.capacity() + mdLength + 8);
        ByteBuffer[] buffers = new ByteBuffer[]{headerBuffer, ByteBuffer.wrap(summaryMDBytes), indexMapBuffer};
        this.fileChannelWrite(buffers);
        this.filePosition_ += (long)(headerBuffer.capacity() + mdLength) + indexMapSpace;
    }

    public void finish() throws IOException {
        this.writeNullOffsetAfterLastImage();
        int numImages = (int)((this.indexMapPosition_ - this.indexMapFirstEntry_) / 20L);
        ByteBuffer indexMapNumEntries = this.allocateByteBuffer(4);
        indexMapNumEntries.putInt(0, numImages);
        this.fileChannelWrite(indexMapNumEntries, this.indexMapFirstEntry_ - 4L);
    }

    public void close(String omeXML) throws IOException {
        String summaryComment = "";
        try {
            JSONObject comments = this.masterMPTiffStorage_.getDisplayAndComments().getJSONObject("Comments");
            if (comments.has("Summary") && !comments.isNull("Summary")) {
                summaryComment = comments.getString("Summary");
            }
        }
        catch (Exception e) {
            ReportingUtils.logError("Could't get acquisition summary comment from displayAndComments");
        }
        this.writeImageJMetadata(this.numChannels_, summaryComment);
        if (this.omeTiff_) {
            try {
                this.writeImageDescription(omeXML, this.omeDescriptionTagPosition_);
            }
            catch (Exception ex) {
                ReportingUtils.showError("Error writing OME metadata");
            }
        }
        this.writeImageDescription(this.getIJDescriptionString(), this.ijDescriptionTagPosition_);
        this.writeDisplaySettings();
        this.writeComments();
        this.executeWritingTask(new Runnable(){

            @Override
            public void run() {
                try {
                    MultipageTiffWriter.this.raFile_.setLength(MultipageTiffWriter.this.filePosition_ + 8L);
                }
                catch (IOException ex) {
                    ReportingUtils.logError(ex);
                }
                MultipageTiffWriter.this.reader_.finishedWriting();
                MultipageTiffWriter.this.fileChannel_ = null;
                MultipageTiffWriter.this.raFile_ = null;
            }
        });
    }

    public boolean hasSpaceForFullOMEMetadata(int length) {
        int extraPadding = 5000000;
        long size = (long)length + 0x100000L + (long)(this.numChannels_ * 256) + (long)extraPadding + this.filePosition_;
        return size < 0x100000000L;
    }

    public boolean hasSpaceToWrite(TaggedImage img, int omeMDLength) {
        int mdLength = img.tags.toString().length();
        int IFDSize = 176;
        int extraPadding = 5000000;
        long size = (long)(mdLength + IFDSize + this.bytesPerImagePixels_) + 0x100000L + (long)(this.numChannels_ * 256) + (long)extraPadding + this.filePosition_;
        if (this.omeTiff_) {
            size += (long)omeMDLength;
        }
        return size < 0x100000000L;
    }

    public boolean isClosed() {
        return this.raFile_ == null;
    }

    public void writeBlankImage(String label) throws IOException {
        this.writeBlankIFD();
        this.writeBuffers();
    }

    public void writeImage(TaggedImage img) throws IOException {
        if (this.writingExecutor_ != null) {
            int queueSize = this.writingExecutor_.getQueue().size();
            int attemptCount = 0;
            while (queueSize > 20) {
                if (attemptCount == 0) {
                    ReportingUtils.logMessage("Warning: writing queue behind by " + queueSize + " images.");
                }
                ++attemptCount;
                try {
                    Thread.sleep(5L);
                    queueSize = this.writingExecutor_.getQueue().size();
                }
                catch (InterruptedException ex) {
                    ReportingUtils.logError(ex);
                }
            }
        }
        long offset = this.filePosition_;
        this.writeIFD(img);
        this.addToIndexMap(MDUtils.getLabel(img.tags), offset);
        this.writeBuffers();
    }

    private void addToIndexMap(String label, long offset) {
        this.indexMap_.put(label, offset);
        ByteBuffer buffer = this.allocateByteBuffer(20);
        String[] indices = label.split("_");
        for (int i = 0; i < 4; ++i) {
            buffer.putInt(4 * i, Integer.parseInt(indices[i]));
        }
        buffer.putInt(16, new Long(offset).intValue());
        this.fileChannelWrite(buffer, this.indexMapPosition_);
        this.indexMapPosition_ += 20L;
    }

    private void writeBuffers() throws IOException {
        ByteBuffer[] buffs = new ByteBuffer[this.buffers_.size()];
        for (int i = 0; i < buffs.length; ++i) {
            buffs[i] = this.buffers_.removeFirst();
        }
        this.fileChannelWrite(buffs);
    }

    private long unsignInt(int i) {
        long val = Integer.MAX_VALUE & i;
        if (i < 0) {
            val += (long)Math.pow(2.0, 31.0);
        }
        return val;
    }

    public void overwritePixels(Object pixels, int channel, int slice, int frame, int position) throws IOException {
        long byteOffset = this.indexMap_.get(MDUtils.generateLabel(channel, slice, frame, position));
        ByteBuffer buffer = ByteBuffer.allocate(2).order(BYTE_ORDER);
        this.fileChannel_.read(buffer, byteOffset);
        int numEntries = buffer.getChar(0);
        ByteBuffer entries = ByteBuffer.allocate(numEntries * 12 + 4).order(BYTE_ORDER);
        this.fileChannel_.read(entries, byteOffset + 2L);
        long pixelOffset = -1L;
        long bytesPerImage = -1L;
        for (int i = 0; i < numEntries; ++i) {
            char tag = entries.getChar(i * 12);
            char type = entries.getChar(i * 12 + 2);
            long count = this.unsignInt(entries.getInt(i * 12 + 4));
            long value = type == '\u0003' && count == 1L ? (long)entries.getChar(i * 12 + 8) : this.unsignInt(entries.getInt(i * 12 + 8));
            if (tag == '\u0111') {
                pixelOffset = value;
                continue;
            }
            if (tag != '\u0117') continue;
            bytesPerImage = value;
        }
        if (pixelOffset == -1L || bytesPerImage == -1L) {
            ReportingUtils.showError("Couldn't overwrite pixel data");
            return;
        }
        ByteBuffer pixBuff = this.getPixelBuffer(pixels);
        this.fileChannelWrite(pixBuff, pixelOffset);
    }

    private void writeIFD(TaggedImage img) throws IOException {
        char numEntries;
        char c = numEntries = this.firstIFD_ ? (char)'\u0011' : '\r';
        if (img.tags.has("Summary")) {
            img.tags.remove("Summary");
        }
        byte[] mdBytes = this.getBytesFromString(img.tags.toString() + " ");
        mdBytes[mdBytes.length - 1] = 0;
        int totalBytes = 2 + numEntries * 12 + 4 + (this.rgb_ ? 6 : 0) + 16 + mdBytes.length + this.bytesPerImagePixels_;
        int IFDandBitDepthBytes = 2 + numEntries * 12 + 4 + (this.rgb_ ? 6 : 0);
        ByteBuffer ifdBuffer = this.allocateByteBuffer(IFDandBitDepthBytes);
        CharBuffer charView = ifdBuffer.asCharBuffer();
        long tagDataOffset = this.filePosition_ + 2L + (long)(numEntries * 12) + 4L;
        this.nextIFDOffsetLocation_ = this.filePosition_ + 2L + (long)(numEntries * 12);
        this.bufferPosition_ = 0;
        charView.put(this.bufferPosition_, numEntries);
        this.bufferPosition_ += 2;
        this.writeIFDEntry(ifdBuffer, charView, '\u0100', '\u0004', 1L, this.imageWidth_);
        this.writeIFDEntry(ifdBuffer, charView, '\u0101', '\u0004', 1L, this.imageHeight_);
        this.writeIFDEntry(ifdBuffer, charView, '\u0102', '\u0003', this.rgb_ ? 3L : 1L, this.rgb_ ? tagDataOffset : (long)(this.byteDepth_ * 8));
        if (this.rgb_) {
            tagDataOffset += 6L;
        }
        this.writeIFDEntry(ifdBuffer, charView, '\u0103', '\u0003', 1L, 1L);
        this.writeIFDEntry(ifdBuffer, charView, '\u0106', '\u0003', 1L, this.rgb_ ? 2L : 1L);
        if (this.firstIFD_) {
            this.omeDescriptionTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(ifdBuffer, charView, '\u010e', '\u0002', 0L, 0L);
            this.ijDescriptionTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(ifdBuffer, charView, '\u010e', '\u0002', 0L, 0L);
        }
        this.writeIFDEntry(ifdBuffer, charView, '\u0111', '\u0004', 1L, tagDataOffset);
        this.writeIFDEntry(ifdBuffer, charView, '\u0115', '\u0003', 1L, this.rgb_ ? 3 : 1);
        this.writeIFDEntry(ifdBuffer, charView, '\u0116', '\u0003', 1L, this.imageHeight_);
        this.writeIFDEntry(ifdBuffer, charView, '\u0117', '\u0004', 1L, this.bytesPerImagePixels_);
        this.writeIFDEntry(ifdBuffer, charView, '\u011a', '\u0005', 1L, tagDataOffset += (long)this.bytesPerImagePixels_);
        this.writeIFDEntry(ifdBuffer, charView, '\u011b', '\u0005', 1L, tagDataOffset += 8L);
        tagDataOffset += 8L;
        this.writeIFDEntry(ifdBuffer, charView, '\u0128', '\u0003', 1L, 3L);
        if (this.firstIFD_) {
            this.ijMetadataCountsTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(ifdBuffer, charView, '\uc696', '\u0004', 0L, 0L);
            this.ijMetadataTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(ifdBuffer, charView, '\uc697', '\u0001', 0L, 0L);
        }
        this.writeIFDEntry(ifdBuffer, charView, '\uc7b3', '\u0002', mdBytes.length, tagDataOffset);
        ifdBuffer.putInt(this.bufferPosition_, (int)(tagDataOffset += (long)mdBytes.length));
        this.bufferPosition_ += 4;
        if (this.rgb_) {
            charView.put(this.bufferPosition_ / 2, (char)(this.byteDepth_ * 8));
            charView.put(this.bufferPosition_ / 2 + 1, (char)(this.byteDepth_ * 8));
            charView.put(this.bufferPosition_ / 2 + 2, (char)(this.byteDepth_ * 8));
        }
        this.buffers_.add(ifdBuffer);
        this.buffers_.add(this.getPixelBuffer(img.pix));
        this.buffers_.add(this.getResolutionValuesBuffer());
        this.buffers_.add(ByteBuffer.wrap(mdBytes));
        this.filePosition_ += (long)totalBytes;
        this.firstIFD_ = false;
    }

    private void writeIFDEntry(ByteBuffer buffer, CharBuffer cBuffer, char tag, char type, long count, long value) throws IOException {
        cBuffer.put(this.bufferPosition_ / 2, tag);
        cBuffer.put(this.bufferPosition_ / 2 + 1, type);
        buffer.putInt(this.bufferPosition_ + 4, (int)count);
        if (type == '\u0003' && count == 1L) {
            cBuffer.put(this.bufferPosition_ / 2 + 4, (char)value);
            cBuffer.put(this.bufferPosition_ / 2 + 5, '\u0000');
        } else {
            buffer.putInt(this.bufferPosition_ + 8, (int)value);
        }
        this.bufferPosition_ += 12;
    }

    private ByteBuffer getResolutionValuesBuffer() throws IOException {
        ByteBuffer buffer = this.allocateByteBuffer(16);
        buffer.putInt(0, (int)this.resNumerator_);
        buffer.putInt(4, (int)this.resDenomenator_);
        buffer.putInt(8, (int)this.resNumerator_);
        buffer.putInt(12, (int)this.resDenomenator_);
        return buffer;
    }

    public void setAbortedNumFrames(int n) {
        this.numFrames_ = n;
    }

    private ByteBuffer getPixelBuffer(Object pixels) throws IOException {
        if (this.rgb_) {
            if (this.byteDepth_ == 1) {
                byte[] originalPix = (byte[])pixels;
                byte[] rgbaPix = new byte[originalPix.length * 3 / 4];
                int count = 0;
                for (int i = 0; i < originalPix.length; ++i) {
                    if ((i + 1) % 4 == 0) continue;
                    rgbaPix[count] = (i + 1) % 4 == 1 ? originalPix[i + 2] : ((i + 1) % 4 == 3 ? originalPix[i - 2] : originalPix[i]);
                    ++count;
                }
                return ByteBuffer.wrap(rgbaPix);
            }
            short[] originalPix = (short[])pixels;
            short[] rgbaPix = new short[originalPix.length * 3 / 4];
            int count = 0;
            for (int i = 0; i < originalPix.length; ++i) {
                if ((i + 1) % 4 == 0) continue;
                rgbaPix[count] = (i + 1) % 4 == 1 ? originalPix[i + 2] : ((i + 1) % 4 == 3 ? originalPix[i - 2] : originalPix[i]);
                ++count;
            }
            ByteBuffer buffer = this.allocateByteBufferMemo(rgbaPix.length * 2);
            buffer.rewind();
            buffer.asShortBuffer().put(rgbaPix);
            return buffer;
        }
        if (this.byteDepth_ == 1) {
            return ByteBuffer.wrap((byte[])pixels);
        }
        short[] pix = (short[])pixels;
        ByteBuffer buffer = this.allocateByteBufferMemo(pix.length * 2);
        buffer.rewind();
        buffer.asShortBuffer().put(pix);
        return buffer;
    }

    private void processSummaryMD(JSONObject summaryMD, boolean splitByPosition) throws MMScriptException, JSONException {
        double log;
        this.rgb_ = MDUtils.isRGB(summaryMD);
        this.numChannels_ = MDUtils.getNumChannels(summaryMD);
        this.numFrames_ = MDUtils.getNumFrames(summaryMD);
        this.numSlices_ = MDUtils.getNumSlices(summaryMD);
        this.imageWidth_ = MDUtils.getWidth(summaryMD);
        this.imageHeight_ = MDUtils.getHeight(summaryMD);
        String pixelType = MDUtils.getPixelType(summaryMD);
        this.byteDepth_ = pixelType.equals("GRAY8") || pixelType.equals("RGB32") || pixelType.equals("RGB24") ? 1 : (pixelType.equals("GRAY16") || pixelType.equals("RGB64") ? 2 : (pixelType.equals("GRAY32") ? 3 : 2));
        this.bytesPerImagePixels_ = this.imageHeight_ * this.imageWidth_ * this.byteDepth_ * (this.rgb_ ? 3 : 1);
        double cmPerPixel = 1.0E-4;
        if (summaryMD.has("PixelSizeUm")) {
            try {
                cmPerPixel = 1.0E-4 * summaryMD.getDouble("PixelSizeUm");
            }
            catch (JSONException jSONException) {}
        } else if (summaryMD.has("PixelSize_um")) {
            try {
                cmPerPixel = 1.0E-4 * summaryMD.getDouble("PixelSize_um");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if ((log = Math.log10(cmPerPixel)) >= 0.0) {
            this.resDenomenator_ = (long)cmPerPixel;
            this.resNumerator_ = 1L;
        } else {
            this.resNumerator_ = (long)(1.0 / cmPerPixel);
            this.resDenomenator_ = 1L;
        }
        if (summaryMD.has("z-step_um") && !summaryMD.isNull("z-step_um")) {
            this.zStepUm_ = summaryMD.getDouble("z-step_um");
        }
    }

    private void writeImageJMetadata(int numChannels, String summaryComment) throws IOException {
        String infoString = this.masterMPTiffStorage_.getSummaryMetadataString();
        if (summaryComment != null && summaryComment.length() > 0) {
            infoString = "Acquisition comments: \n" + summaryComment + "\n\n\n" + infoString;
        }
        char[] infoChars = infoString.toCharArray();
        int infoSize = 2 * infoChars.length;
        int mdByteCountsBufferSize = 12 + 4 * numChannels;
        int bufferPosition = 0;
        ByteBuffer mdByteCountsBuffer = this.allocateByteBuffer(mdByteCountsBufferSize);
        int nTypes = 3;
        int mdBufferSize = 4 + nTypes * 8;
        mdByteCountsBuffer.putInt(bufferPosition, 4 + nTypes * 8);
        mdByteCountsBuffer.putInt(bufferPosition += 4, infoSize);
        mdBufferSize += infoSize;
        mdByteCountsBuffer.putInt(bufferPosition += 4, numChannels * 2 * 8);
        bufferPosition += 4;
        mdBufferSize += numChannels * 2 * 8;
        for (int i = 0; i < numChannels; ++i) {
            mdByteCountsBuffer.putInt(bufferPosition, 768);
            bufferPosition += 4;
            mdBufferSize += 768;
        }
        int numMDEntries = 3 + numChannels;
        ByteBuffer ifdCountAndValueBuffer = this.allocateByteBuffer(8);
        ifdCountAndValueBuffer.putInt(0, numMDEntries);
        ifdCountAndValueBuffer.putInt(4, (int)this.filePosition_);
        this.fileChannelWrite(ifdCountAndValueBuffer, this.ijMetadataCountsTagPosition_ + 4L);
        this.fileChannelWrite(mdByteCountsBuffer, this.filePosition_);
        this.filePosition_ += (long)mdByteCountsBufferSize;
        ByteBuffer mdBuffer = this.allocateByteBuffer(mdBufferSize);
        bufferPosition = 0;
        int ijMagicNumber = 0x494A494A;
        mdBuffer.putInt(bufferPosition, 0x494A494A);
        int fileInfo = 1768842863;
        mdBuffer.putInt(bufferPosition += 4, 1768842863);
        mdBuffer.putInt(bufferPosition += 4, 1);
        int displayRanges = 1918987879;
        mdBuffer.putInt(bufferPosition += 4, 1918987879);
        mdBuffer.putInt(bufferPosition += 4, 1);
        int luts = 1819636851;
        mdBuffer.putInt(bufferPosition += 4, 1819636851);
        mdBuffer.putInt(bufferPosition += 4, numChannels);
        bufferPosition += 4;
        for (char c : infoChars) {
            mdBuffer.putChar(bufferPosition, c);
            bufferPosition += 2;
        }
        try {
            int i;
            JSONArray channels = this.masterMPTiffStorage_.getDisplayAndComments().getJSONArray("Channels");
            for (i = 0; i < numChannels; ++i) {
                JSONObject channelSetting = channels.getJSONObject(i);
                mdBuffer.putDouble(bufferPosition, channelSetting.getInt("Min"));
                mdBuffer.putDouble(bufferPosition += 8, channelSetting.getInt("Max"));
                bufferPosition += 8;
            }
            for (i = 0; i < numChannels; ++i) {
                JSONObject channelSetting = channels.getJSONObject(i);
                LUT lut = ImageUtils.makeLUT(new Color(channelSetting.getInt("Color")), channelSetting.getDouble("Gamma"));
                for (byte b : lut.getBytes()) {
                    mdBuffer.put(bufferPosition, b);
                    ++bufferPosition;
                }
            }
        }
        catch (JSONException ex) {
            ReportingUtils.logError("Problem with displayAndComments: Couldn't write ImageJ display settings as a result");
        }
        ifdCountAndValueBuffer = this.allocateByteBuffer(8);
        ifdCountAndValueBuffer.putInt(0, mdBufferSize);
        ifdCountAndValueBuffer.putInt(4, (int)this.filePosition_);
        this.fileChannelWrite(ifdCountAndValueBuffer, this.ijMetadataTagPosition_ + 4L);
        this.fileChannelWrite(mdBuffer, this.filePosition_);
        this.filePosition_ += (long)mdBufferSize;
    }

    private String getIJDescriptionString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ImageJ=1.48v\n");
        if (this.numChannels_ > 1) {
            sb.append("channels=").append(this.numChannels_).append("\n");
        }
        if (this.numSlices_ > 1) {
            sb.append("slices=").append(this.numSlices_).append("\n");
        }
        if (this.numFrames_ > 1) {
            sb.append("frames=").append(this.numFrames_).append("\n");
        }
        if (this.numFrames_ > 1 || this.numSlices_ > 1 || this.numChannels_ > 1) {
            sb.append("hyperstack=true\n");
        }
        if (this.numChannels_ > 1 && this.numSlices_ > 1 && this.masterMPTiffStorage_.slicesFirst()) {
            sb.append("order=zct\n");
        }
        sb.append("unit=um\n");
        if (this.numSlices_ > 1) {
            sb.append("spacing=").append(this.zStepUm_).append("\n");
        }
        try {
            JSONObject channel0setting = this.masterMPTiffStorage_.getDisplayAndComments().getJSONArray("Channels").getJSONObject(0);
            if (this.numChannels_ == 1) {
                double min = channel0setting.getInt("Min");
                double max = channel0setting.getInt("Max");
                sb.append("min=").append(min).append("\n");
                sb.append("max=").append(max).append("\n");
            } else {
                int displayMode = channel0setting.getInt("DisplayMode");
                if (displayMode == 1) {
                    sb.append("mode=composite\n");
                } else if (displayMode == 2) {
                    sb.append("mode=color\n");
                } else if (displayMode == 3) {
                    sb.append("mode=gray\n");
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        sb.append('\u0000');
        return new String(sb);
    }

    private void writeImageDescription(String text, long imageDescriptionTagOffset) throws IOException {
        byte[] bytes = this.getBytesFromString(text + " ");
        bytes[bytes.length - 1] = 0;
        ByteBuffer ifdCountAndValueBuffer = this.allocateByteBuffer(8);
        ifdCountAndValueBuffer.putInt(0, bytes.length);
        ifdCountAndValueBuffer.putInt(4, (int)this.filePosition_);
        this.fileChannelWrite(ifdCountAndValueBuffer, imageDescriptionTagOffset + 4L);
        this.fileChannelWrite(ByteBuffer.wrap(bytes), this.filePosition_);
        this.filePosition_ += (long)bytes.length;
    }

    private byte[] getBytesFromString(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ReportingUtils.logError("Error encoding String to bytes");
            return null;
        }
    }

    private void writeNullOffsetAfterLastImage() throws IOException {
        ByteBuffer buffer = this.allocateByteBuffer(4);
        buffer.putInt(0, 0);
        this.fileChannelWrite(buffer, this.nextIFDOffsetLocation_);
    }

    private void writeComments() throws IOException {
        JSONObject comments;
        try {
            comments = this.masterMPTiffStorage_.getDisplayAndComments().getJSONObject("Comments");
        }
        catch (JSONException ex) {
            comments = new JSONObject();
        }
        byte[] commentsBytes = this.getBytesFromString(comments.toString());
        ByteBuffer header = this.allocateByteBuffer(8);
        header.putInt(0, 84720485);
        header.putInt(4, commentsBytes.length);
        ByteBuffer buffer = ByteBuffer.wrap(commentsBytes);
        this.fileChannelWrite(header, this.filePosition_);
        this.fileChannelWrite(buffer, this.filePosition_ + 8L);
        ByteBuffer offsetHeader = this.allocateByteBuffer(8);
        offsetHeader.putInt(0, 99384722);
        offsetHeader.putInt(4, (int)this.filePosition_);
        this.fileChannelWrite(offsetHeader, 24L);
        this.filePosition_ += (long)(8 + commentsBytes.length);
    }

    private void writeDisplaySettings() throws IOException {
        JSONArray displaySettings;
        try {
            displaySettings = this.masterMPTiffStorage_.getDisplayAndComments().getJSONArray("Channels");
        }
        catch (JSONException ex) {
            displaySettings = new JSONArray();
        }
        int numReservedBytes = this.numChannels_ * 256;
        ByteBuffer header = this.allocateByteBuffer(8);
        ByteBuffer buffer = ByteBuffer.wrap(this.getBytesFromString(displaySettings.toString()));
        header.putInt(0, 347834724);
        header.putInt(4, numReservedBytes);
        this.fileChannelWrite(header, this.filePosition_);
        this.fileChannelWrite(buffer, this.filePosition_ + 8L);
        ByteBuffer offsetHeader = this.allocateByteBuffer(8);
        offsetHeader.putInt(0, 483765892);
        offsetHeader.putInt(4, (int)this.filePosition_);
        this.fileChannelWrite(offsetHeader, 16L);
        this.filePosition_ += (long)(numReservedBytes + 8);
    }

    private void writeBlankIFD() throws IOException {
        boolean blankPixelsAlreadyWritten = false;
        char numEntries = (char)((this.firstIFD_ && this.omeTiff_ ? 15 : 13) + (this.firstIFD_ ? 2 : 0));
        byte[] mdBytes = this.getBytesFromString("NULL ");
        int totalBytes = 2 + numEntries * 12 + 4 + (this.rgb_ ? 6 : 0) + 16 + mdBytes.length + (blankPixelsAlreadyWritten ? 0 : this.bytesPerImagePixels_);
        int IFDandBitDepthBytes = 2 + numEntries * 12 + 4 + (this.rgb_ ? 6 : 0);
        ByteBuffer ifdBuffer = this.allocateByteBuffer(IFDandBitDepthBytes);
        CharBuffer charView = ifdBuffer.asCharBuffer();
        long tagDataOffset = this.filePosition_ + 2L + (long)(numEntries * 12) + 4L;
        this.nextIFDOffsetLocation_ = this.filePosition_ + 2L + (long)(numEntries * 12);
        this.bufferPosition_ = 0;
        charView.put(this.bufferPosition_, numEntries);
        this.bufferPosition_ += 2;
        this.writeIFDEntry(ifdBuffer, charView, '\u0100', '\u0004', 1L, this.imageWidth_);
        this.writeIFDEntry(ifdBuffer, charView, '\u0101', '\u0004', 1L, this.imageHeight_);
        this.writeIFDEntry(ifdBuffer, charView, '\u0102', '\u0003', this.rgb_ ? 3L : 1L, this.rgb_ ? tagDataOffset : (long)(this.byteDepth_ * 8));
        if (this.rgb_) {
            tagDataOffset += 6L;
        }
        this.writeIFDEntry(ifdBuffer, charView, '\u0103', '\u0003', 1L, 1L);
        this.writeIFDEntry(ifdBuffer, charView, '\u0106', '\u0003', 1L, this.rgb_ ? 2L : 1L);
        if (this.firstIFD_ && this.omeTiff_) {
            this.omeDescriptionTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(ifdBuffer, charView, '\u010e', '\u0002', 0L, 0L);
        }
        if (this.firstIFD_) {
            this.ijDescriptionTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(ifdBuffer, charView, '\u010e', '\u0002', 0L, 0L);
        }
        if (!blankPixelsAlreadyWritten) {
            this.writeIFDEntry(ifdBuffer, charView, '\u0111', '\u0004', 1L, tagDataOffset);
            this.blankPixelsOffset_ = tagDataOffset;
            tagDataOffset += (long)this.bytesPerImagePixels_;
        } else {
            this.writeIFDEntry(ifdBuffer, charView, '\u0111', '\u0004', 1L, this.blankPixelsOffset_);
        }
        this.writeIFDEntry(ifdBuffer, charView, '\u0115', '\u0003', 1L, this.rgb_ ? 3 : 1);
        this.writeIFDEntry(ifdBuffer, charView, '\u0116', '\u0003', 1L, this.imageHeight_);
        this.writeIFDEntry(ifdBuffer, charView, '\u0117', '\u0004', 1L, this.bytesPerImagePixels_);
        this.writeIFDEntry(ifdBuffer, charView, '\u011a', '\u0005', 1L, tagDataOffset);
        this.writeIFDEntry(ifdBuffer, charView, '\u011b', '\u0005', 1L, tagDataOffset += 8L);
        tagDataOffset += 8L;
        this.writeIFDEntry(ifdBuffer, charView, '\u0128', '\u0003', 1L, 3L);
        if (this.firstIFD_) {
            this.ijMetadataCountsTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(ifdBuffer, charView, '\uc696', '\u0004', 0L, 0L);
            this.ijMetadataTagPosition_ = this.filePosition_ + (long)this.bufferPosition_;
            this.writeIFDEntry(ifdBuffer, charView, '\uc697', '\u0001', 0L, 0L);
        }
        this.writeIFDEntry(ifdBuffer, charView, '\uc7b3', '\u0002', mdBytes.length, tagDataOffset);
        ifdBuffer.putInt(this.bufferPosition_, (int)(tagDataOffset += (long)mdBytes.length));
        this.bufferPosition_ += 4;
        if (this.rgb_) {
            charView.put(this.bufferPosition_ / 2, (char)(this.byteDepth_ * 8));
            charView.put(this.bufferPosition_ / 2 + 1, (char)(this.byteDepth_ * 8));
            charView.put(this.bufferPosition_ / 2 + 2, (char)(this.byteDepth_ * 8));
        }
        this.buffers_.add(ifdBuffer);
        if (!blankPixelsAlreadyWritten) {
            this.buffers_.add(ByteBuffer.wrap(new byte[this.bytesPerImagePixels_]));
        }
        this.buffers_.add(this.getResolutionValuesBuffer());
        this.buffers_.add(ByteBuffer.wrap(mdBytes));
        this.filePosition_ += (long)totalBytes;
        this.firstIFD_ = false;
    }
}

