/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Set;
import javax.swing.SwingUtilities;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.acquisition.InvalidIndexMapException;
import org.micromanager.acquisition.MultipageTiffWriter;
import org.micromanager.imagedisplay.DisplaySettings;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ProgressBar;
import org.micromanager.utils.ReportingUtils;

public class MultipageTiffReader {
    private static final long BIGGEST_INT_BIT = (long)Math.pow(2.0, 31.0);
    public static final char BITS_PER_SAMPLE = '\u0102';
    public static final char STRIP_OFFSETS = '\u0111';
    public static final char SAMPLES_PER_PIXEL = '\u0115';
    public static final char STRIP_BYTE_COUNTS = '\u0117';
    public static final char IMAGE_DESCRIPTION = '\u010e';
    public static final char MM_METADATA = '\uc7b3';
    private ByteOrder byteOrder_;
    private File file_;
    private RandomAccessFile raFile_;
    private FileChannel fileChannel_;
    private JSONObject displayAndComments_;
    private JSONObject summaryMetadata_;
    private int byteDepth_ = 0;
    private boolean rgb_;
    private boolean writingFinished_;
    private HashMap<String, Long> indexMap_;

    public MultipageTiffReader(JSONObject summaryMD) {
        this.displayAndComments_ = new JSONObject();
        this.summaryMetadata_ = summaryMD;
        this.byteOrder_ = MultipageTiffWriter.BYTE_ORDER;
        this.getRGBAndByteDepth(summaryMD);
        this.writingFinished_ = false;
    }

    public void setIndexMap(HashMap<String, Long> indexMap) {
        this.indexMap_ = indexMap;
    }

    public void setFileChannel(FileChannel fc) {
        this.fileChannel_ = fc;
    }

    public MultipageTiffReader(File file) throws IOException, InvalidIndexMapException {
        this.displayAndComments_ = new JSONObject();
        this.file_ = file;
        try {
            this.createFileChannel(false);
        }
        catch (Exception ex) {
            ReportingUtils.showError("Can't successfully open file: " + this.file_.getName());
        }
        this.writingFinished_ = true;
        long firstIFD = this.readHeader();
        this.summaryMetadata_ = this.readSummaryMD();
        try {
            this.readIndexMap();
        }
        catch (IOException e) {
            throw new InvalidIndexMapException(e);
        }
        try {
            this.displayAndComments_.put("Channels", this.readDisplaySettings());
            this.displayAndComments_.put("Comments", this.readComments());
        }
        catch (Exception ex) {
            ReportingUtils.logError("Problem with JSON Representation of DisplayAndComments");
        }
        if (this.summaryMetadata_ != null) {
            this.getRGBAndByteDepth(this.summaryMetadata_);
        }
    }

    public MultipageTiffReader(File file, boolean shouldFixIndexMap) throws IOException {
        if (!shouldFixIndexMap) {
            throw new IllegalArgumentException("Don't call this method unless you're fixing index maps!");
        }
        this.file_ = file;
        try {
            this.createFileChannel(true);
        }
        catch (Exception ex) {
            ReportingUtils.showError("Can't successfully open file: " + this.file_.getName());
        }
        this.writingFinished_ = true;
        long firstIFD = this.readHeader();
        this.summaryMetadata_ = this.readSummaryMD();
        this.fixIndexMap(firstIFD, file.getName());
    }

    public static boolean isMMMultipageTiff(String directory) throws IOException {
        ByteOrder bo;
        RandomAccessFile ra;
        File dir = new File(directory);
        File[] children = dir.listFiles();
        File testFile = null;
        block2: for (File child : children) {
            if (child.isDirectory()) {
                File[] grandchildren;
                for (File grandchild : grandchildren = child.listFiles()) {
                    if (!grandchild.getName().endsWith(".tif")) continue;
                    testFile = grandchild;
                    continue block2;
                }
                continue;
            }
            if (!child.getName().endsWith(".tif") && !child.getName().endsWith(".TIF")) continue;
            testFile = child;
            break;
        }
        if (testFile == null) {
            throw new IOException("Unexpected file structure: is this an MM dataset?");
        }
        try {
            ra = new RandomAccessFile(testFile, "r");
        }
        catch (FileNotFoundException ex) {
            ReportingUtils.logError(ex);
            return false;
        }
        FileChannel channel = ra.getChannel();
        ByteBuffer tiffHeader = ByteBuffer.allocate(36);
        channel.read(tiffHeader, 0L);
        char zeroOne = tiffHeader.getChar(0);
        if (zeroOne == '\u4949') {
            bo = ByteOrder.LITTLE_ENDIAN;
        } else if (zeroOne == '\u4d4d') {
            bo = ByteOrder.BIG_ENDIAN;
        } else {
            ra.close();
            throw new IOException("Error reading Tiff header");
        }
        tiffHeader.order(bo);
        int summaryMDHeader = tiffHeader.getInt(32);
        channel.close();
        ra.close();
        return summaryMDHeader == 2355492;
    }

    public void finishedWriting() {
        this.writingFinished_ = true;
    }

    private void getRGBAndByteDepth(JSONObject md) {
        try {
            String pixelType = MDUtils.getPixelType(md);
            this.rgb_ = pixelType.startsWith("RGB");
            this.byteDepth_ = pixelType.equals("RGB32") || pixelType.equals("GRAY8") ? 1 : 2;
        }
        catch (JSONException ex) {
            ReportingUtils.showError(ex);
        }
        catch (MMScriptException ex) {
            ReportingUtils.showError(ex);
        }
    }

    public JSONObject getSummaryMetadata() {
        return this.summaryMetadata_;
    }

    public JSONObject getDisplayAndComments() {
        return this.displayAndComments_;
    }

    public TaggedImage readImage(String label) {
        if (this.indexMap_.containsKey(label)) {
            if (this.fileChannel_ == null) {
                ReportingUtils.logError("Attempted to read image on FileChannel that is null");
                return null;
            }
            try {
                long byteOffset = this.indexMap_.get(label);
                IFDData data = this.readIFD(byteOffset);
                return this.readTaggedImage(data);
            }
            catch (IOException ex) {
                ReportingUtils.logError(ex);
                return null;
            }
        }
        return null;
    }

    public Set<String> getIndexKeys() {
        if (this.indexMap_ == null) {
            return null;
        }
        return this.indexMap_.keySet();
    }

    private JSONObject readSummaryMD() {
        try {
            ByteBuffer mdInfo = ByteBuffer.allocate(8).order(this.byteOrder_);
            this.fileChannel_.read(mdInfo, 32L);
            int header = mdInfo.getInt(0);
            int length = mdInfo.getInt(4);
            if (header != 2355492) {
                ReportingUtils.logError("Summary Metadata Header Incorrect");
                return null;
            }
            ByteBuffer mdBuffer = ByteBuffer.allocate(length).order(this.byteOrder_);
            this.fileChannel_.read(mdBuffer, 40L);
            JSONObject summaryMD = new JSONObject(this.getString(mdBuffer));
            if (this.displayAndComments_ != null && this.displayAndComments_.has("Comments") && this.displayAndComments_.getJSONObject("Comments").has("Summary")) {
                summaryMD.put("Comment", this.displayAndComments_.getJSONObject("Comments").getString("Summary"));
            }
            return summaryMD;
        }
        catch (IOException ex) {
            ReportingUtils.showError("Couldn't read summary Metadata from file: " + this.file_.getName());
            return null;
        }
        catch (JSONException ex) {
            ReportingUtils.showError("Couldn't read summary Metadata from file: " + this.file_.getName());
            return null;
        }
    }

    private JSONObject readComments() {
        try {
            long offset = this.readOffsetHeaderAndOffset(99384722, 24);
            ByteBuffer header = this.readIntoBuffer(offset, 8);
            if (header.getInt(0) != 84720485) {
                ReportingUtils.logError("Can't find image comments in file: " + this.file_.getName());
                return null;
            }
            ByteBuffer buffer = this.readIntoBuffer(offset + 8L, header.getInt(4));
            return new JSONObject(this.getString(buffer));
        }
        catch (IOException ex) {
            ReportingUtils.logError("Can't find image comments in file: " + this.file_.getName());
            return null;
        }
        catch (JSONException ex) {
            ReportingUtils.logError("Can't find image comments in file: " + this.file_.getName());
            return null;
        }
    }

    public void rewriteComments(JSONObject comments) throws IOException, JSONException {
        if (this.writingFinished_) {
            byte[] bytes = this.getBytesFromString(comments.toString());
            ByteBuffer byteCount = ByteBuffer.wrap(new byte[4]).order(this.byteOrder_).putInt(0, bytes.length);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            long offset = this.readOffsetHeaderAndOffset(99384722, 24);
            this.fileChannel_.write(byteCount, offset + 4L);
            this.fileChannel_.write(buffer, offset + 8L);
        }
        this.displayAndComments_.put("Comments", comments);
    }

    public void rewriteDisplaySettings(JSONArray settings) throws IOException, JSONException {
        if (this.writingFinished_) {
            long offset = this.readOffsetHeaderAndOffset(483765892, 16);
            int numReservedBytes = this.readIntoBuffer(offset + 4L, 4).getInt(0);
            byte[] blank = new byte[numReservedBytes];
            for (int i = 0; i < blank.length; ++i) {
                blank[i] = 0;
            }
            this.fileChannel_.write(ByteBuffer.wrap(blank), offset + 8L);
            byte[] bytes = this.getBytesFromString(settings.toString());
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            this.fileChannel_.write(buffer, offset + 8L);
        }
        this.displayAndComments_.put("Channels", settings);
    }

    private JSONArray readDisplaySettings() {
        try {
            long offset = this.readOffsetHeaderAndOffset(483765892, 16);
            ByteBuffer header = this.readIntoBuffer(offset, 8);
            if (header.getInt(0) != 347834724) {
                ReportingUtils.logError("Can't find display settings in file: " + this.file_.getName());
                return null;
            }
            ByteBuffer buffer = this.readIntoBuffer(offset + 8L, header.getInt(4));
            return new JSONArray(this.getString(buffer));
        }
        catch (IOException ex) {
            ReportingUtils.logError("Can't find display settings in file: " + this.file_.getName());
            return null;
        }
        catch (JSONException ex) {
            ReportingUtils.logError("Can't find display settings in file: " + this.file_.getName());
            return null;
        }
    }

    private ByteBuffer readIntoBuffer(long position, int length) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(length).order(this.byteOrder_);
        this.fileChannel_.read(buffer, position);
        return buffer;
    }

    private long readOffsetHeaderAndOffset(int offsetHeaderVal, int startOffset) throws IOException {
        ByteBuffer buffer1 = this.readIntoBuffer(startOffset, 8);
        int offsetHeader = buffer1.getInt(0);
        if (offsetHeader != offsetHeaderVal) {
            throw new IOException("Offset header incorrect, expected: " + offsetHeaderVal + "   found: " + offsetHeader);
        }
        return this.unsignInt(buffer1.getInt(4));
    }

    private void readIndexMap() throws IOException, InvalidIndexMapException {
        long offset = this.readOffsetHeaderAndOffset(54773648, 8);
        ByteBuffer header = this.readIntoBuffer(offset, 8);
        if (header.getInt(0) != 3453623) {
            throw new InvalidIndexMapException();
        }
        int numMappings = header.getInt(4);
        this.indexMap_ = new HashMap();
        ByteBuffer mapBuffer = this.readIntoBuffer(offset + 8L, 20 * numMappings);
        for (int i = 0; i < numMappings; ++i) {
            int channel = mapBuffer.getInt(i * 20);
            int slice = mapBuffer.getInt(i * 20 + 4);
            int frame = mapBuffer.getInt(i * 20 + 8);
            int position = mapBuffer.getInt(i * 20 + 12);
            long imageOffset = this.unsignInt(mapBuffer.getInt(i * 20 + 16));
            if (imageOffset == 0L) break;
            this.indexMap_.put(MDUtils.generateLabel(channel, slice, frame, position), imageOffset);
        }
    }

    private IFDData readIFD(long byteOffset) throws IOException {
        ByteBuffer buff = this.readIntoBuffer(byteOffset, 2);
        int numEntries = buff.getChar(0);
        ByteBuffer entries = this.readIntoBuffer(byteOffset + 2L, numEntries * 12 + 4).order(this.byteOrder_);
        IFDData data = new IFDData();
        for (int i = 0; i < numEntries; ++i) {
            IFDEntry entry = this.readDirectoryEntry(i * 12, entries);
            if (entry.tag == '\uc7b3') {
                data.mdOffset = entry.value;
                data.mdLength = entry.count;
                continue;
            }
            if (entry.tag == '\u0111') {
                data.pixelOffset = entry.value;
                continue;
            }
            if (entry.tag != '\u0117') continue;
            data.bytesPerImage = entry.value;
        }
        data.nextIFD = this.unsignInt(entries.getInt(numEntries * 12));
        data.nextIFDOffsetLocation = byteOffset + 2L + (long)(numEntries * 12);
        return data;
    }

    private String getString(ByteBuffer buffer) {
        try {
            return new String(buffer.array(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ReportingUtils.logError(ex);
            return "";
        }
    }

    private TaggedImage readTaggedImage(IFDData data) throws IOException {
        ByteBuffer pixelBuffer = ByteBuffer.allocate((int)data.bytesPerImage).order(this.byteOrder_);
        ByteBuffer mdBuffer = ByteBuffer.allocate((int)data.mdLength).order(this.byteOrder_);
        this.fileChannel_.read(pixelBuffer, data.pixelOffset);
        this.fileChannel_.read(mdBuffer, data.mdOffset);
        JSONObject md = new JSONObject();
        try {
            md = new JSONObject(this.getString(mdBuffer));
        }
        catch (JSONException ex) {
            ReportingUtils.logError("Error reading image metadata from file");
        }
        if (this.byteDepth_ == 0) {
            this.getRGBAndByteDepth(md);
        }
        if (this.rgb_) {
            if (this.byteDepth_ == 1) {
                byte[] pixels = new byte[(int)(4L * data.bytesPerImage / 3L)];
                byte[] source = pixelBuffer.array();
                int numPixels = 0;
                int numComponents = 0;
                for (int i = 0; i < source.length; ++i) {
                    pixels[i + numPixels] = source[i - 2 * (i % 3) + 2];
                    if (++numComponents != 3) continue;
                    pixels[i + numPixels + 1] = 0;
                    ++numPixels;
                    numComponents = 0;
                }
                return new TaggedImage((Object)pixels, md);
            }
            short[] pixels = new short[(int)(2L * (data.bytesPerImage / 3L))];
            int i = 0;
            while (i < pixels.length) {
                pixels[i] = pixelBuffer.getShort(2 * (i / 4 * 3 + i % 4));
                if ((++i + 1) % 4 != 0) continue;
                pixels[i] = 0;
                ++i;
            }
            return new TaggedImage((Object)pixels, md);
        }
        if (this.byteDepth_ == 1) {
            return new TaggedImage((Object)pixelBuffer.array(), md);
        }
        short[] pix = new short[pixelBuffer.capacity() / 2];
        for (int i = 0; i < pix.length; ++i) {
            pix[i] = pixelBuffer.getShort(i * 2);
        }
        return new TaggedImage((Object)pix, md);
    }

    private IFDEntry readDirectoryEntry(int offset, ByteBuffer buffer) throws IOException {
        char tag = buffer.getChar(offset);
        char type = buffer.getChar(offset + 2);
        long count = this.unsignInt(buffer.getInt(offset + 4));
        long value = type == '\u0003' && count == 1L ? (long)buffer.getChar(offset + 8) : this.unsignInt(buffer.getInt(offset + 8));
        return new IFDEntry(tag, type, count, value);
    }

    private long readHeader() throws IOException {
        ByteBuffer tiffHeader = ByteBuffer.allocate(8);
        this.fileChannel_.read(tiffHeader, 0L);
        char zeroOne = tiffHeader.getChar(0);
        if (zeroOne == '\u4949') {
            this.byteOrder_ = ByteOrder.LITTLE_ENDIAN;
        } else if (zeroOne == '\u4d4d') {
            this.byteOrder_ = ByteOrder.BIG_ENDIAN;
        } else {
            throw new IOException("Error reading Tiff header");
        }
        tiffHeader.order(this.byteOrder_);
        short twoThree = tiffHeader.getShort(2);
        if (twoThree != 42) {
            throw new IOException("Tiff identifier code incorrect");
        }
        return this.unsignInt(tiffHeader.getInt(4));
    }

    private byte[] getBytesFromString(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ReportingUtils.logError("Error encoding String to bytes");
            return null;
        }
    }

    private void createFileChannel(boolean isReadWrite) throws FileNotFoundException, IOException {
        this.raFile_ = new RandomAccessFile(this.file_, isReadWrite ? "rw" : "r");
        this.fileChannel_ = this.raFile_.getChannel();
    }

    public void close() throws IOException {
        if (this.fileChannel_ != null) {
            this.fileChannel_.close();
            this.fileChannel_ = null;
        }
        if (this.raFile_ != null) {
            this.raFile_.close();
            this.raFile_ = null;
        }
    }

    private long unsignInt(int i) {
        long val = Integer.MAX_VALUE & i;
        if (i < 0) {
            val += BIGGEST_INT_BIT;
        }
        return val;
    }

    private void fixIndexMap(long firstIFD, String fileName) throws IOException {
        long filePosition = firstIFD;
        this.indexMap_ = new HashMap();
        long progBarMax = this.fileChannel_.size() / 2L;
        final ProgressBar progressBar = new ProgressBar("Fixing " + fileName, 0, progBarMax >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)progBarMax);
        progressBar.setRange(0, progBarMax >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)progBarMax);
        progressBar.setProgress(0);
        progressBar.setVisible(true);
        long nextIFDOffsetLocation = 0L;
        while (filePosition > 0L) {
            try {
                IFDData data = this.readIFD(filePosition);
                if (data.nextIFD == 0L) break;
                TaggedImage ti = this.readTaggedImage(data);
                if (ti.tags == null || ti.tags.length() == 0) {
                    filePosition = data.nextIFD;
                    nextIFDOffsetLocation = data.nextIFDOffsetLocation;
                    continue;
                }
                String label = MDUtils.getLabel(ti.tags);
                if (label == null) break;
                this.indexMap_.put(label, filePosition);
                final int progress = (int)(filePosition / 2L);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressBar.setProgress(progress);
                    }
                });
                if (data.nextIFD <= filePosition || data.nextIFDOffsetLocation <= nextIFDOffsetLocation) break;
                filePosition = data.nextIFD;
                nextIFDOffsetLocation = data.nextIFDOffsetLocation;
            }
            catch (Exception e) {
                // empty catch block
                break;
            }
        }
        progressBar.setVisible(false);
        filePosition += (long)this.writeIndexMap(filePosition);
        ByteBuffer buffer = ByteBuffer.allocate(4).order(this.byteOrder_);
        buffer.putInt(0, 0);
        this.fileChannel_.write(buffer, nextIFDOffsetLocation);
        JSONArray settings = null;
        try {
            settings = DisplaySettings.getDisplaySettingsFromSummary(this.summaryMetadata_).getJSONArray("Channels");
        }
        catch (Exception ex) {
            ReportingUtils.showError((Throwable)ex, "Problem saving file.  PLease test to make sure file can be opened");
        }
        filePosition += (long)this.writeDisplaySettings(settings, filePosition);
        this.fileChannel_.close();
        this.raFile_.close();
        this.createFileChannel(false);
    }

    private int writeDisplaySettings(JSONArray settings, long filePosition) throws IOException {
        int numReservedBytes = settings.length() * 256;
        ByteBuffer header = ByteBuffer.allocate(8).order(MultipageTiffWriter.BYTE_ORDER);
        ByteBuffer buffer = ByteBuffer.wrap(this.getBytesFromString(settings.toString()));
        header.putInt(0, 347834724);
        header.putInt(4, numReservedBytes);
        this.fileChannel_.write(header, filePosition);
        this.fileChannel_.write(buffer, filePosition + 8L);
        ByteBuffer offsetHeader = ByteBuffer.allocate(8).order(MultipageTiffWriter.BYTE_ORDER);
        offsetHeader.putInt(0, 483765892);
        offsetHeader.putInt(4, (int)filePosition);
        this.fileChannel_.write(offsetHeader, 16L);
        return numReservedBytes + 8;
    }

    private int writeIndexMap(long filePosition) throws IOException {
        int numMappings = this.indexMap_.size();
        ByteBuffer buffer = ByteBuffer.allocate(8 + 20 * numMappings).order(this.byteOrder_);
        buffer.putInt(0, 3453623);
        buffer.putInt(4, numMappings);
        int position = 2;
        for (String label : this.indexMap_.keySet()) {
            String[] indecies;
            for (String index : indecies = label.split("_")) {
                buffer.putInt(4 * position, Integer.parseInt(index));
                ++position;
            }
            buffer.putInt(4 * position, this.indexMap_.get(label).intValue());
            ++position;
        }
        this.fileChannel_.write(buffer, filePosition);
        ByteBuffer header = ByteBuffer.allocate(8).order(this.byteOrder_);
        header.putInt(0, 54773648);
        header.putInt(4, (int)filePosition);
        this.fileChannel_.write(header, 8L);
        return buffer.capacity();
    }

    private class IFDEntry {
        public char tag;
        public char type;
        public long count;
        public long value;

        public IFDEntry(char tg, char typ, long cnt, long val) {
            this.tag = tg;
            this.type = typ;
            this.count = cnt;
            this.value = val;
        }
    }

    private class IFDData {
        public long pixelOffset;
        public long bytesPerImage;
        public long mdOffset;
        public long mdLength;
        public long nextIFD;
        public long nextIFDOffsetLocation;
    }
}

