/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.acquisition.TaggedImageStorageRamFast;
import org.micromanager.api.ImageCache;
import org.micromanager.api.ImageCacheListener;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ProgressBar;
import org.micromanager.utils.ReportingUtils;

public class MMImageCache
implements ImageCache {
    public final List<ImageCacheListener> imageStorageListeners_ = Collections.synchronizedList(new ArrayList());
    private TaggedImageStorage imageStorage_;
    private Set<String> changingKeys_;
    private JSONObject firstTags_;
    private int lastFrame_ = -1;
    private JSONObject lastTags_;
    private final ExecutorService listenerExecutor_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addImageCacheListener(ImageCacheListener l) {
        List<ImageCacheListener> list = this.imageStorageListeners_;
        synchronized (list) {
            this.imageStorageListeners_.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageCacheListener[] getImageCacheListeners() {
        List<ImageCacheListener> list = this.imageStorageListeners_;
        synchronized (list) {
            return (ImageCacheListener[])this.imageStorageListeners_.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeImageCacheListener(ImageCacheListener l) {
        List<ImageCacheListener> list = this.imageStorageListeners_;
        synchronized (list) {
            this.imageStorageListeners_.remove(l);
        }
    }

    public MMImageCache(TaggedImageStorage imageStorage) {
        this.imageStorage_ = imageStorage;
        this.changingKeys_ = new HashSet<String>();
        this.listenerExecutor_ = Executors.newFixedThreadPool(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished() {
        this.imageStorage_.finished();
        String path = this.getDiskLocation();
        List<ImageCacheListener> list = this.imageStorageListeners_;
        synchronized (list) {
            for (ImageCacheListener l : this.imageStorageListeners_) {
                l.imagingFinished(path);
            }
        }
        this.listenerExecutor_.shutdown();
    }

    @Override
    public boolean isFinished() {
        return this.imageStorage_.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastAcquiredFrame() {
        MMImageCache mMImageCache = this;
        synchronized (mMImageCache) {
            this.lastFrame_ = Math.max(this.imageStorage_.lastAcquiredFrame(), this.lastFrame_);
            return this.lastFrame_;
        }
    }

    @Override
    public String getDiskLocation() {
        return this.imageStorage_.getDiskLocation();
    }

    @Override
    public void setDisplayAndComments(JSONObject settings) {
        this.imageStorage_.setDisplayAndComments(settings);
    }

    @Override
    public JSONObject getDisplayAndComments() {
        return this.imageStorage_.getDisplayAndComments();
    }

    @Override
    public void writeDisplaySettings() {
        this.imageStorage_.writeDisplaySettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.imageStorage_.close();
        List<ImageCacheListener> list = this.imageStorageListeners_;
        synchronized (list) {
            this.imageStorageListeners_.clear();
        }
    }

    @Override
    public void saveAs(TaggedImageStorage newImageFileManager) {
        this.saveAs(newImageFileManager, true);
        this.finished();
    }

    @Override
    public void saveAs(TaggedImageStorage newImageFileManager, boolean useNewStorage) {
        if (newImageFileManager == null) {
            return;
        }
        newImageFileManager.setSummaryMetadata(this.imageStorage_.getSummaryMetadata());
        newImageFileManager.setDisplayAndComments(this.getDisplayAndComments());
        String progressBarTitle = newImageFileManager instanceof TaggedImageStorageRamFast ? "Loading images..." : "Saving images...";
        final ProgressBar progressBar = new ProgressBar(progressBarTitle, 0, 100);
        ArrayList<String> keys = new ArrayList<String>(this.imageKeys());
        int n = keys.size();
        progressBar.setRange(0, n);
        progressBar.setProgress(0);
        progressBar.setVisible(true);
        boolean wasSuccessful = true;
        for (int i = 0; i < n; ++i) {
            final int i1 = i;
            int[] pos = MDUtils.getIndices(keys.get(i));
            try {
                newImageFileManager.putImage(this.getImage(pos[0], pos[1], pos[2], pos[3]));
            }
            catch (MMException ex) {
                ReportingUtils.logError(ex);
            }
            catch (IOException ex) {
                ReportingUtils.showError((Throwable)ex, "Unable to write image " + i);
                wasSuccessful = false;
                break;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressBar.setProgress(i1);
                }
            });
        }
        if (wasSuccessful) {
            newImageFileManager.finished();
        }
        progressBar.setVisible(false);
        if (useNewStorage) {
            this.imageStorage_ = newImageFileManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putImage(final TaggedImage taggedImg) {
        try {
            this.checkForChangingTags(taggedImg);
            this.imageStorage_.putImage(taggedImg);
            MMImageCache mMImageCache = this;
            synchronized (mMImageCache) {
                this.lastFrame_ = Math.max(this.lastFrame_, MDUtils.getFrameIndex(taggedImg.tags));
                this.lastTags_ = taggedImg.tags;
            }
            JSONObject displayAndComments = this.imageStorage_.getDisplayAndComments();
            if (displayAndComments.length() > 0) {
                JSONArray channelSettings = this.imageStorage_.getDisplayAndComments().getJSONArray("Channels");
                JSONObject imageTags = taggedImg.tags;
                int chanIndex = MDUtils.getChannelIndex(imageTags);
                if (chanIndex >= channelSettings.length()) {
                    JSONObject newChanObject = new JSONObject();
                    MDUtils.setChannelName(newChanObject, MDUtils.getChannelName(imageTags));
                    MDUtils.setChannelColor(newChanObject, MDUtils.getChannelColor(imageTags));
                    channelSettings.put(chanIndex, newChanObject);
                }
            }
            List<ImageCacheListener> list = this.imageStorageListeners_;
            synchronized (list) {
                for (final ImageCacheListener l : this.imageStorageListeners_) {
                    this.listenerExecutor_.submit(new Runnable(){

                        @Override
                        public void run() {
                            l.imageReceived(taggedImg);
                        }
                    });
                }
            }
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject getLastImageTags() {
        MMImageCache mMImageCache = this;
        synchronized (mMImageCache) {
            return this.lastTags_;
        }
    }

    @Override
    public TaggedImage getImage(int channel, int slice, int frame, int position) {
        TaggedImage taggedImg = null;
        if (taggedImg == null && (taggedImg = this.imageStorage_.getImage(channel, slice, frame, position)) != null) {
            this.checkForChangingTags(taggedImg);
        }
        return taggedImg;
    }

    @Override
    public JSONObject getImageTags(int channel, int slice, int frame, int position) {
        String label = MDUtils.generateLabel(channel, slice, frame, position);
        JSONObject tags = null;
        if (tags == null) {
            tags = this.imageStorage_.getImageTags(channel, slice, frame, position);
        }
        return tags;
    }

    private void checkForChangingTags(TaggedImage taggedImg) {
        if (this.firstTags_ == null) {
            this.firstTags_ = taggedImg.tags;
        } else {
            Iterator<String> keys = taggedImg.tags.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                try {
                    if (taggedImg.tags.isNull(key)) continue;
                    if (!this.firstTags_.has(key) || this.firstTags_.isNull(key)) {
                        this.changingKeys_.add(key);
                        continue;
                    }
                    if (taggedImg.tags.getString(key).contentEquals(this.firstTags_.getString(key))) continue;
                    this.changingKeys_.add(key);
                }
                catch (Exception e) {
                    ReportingUtils.logError(e);
                }
            }
        }
    }

    private JSONObject getCommentsJSONObject() {
        JSONObject comments;
        if (this.imageStorage_ == null) {
            ReportingUtils.logError("imageStorage_ is null in getCommentsJSONObject");
            return null;
        }
        try {
            comments = this.imageStorage_.getDisplayAndComments().getJSONObject("Comments");
        }
        catch (JSONException ex) {
            comments = new JSONObject();
            try {
                this.imageStorage_.getDisplayAndComments().put("Comments", comments);
            }
            catch (JSONException ex1) {
                ReportingUtils.logError(ex1);
            }
        }
        return comments;
    }

    @Override
    public boolean getIsOpen() {
        return this.getDisplayAndComments() != null;
    }

    @Override
    public void setComment(String text) {
        JSONObject comments = this.getCommentsJSONObject();
        try {
            comments.put("Summary", text);
        }
        catch (JSONException ex) {
            ReportingUtils.logError(ex);
        }
    }

    @Override
    public void setImageComment(String comment, JSONObject tags) {
        JSONObject comments = this.getCommentsJSONObject();
        String label = MDUtils.getLabel(tags);
        try {
            comments.put(label, comment);
        }
        catch (JSONException ex) {
            ReportingUtils.logError(ex);
        }
    }

    @Override
    public String getImageComment(JSONObject tags) {
        if (tags == null) {
            return "";
        }
        try {
            String label = MDUtils.getLabel(tags);
            return this.getCommentsJSONObject().getString(label);
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public String getComment() {
        try {
            return this.getCommentsJSONObject().getString("Summary");
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public JSONObject getSummaryMetadata() {
        if (this.imageStorage_ == null) {
            ReportingUtils.logError("imageStorage_ is null in getSummaryMetadata");
            return null;
        }
        return this.imageStorage_.getSummaryMetadata();
    }

    @Override
    public void setSummaryMetadata(JSONObject tags) {
        if (this.imageStorage_ == null) {
            ReportingUtils.logError("imageStorage_ is null in setSummaryMetadata");
            return;
        }
        this.imageStorage_.setSummaryMetadata(tags);
    }

    @Override
    public Set<String> getChangingKeys() {
        return this.changingKeys_;
    }

    @Override
    public Set<String> imageKeys() {
        return this.imageStorage_.imageKeys();
    }

    private boolean isRGB() throws JSONException, MMScriptException {
        return MDUtils.isRGB(this.getSummaryMetadata());
    }

    @Override
    public String getPixelType() {
        try {
            return MDUtils.getPixelType(this.getSummaryMetadata());
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
            return null;
        }
    }

    @Override
    public void storeChannelDisplaySettings(int channelIndex, int min, int max, double gamma, int histMax, int displayMode) {
        try {
            JSONObject settings = this.getChannelSetting(channelIndex);
            settings.put("Max", max);
            settings.put("Min", min);
            settings.put("Gamma", gamma);
            settings.put("HistogramMax", histMax);
            settings.put("DisplayMode", displayMode);
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
        }
    }

    @Override
    public JSONObject getChannelSetting(int channel) {
        try {
            JSONArray array = this.getDisplayAndComments().getJSONArray("Channels");
            if (channel >= array.length()) {
                array.put(channel, new JSONObject(array.getJSONObject(0).toString()));
            }
            if (!array.isNull(channel)) {
                return array.getJSONObject(channel);
            }
            return null;
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
            return null;
        }
    }

    @Override
    public int getBitDepth() {
        try {
            return this.imageStorage_.getSummaryMetadata().getInt("BitDepth");
        }
        catch (JSONException ex) {
            ReportingUtils.logError("MMImageCache.BitDepth: no tag BitDepth found");
            return 16;
        }
    }

    @Override
    public Color getChannelColor(int channelIndex) {
        try {
            if (this.isRGB()) {
                return channelIndex == 0 ? Color.red : (channelIndex == 1 ? Color.green : Color.blue);
            }
            return new Color(this.getChannelSetting(channelIndex).getInt("Color"));
        }
        catch (Exception ex) {
            return Color.WHITE;
        }
    }

    @Override
    public void setChannelColor(int channel, int rgb) {
        JSONObject chan = this.getChannelSetting(channel);
        try {
            if (chan == null) {
                return;
            }
            chan.put("Color", rgb);
        }
        catch (JSONException ex) {
            ReportingUtils.logError(ex);
        }
    }

    @Override
    public String getChannelName(int channelIndex) {
        try {
            if (this.isRGB()) {
                return channelIndex == 0 ? "Red" : (channelIndex == 1 ? "Green" : "Blue");
            }
            JSONObject channelSetting = this.getChannelSetting(channelIndex);
            if (channelSetting.has("Name")) {
                return channelSetting.getString("Name");
            }
            return "";
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
            return "";
        }
    }

    public void setChannelName(int channel, String channelName) {
        try {
            JSONArray channelArray;
            if (this.isRGB()) {
                return;
            }
            JSONObject displayAndComments = this.getDisplayAndComments();
            if (displayAndComments.has("Channels")) {
                channelArray = displayAndComments.getJSONArray("Channels");
            } else {
                channelArray = new JSONArray();
                displayAndComments.put("Channels", channelArray);
            }
            if (channelArray.isNull(channel)) {
                channelArray.put(channel, new JSONObject().put("Name", channelName));
            }
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
        }
    }

    @Override
    public int getDisplayMode() {
        try {
            return this.getChannelSetting(0).getInt("DisplayMode");
        }
        catch (JSONException ex) {
            return 1;
        }
    }

    @Override
    public int getChannelMin(int channelIndex) {
        try {
            return this.getChannelSetting(channelIndex).getInt("Min");
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int getChannelMax(int channelIndex) {
        try {
            return this.getChannelSetting(channelIndex).getInt("Max");
        }
        catch (Exception ex) {
            return -1;
        }
    }

    @Override
    public double getChannelGamma(int channelIndex) {
        try {
            return this.getChannelSetting(channelIndex).getDouble("Gamma");
        }
        catch (Exception ex) {
            return 1.0;
        }
    }

    @Override
    public int getChannelHistogramMax(int channelIndex) {
        try {
            return this.getChannelSetting(channelIndex).getInt("HistogramMax");
        }
        catch (JSONException ex) {
            return -1;
        }
    }

    @Override
    public int getNumDisplayChannels() {
        JSONArray array;
        try {
            array = this.getDisplayAndComments().getJSONArray("Channels");
        }
        catch (Exception ex) {
            return 1;
        }
        return array.length();
    }

    @Override
    public long getDataSetSize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

