/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import ij.gui.ImageWindow;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.SwingUtilities;
import mmcorej.CMMCore;
import mmcorej.TaggedImage;
import org.micromanager.MMStudio;
import org.micromanager.SnapLiveManager;
import org.micromanager.acquisition.TaggedImageQueue;
import org.micromanager.imagedisplay.VirtualAcquisitionDisplay;
import org.micromanager.utils.CanvasPaintPending;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class LiveModeTimer {
    private VirtualAcquisitionDisplay win_;
    private CMMCore core_;
    private MMStudio studio_;
    private SnapLiveManager snapLiveManager_;
    private int multiChannelCameraNrCh_;
    private Thread displayThread_;
    private long fpsTimer_;
    private long fpsCounter_;
    private long imageNumber_;
    private long oldImageNumber_;
    private long fpsInterval_ = 5000L;
    private final NumberFormat format_;
    private boolean running_ = false;
    private Runnable task_;
    private final MMStudio.DisplayImageRoutine displayImageRoutine_;
    private LinkedBlockingQueue<TaggedImage> imageQueue_;
    private static int mCamImageCounter_ = 0;
    private boolean multiCam_ = false;
    private final TimerController timerController_ = new TimerController();

    public LiveModeTimer() {
        this.studio_ = MMStudio.getInstance();
        this.snapLiveManager_ = this.studio_.getSnapLiveManager();
        this.core_ = this.studio_.getCore();
        this.format_ = NumberFormat.getInstance();
        this.format_.setMaximumFractionDigits(1);
        mCamImageCounter_ = 0;
        this.displayImageRoutine_ = new MMStudio.DisplayImageRoutine(){

            @Override
            public void show(TaggedImage ti) {
                try {
                    MDUtils.setSummary(ti.tags, MMStudio.getInstance().getAcquisitionWithName("Snap/Live Window").getSummaryMetadata());
                }
                catch (Exception e) {
                    ReportingUtils.logError(e, "Error setting summary metadata");
                }
                try {
                    ImageWindow window;
                    if (LiveModeTimer.this.multiCam_) {
                        mCamImageCounter_++;
                        if (mCamImageCounter_ < LiveModeTimer.this.multiChannelCameraNrCh_) {
                            LiveModeTimer.this.studio_.normalizeTags(ti);
                            LiveModeTimer.this.studio_.addImage("Snap/Live Window", ti, false, false);
                            return;
                        }
                        mCamImageCounter_ = 0;
                    }
                    if (!CanvasPaintPending.isMyPaintPending((window = LiveModeTimer.this.snapLiveManager_.getSnapLiveWindow()).getCanvas(), this)) {
                        CanvasPaintPending.setPaintPending(window.getCanvas(), this);
                        LiveModeTimer.this.studio_.normalizeTags(ti);
                        LiveModeTimer.this.studio_.addImage("Snap/Live Window", ti, true, true);
                        LiveModeTimer.this.studio_.updateLineProfile();
                        LiveModeTimer.this.updateFPS();
                    }
                }
                catch (MMScriptException e) {
                    ReportingUtils.logError(e);
                }
            }
        };
    }

    private long getInterval() {
        double interval = 20.0;
        try {
            interval = Math.max(this.core_.getExposure(), interval);
        }
        catch (Exception e) {
            ReportingUtils.logError("Unable to get exposure from core");
        }
        this.fpsInterval_ = (long)(20.0 * interval);
        if (this.fpsInterval_ < 1000L) {
            this.fpsInterval_ = 1000L;
        }
        return (int)interval;
    }

    private void setType() {
        this.multiChannelCameraNrCh_ = (int)this.core_.getNumberOfCameraChannels();
        if (this.multiChannelCameraNrCh_ == 1) {
            this.task_ = this.singleCameraLiveTask();
            this.multiCam_ = false;
        } else {
            this.task_ = this.multiCamLiveTask();
            this.multiCam_ = true;
        }
    }

    public boolean isRunning() {
        return this.running_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() throws Exception {
        long start;
        if (this.running_) {
            return;
        }
        this.core_.clearCircularBuffer();
        try {
            this.core_.startContinuousSequenceAcquisition(0.0);
        }
        catch (Exception e) {
            ReportingUtils.showError("Unable to start the sequence acquisition: " + e);
            throw e;
        }
        this.setType();
        long period = this.getInterval();
        long now = start = System.currentTimeMillis();
        long timeout = period + 10000L;
        while (this.core_.getRemainingImageCount() == 0 && now - start < timeout) {
            now = System.currentTimeMillis();
            Thread.sleep(5L);
        }
        if (now - start >= timeout) {
            throw new Exception("Camera did not send image within " + timeout + "ms");
        }
        TaggedImage timg = this.core_.getLastTaggedImage();
        this.snapLiveManager_.validateDisplayAndAcquisition(timg);
        this.win_ = this.snapLiveManager_.getSnapLiveDisplay();
        long firstImageSequenceNumber = MDUtils.getSequenceNumber(timg.tags);
        LiveModeTimer liveModeTimer = this;
        synchronized (liveModeTimer) {
            this.fpsCounter_ = 0L;
            this.fpsTimer_ = System.nanoTime();
            this.imageNumber_ = firstImageSequenceNumber;
            this.oldImageNumber_ = firstImageSequenceNumber;
        }
        this.imageQueue_ = new LinkedBlockingQueue(10);
        if (!this.multiCam_) {
            this.imageQueue_.put(timg);
        }
        this.timerController_.start(this.task_, period);
        this.win_.getImagePlus().getWindow().toFront();
        this.running_ = true;
        this.displayThread_ = this.studio_.runDisplayThread(this.imageQueue_, this.displayImageRoutine_);
    }

    public void stop() {
        this.stop(true);
    }

    private void stop(boolean firstAttempt) {
        block9: {
            ReportingUtils.logMessage("Stop called in LiveModeTimer, " + (firstAttempt ? "first" : "second") + " attempt");
            try {
                if (this.core_.isSequenceRunning()) {
                    this.core_.stopSequenceAcquisition();
                }
                this.running_ = false;
            }
            catch (Exception ex) {
                ReportingUtils.showError(ex);
                if (!firstAttempt) break block9;
                long RETRY_DELAY_MS = 1000L;
                ReportingUtils.logMessage("Will try again to stop live acquisition after 1000 ms");
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        LiveModeTimer.this.stop(false);
                    }
                }, 1000L);
            }
        }
        this.timerController_.stop();
        ReportingUtils.logMessage("Waiting for timer to stop");
        this.timerController_.waitForCompletion();
        ReportingUtils.logMessage("Finished waiting for timer to stop");
        try {
            if (this.imageQueue_ != null) {
                this.imageQueue_.put(TaggedImageQueue.POISON);
                this.imageQueue_ = null;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (this.displayThread_ != null) {
            ReportingUtils.logMessage("Waiting for live mode display thread");
            try {
                this.displayThread_.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ReportingUtils.logMessage("Finished waiting for live mode display thread");
            this.displayThread_ = null;
        }
    }

    private synchronized boolean setImageNumber(long imageNumber) {
        if (imageNumber > this.imageNumber_) {
            this.imageNumber_ = imageNumber;
            return true;
        }
        return false;
    }

    private synchronized void updateFPS() {
        if (!this.running_) {
            return;
        }
        if (this.imageNumber_ == this.oldImageNumber_) {
            return;
        }
        try {
            ++this.fpsCounter_;
            long now = System.nanoTime();
            long diffMs = (now - this.fpsTimer_) / 1000000L;
            if (diffMs > this.fpsInterval_) {
                double d = (double)diffMs / 1000.0;
                double fps = (double)this.fpsCounter_ / d;
                double dfps = (double)(this.imageNumber_ - this.oldImageNumber_) / d;
                this.win_.displayStatusLine("fps: " + this.format_.format(dfps) + ", display fps: " + this.format_.format(fps));
                this.fpsCounter_ = 0L;
                this.fpsTimer_ = now;
                this.oldImageNumber_ = this.imageNumber_;
            }
        }
        catch (Exception ex) {
            ReportingUtils.logError(ex);
        }
    }

    private Runnable singleCameraLiveTask() {
        return new Runnable(){

            @Override
            public void run() {
                if (LiveModeTimer.this.core_.getRemainingImageCount() == 0) {
                    return;
                }
                if (LiveModeTimer.this.win_.windowClosed()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LiveModeTimer.this.snapLiveManager_.setLiveMode(false);
                        }
                    });
                } else {
                    try {
                        TaggedImage ti = LiveModeTimer.this.core_.getLastTaggedImage();
                        long imageNumber = MDUtils.getSequenceNumber(ti.tags);
                        if (LiveModeTimer.this.setImageNumber(imageNumber)) {
                            LiveModeTimer.this.imageQueue_.put(ti);
                        }
                    }
                    catch (Exception ex) {
                        ReportingUtils.logMessage("Stopping live mode because of error...");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LiveModeTimer.this.snapLiveManager_.setLiveMode(false);
                                ReportingUtils.showError(ex);
                            }
                        });
                    }
                }
            }
        };
    }

    private Runnable multiCamLiveTask() {
        return new Runnable(){

            @Override
            public void run() {
                if (LiveModeTimer.this.core_.getRemainingImageCount() == 0) {
                    return;
                }
                if (LiveModeTimer.this.win_.windowClosed() || !LiveModeTimer.this.studio_.acquisitionExists("Snap/Live Window").booleanValue()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LiveModeTimer.this.snapLiveManager_.setLiveMode(false);
                        }
                    });
                } else {
                    try {
                        String camera = LiveModeTimer.this.core_.getCameraDevice();
                        HashSet<String> cameraChannelsAcquired = new HashSet<String>();
                        for (int i = 0; i < 2 * LiveModeTimer.this.multiChannelCameraNrCh_; ++i) {
                            TaggedImage ti = LiveModeTimer.this.core_.getNBeforeLastTaggedImage((long)i);
                            if (!ti.tags.has(camera + "-CameraChannelName")) continue;
                            String channelName = ti.tags.getString(camera + "-CameraChannelName");
                            if (!cameraChannelsAcquired.contains(channelName)) {
                                MDUtils.setChannelName(ti.tags, channelName);
                                int ccIndex = ti.tags.getInt(camera + "-CameraChannelIndex");
                                MDUtils.setChannelIndex(ti.tags, ccIndex);
                                if (ccIndex == 0) {
                                    LiveModeTimer.this.setImageNumber(MDUtils.getSequenceNumber(ti.tags));
                                }
                                LiveModeTimer.this.imageQueue_.put(ti);
                                cameraChannelsAcquired.add(channelName);
                            }
                            if (cameraChannelsAcquired.size() != LiveModeTimer.this.multiChannelCameraNrCh_) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exc) {
                        ReportingUtils.logMessage("Stopping live mode because of error...");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LiveModeTimer.this.snapLiveManager_.setLiveMode(false);
                                ReportingUtils.showError(exc);
                            }
                        });
                    }
                }
            }
        };
    }

    private class TimerController {
        private Timer timer_;
        private final Object timerLock_ = new Object();
        private boolean timerTaskShouldStop_ = true;
        private boolean timerTaskIsBusy_ = false;

        private TimerController() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(final Runnable task, long interval) {
            Object object = this.timerLock_;
            synchronized (object) {
                if (this.timer_ != null) {
                    return;
                }
                this.timer_ = new Timer("Live mode timer");
                this.timerTaskShouldStop_ = false;
                TimerTask timerTask = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = TimerController.this.timerLock_;
                        synchronized (object) {
                            if (TimerController.this.timerTaskShouldStop_) {
                                return;
                            }
                            TimerController.this.timerTaskIsBusy_ = true;
                        }
                        try {
                            task.run();
                        }
                        finally {
                            object = TimerController.this.timerLock_;
                            synchronized (object) {
                                TimerController.this.timerTaskIsBusy_ = false;
                                TimerController.this.timerLock_.notifyAll();
                            }
                        }
                    }
                };
                this.timer_.schedule(timerTask, 0L, interval);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.timerLock_;
            synchronized (object) {
                if (this.timer_ == null || this.timerTaskShouldStop_) {
                    return;
                }
                this.timerTaskShouldStop_ = true;
                this.timer_.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() {
            Object object = this.timerLock_;
            synchronized (object) {
                while (this.timerTaskIsBusy_) {
                    try {
                        this.timerLock_.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.timer_ = null;
            }
        }
    }
}

