/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import mmcorej.TaggedImage;
import org.micromanager.acquisition.TaggedImageQueue;
import org.micromanager.api.ImageCache;
import org.micromanager.utils.ReportingUtils;

public class DefaultTaggedImageSink {
    private final BlockingQueue<TaggedImage> imageProducingQueue_;
    private ImageCache imageCache_ = null;

    public DefaultTaggedImageSink(BlockingQueue<TaggedImage> imageProducingQueue, ImageCache imageCache) {
        this.imageProducingQueue_ = imageProducingQueue;
        this.imageCache_ = imageCache;
    }

    public void start() {
        this.start(null);
    }

    public void start(final Runnable sinkFullCallback) {
        Thread savingThread = new Thread("tagged image sink thread"){

            @Override
            public void run() {
                long t1 = System.currentTimeMillis();
                int imageCount = 0;
                while (true) {
                    try {
                        TaggedImage image;
                        while ((image = (TaggedImage)DefaultTaggedImageSink.this.imageProducingQueue_.poll(1L, TimeUnit.SECONDS)) == null) {
                        }
                        if (TaggedImageQueue.isPoison(image)) break;
                        ++imageCount;
                        try {
                            DefaultTaggedImageSink.this.imageCache_.putImage(image);
                        }
                        catch (OutOfMemoryError e) {
                            DefaultTaggedImageSink.this.handleOutOfMemory(e, sinkFullCallback);
                            break;
                        }
                    }
                    catch (Exception ex2) {
                        ReportingUtils.logError(ex2);
                        break;
                    }
                }
                long t2 = System.currentTimeMillis();
                ReportingUtils.logMessage(imageCount + " images stored in " + (t2 - t1) + " ms.");
                DefaultTaggedImageSink.this.imageCache_.finished();
            }
        };
        savingThread.start();
    }

    private void handleOutOfMemory(final OutOfMemoryError e, Runnable sinkFullCallback) {
        ReportingUtils.logError(e);
        if (sinkFullCallback != null) {
            sinkFullCallback.run();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, "Out of memory to store images: " + e.getMessage(), "Out of image storage memory", 0);
            }
        });
    }

    public ImageCache getImageCache() {
        return this.imageCache_;
    }
}

